/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.0
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIGJAVA
#define SWIG_DIRECTORS


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif 
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif



/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else


#define SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON

/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes that proxy
 * method calls from C++ to Java extensions.
 * ----------------------------------------------------------------------------- */

#ifdef __cplusplus

#if defined(DEBUG_DIRECTOR_OWNED)
#include <iostream>
#endif

namespace Swig {
  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = weak_global;
        if (jobj)
          jthis_ = ((weak_global_ || !mem_own) ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj));
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java
       proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else { /* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(0) {
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for 
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon((void **) &jenv_, NULL);
#else
        director_->swig_jvm_->AttachCurrentThread((void **) &jenv_, NULL);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.peek();
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };
}

#endif /* __cplusplus */


namespace Swig {
  static jclass jclass_IdaJavaJNI = NULL;
  static jmethodID director_methids[1];
}

#define USE_DANGEROUS_FUNCTIONS
#define USE_STANDARD_FILE_FUNCTIONS
#pragma warning(push)
#pragma warning(disable: 4267) // netnode.hpp: Conversion nodeidx_t <-> size_t
#pragma warning(disable: 4800) // graph.hpp: Performance int forced to bool
#include <pro.h>
#include <ida.hpp>
#include <fpro.h>
#include <netnode.hpp>
#include <nalt.hpp>
#include <idp.hpp>
#include <kernwin.hpp>

#include <allins.hpp>
#include <area.hpp>
#include <auto.hpp>
#include <bytes.hpp>
//#include <compress.hpp>
//#include <dbg.hpp>
#include <demangle.hpp>
#include <diskio.hpp>
#include <entry.hpp>
#include <enum.hpp>
#include <exehdr.h>
#include <expr.hpp>
#include <fixup.hpp>
#include <funcs.hpp>
#include <frame.hpp>
#include <gdl.hpp>
#include <graph.hpp>

#include <help.h>
#include <idd.hpp>
#include <idp.hpp>
#include <ieee.h>
#include <intel.hpp>
#include <ints.hpp>
#include <lex.hpp>
#include <lines.hpp>
#include <llong.hpp>
#include <loader.hpp>
#include <md5.h>
//#include <moves.hpp>
#include <name.hpp>
#include <offset.hpp>
//#include <prodir.h>
//#include <queue.hpp>
//#include <regex.hpp>
//#include <search.hpp>
#include <segment.hpp>
//#include <sistack.hpp>
#include <srarea.hpp>
//#include <strlist.hpp>
#include <struct.hpp>
//#include <typeinf.hpp>
#include <ua.hpp>
//#include <va.hpp>
//#include <vm.hpp>
#include <xref.hpp>
#pragma warning(pop)

// Windows specific includes, omit rarely used APIs
#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#include "idajava_natives.h"


#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


	typedef bool (idaapi* asm_t_checkarg_dispatch_cb)(void *a1, void *a2, uchar cmd);
	typedef void (idaapi *asm_t_func_cb)(func_t *);
	typedef ssize_t (idaapi *asm_t_get_type_name_cb)(flags_t flag, ea_t ea_or_id, char *buf, size_t bufsize);

typedef int (idaapi *enum_processor_modules_cb)(const char *file, void *ud);
typedef int (idaapi *enum_plugins_cb)(const char *file, void *ud);

	typedef int (idaapi *enumerate_files_cb)(const char *file, void *ud);


	typedef error_t (idaapi *funcset_t_cb)(void);


	typedef bool (idaapi *extlang_t_compile_cb)(const char *name, ea_t current_ea, const char *expr, char *errbuf, size_t errbufsize);
	typedef bool (idaapi *extlang_t_run_cb)(const char *name, int nargs, const idc_value_t args[], idc_value_t *result, char *errbuf, size_t errbufsize);
	typedef bool (idaapi *extlang_t_calcexpr_cb)(ea_t current_ea, const char *expr, idc_value_t *rv, char *errbuf, size_t errbufsize);
	typedef bool (idaapi *extlang_t_compile_file_cb)(const char *file, char *errbuf, size_t errbufsize);
	typedef bool (idaapi *extlang_t_create_object_cb)(const char *name, int nargs, const idc_value_t args[], idc_value_t *result, char *errbuf, size_t errbufsize);
	typedef bool (idaapi *extlang_t_get_attr_cb)(const idc_value_t *obj, const char *attr, idc_value_t *result);
	typedef bool (idaapi *extlang_t_set_attr_cb)(idc_value_t *obj, const char *attr, idc_value_t *value);
	typedef bool (idaapi *extlang_t_call_method_cb)(const idc_value_t *obj, const char *name, int nargs, const idc_value_t args[], idc_value_t *result, char *errbuf, size_t errbufsize);         // in: size of the error buffer


	typedef uval_t (idaapi *getname_cb)(const char *name);


	typedef bool (idaapi *construct_macro_cb)(insn_t &s, bool may_go_forward);

SWIGINTERN bool op_t_hasSIB(op_t *self){
			return self->specflag1;
		}
SWIGINTERN op_t *insn_t_getOperand(insn_t *self,int index){
			if (index < UA_MAXOP) {
				return &(self->Operands[index]);
			} else {
				return NULL;
			}
		}
SWIGINTERN bool insn_t_setOperand(insn_t *self,int index,op_t op){
			if (index < UA_MAXOP) {
				self->Operands[index] = op;
				return 1;
			} else {
				return 0;
			}
		}

	typedef area_t *(idaapi *set_dbgmem_source_dbg_get_memory_config_cb)(int *n);
	typedef int (idaapi *set_dbgmem_source_memory_read_cb)(ea_t ea, void *buffer, int size);
	typedef int (idaapi *set_dbgmem_source_memory_write_cb)(ea_t ea, const void *buffer, int size);


ea_t get_fchunk_referer(ea_t ea, size_t idx)
{
    func_t *pfn = get_fchunk(ea);
    func_parent_iterator_t dummy(pfn); // read referer info
    if (idx >= static_cast<size_t>(pfn->refqty) || pfn->referers == NULL)
        return BADADDR;
    return pfn->referers[idx];
}

SWIGINTERN member_t *struc_t_get_member(struc_t *self,int index){ return &(self->members[index]); }

	typedef bool (idaapi *debugger_t_init_debugger_cb)(const char *hostname, int portnum, const char *password);
	typedef bool (idaapi *debugger_t_term_debugger_cb)(void);
	typedef int (idaapi *debugger_t_process_get_info_cb)(int n, process_info_t *info);
	typedef int (idaapi *debugger_t_start_process_cb)(const char *path, const char *args, const char *startdir, uint32 input_file_crc32);
	typedef int (idaapi *debugger_t_attach_process_cb)(pid_t pid, int event_id);
	typedef int (idaapi *debugger_t_detach_process_cb)(void);
	typedef void (idaapi *debugger_t_rebase_if_required_to_cb)(ea_t new_base);
	typedef int (idaapi *debugger_t_prepare_to_pause_process_cb)(void);
	typedef int (idaapi *debugger_t_exit_process_cb)(void);
	typedef gdecode_t (idaapi *debugger_t_get_debug_event_cb)(debug_event_t *event, bool ida_is_idle);
	typedef int (idaapi *debugger_t_continue_after_event_cb)(const debug_event_t *event);
	typedef void (idaapi *debugger_t_set_exception_info_cb)(const exception_info_t *info, int qty);
	typedef void (idaapi *debugger_t_stopped_at_debug_event_cb)(bool dlls_added);
	typedef int (idaapi *debugger_t_thread_suspend_cb) (thid_t tid);
	typedef int (idaapi *debugger_t_thread_continue_cb)(thid_t tid);
	typedef int (idaapi *debugger_t_thread_set_step_cb)(thid_t tid);
	typedef int (idaapi *debugger_t_read_registers_cb)(thid_t tid, int clsmask, regval_t *values);
	typedef int (idaapi *debugger_t_write_register_cb)(thid_t tid, int regidx, const regval_t *value);
	typedef int (idaapi *debugger_t_thread_get_sreg_base_cb)(thid_t tid, int sreg_value, ea_t *answer);
	typedef int (idaapi *debugger_t_get_memory_info_cb)(meminfo_vec_t &areas);
	typedef ssize_t (idaapi *debugger_t_read_memory_cb)(ea_t ea, void *buffer, size_t size);
	typedef ssize_t (idaapi *debugger_t_write_memory_cb)(ea_t ea, const void *buffer, size_t size);
	typedef int (idaapi *debugger_t_is_ok_bpt_cb)(bpttype_t type, ea_t ea, int len);
	typedef int (idaapi *debugger_t_add_bpt_cb)(bpttype_t type, ea_t ea, int len);
	typedef int (idaapi *debugger_t_del_bpt_cb)(ea_t ea, const uchar *orig_bytes, int len);
	typedef int  (idaapi *debugger_t_open_file_cb)(const char *file, uint32 *fsize, bool readonly);
	typedef void (idaapi *debugger_t_close_file_cb)(int fn);
	typedef ssize_t (idaapi *debugger_t_read_file_cb)(int fn, uint32 off, void *buf, size_t size);
	typedef ea_t (idaapi *debugger_t_map_address_cb)(ea_t off, const regval_t *regs, int regnum);
	typedef const char *(idaapi *debugger_t_set_dbg_options_cb)(const char *keyword, int value_type, const void *value);
	typedef const void *(idaapi *debugger_t_get_debmod_extensions_cb)(void);
	typedef bool (idaapi *debugger_t_update_call_stack_cb)(thid_t tid, call_stack_t *trace);
	typedef ea_t (idaapi *debugger_t_appcall_cb)(ea_t func_ea, thid_t tid, const struct func_type_info_t *fti, int nargs, const struct regobjs_t *regargs, struct relobj_t *stkargs, struct regobjs_t *retregs, qstring *errbuf, debug_event_t *event, int options);
	typedef int (idaapi *debugger_t_cleanup_appcall_cb)(thid_t tid);



/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "idajava_idaapi_wrap.h"

SwigDirector_IdaMenuItemListener::SwigDirector_IdaMenuItemListener(JNIEnv *jenv) : IdaMenuItemListener(), Swig::Director(jenv) {
}

SwigDirector_IdaMenuItemListener::~SwigDirector_IdaMenuItemListener() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_IdaMenuItemListener::actionPerformed() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    IdaMenuItemListener::actionPerformed();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_IdaJavaJNI, Swig::director_methids[0], swigjobj);
    if (jenv->ExceptionOccurred()) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_IdaMenuItemListener::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "actionPerformed", "()V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("de/blichmann/idajava/natives/IdaMenuItemListener");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_can_1place32_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  uint64 arg1 ;
  uint64 *argp1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(uint64 **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null uint64");
    return 0;
  }
  arg1 = *argp1; 
  result = (bool)can_place32(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_can_1place32_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  int64 arg1 ;
  int64 *argp1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(int64 **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null int64");
    return 0;
  }
  arg1 = *argp1; 
  result = (bool)can_place32(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qexit(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  qexit(arg1);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_test_1bit(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  uchar *arg1 = (uchar *) 0 ;
  size_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uchar **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (bool)test_bit((unsigned char const *)arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1bit(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  uchar *arg1 = (uchar *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uchar **)&jarg1; 
  arg2 = (size_t)jarg2; 
  set_bit(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_clear_1bit(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  uchar *arg1 = (uchar *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uchar **)&jarg1; 
  arg2 = (size_t)jarg2; 
  clear_bit(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1all_1bits(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  uchar *arg1 = (uchar *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uchar **)&jarg1; 
  arg2 = (size_t)jarg2; 
  set_all_bits(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_clear_1all_1bits(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  uchar *arg1 = (uchar *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uchar **)&jarg1; 
  arg2 = (size_t)jarg2; 
  clear_all_bits(arg1,arg2);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_overlap(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jboolean jresult = 0 ;
  uval_t arg1 ;
  asize_t arg2 ;
  uval_t arg3 ;
  asize_t arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uval_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  arg3 = (uval_t)jarg3; 
  arg4 = (asize_t)jarg4; 
  result = (bool)interval::overlap(arg1,arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_includes(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jboolean jresult = 0 ;
  uval_t arg1 ;
  asize_t arg2 ;
  uval_t arg3 ;
  asize_t arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uval_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  arg3 = (uval_t)jarg3; 
  arg4 = (asize_t)jarg4; 
  result = (bool)interval::includes(arg1,arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_contains(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  uval_t arg1 ;
  asize_t arg2 ;
  uval_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uval_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  arg3 = (uval_t)jarg3; 
  result = (bool)interval::contains(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_readbytes(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jint jarg3, jboolean jarg4) {
  jint jresult = 0 ;
  int arg1 ;
  uint32 *arg2 = (uint32 *) 0 ;
  int arg3 ;
  bool arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = *(uint32 **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = jarg4 ? true : false; 
  result = (int)readbytes(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_writebytes(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jint jarg3, jboolean jarg4) {
  jint jresult = 0 ;
  int arg1 ;
  uint32 arg2 ;
  int arg3 ;
  bool arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (uint32)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = jarg4 ? true : false; 
  result = (int)writebytes(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_read2bytes(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  int arg1 ;
  uint16 *arg2 = (uint16 *) 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = *(uint16 **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (int)read2bytes(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_swap32(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  uint32 arg1 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32)jarg1; 
  result = (uint32)swap32(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_swap16(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  ushort arg1 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ushort)jarg1; 
  result = (ushort)swap16(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_swap_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  void *arg1 = (void *) 0 ;
  void *arg2 = (void *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (int)jarg3; 
  swap_value(arg1,(void const *)arg2,arg3);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_reloc_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jboolean jarg4) {
  void *arg1 = (void *) 0 ;
  int arg2 ;
  adiff_t arg3 ;
  bool arg4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (adiff_t)jarg3; 
  arg4 = jarg4 ? true : false; 
  reloc_value(arg1,arg2,arg3,arg4);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_rotate_1left(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  uval_t arg1 ;
  int arg2 ;
  size_t arg3 ;
  size_t arg4 ;
  uval_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uval_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (size_t)jarg3; 
  arg4 = (size_t)jarg4; 
  result = (uval_t)rotate_left(arg1,arg2,arg3,arg4);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qalloc_1or_1throw(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  size_t arg1 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (size_t)jarg1; 
  result = (void *)qalloc_or_throw(arg1);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qrealloc_1or_1throw(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  void *arg1 = (void *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)qrealloc_or_throw(arg1,arg2);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qstrlen_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = qstrlen((char const *)arg1);
  jresult = (jlong)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qstrlen_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  uchar *arg1 = (uchar *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uchar **)&jarg1; 
  result = qstrlen((unsigned char const *)arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qstrlen_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  wchar16_t *arg1 = (wchar16_t *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(wchar16_t **)&jarg1; 
  result = qstrlen((wchar16_t const *)arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qstrcmp_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)qstrcmp((char const *)arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qstrcmp_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  uchar *arg1 = (uchar *) 0 ;
  uchar *arg2 = (uchar *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uchar **)&jarg1; 
  arg2 = *(uchar **)&jarg2; 
  result = (int)qstrcmp((unsigned char const *)arg1,(unsigned char const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qstrcmp_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  wchar16_t *arg1 = (wchar16_t *) 0 ;
  wchar16_t *arg2 = (wchar16_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(wchar16_t **)&jarg1; 
  arg2 = *(wchar16_t **)&jarg2; 
  result = (int)qstrcmp((wchar16_t const *)arg1,(wchar16_t const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qstrstr_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)qstrstr((char const *)arg1,(char const *)arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qstrstr_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  uchar *arg1 = (uchar *) 0 ;
  uchar *arg2 = (uchar *) 0 ;
  uchar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uchar **)&jarg1; 
  arg2 = *(uchar **)&jarg2; 
  result = (uchar *)qstrstr((unsigned char const *)arg1,(unsigned char const *)arg2);
  *(uchar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qstrchr_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jchar jarg2) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (char)jarg2; 
  result = (char *)qstrchr((char const *)arg1,arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qstrchr_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
  jlong jresult = 0 ;
  uchar *arg1 = (uchar *) 0 ;
  uchar arg2 ;
  uchar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uchar **)&jarg1; 
  arg2 = (uchar)jarg2; 
  result = (uchar *)qstrchr((unsigned char const *)arg1,arg2);
  *(uchar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qstrchr_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  wchar16_t *arg1 = (wchar16_t *) 0 ;
  wchar16_t arg2 ;
  wchar16_t *argp2 ;
  wchar16_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(wchar16_t **)&jarg1; 
  argp2 = *(wchar16_t **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null wchar16_t");
    return 0;
  }
  arg2 = *argp2; 
  result = (wchar16_t *)qstrchr((wchar16_t const *)arg1,arg2);
  *(wchar16_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qstrrchr_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jchar jarg2) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (char)jarg2; 
  result = (char *)qstrrchr((char const *)arg1,arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qstrrchr_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
  jlong jresult = 0 ;
  uchar *arg1 = (uchar *) 0 ;
  uchar arg2 ;
  uchar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uchar **)&jarg1; 
  arg2 = (uchar)jarg2; 
  result = (uchar *)qstrrchr((unsigned char const *)arg1,arg2);
  *(uchar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qstrrchr_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  wchar16_t *arg1 = (wchar16_t *) 0 ;
  wchar16_t arg2 ;
  wchar16_t *argp2 ;
  wchar16_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(wchar16_t **)&jarg1; 
  argp2 = *(wchar16_t **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null wchar16_t");
    return 0;
  }
  arg2 = *argp2; 
  result = (wchar16_t *)qstrrchr((wchar16_t const *)arg1,arg2);
  *(wchar16_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1bytevec_1t_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  bytevec_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (bytevec_t *)new bytevec_t();
  *(bytevec_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1bytevec_1t_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  void *arg1 = (void *) 0 ;
  size_t arg2 ;
  bytevec_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (bytevec_t *)new bytevec_t((void const *)arg1,arg2);
  *(bytevec_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_bytevec_1t_1append(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  bytevec_t *arg1 = (bytevec_t *) 0 ;
  void *arg2 = (void *) 0 ;
  size_t arg3 ;
  bytevec_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(bytevec_t **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (size_t)jarg3; 
  result = (bytevec_t *) &(arg1)->append((void const *)arg2,arg3);
  *(bytevec_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_bytevec_1t_1inject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  bytevec_t *arg1 = (bytevec_t *) 0 ;
  void *arg2 = (void *) 0 ;
  size_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(bytevec_t **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (size_t)jarg3; 
  (arg1)->inject(arg2,arg3);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_bytevec_1t_1test_1bit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  bytevec_t *arg1 = (bytevec_t *) 0 ;
  size_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(bytevec_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (bool)((bytevec_t const *)arg1)->test_bit(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_bytevec_1t_1set_1bit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  bytevec_t *arg1 = (bytevec_t *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(bytevec_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  (arg1)->set_bit(arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_bytevec_1t_1clear_1bit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  bytevec_t *arg1 = (bytevec_t *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(bytevec_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  (arg1)->clear_bit(arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_bytevec_1t_1set_1all_1bits(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  bytevec_t *arg1 = (bytevec_t *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(bytevec_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  (arg1)->set_all_bits(arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_bytevec_1t_1clear_1all_1bits(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  bytevec_t *arg1 = (bytevec_t *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(bytevec_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  (arg1)->clear_all_bits(arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_bytevec_1t_1set_1bits(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  bytevec_t *arg1 = (bytevec_t *) 0 ;
  bytevec_t *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(bytevec_t **)&jarg1; 
  arg2 = *(bytevec_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "bytevec_t const & reference is null");
    return ;
  } 
  (arg1)->set_bits((bytevec_t const &)*arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_bytevec_1t_1clear_1bits(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  bytevec_t *arg1 = (bytevec_t *) 0 ;
  bytevec_t *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(bytevec_t **)&jarg1; 
  arg2 = *(bytevec_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "bytevec_t const & reference is null");
    return ;
  } 
  (arg1)->clear_bits((bytevec_t const &)*arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1bytevec_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  bytevec_t *arg1 = (bytevec_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(bytevec_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1reloc_1info_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  reloc_info_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (reloc_info_t *)new reloc_info_t();
  *(reloc_info_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1reloc_1info_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  reloc_info_t *arg1 = (reloc_info_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(reloc_info_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_relocate_1relobj(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jboolean jarg3) {
  jboolean jresult = 0 ;
  relobj_t *arg1 = (relobj_t *) 0 ;
  ea_t arg2 ;
  bool arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(relobj_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (bool)relocate_relobj(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_relobj_1t_1base_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  relobj_t *arg1 = (relobj_t *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(relobj_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->base = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_relobj_1t_1base_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  relobj_t *arg1 = (relobj_t *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(relobj_t **)&jarg1; 
  result = (ea_t) ((arg1)->base);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_relobj_1t_1ri_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  relobj_t *arg1 = (relobj_t *) 0 ;
  reloc_info_t *arg2 = (reloc_info_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(relobj_t **)&jarg1; 
  arg2 = *(reloc_info_t **)&jarg2; 
  if (arg1) (arg1)->ri = *arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_relobj_1t_1ri_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  relobj_t *arg1 = (relobj_t *) 0 ;
  reloc_info_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(relobj_t **)&jarg1; 
  result = (reloc_info_t *)& ((arg1)->ri);
  *(reloc_info_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1relobj_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  relobj_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (relobj_t *)new relobj_t();
  *(relobj_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_relobj_1t_1relocate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jboolean jarg3) {
  jboolean jresult = 0 ;
  relobj_t *arg1 = (relobj_t *) 0 ;
  ea_t arg2 ;
  bool arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(relobj_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (bool)(arg1)->relocate(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1relobj_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  relobj_t *arg1 = (relobj_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(relobj_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1incrementer_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  hit_counter_t *arg1 = 0 ;
  incrementer_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(hit_counter_t **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "hit_counter_t & reference is null");
    return 0;
  } 
  result = (incrementer_t *)new incrementer_t(*arg1);
  *(incrementer_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1incrementer_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  incrementer_t *arg1 = (incrementer_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(incrementer_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_incrementer_1t_1failed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  incrementer_t *arg1 = (incrementer_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(incrementer_t **)&jarg1; 
  (arg1)->failed();
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_parse_1command_1line(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  qstrvec_t *arg2 = (qstrvec_t *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(qstrvec_t **)&jarg2; 
  result = parse_command_line((char const *)arg1,arg2);
  jresult = (jlong)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_u2cstr_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  wchar16_t *arg1 = (wchar16_t *) 0 ;
  qstring *arg2 = (qstring *) 0 ;
  int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(wchar16_t **)&jarg1; 
  arg2 = *(qstring **)&jarg2; 
  arg3 = (int)jarg3; 
  result = (bool)u2cstr((wchar16_t const *)arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_u2cstr_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  wchar16_t *arg1 = (wchar16_t *) 0 ;
  qstring *arg2 = (qstring *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(wchar16_t **)&jarg1; 
  arg2 = *(qstring **)&jarg2; 
  result = (bool)u2cstr((wchar16_t const *)arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_c2ustr_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  qwstring *arg2 = (qwstring *) 0 ;
  int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(qwstring **)&jarg2; 
  arg3 = (int)jarg3; 
  result = (bool)c2ustr((char const *)arg1,arg2,arg3);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_c2ustr_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  qwstring *arg2 = (qwstring *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(qwstring **)&jarg2; 
  result = (bool)c2ustr((char const *)arg1,arg2);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_utf8_1unicode(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  wchar16_t *arg2 = (wchar16_t *) 0 ;
  size_t arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(wchar16_t **)&jarg2; 
  arg3 = (size_t)jarg3; 
  result = (int)utf8_unicode((char const *)arg1,arg2,arg3);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_win_1utf2idb(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (bool)win_utf2idb(arg1);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_char2oem(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  char2oem(arg1);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_oem2char(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  oem2char(arg1);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1codepages(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  int arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)set_codepages(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1codepages(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  int *arg1 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int **)&jarg1; 
  result = (int)get_codepages(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_convert_1codepage_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2, jstring jarg3, jlong jarg4, jint jarg5, jint jarg6, jint jarg7) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  size_t arg4 ;
  int arg5 ;
  int arg6 ;
  int arg7 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (size_t)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (int)jarg6; 
  arg7 = (int)jarg7; 
  result = (int)convert_codepage(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_convert_1codepage_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2, jstring jarg3, jlong jarg4, jint jarg5, jint jarg6) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  size_t arg4 ;
  int arg5 ;
  int arg6 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (size_t)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (int)jarg6; 
  result = (int)convert_codepage(arg1,arg2,arg3,arg4,arg5,arg6);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_SubstChar_1set(JNIEnv *jenv, jclass jcls, jchar jarg1) {
  char arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (char)jarg1; 
  SubstChar = arg1;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_SubstChar_1get(JNIEnv *jenv, jclass jcls) {
  jchar jresult = 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  result = (char)SubstChar;
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_launch_1process_1t_1cb_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  launch_process_t *arg1 = (launch_process_t *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(launch_process_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  if (arg1) (arg1)->cb = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_launch_1process_1t_1cb_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  launch_process_t *arg1 = (launch_process_t *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(launch_process_t **)&jarg1; 
  result =  ((arg1)->cb);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_launch_1process_1t_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  launch_process_t *arg1 = (launch_process_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(launch_process_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->flags = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_launch_1process_1t_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  launch_process_t *arg1 = (launch_process_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(launch_process_t **)&jarg1; 
  result = (int) ((arg1)->flags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_launch_1process_1t_1path_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  launch_process_t *arg1 = (launch_process_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(launch_process_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg2) {
      arg1->path = (char const *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->path, (const char *)arg2);
    } else {
      arg1->path = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_launch_1process_1t_1path_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  launch_process_t *arg1 = (launch_process_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(launch_process_t **)&jarg1; 
  result = (char *) ((arg1)->path);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_launch_1process_1t_1args_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  launch_process_t *arg1 = (launch_process_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(launch_process_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg2) {
      arg1->args = (char const *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->args, (const char *)arg2);
    } else {
      arg1->args = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_launch_1process_1t_1args_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  launch_process_t *arg1 = (launch_process_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(launch_process_t **)&jarg1; 
  result = (char *) ((arg1)->args);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_launch_1process_1t_1in_1handle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  launch_process_t *arg1 = (launch_process_t *) 0 ;
  ssize_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(launch_process_t **)&jarg1; 
  arg2 = (ssize_t)jarg2; 
  if (arg1) (arg1)->in_handle = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_launch_1process_1t_1in_1handle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  launch_process_t *arg1 = (launch_process_t *) 0 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(launch_process_t **)&jarg1; 
  result = (ssize_t) ((arg1)->in_handle);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_launch_1process_1t_1out_1handle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  launch_process_t *arg1 = (launch_process_t *) 0 ;
  ssize_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(launch_process_t **)&jarg1; 
  arg2 = (ssize_t)jarg2; 
  if (arg1) (arg1)->out_handle = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_launch_1process_1t_1out_1handle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  launch_process_t *arg1 = (launch_process_t *) 0 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(launch_process_t **)&jarg1; 
  result = (ssize_t) ((arg1)->out_handle);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_launch_1process_1t_1err_1handle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  launch_process_t *arg1 = (launch_process_t *) 0 ;
  ssize_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(launch_process_t **)&jarg1; 
  arg2 = (ssize_t)jarg2; 
  if (arg1) (arg1)->err_handle = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_launch_1process_1t_1err_1handle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  launch_process_t *arg1 = (launch_process_t *) 0 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(launch_process_t **)&jarg1; 
  result = (ssize_t) ((arg1)->err_handle);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1launch_1process_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  launch_process_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (launch_process_t *)new launch_process_t();
  *(launch_process_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1launch_1process_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  launch_process_t *arg1 = (launch_process_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(launch_process_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_init_1process(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  launch_process_t *arg1 = 0 ;
  qstring *arg2 = (qstring *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(launch_process_t **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "launch_process_t const & reference is null");
    return 0;
  } 
  arg2 = *(qstring **)&jarg2; 
  result = (void *)init_process((launch_process_t const &)*arg1,arg2);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_term_1process(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  void *arg1 = (void *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  result = (int)term_process(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1process_1exit_1code(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  void *arg1 = (void *) 0 ;
  int *arg2 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  arg2 = *(int **)&jarg2; 
  result = (int)get_process_exit_code(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1_1_1qthread_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  __qthread_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (__qthread_t *)new __qthread_t();
  *(__qthread_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1_1_1qthread_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  __qthread_t *arg1 = (__qthread_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(__qthread_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qthread_1create(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  qthread_cb_t arg1 = (qthread_cb_t) 0 ;
  void *arg2 = (void *) 0 ;
  qthread_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(qthread_cb_t *)&jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (qthread_t)qthread_create(arg1,arg2);
  *(qthread_t *)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qthread_1free(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  qthread_t arg1 = (qthread_t) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qthread_t *)&jarg1; 
  qthread_free(arg1);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qthread_1join(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  qthread_t arg1 = (qthread_t) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qthread_t *)&jarg1; 
  result = (bool)qthread_join(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qthread_1kill(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  qthread_t arg1 = (qthread_t) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qthread_t *)&jarg1; 
  result = (bool)qthread_kill(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qthread_1self(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  qthread_t result;
  
  (void)jenv;
  (void)jcls;
  result = (qthread_t)qthread_self();
  *(qthread_t *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1_1_1qsemaphore_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  __qsemaphore_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (__qsemaphore_t *)new __qsemaphore_t();
  *(__qsemaphore_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1_1_1qsemaphore_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  __qsemaphore_t *arg1 = (__qsemaphore_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(__qsemaphore_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qsem_1create(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int arg2 ;
  qsemaphore_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (int)jarg2; 
  result = (qsemaphore_t)qsem_create((char const *)arg1,arg2);
  *(qsemaphore_t *)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qsem_1free(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  qsemaphore_t arg1 = (qsemaphore_t) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qsemaphore_t *)&jarg1; 
  result = (bool)qsem_free(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qsem_1post(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  qsemaphore_t arg1 = (qsemaphore_t) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qsemaphore_t *)&jarg1; 
  result = (bool)qsem_post(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qsem_1wait(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  qsemaphore_t arg1 = (qsemaphore_t) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qsemaphore_t *)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)qsem_wait(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1_1_1qmutex_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  __qmutex_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (__qmutex_t *)new __qmutex_t();
  *(__qmutex_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1_1_1qmutex_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  __qmutex_t *arg1 = (__qmutex_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(__qmutex_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qmutex_1free(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  qmutex_t arg1 = (qmutex_t) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qmutex_t *)&jarg1; 
  result = (bool)qmutex_free(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qmutex_1create(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  qmutex_t result;
  
  (void)jenv;
  (void)jcls;
  result = (qmutex_t)qmutex_create();
  *(qmutex_t *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qmutex_1lock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  qmutex_t arg1 = (qmutex_t) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qmutex_t *)&jarg1; 
  result = (bool)qmutex_lock(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qmutex_1unlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  qmutex_t arg1 = (qmutex_t) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qmutex_t *)&jarg1; 
  result = (bool)qmutex_unlock(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1qvector_1uchar_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  qvector< uchar > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (qvector< uchar > *)new qvector< uchar >();
  *(qvector< uchar > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1qvector_1uchar_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< unsigned char > *arg1 = 0 ;
  qvector< uchar > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< unsigned char > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "qvector< unsigned char > const & reference is null");
    return 0;
  } 
  result = (qvector< uchar > *)new qvector< uchar >((qvector< unsigned char > const &)*arg1);
  *(qvector< uchar > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1qvector_1uchar(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(qvector< uchar > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1push_1back_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  unsigned char *arg2 = 0 ;
  unsigned char temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  temp2 = (unsigned char)jarg2; 
  arg2 = &temp2; 
  (arg1)->push_back((unsigned char const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1push_1back_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  result = (unsigned char *) &(arg1)->push_back();
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1pop_1back(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  (arg1)->pop_back();
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  result = ((qvector< uchar > const *)arg1)->size();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  result = (bool)((qvector< uchar > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1_1_1aref_1_1_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jshort jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  size_t arg2 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (unsigned char *) &((qvector< uchar > const *)arg1)->operator [](arg2);
  jresult = (jshort)*result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1at_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jshort jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  size_t arg2 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (unsigned char *) &((qvector< uchar > const *)arg1)->at(arg2);
  jresult = (jshort)*result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1front_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  result = (unsigned char *) &((qvector< uchar > const *)arg1)->front();
  jresult = (jshort)*result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1back_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  result = (unsigned char *) &((qvector< uchar > const *)arg1)->back();
  jresult = (jshort)*result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1qclear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  (arg1)->qclear();
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1_1_1assign_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  qvector< unsigned char > *arg2 = 0 ;
  qvector< unsigned char > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  arg2 = *(qvector< unsigned char > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "qvector< unsigned char > const & reference is null");
    return 0;
  } 
  result = (qvector< unsigned char > *) &(arg1)->operator =((qvector< unsigned char > const &)*arg2);
  *(qvector< unsigned char > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1resize_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jshort jarg3) {
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  size_t arg2 ;
  unsigned char *arg3 = 0 ;
  unsigned char temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  temp3 = (unsigned char)jarg3; 
  arg3 = &temp3; 
  (arg1)->resize(arg2,(unsigned char const &)*arg3);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1resize_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  (arg1)->resize(arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1grow_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  unsigned char *arg2 = 0 ;
  unsigned char temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  temp2 = (unsigned char)jarg2; 
  arg2 = &temp2; 
  (arg1)->grow((unsigned char const &)*arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1grow_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  (arg1)->grow();
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  result = ((qvector< uchar > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  (arg1)->reserve(arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1move(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  unsigned char *arg3 = (unsigned char *) 0 ;
  size_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  arg3 = *(unsigned char **)&jarg3; 
  arg4 = (size_t)jarg4; 
  (arg1)->move(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1truncate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  (arg1)->truncate();
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1swap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  qvector< unsigned char > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  arg2 = *(qvector< unsigned char > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "qvector< unsigned char > & reference is null");
    return ;
  } 
  (arg1)->swap(*arg2);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1extract(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  result = (unsigned char *)(arg1)->extract();
  *(unsigned char **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1inject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  size_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  arg2 = *(unsigned char **)&jarg2; 
  arg3 = (size_t)jarg3; 
  (arg1)->inject(arg2,arg3);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1_1_1eq_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  qvector< unsigned char > *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  arg2 = *(qvector< unsigned char > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "qvector< unsigned char > const & reference is null");
    return 0;
  } 
  result = (bool)((qvector< uchar > const *)arg1)->operator ==((qvector< unsigned char > const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1_1_1ne_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  qvector< unsigned char > *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  arg2 = *(qvector< unsigned char > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "qvector< unsigned char > const & reference is null");
    return 0;
  } 
  result = (bool)((qvector< uchar > const *)arg1)->operator !=((qvector< unsigned char > const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1begin_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  qvector< unsigned char >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  result = (qvector< unsigned char >::iterator)(arg1)->begin();
  *(qvector< unsigned char >::iterator *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1end_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  qvector< unsigned char >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  result = (qvector< unsigned char >::iterator)(arg1)->end();
  *(qvector< unsigned char >::iterator *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1insert(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jshort jarg3) {
  jlong jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  qvector< unsigned char >::iterator arg2 = (qvector< unsigned char >::iterator) 0 ;
  unsigned char *arg3 = 0 ;
  unsigned char temp3 ;
  qvector< unsigned char >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  arg2 = *(qvector< unsigned char >::iterator *)&jarg2; 
  temp3 = (unsigned char)jarg3; 
  arg3 = &temp3; 
  result = (qvector< unsigned char >::iterator)(arg1)->insert(arg2,(unsigned char const &)*arg3);
  *(qvector< unsigned char >::iterator *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1erase_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  qvector< unsigned char >::iterator arg2 = (qvector< unsigned char >::iterator) 0 ;
  qvector< unsigned char >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  arg2 = *(qvector< unsigned char >::iterator *)&jarg2; 
  result = (qvector< unsigned char >::iterator)(arg1)->erase(arg2);
  *(qvector< unsigned char >::iterator *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1erase_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  qvector< unsigned char >::iterator arg2 = (qvector< unsigned char >::iterator) 0 ;
  qvector< unsigned char >::iterator arg3 = (qvector< unsigned char >::iterator) 0 ;
  qvector< unsigned char >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  arg2 = *(qvector< unsigned char >::iterator *)&jarg2; 
  arg3 = *(qvector< unsigned char >::iterator *)&jarg3; 
  result = (qvector< unsigned char >::iterator)(arg1)->erase(arg2,arg3);
  *(qvector< unsigned char >::iterator *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1find_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  jlong jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  unsigned char *arg2 = 0 ;
  unsigned char temp2 ;
  qvector< unsigned char >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  temp2 = (unsigned char)jarg2; 
  arg2 = &temp2; 
  result = (qvector< unsigned char >::iterator)(arg1)->find((unsigned char const &)*arg2);
  *(qvector< unsigned char >::iterator *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1has(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  jboolean jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  unsigned char *arg2 = 0 ;
  unsigned char temp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  temp2 = (unsigned char)jarg2; 
  arg2 = &temp2; 
  result = (bool)((qvector< uchar > const *)arg1)->has((unsigned char const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1add_1unique(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  jboolean jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  unsigned char *arg2 = 0 ;
  unsigned char temp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  temp2 = (unsigned char)jarg2; 
  arg2 = &temp2; 
  result = (bool)(arg1)->add_unique((unsigned char const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1uchar_1del(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  jboolean jresult = 0 ;
  qvector< uchar > *arg1 = (qvector< uchar > *) 0 ;
  unsigned char *arg2 = 0 ;
  unsigned char temp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< uchar > **)&jarg1; 
  temp2 = (unsigned char)jarg2; 
  arg2 = &temp2; 
  result = (bool)(arg1)->del((unsigned char const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_compiler_1info_1t_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  compiler_info_t *arg1 = (compiler_info_t *) 0 ;
  comp_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(compiler_info_t **)&jarg1; 
  arg2 = (comp_t)jarg2; 
  if (arg1) (arg1)->id = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_compiler_1info_1t_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  compiler_info_t *arg1 = (compiler_info_t *) 0 ;
  comp_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(compiler_info_t **)&jarg1; 
  result = (comp_t) ((arg1)->id);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_compiler_1info_1t_1cm_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  compiler_info_t *arg1 = (compiler_info_t *) 0 ;
  cm_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(compiler_info_t **)&jarg1; 
  arg2 = (cm_t)jarg2; 
  if (arg1) (arg1)->cm = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_compiler_1info_1t_1cm_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  compiler_info_t *arg1 = (compiler_info_t *) 0 ;
  cm_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(compiler_info_t **)&jarg1; 
  result = (cm_t) ((arg1)->cm);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_compiler_1info_1t_1size_1i_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  compiler_info_t *arg1 = (compiler_info_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(compiler_info_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->size_i = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_compiler_1info_1t_1size_1i_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  compiler_info_t *arg1 = (compiler_info_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(compiler_info_t **)&jarg1; 
  result = (uchar) ((arg1)->size_i);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_compiler_1info_1t_1size_1b_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  compiler_info_t *arg1 = (compiler_info_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(compiler_info_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->size_b = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_compiler_1info_1t_1size_1b_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  compiler_info_t *arg1 = (compiler_info_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(compiler_info_t **)&jarg1; 
  result = (uchar) ((arg1)->size_b);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_compiler_1info_1t_1size_1e_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  compiler_info_t *arg1 = (compiler_info_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(compiler_info_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->size_e = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_compiler_1info_1t_1size_1e_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  compiler_info_t *arg1 = (compiler_info_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(compiler_info_t **)&jarg1; 
  result = (uchar) ((arg1)->size_e);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_compiler_1info_1t_1defalign_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  compiler_info_t *arg1 = (compiler_info_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(compiler_info_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->defalign = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_compiler_1info_1t_1defalign_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  compiler_info_t *arg1 = (compiler_info_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(compiler_info_t **)&jarg1; 
  result = (uchar) ((arg1)->defalign);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_compiler_1info_1t_1size_1s_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  compiler_info_t *arg1 = (compiler_info_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(compiler_info_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->size_s = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_compiler_1info_1t_1size_1s_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  compiler_info_t *arg1 = (compiler_info_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(compiler_info_t **)&jarg1; 
  result = (uchar) ((arg1)->size_s);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_compiler_1info_1t_1size_1l_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  compiler_info_t *arg1 = (compiler_info_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(compiler_info_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->size_l = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_compiler_1info_1t_1size_1l_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  compiler_info_t *arg1 = (compiler_info_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(compiler_info_t **)&jarg1; 
  result = (uchar) ((arg1)->size_l);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_compiler_1info_1t_1size_1ll_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  compiler_info_t *arg1 = (compiler_info_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(compiler_info_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->size_ll = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_compiler_1info_1t_1size_1ll_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  compiler_info_t *arg1 = (compiler_info_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(compiler_info_t **)&jarg1; 
  result = (uchar) ((arg1)->size_ll);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1compiler_1info_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  compiler_info_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (compiler_info_t *)new compiler_info_t();
  *(compiler_info_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1compiler_1info_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  compiler_info_t *arg1 = (compiler_info_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(compiler_info_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1tag_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->tag, (const char *)arg2, 3-1);
      arg1->tag[3-1] = 0;
    } else {
      arg1->tag[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1tag_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (char *)(char *) ((arg1)->tag);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  ushort arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (ushort)jarg2; 
  if (arg1) (arg1)->version = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (ushort) ((arg1)->version);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1procName_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->procName, (const char *)arg2, 8-1);
      arg1->procName[8-1] = 0;
    } else {
      arg1->procName[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1procName_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (char *)(char *) ((arg1)->procName);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1get_1proc_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)(arg1)->get_proc_name(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1lflags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->lflags = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1lflags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->lflags);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1is_132bit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (bool)((idainfo const *)arg1)->is_32bit();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1is_164bit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (bool)((idainfo const *)arg1)->is_64bit();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1is_1snapshot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (bool)((idainfo const *)arg1)->is_snapshot();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1demnames_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->demnames = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1demnames_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->demnames);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1get_1demname_1form(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar)((idainfo const *)arg1)->get_demname_form();
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1filetype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  ushort arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (ushort)jarg2; 
  if (arg1) (arg1)->filetype = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1filetype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (ushort) ((arg1)->filetype);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1like_1binary(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (bool)((idainfo const *)arg1)->like_binary();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1fcoresiz_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uval_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uval_t)jarg2; 
  if (arg1) (arg1)->fcoresiz = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1fcoresiz_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uval_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uval_t) ((arg1)->fcoresiz);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1corestart_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uval_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uval_t)jarg2; 
  if (arg1) (arg1)->corestart = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1corestart_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uval_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uval_t) ((arg1)->corestart);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1ostype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  ushort arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (ushort)jarg2; 
  if (arg1) (arg1)->ostype = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1ostype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (ushort) ((arg1)->ostype);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1apptype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  ushort arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (ushort)jarg2; 
  if (arg1) (arg1)->apptype = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1apptype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (ushort) ((arg1)->apptype);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1startSP_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->startSP = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1startSP_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (ea_t) ((arg1)->startSP);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1af_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  ushort arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (ushort)jarg2; 
  if (arg1) (arg1)->af = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1af_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (ushort) ((arg1)->af);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1startIP_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->startIP = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1startIP_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (ea_t) ((arg1)->startIP);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1beginEA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->beginEA = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1beginEA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (ea_t) ((arg1)->beginEA);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1minEA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->minEA = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1minEA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (ea_t) ((arg1)->minEA);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1maxEA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->maxEA = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1maxEA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (ea_t) ((arg1)->maxEA);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1ominEA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->ominEA = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1ominEA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (ea_t) ((arg1)->ominEA);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1omaxEA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->omaxEA = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1omaxEA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (ea_t) ((arg1)->omaxEA);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1lowoff_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->lowoff = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1lowoff_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (ea_t) ((arg1)->lowoff);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1highoff_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->highoff = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1highoff_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (ea_t) ((arg1)->highoff);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1maxref_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uval_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uval_t)jarg2; 
  if (arg1) (arg1)->maxref = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1maxref_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uval_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uval_t) ((arg1)->maxref);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1ASCIIbreak_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->ASCIIbreak = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1ASCIIbreak_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->ASCIIbreak);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1wide_1high_1byte_1first_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->wide_high_byte_first = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1wide_1high_1byte_1first_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->wide_high_byte_first);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1indent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->indent = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1indent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->indent);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1comment_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->comment = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1comment_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->comment);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1xrefnum_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->xrefnum = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1xrefnum_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->xrefnum);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1entab_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_entab = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1entab_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->s_entab);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1specsegs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->specsegs = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1specsegs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->specsegs);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1void_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_void = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1void_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->s_void);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1reserved2_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_reserved2 = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1reserved2_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->s_reserved2);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1showauto_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_showauto = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1showauto_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->s_showauto);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1auto_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_auto = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1auto_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->s_auto);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1limiter_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_limiter = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1limiter_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->s_limiter);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1null_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_null = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1null_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->s_null);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1genflags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_genflags = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1genflags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->s_genflags);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1use_1allasm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (bool)((idainfo const *)arg1)->use_allasm();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1loading_1idc(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (bool)((idainfo const *)arg1)->loading_idc();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1showpref_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_showpref = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1showpref_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->s_showpref);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1prefseg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_prefseg = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1prefseg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->s_prefseg);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1asmtype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->asmtype = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1asmtype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->asmtype);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1baseaddr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uval_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uval_t)jarg2; 
  if (arg1) (arg1)->baseaddr = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1baseaddr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uval_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uval_t) ((arg1)->baseaddr);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1xrefflag_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_xrefflag = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1xrefflag_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->s_xrefflag);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1binSize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  short arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (short)jarg2; 
  if (arg1) (arg1)->binSize = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1binSize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  short result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (short) ((arg1)->binSize);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1cmtflg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_cmtflg = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1cmtflg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->s_cmtflg);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1nametype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (char)jarg2; 
  if (arg1) (arg1)->nametype = arg2;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1nametype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jchar jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (char) ((arg1)->nametype);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1showbads_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_showbads = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1showbads_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->s_showbads);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1prefflag_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_prefflag = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1prefflag_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->s_prefflag);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1packbase_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_packbase = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1packbase_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->s_packbase);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1asciiflags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->asciiflags = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1asciiflags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->asciiflags);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1listnames_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->listnames = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1listnames_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->listnames);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1ASCIIpref_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->ASCIIpref, (const char *)arg2, 16-1);
      arg1->ASCIIpref[16-1] = 0;
    } else {
      arg1->ASCIIpref[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1ASCIIpref_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (char *)(char *) ((arg1)->ASCIIpref);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1ASCIIsernum_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uval_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uval_t)jarg2; 
  if (arg1) (arg1)->ASCIIsernum = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1ASCIIsernum_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uval_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uval_t) ((arg1)->ASCIIsernum);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1ASCIIzeroes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (char)jarg2; 
  if (arg1) (arg1)->ASCIIzeroes = arg2;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1ASCIIzeroes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jchar jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (char) ((arg1)->ASCIIzeroes);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1graph_1view_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->graph_view = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1graph_1view_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->graph_view);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1reserved5_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_reserved5 = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1reserved5_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->s_reserved5);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1tribyte_1order_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->tribyte_order = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1tribyte_1order_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->tribyte_order);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1mf_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->mf = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1mf_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->mf);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1org_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_org = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1org_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->s_org);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1assume_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_assume = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1assume_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->s_assume);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1checkarg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_checkarg = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1s_1checkarg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->s_checkarg);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1start_1ss_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  sel_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (sel_t)jarg2; 
  if (arg1) (arg1)->start_ss = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1start_1ss_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  sel_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (sel_t) ((arg1)->start_ss);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1start_1cs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  sel_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (sel_t)jarg2; 
  if (arg1) (arg1)->start_cs = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1start_1cs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  sel_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (sel_t) ((arg1)->start_cs);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1main_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->main = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1main_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (ea_t) ((arg1)->main);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1short_1demnames_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uint32)jarg2; 
  if (arg1) (arg1)->short_demnames = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1short_1demnames_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uint32) ((arg1)->short_demnames);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1long_1demnames_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uint32)jarg2; 
  if (arg1) (arg1)->long_demnames = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1long_1demnames_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uint32) ((arg1)->long_demnames);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1datatypes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uval_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uval_t)jarg2; 
  if (arg1) (arg1)->datatypes = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1datatypes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uval_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uval_t) ((arg1)->datatypes);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1strtype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  int32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (int32)jarg2; 
  if (arg1) (arg1)->strtype = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1strtype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  int32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (int32) ((arg1)->strtype);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1af2_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  ushort arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (ushort)jarg2; 
  if (arg1) (arg1)->af2 = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1af2_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (ushort) ((arg1)->af2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1namelen_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  ushort arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (ushort)jarg2; 
  if (arg1) (arg1)->namelen = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1namelen_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (ushort) ((arg1)->namelen);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1margin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  ushort arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (ushort)jarg2; 
  if (arg1) (arg1)->margin = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1margin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (ushort) ((arg1)->margin);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1lenxref_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  ushort arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (ushort)jarg2; 
  if (arg1) (arg1)->lenxref = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1lenxref_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (ushort) ((arg1)->lenxref);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1lprefix_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->lprefix, (const char *)arg2, 16-1);
      arg1->lprefix[16-1] = 0;
    } else {
      arg1->lprefix[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1lprefix_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (char *)(char *) ((arg1)->lprefix);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1lprefixlen_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->lprefixlen = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1lprefixlen_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->lprefixlen);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1cc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  idainfo *arg1 = (idainfo *) 0 ;
  compiler_info_t *arg2 = (compiler_info_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = *(compiler_info_t **)&jarg2; 
  if (arg1) (arg1)->cc = *arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1cc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  compiler_info_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (compiler_info_t *)& ((arg1)->cc);
  *(compiler_info_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1database_1change_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uint32)jarg2; 
  if (arg1) (arg1)->database_change_count = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1database_1change_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uint32) ((arg1)->database_change_count);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1size_1ldbl_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->size_ldbl = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1size_1ldbl_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar) ((arg1)->size_ldbl);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1appcall_1options_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  arg2 = (uint32)jarg2; 
  if (arg1) (arg1)->appcall_options = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1appcall_1options_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uint32) ((arg1)->appcall_options);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1reserved_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshortArray jarg2) {
  idainfo *arg1 = (idainfo *) 0 ;
  uchar *arg2 ;
  jshort *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 55) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUchar(jenv, &jarr2, &arg2, jarg2)) return ; 
  {
    size_t ii;
    uchar *b = (uchar *) arg1->reserved;
    for (ii = 0; ii < (size_t)55; ii++) b[ii] = *((uchar *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUchar(jenv, jarr2, arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jshortArray JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idainfo_1reserved_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshortArray jresult = 0 ;
  idainfo *arg1 = (idainfo *) 0 ;
  uchar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  result = (uchar *)(uchar *) ((arg1)->reserved);
  jresult = SWIG_JavaArrayOutUchar(jenv, result, 55); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1idainfo(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  idainfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (idainfo *)new idainfo();
  *(idainfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1idainfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  idainfo *arg1 = (idainfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(idainfo **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_inf_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  idainfo *arg1 = (idainfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1; 
  inf = *arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_inf_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  idainfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (idainfo *)&inf;
  *(idainfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dual_1text_1options_1t_1mysize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->mysize = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dual_1text_1options_1t_1mysize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  result = (int) ((arg1)->mysize);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dual_1text_1options_1t_1graph_1view_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->graph_view = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dual_1text_1options_1t_1graph_1view_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  result = (uchar) ((arg1)->graph_view);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dual_1text_1options_1t_1xrefnum_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->xrefnum = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dual_1text_1options_1t_1xrefnum_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  result = (uchar) ((arg1)->xrefnum);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dual_1text_1options_1t_1s_1showpref_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_showpref = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dual_1text_1options_1t_1s_1showpref_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  result = (uchar) ((arg1)->s_showpref);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dual_1text_1options_1t_1comment_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->comment = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dual_1text_1options_1t_1comment_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  result = (uchar) ((arg1)->comment);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dual_1text_1options_1t_1indent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->indent = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dual_1text_1options_1t_1indent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  result = (uchar) ((arg1)->indent);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dual_1text_1options_1t_1s_1limiter_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->s_limiter = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dual_1text_1options_1t_1s_1limiter_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  result = (uchar) ((arg1)->s_limiter);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dual_1text_1options_1t_1margin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  ushort arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  arg2 = (ushort)jarg2; 
  if (arg1) (arg1)->margin = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dual_1text_1options_1t_1margin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  result = (ushort) ((arg1)->margin);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dual_1text_1options_1t_1binSize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  ushort arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  arg2 = (ushort)jarg2; 
  if (arg1) (arg1)->binSize = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dual_1text_1options_1t_1binSize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  result = (ushort) ((arg1)->binSize);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1dual_1text_1options_1t_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jlong jresult = 0 ;
  bool arg1 ;
  dual_text_options_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (dual_text_options_t *)new dual_text_options_t(arg1);
  *(dual_text_options_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1dual_1text_1options_1t_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idainfo *arg1 = 0 ;
  dual_text_options_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idainfo **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "idainfo const & reference is null");
    return 0;
  } 
  result = (dual_text_options_t *)new dual_text_options_t((idainfo const &)*arg1);
  *(dual_text_options_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1dual_1text_1options_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(dual_text_options_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_text_1options_1t_1text_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  text_options_t *arg1 = (text_options_t *) 0 ;
  dual_text_options_t *arg2 = (dual_text_options_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(text_options_t **)&jarg1; 
  arg2 = *(dual_text_options_t **)&jarg2; 
  if (arg1) (arg1)->text = *arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_text_1options_1t_1text_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  text_options_t *arg1 = (text_options_t *) 0 ;
  dual_text_options_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(text_options_t **)&jarg1; 
  result = (dual_text_options_t *)& ((arg1)->text);
  *(dual_text_options_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_text_1options_1t_1graph_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  text_options_t *arg1 = (text_options_t *) 0 ;
  dual_text_options_t *arg2 = (dual_text_options_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(text_options_t **)&jarg1; 
  arg2 = *(dual_text_options_t **)&jarg2; 
  if (arg1) (arg1)->graph = *arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_text_1options_1t_1graph_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  text_options_t *arg1 = (text_options_t *) 0 ;
  dual_text_options_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(text_options_t **)&jarg1; 
  result = (dual_text_options_t *)& ((arg1)->graph);
  *(dual_text_options_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1text_1options_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  text_options_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (text_options_t *)new text_options_t();
  *(text_options_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1text_1options_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  text_options_t *arg1 = (text_options_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(text_options_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dto_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  text_options_t *arg1 = (text_options_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(text_options_t **)&jarg1; 
  dto = *arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dto_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  text_options_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (text_options_t *)&dto;
  *(text_options_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_showRepeatables(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)showRepeatables();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_showAllComments(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)showAllComments();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_showComments(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)showComments();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_should_1trace_1sp(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)should_trace_sp();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_should_1create_1stkvars(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)should_create_stkvars();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_calc_1default_1idaplace_1flags(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)calc_default_idaplace_flags();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_toEA(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  sel_t arg1 ;
  ea_t arg2 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sel_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (ea_t)toEA(arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idb2scr(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (char *)idb2scr(arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_scr2idb(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (char *)scr2idb(arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ansi2idb(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (char *)ansi2idb(arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dto_1copy_1to_1inf(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  idainfo *arg2 = (idainfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  arg2 = *(idainfo **)&jarg2; 
  dto_copy_to_inf((dual_text_options_t const *)arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dto_1copy_1from_1inf(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  idainfo *arg2 = (idainfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  arg2 = *(idainfo **)&jarg2; 
  dto_copy_from_inf(arg1,(idainfo const *)arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dto_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  dual_text_options_t *arg1 = (dual_text_options_t *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dual_text_options_t **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  dto_init(arg1,arg2);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qfopen(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  FILE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (FILE *)qfopen((char const *)arg1,(char const *)arg2);
  *(FILE **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qfread(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  void *arg2 = (void *) 0 ;
  size_t arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (size_t)jarg3; 
  result = (int)qfread(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qfwrite(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  void *arg2 = (void *) 0 ;
  size_t arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (size_t)jarg3; 
  result = (int)qfwrite(arg1,(void const *)arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qftell(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  int32 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  result = (int32)qftell(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qfseek(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  int32 arg2 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = (int32)jarg2; 
  arg3 = (int)jarg3; 
  result = (int)qfseek(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qfclose(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  result = (int)qfclose(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qflush(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  result = (int)qflush(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qtmpfile(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  FILE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (FILE *)qtmpfile();
  *(FILE **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qrename(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)qrename((char const *)arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qtmpnam(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (size_t)jarg2; 
  result = (char *)qtmpnam(arg1,arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qfputc(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2) {
  jint jresult = 0 ;
  int arg1 ;
  FILE *arg2 = (FILE *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = *(FILE **)&jarg2; 
  result = (int)qfputc(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qfgetc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  result = (int)qfgetc(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qfgets(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  FILE *arg3 = (FILE *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (size_t)jarg2; 
  arg3 = *(FILE **)&jarg3; 
  result = (char *)qfgets(arg1,arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qfputs(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  FILE *arg2 = (FILE *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(FILE **)&jarg2; 
  result = (int)qfputs((char const *)arg1,arg2);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvfprintf(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  char *arg2 = (char *) 0 ;
  va_list arg3 ;
  va_list *argp3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  argp3 = *(va_list **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null va_list");
    return 0;
  }
  arg3 = *argp3; 
  result = (int)qvfprintf(arg1,(char const *)arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvprintf(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  va_list arg2 ;
  va_list *argp2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  argp2 = *(va_list **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null va_list");
    return 0;
  }
  arg2 = *argp2; 
  result = (int)qvprintf((char const *)arg1,arg2);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvfscanf(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  char *arg2 = (char *) 0 ;
  va_list arg3 ;
  va_list *argp3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  argp3 = *(va_list **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null va_list");
    return 0;
  }
  arg3 = *argp3; 
  result = (int)qvfscanf(arg1,(char const *)arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qgets(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (size_t)jarg2; 
  result = (char *)qgets(arg1,arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qfprintf(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  char *arg2 = (char *) 0 ;
  void *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)qfprintf(arg1,(char const *)arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qprintf(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  void *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (int)qprintf((char const *)arg1,arg2);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_freadbytes(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jint jarg4) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  void *arg2 = (void *) 0 ;
  int arg3 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (int)freadbytes(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_fwritebytes(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jint jarg4) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  void *arg2 = (void *) 0 ;
  int arg3 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (int)fwritebytes(arg1,(void const *)arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_fread2bytes_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  int16 *arg2 = (int16 *) 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = *(int16 **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (int)fread2bytes(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_fwrite2bytes_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  int16 *arg2 = (int16 *) 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = *(int16 **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (int)fwrite2bytes(arg1,(short const *)arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_fread2bytes_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  uint16 *arg2 = (uint16 *) 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = *(uint16 **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (int)fread2bytes(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_fwrite2bytes_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  uint16 *arg2 = (uint16 *) 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = *(uint16 **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (int)fwrite2bytes(arg1,(unsigned short const *)arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_fread4bytes_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  int32 *arg2 = (int32 *) 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = *(int32 **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (int)fread4bytes(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_fwrite4bytes_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  int32 *arg2 = (int32 *) 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = *(int32 **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (int)fwrite4bytes(arg1,(int const *)arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_fread4bytes_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  uint32 *arg2 = (uint32 *) 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = *(uint32 **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (int)fread4bytes(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_fwrite4bytes_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  uint32 *arg2 = (uint32 *) 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = *(uint32 **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (int)fwrite4bytes(arg1,(unsigned int const *)arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_fread8bytes_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  longlong *arg2 = (longlong *) 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = *(longlong **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (int)fread8bytes(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_fwrite8bytes_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  longlong *arg2 = (longlong *) 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = *(longlong **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (int)fwrite8bytes(arg1,(longlong const *)arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_fread8bytes_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  ulonglong *arg2 = (ulonglong *) 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = *(ulonglong **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (int)fread8bytes(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_fwrite8bytes_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  ulonglong *arg2 = (ulonglong *) 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = *(ulonglong **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (int)fwrite8bytes(arg1,(ulonglong const *)arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_net_1patch_1set(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  netnode arg1 ;
  netnode *argp1 ;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(netnode **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null netnode");
    return ;
  }
  arg1 = *argp1; 
  net_patch = arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_net_1patch_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  netnode result;
  
  (void)jenv;
  (void)jcls;
  result = net_patch;
  *(netnode **)&jresult = new netnode((const netnode &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_import_1node_1set(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  netnode arg1 ;
  netnode *argp1 ;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(netnode **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null netnode");
    return ;
  }
  arg1 = *argp1; 
  import_node = arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_import_1node_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  netnode result;
  
  (void)jenv;
  (void)jcls;
  result = import_node;
  *(netnode **)&jresult = new netnode((const netnode &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1aflags0(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  ea_t arg1 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (uint32)jarg2; 
  set_aflags0(arg1,arg2);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1aflags0(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (uint32)get_aflags0(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_del_1aflags0(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  del_aflags0(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1aflags(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  ea_t arg1 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (uint32)jarg2; 
  set_aflags(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1abits(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  ea_t arg1 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (uint32)jarg2; 
  set_abits(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_clr_1abits(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  ea_t arg1 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (uint32)jarg2; 
  clr_abits(arg1,arg2);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1aflags(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (uint32)get_aflags(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_del_1aflags(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  del_aflags(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1visible_1item(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
  ea_t arg1 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = jarg2 ? true : false; 
  set_visible_item(arg1,arg2);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1visible_1item(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (bool)is_visible_item(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1finally_1visible_1item(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (bool)is_finally_visible_item(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1source_1linnum(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  ea_t arg1 ;
  uval_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (uval_t)jarg2; 
  set_source_linnum(arg1,arg2);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1source_1linnum(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  uval_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (uval_t)get_source_linnum(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_del_1source_1linnum(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  del_source_linnum(arg1);
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1str_1type_1code(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jchar jresult = 0 ;
  uval_t arg1 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uval_t)jarg1; 
  result = (char)get_str_type_code(arg1);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1str_1term1(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jchar jresult = 0 ;
  int32 arg1 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32)jarg1; 
  result = (char)get_str_term1(arg1);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1str_1term2(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jchar jresult = 0 ;
  int32 arg1 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32)jarg1; 
  result = (char)get_str_term2(arg1);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1unicode(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int32 arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32)jarg1; 
  result = (bool)is_unicode(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1pascal(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int32 arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32)jarg1; 
  result = (bool)is_pascal(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1item_1color(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  ea_t arg1 ;
  bgcolor_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (bgcolor_t)jarg2; 
  set_item_color(arg1,arg2);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1item_1color(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  bgcolor_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (bgcolor_t)get_item_color(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_del_1item_1color(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  del_item_color(arg1);
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_REF_1OFF8_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  reftype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (reftype_t)(reftype_t)REF_OFF8;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_REF_1OFF16_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  reftype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (reftype_t)(reftype_t)REF_OFF16;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_REF_1OFF32_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  reftype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (reftype_t)(reftype_t)REF_OFF32;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_REF_1LOW8_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  reftype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (reftype_t)(reftype_t)REF_LOW8;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_REF_1LOW16_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  reftype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (reftype_t)(reftype_t)REF_LOW16;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_REF_1HIGH8_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  reftype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (reftype_t)(reftype_t)REF_HIGH8;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_REF_1HIGH16_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  reftype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (reftype_t)(reftype_t)REF_HIGH16;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_REF_1VHIGH_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  reftype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (reftype_t)(reftype_t)REF_VHIGH;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_REF_1VLOW_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  reftype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (reftype_t)(reftype_t)REF_VLOW;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_REF_1OFF64_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  reftype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (reftype_t)(reftype_t)REF_OFF64;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_REF_1LAST_1get(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  reftype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (reftype_t)(reftype_t)REF_LAST;
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1reftype_1by_1size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jshort jresult = 0 ;
  size_t arg1 ;
  reftype_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (size_t)jarg1; 
  result = (reftype_t)get_reftype_by_size(arg1);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refinfo_1t_1target_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(refinfo_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->target = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refinfo_1t_1target_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(refinfo_t **)&jarg1; 
  result = (ea_t) ((arg1)->target);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refinfo_1t_1base_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(refinfo_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->base = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refinfo_1t_1base_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(refinfo_t **)&jarg1; 
  result = (ea_t) ((arg1)->base);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refinfo_1t_1tdelta_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  adiff_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(refinfo_t **)&jarg1; 
  arg2 = (adiff_t)jarg2; 
  if (arg1) (arg1)->tdelta = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refinfo_1t_1tdelta_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  adiff_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(refinfo_t **)&jarg1; 
  result = (adiff_t) ((arg1)->tdelta);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refinfo_1t_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(refinfo_t **)&jarg1; 
  arg2 = (uint32)jarg2; 
  if (arg1) (arg1)->flags = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refinfo_1t_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(refinfo_t **)&jarg1; 
  result = (uint32) ((arg1)->flags);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refinfo_1t_1type(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  reftype_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(refinfo_t **)&jarg1; 
  result = (reftype_t)((refinfo_t const *)arg1)->type();
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refinfo_1t_1no_1base_1xref(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(refinfo_t **)&jarg1; 
  result = (bool)((refinfo_t const *)arg1)->no_base_xref();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refinfo_1t_1is_1pastend(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(refinfo_t **)&jarg1; 
  result = (bool)((refinfo_t const *)arg1)->is_pastend();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refinfo_1t_1is_1rvaoff(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(refinfo_t **)&jarg1; 
  result = (bool)((refinfo_t const *)arg1)->is_rvaoff();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refinfo_1t_1is_1custom(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(refinfo_t **)&jarg1; 
  result = (bool)((refinfo_t const *)arg1)->is_custom();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refinfo_1t_1is_1subtract(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(refinfo_t **)&jarg1; 
  result = (bool)((refinfo_t const *)arg1)->is_subtract();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refinfo_1t_1is_1signed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(refinfo_t **)&jarg1; 
  result = (bool)((refinfo_t const *)arg1)->is_signed();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refinfo_1t_1set_1type(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  reftype_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(refinfo_t **)&jarg1; 
  arg2 = (reftype_t)jarg2; 
  (arg1)->set_type(arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refinfo_1t_1init_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  uint32 arg2 ;
  ea_t arg3 ;
  ea_t arg4 ;
  adiff_t arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(refinfo_t **)&jarg1; 
  arg2 = (uint32)jarg2; 
  arg3 = (ea_t)jarg3; 
  arg4 = (ea_t)jarg4; 
  arg5 = (adiff_t)jarg5; 
  (arg1)->init(arg2,arg3,arg4,arg5);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refinfo_1t_1init_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  uint32 arg2 ;
  ea_t arg3 ;
  ea_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(refinfo_t **)&jarg1; 
  arg2 = (uint32)jarg2; 
  arg3 = (ea_t)jarg3; 
  arg4 = (ea_t)jarg4; 
  (arg1)->init(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refinfo_1t_1init_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  uint32 arg2 ;
  ea_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(refinfo_t **)&jarg1; 
  arg2 = (uint32)jarg2; 
  arg3 = (ea_t)jarg3; 
  (arg1)->init(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refinfo_1t_1init_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(refinfo_t **)&jarg1; 
  arg2 = (uint32)jarg2; 
  (arg1)->init(arg2);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1refinfo_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  refinfo_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (refinfo_t *)new refinfo_t();
  *(refinfo_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1refinfo_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  refinfo_t *arg1 = (refinfo_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(refinfo_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_strpath_1t_1len_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  strpath_t *arg1 = (strpath_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(strpath_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->len = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_strpath_1t_1len_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  strpath_t *arg1 = (strpath_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(strpath_t **)&jarg1; 
  result = (int) ((arg1)->len);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_strpath_1t_1ids_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlongArray jarg2) {
  strpath_t *arg1 = (strpath_t *) 0 ;
  tid_t *arg2 ;
  jlong *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(strpath_t **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 32) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUint(jenv, &jarr2, &arg2, jarg2)) return ; 
  {
    size_t ii;
    tid_t *b = (tid_t *) arg1->ids;
    for (ii = 0; ii < (size_t)32; ii++) b[ii] = *((tid_t *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUint(jenv, jarr2, arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jlongArray JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_strpath_1t_1ids_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlongArray jresult = 0 ;
  strpath_t *arg1 = (strpath_t *) 0 ;
  tid_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(strpath_t **)&jarg1; 
  result = (tid_t *)(tid_t *) ((arg1)->ids);
  jresult = SWIG_JavaArrayOutUint(jenv, result, 32); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_strpath_1t_1delta_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  strpath_t *arg1 = (strpath_t *) 0 ;
  adiff_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(strpath_t **)&jarg1; 
  arg2 = (adiff_t)jarg2; 
  if (arg1) (arg1)->delta = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_strpath_1t_1delta_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  strpath_t *arg1 = (strpath_t *) 0 ;
  adiff_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(strpath_t **)&jarg1; 
  result = (adiff_t) ((arg1)->delta);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1strpath_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  strpath_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (strpath_t *)new strpath_t();
  *(strpath_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1strpath_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  strpath_t *arg1 = (strpath_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(strpath_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_enum_1const_1t_1tid_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  enum_const_t *arg1 = (enum_const_t *) 0 ;
  tid_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(enum_const_t **)&jarg1; 
  arg2 = (tid_t)jarg2; 
  if (arg1) (arg1)->tid = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_enum_1const_1t_1tid_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  enum_const_t *arg1 = (enum_const_t *) 0 ;
  tid_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(enum_const_t **)&jarg1; 
  result = (tid_t) ((arg1)->tid);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_enum_1const_1t_1serial_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  enum_const_t *arg1 = (enum_const_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(enum_const_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->serial = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_enum_1const_1t_1serial_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  enum_const_t *arg1 = (enum_const_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(enum_const_t **)&jarg1; 
  result = (uchar) ((arg1)->serial);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1enum_1const_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  enum_const_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (enum_const_t *)new enum_const_t();
  *(enum_const_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1enum_1const_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  enum_const_t *arg1 = (enum_const_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(enum_const_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_opinfo_1t_1ri_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  opinfo_t *arg1 = (opinfo_t *) 0 ;
  refinfo_t *arg2 = (refinfo_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(opinfo_t **)&jarg1; 
  arg2 = *(refinfo_t **)&jarg2; 
  if (arg1) (arg1)->ri = *arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_opinfo_1t_1ri_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  opinfo_t *arg1 = (opinfo_t *) 0 ;
  refinfo_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(opinfo_t **)&jarg1; 
  result = (refinfo_t *)& ((arg1)->ri);
  *(refinfo_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_opinfo_1t_1tid_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  opinfo_t *arg1 = (opinfo_t *) 0 ;
  tid_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(opinfo_t **)&jarg1; 
  arg2 = (tid_t)jarg2; 
  if (arg1) (arg1)->tid = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_opinfo_1t_1tid_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  opinfo_t *arg1 = (opinfo_t *) 0 ;
  tid_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(opinfo_t **)&jarg1; 
  result = (tid_t) ((arg1)->tid);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_opinfo_1t_1path_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  opinfo_t *arg1 = (opinfo_t *) 0 ;
  strpath_t *arg2 = (strpath_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(opinfo_t **)&jarg1; 
  arg2 = *(strpath_t **)&jarg2; 
  if (arg1) (arg1)->path = *arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_opinfo_1t_1path_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  opinfo_t *arg1 = (opinfo_t *) 0 ;
  strpath_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(opinfo_t **)&jarg1; 
  result = (strpath_t *)& ((arg1)->path);
  *(strpath_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_opinfo_1t_1strtype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  opinfo_t *arg1 = (opinfo_t *) 0 ;
  int32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(opinfo_t **)&jarg1; 
  arg2 = (int32)jarg2; 
  if (arg1) (arg1)->strtype = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_opinfo_1t_1strtype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  opinfo_t *arg1 = (opinfo_t *) 0 ;
  int32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(opinfo_t **)&jarg1; 
  result = (int32) ((arg1)->strtype);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_opinfo_1t_1ec_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  opinfo_t *arg1 = (opinfo_t *) 0 ;
  enum_const_t *arg2 = (enum_const_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(opinfo_t **)&jarg1; 
  arg2 = *(enum_const_t **)&jarg2; 
  if (arg1) (arg1)->ec = *arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_opinfo_1t_1ec_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  opinfo_t *arg1 = (opinfo_t *) 0 ;
  enum_const_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(opinfo_t **)&jarg1; 
  result = (enum_const_t *)& ((arg1)->ec);
  *(enum_const_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_opinfo_1t_1cd_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  opinfo_t *arg1 = (opinfo_t *) 0 ;
  custom_data_type_ids_t arg2 ;
  custom_data_type_ids_t *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(opinfo_t **)&jarg1; 
  argp2 = *(custom_data_type_ids_t **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null custom_data_type_ids_t");
    return ;
  }
  arg2 = *argp2; 
  if (arg1) (arg1)->cd = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_opinfo_1t_1cd_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  opinfo_t *arg1 = (opinfo_t *) 0 ;
  custom_data_type_ids_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(opinfo_t **)&jarg1; 
  result =  ((arg1)->cd);
  *(custom_data_type_ids_t **)&jresult = new custom_data_type_ids_t((const custom_data_type_ids_t &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1opinfo_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  opinfo_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (opinfo_t *)new opinfo_t();
  *(opinfo_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1opinfo_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  opinfo_t *arg1 = (opinfo_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(opinfo_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1refinfo_1ex(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  refinfo_t *arg3 = (refinfo_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(refinfo_t **)&jarg3; 
  result = (int)set_refinfo_ex(arg1,arg2,(refinfo_t const *)arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1refinfo_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jshort jarg3, jlong jarg4, jlong jarg5, jint jarg6) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  reftype_t arg3 ;
  ea_t arg4 ;
  ea_t arg5 ;
  adiff_t arg6 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (reftype_t)jarg3; 
  arg4 = (ea_t)jarg4; 
  arg5 = (ea_t)jarg5; 
  arg6 = (adiff_t)jarg6; 
  result = (int)set_refinfo(arg1,arg2,arg3,arg4,arg5,arg6);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1refinfo_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jshort jarg3, jlong jarg4, jlong jarg5) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  reftype_t arg3 ;
  ea_t arg4 ;
  ea_t arg5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (reftype_t)jarg3; 
  arg4 = (ea_t)jarg4; 
  arg5 = (ea_t)jarg5; 
  result = (int)set_refinfo(arg1,arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1refinfo_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jshort jarg3, jlong jarg4) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  reftype_t arg3 ;
  ea_t arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (reftype_t)jarg3; 
  arg4 = (ea_t)jarg4; 
  result = (int)set_refinfo(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1refinfo_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jshort jarg3) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  reftype_t arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (reftype_t)jarg3; 
  result = (int)set_refinfo(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1refinfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  refinfo_t *arg3 = (refinfo_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(refinfo_t **)&jarg3; 
  result = (int)get_refinfo(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_del_1refinfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (int)del_refinfo(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_write_1struc_1path(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jint jarg4, jint jarg5) {
  netnode arg1 ;
  int arg2 ;
  tid_t *arg3 = (tid_t *) 0 ;
  int arg4 ;
  adiff_t arg5 ;
  netnode *argp1 ;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(netnode **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null netnode");
    return ;
  }
  arg1 = *argp1; 
  arg2 = (int)jarg2; 
  arg3 = *(tid_t **)&jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (adiff_t)jarg5; 
  write_struc_path(arg1,arg2,(unsigned int const *)arg3,arg4,arg5);
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_read_1struc_1path(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  netnode arg1 ;
  int arg2 ;
  tid_t *arg3 = (tid_t *) 0 ;
  adiff_t *arg4 = (adiff_t *) 0 ;
  netnode *argp1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(netnode **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null netnode");
    return 0;
  }
  arg1 = *argp1; 
  arg2 = (int)jarg2; 
  arg3 = *(tid_t **)&jarg3; 
  arg4 = *(adiff_t **)&jarg4; 
  result = (int)read_struc_path(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1input_1file_1path(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (size_t)jarg2; 
  result = (ssize_t)get_input_file_path(arg1,arg2);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1root_1filename(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (size_t)jarg2; 
  result = (ssize_t)get_root_filename(arg1,arg2);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1root_1filename(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  set_root_filename((char const *)arg1);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_retrieve_1input_1file_1crc32(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  result = (uint32)retrieve_input_file_crc32();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_retrieve_1input_1file_1md5(JNIEnv *jenv, jclass jcls, jshortArray jarg1) {
  jboolean jresult = 0 ;
  uchar *arg1 ;
  jshort *jarr1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  if (jarg1 && jenv->GetArrayLength(jarg1) != 16) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return 0;
  }
  if (!SWIG_JavaArrayInUchar(jenv, &jarr1, &arg1, jarg1)) return 0; 
  result = (bool)retrieve_input_file_md5(arg1);
  jresult = (jboolean)result; 
  SWIG_JavaArrayArgoutUchar(jenv, jarr1, arg1, jarg1); 
  delete [] arg1; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1asm_1inc_1file(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (size_t)jarg2; 
  result = (ssize_t)get_asm_inc_file(arg1,arg2);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1asm_1inc_1file(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (bool)set_asm_inc_file((char const *)arg1);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1imagebase(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  result = (ea_t)get_imagebase();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1imagebase(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  set_imagebase(arg1);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1ids_1modnode(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  netnode result;
  
  (void)jenv;
  (void)jcls;
  result = get_ids_modnode();
  *(netnode **)&jresult = new netnode((const netnode &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1ids_1modnode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  netnode arg1 ;
  netnode *argp1 ;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(netnode **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null netnode");
    return ;
  }
  arg1 = *argp1; 
  set_ids_modnode(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ExtraUpdate(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  ea_t arg1 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (int)jarg3; 
  ExtraUpdate(arg1,(char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ExtraDel(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  ea_t arg1 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  ExtraDel(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ExtraGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jlong jarg4) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  size_t arg4 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (size_t)jarg4; 
  result = (ssize_t)ExtraGet(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1auto_1plugins(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (size_t)jarg2; 
  result = (ssize_t)get_auto_plugins(arg1,arg2);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1auto_1plugins_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (size_t)jarg2; 
  result = (bool)set_auto_plugins((char const *)arg1,arg2);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1auto_1plugins_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (bool)set_auto_plugins((char const *)arg1);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dbg_1get_1input_1path(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (size_t)jarg2; 
  result = dbg_get_input_path(arg1,arg2);
  jresult = (jlong)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1import_1module_1qty(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)get_import_module_qty();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1import_1module_1name(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  int arg1 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (bool)get_import_module_name(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_enum_1import_1names_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  int arg1 ;
  import_enum_cb_t *arg2 = (import_enum_cb_t *) 0 ;
  void *arg3 = (void *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = *(import_enum_cb_t **)&jarg2; 
  arg3 = *(void **)&jarg3; 
  result = (int)enum_import_names(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_enum_1import_1names_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2) {
  jint jresult = 0 ;
  int arg1 ;
  import_enum_cb_t *arg2 = (import_enum_cb_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = *(import_enum_cb_t **)&jarg2; 
  result = (int)enum_import_names(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1flag_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  asm_t *arg1 = (asm_t *) 0 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  arg2 = (uint32)jarg2; 
  if (arg1) (arg1)->flag = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1flag_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (uint32) ((arg1)->flag);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1uflag_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  asm_t *arg1 = (asm_t *) 0 ;
  uint16 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  arg2 = (uint16)jarg2; 
  if (arg1) (arg1)->uflag = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1uflag_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  uint16 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (uint16) ((arg1)->uflag);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1help_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  asm_t *arg1 = (asm_t *) 0 ;
  help_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  arg2 = (help_t)jarg2; 
  if (arg1) (arg1)->help = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1help_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  help_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (help_t) ((arg1)->help);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1header_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char **) ((arg1)->header);
  *(char ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1badworks_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  uint16 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (uint16 *) ((arg1)->badworks);
  *(uint16 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1origin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->origin);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1end_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->end);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1cmnt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->cmnt);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1ascsep_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  asm_t *arg1 = (asm_t *) 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  arg2 = (char)jarg2; 
  if (arg1) (arg1)->ascsep = arg2;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1ascsep_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jchar jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char) ((arg1)->ascsep);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1accsep_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  asm_t *arg1 = (asm_t *) 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  arg2 = (char)jarg2; 
  if (arg1) (arg1)->accsep = arg2;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1accsep_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jchar jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char) ((arg1)->accsep);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1esccodes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->esccodes);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1ascii_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_ascii);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1byte_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_byte);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1word_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_word);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1dword_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_dword);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1qword_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_qword);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1oword_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_oword);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1float_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_float);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1double_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_double);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1tbyte_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_tbyte);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1packreal_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_packreal);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1dups_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_dups);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1bss_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_bss);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1equ_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_equ);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1seg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_seg);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1checkarg_1dispatch_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  asm_t *arg1 = (asm_t *) 0 ;
  asm_t_checkarg_dispatch_cb arg2 = (asm_t_checkarg_dispatch_cb) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  arg2 = *(asm_t_checkarg_dispatch_cb *)&jarg2; 
  if (arg1) (arg1)->checkarg_dispatch = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1checkarg_1dispatch_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  asm_t_checkarg_dispatch_cb result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (asm_t_checkarg_dispatch_cb) ((arg1)->checkarg_dispatch);
  *(asm_t_checkarg_dispatch_cb *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1_1UNUSED1_1was_1atomprefix_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (void *) ((arg1)->_UNUSED1_was_atomprefix);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1_1UNUSED2_1was_1checkarg_1operations_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (void *) ((arg1)->_UNUSED2_was_checkarg_operations);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1XlatAsciiOutput_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  uchar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (uchar *) ((arg1)->XlatAsciiOutput);
  *(uchar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1curip_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_curip);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1func_1header_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  asm_t *arg1 = (asm_t *) 0 ;
  asm_t_func_cb arg2 = (asm_t_func_cb) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  arg2 = *(asm_t_func_cb *)&jarg2; 
  if (arg1) (arg1)->func_header = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1func_1header_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  asm_t_func_cb result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (asm_t_func_cb) ((arg1)->func_header);
  *(asm_t_func_cb *)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1func_1footer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  asm_t *arg1 = (asm_t *) 0 ;
  asm_t_func_cb arg2 = (asm_t_func_cb) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  arg2 = *(asm_t_func_cb *)&jarg2; 
  if (arg1) (arg1)->func_footer = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1func_1footer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  asm_t_func_cb result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (asm_t_func_cb) ((arg1)->func_footer);
  *(asm_t_func_cb *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1public_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_public);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1weak_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_weak);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1extrn_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_extrn);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1comdef_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_comdef);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1get_1type_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  asm_t *arg1 = (asm_t *) 0 ;
  asm_t_get_type_name_cb arg2 = (asm_t_get_type_name_cb) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  arg2 = *(asm_t_get_type_name_cb *)&jarg2; 
  if (arg1) (arg1)->get_type_name = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1get_1type_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  asm_t_get_type_name_cb result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (asm_t_get_type_name_cb) ((arg1)->get_type_name);
  *(asm_t_get_type_name_cb *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1align_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_align);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1lbrace_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  asm_t *arg1 = (asm_t *) 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  arg2 = (char)jarg2; 
  if (arg1) (arg1)->lbrace = arg2;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1lbrace_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jchar jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char) ((arg1)->lbrace);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1rbrace_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  asm_t *arg1 = (asm_t *) 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  arg2 = (char)jarg2; 
  if (arg1) (arg1)->rbrace = arg2;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1rbrace_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jchar jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char) ((arg1)->rbrace);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1mod_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_mod);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1band_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_band);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1bor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_bor);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1xor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_xor);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1bnot_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_bnot);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1shl_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_shl);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1shr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_shr);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1sizeof_1fmt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_sizeof_fmt);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1flag2_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  asm_t *arg1 = (asm_t *) 0 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  arg2 = (uint32)jarg2; 
  if (arg1) (arg1)->flag2 = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1flag2_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (uint32) ((arg1)->flag2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1cmnt2_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->cmnt2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1low8_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->low8);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1high8_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->high8);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1low16_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->low16);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1high16_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->high16);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1include_1fmt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_include_fmt);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1vstruc_1fmt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_vstruc_fmt);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_13byte_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_3byte);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asm_1t_1a_1rva_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  asm_t *arg1 = (asm_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  result = (char *) ((arg1)->a_rva);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1asm_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  asm_t *arg1 = (asm_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(asm_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_bytes_1t_1len_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  bytes_t *arg1 = (bytes_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(bytes_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->len = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_bytes_1t_1len_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  bytes_t *arg1 = (bytes_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(bytes_t **)&jarg1; 
  result = (uchar) ((arg1)->len);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_bytes_1t_1bytes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  bytes_t *arg1 = (bytes_t *) 0 ;
  uchar *arg2 = (uchar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(bytes_t **)&jarg1; 
  arg2 = *(uchar **)&jarg2; 
  if (arg1) (arg1)->bytes = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_bytes_1t_1bytes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  bytes_t *arg1 = (bytes_t *) 0 ;
  uchar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(bytes_t **)&jarg1; 
  result = (uchar *) ((arg1)->bytes);
  *(uchar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1bytes_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  bytes_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (bytes_t *)new bytes_t();
  *(bytes_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1bytes_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  bytes_t *arg1 = (bytes_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(bytes_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_instruc_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  instruc_t *arg1 = (instruc_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(instruc_t **)&jarg1; 
  result = (char *) ((arg1)->name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_instruc_1t_1feature_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  instruc_t *arg1 = (instruc_t *) 0 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(instruc_t **)&jarg1; 
  arg2 = (uint32)jarg2; 
  if (arg1) (arg1)->feature = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_instruc_1t_1feature_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  instruc_t *arg1 = (instruc_t *) 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(instruc_t **)&jarg1; 
  result = (uint32) ((arg1)->feature);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1instruc_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  instruc_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (instruc_t *)new instruc_t();
  *(instruc_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1instruc_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  instruc_t *arg1 = (instruc_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(instruc_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_InstrIsSet(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  int arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)InstrIsSet(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1call_1insn(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (bool)is_call_insn(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1ret_1insn_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)is_ret_insn(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1ret_1insn_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (bool)is_ret_insn(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1indirect_1jump_1insn(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (bool)is_indirect_jump_insn(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1basic_1block_1end(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)is_basic_block_end(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->version = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (int) ((arg1)->version);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->id = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (int) ((arg1)->id);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1flag_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = (uint32)jarg2; 
  if (arg1) (arg1)->flag = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1flag_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (uint32) ((arg1)->flag);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1has_1segregs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (bool)((processor_t const *)arg1)->has_segregs();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1use32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (bool)((processor_t const *)arg1)->use32();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1use64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (bool)((processor_t const *)arg1)->use64();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1ti(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (bool)((processor_t const *)arg1)->ti();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1stkup(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (bool)((processor_t const *)arg1)->stkup();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1use_1tbyte(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (bool)((processor_t const *)arg1)->use_tbyte();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1get_1segm_1bitness(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (int)((processor_t const *)arg1)->get_segm_bitness();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1cnbits_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->cnbits = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1cnbits_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (int) ((arg1)->cnbits);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1dnbits_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->dnbits = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1dnbits_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (int) ((arg1)->dnbits);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1cbsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (int)(arg1)->cbsize();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1dbsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (int)(arg1)->dbsize();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1psnames_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  char **arg2 = (char **) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = *(char ***)&jarg2; 
  if (arg1) (arg1)->psnames = (char const **)arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1psnames_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (char **) ((arg1)->psnames);
  *(char ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1plnames_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  char **arg2 = (char **) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = *(char ***)&jarg2; 
  if (arg1) (arg1)->plnames = (char const **)arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1plnames_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (char **) ((arg1)->plnames);
  *(char ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1assemblers_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  asm_t **arg2 = (asm_t **) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = *(asm_t ***)&jarg2; 
  if (arg1) (arg1)->assemblers = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1assemblers_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  asm_t **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (asm_t **) ((arg1)->assemblers);
  *(asm_t ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1get_1stkvar_1scale(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (int)(arg1)->get_stkvar_scale();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1regsNum_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->regsNum = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1regsNum_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (int) ((arg1)->regsNum);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1regNames_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  char **arg2 = (char **) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = *(char ***)&jarg2; 
  if (arg1) (arg1)->regNames = (char const **)arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1regNames_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (char **) ((arg1)->regNames);
  *(char ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1rFiles_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->rFiles = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1rFiles_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (int) ((arg1)->rFiles);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1rFnames_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  char **arg2 = (char **) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = *(char ***)&jarg2; 
  if (arg1) (arg1)->rFnames = (char const **)arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1rFnames_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (char **) ((arg1)->rFnames);
  *(char ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1rFdescs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  rginfo *arg2 = (rginfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = *(rginfo **)&jarg2; 
  if (arg1) (arg1)->rFdescs = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1rFdescs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  rginfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (rginfo *) ((arg1)->rFdescs);
  *(rginfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1CPUregs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  WorkReg *arg2 = (WorkReg *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = *(WorkReg **)&jarg2; 
  if (arg1) (arg1)->CPUregs = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1CPUregs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  WorkReg *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (WorkReg *) ((arg1)->CPUregs);
  *(WorkReg **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1regFirstSreg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->regFirstSreg = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1regFirstSreg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (int) ((arg1)->regFirstSreg);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1regLastSreg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->regLastSreg = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1regLastSreg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (int) ((arg1)->regLastSreg);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1segreg_1size_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->segreg_size = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1segreg_1size_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (int) ((arg1)->segreg_size);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1regCodeSreg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->regCodeSreg = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1regCodeSreg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (int) ((arg1)->regCodeSreg);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1regDataSreg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->regDataSreg = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1regDataSreg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (int) ((arg1)->regDataSreg);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1codestart_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  processor_t *arg1 = (processor_t *) 0 ;
  bytes_t *arg2 = (bytes_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = *(bytes_t **)&jarg2; 
  if (arg1) (arg1)->codestart = (bytes_t const *)arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1codestart_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  bytes_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (bytes_t *) ((arg1)->codestart);
  *(bytes_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1retcodes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  processor_t *arg1 = (processor_t *) 0 ;
  bytes_t *arg2 = (bytes_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = *(bytes_t **)&jarg2; 
  if (arg1) (arg1)->retcodes = (bytes_t const *)arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1retcodes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  bytes_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (bytes_t *) ((arg1)->retcodes);
  *(bytes_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1instruc_1start_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->instruc_start = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1instruc_1start_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (int) ((arg1)->instruc_start);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1instruc_1end_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->instruc_end = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1instruc_1end_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (int) ((arg1)->instruc_end);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1is_1canon_1insn(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  uint16 arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = (uint16)jarg2; 
  result = (bool)((processor_t const *)arg1)->is_canon_insn(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1instruc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  processor_t *arg1 = (processor_t *) 0 ;
  instruc_t *arg2 = (instruc_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = *(instruc_t **)&jarg2; 
  if (arg1) (arg1)->instruc = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1instruc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  instruc_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (instruc_t *) ((arg1)->instruc);
  *(instruc_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1tbyte_1size_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  if (arg1) (arg1)->tbyte_size = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1tbyte_1size_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result =  ((arg1)->tbyte_size);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1real_1width_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->real_width, (const char *)arg2, 4-1);
      arg1->real_width[4-1] = 0;
    } else {
      arg1->real_width[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1real_1width_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (char *)(char *) ((arg1)->real_width);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1icode_1return_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->icode_return = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1icode_1return_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (int) ((arg1)->icode_return);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1mvm_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  mvm_t *arg2 = (mvm_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = *(mvm_t **)&jarg2; 
  if (arg1) (arg1)->mvm = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1mvm_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  mvm_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (mvm_t *) ((arg1)->mvm);
  *(mvm_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1high_1fixup_1bits_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  processor_t *arg1 = (processor_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->high_fixup_bits = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_processor_1t_1high_1fixup_1bits_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  processor_t *arg1 = (processor_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  result = (int) ((arg1)->high_fixup_bits);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1processor_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  processor_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (processor_t *)new processor_t();
  *(processor_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1processor_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  processor_t *arg1 = (processor_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(processor_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ph_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  processor_t *arg1 = (processor_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(processor_t **)&jarg1; 
  ph = *arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ph_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  processor_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (processor_t *)&ph;
  *(processor_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ash_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  asm_t *arg1 = (asm_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(asm_t **)&jarg1; 
  ash = *arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ash_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  asm_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (asm_t *)&ash;
  *(asm_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_str2regf(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (int)str2regf((char const *)arg1);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_str2reg(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (int)str2reg((char const *)arg1);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1reg_1name_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jstring jarg3, jlong jarg4, jint jarg5) {
  jint jresult = 0 ;
  int arg1 ;
  size_t arg2 ;
  char *arg3 = (char *) 0 ;
  size_t arg4 ;
  int arg5 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (size_t)jarg4; 
  arg5 = (int)jarg5; 
  result = (ssize_t)get_reg_name(arg1,arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1reg_1name_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jstring jarg3, jlong jarg4) {
  jint jresult = 0 ;
  int arg1 ;
  size_t arg2 ;
  char *arg3 = (char *) 0 ;
  size_t arg4 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (size_t)jarg4; 
  result = (ssize_t)get_reg_name(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1reg_1info(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  uint64 *arg2 = (uint64 *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(uint64 **)&jarg2; 
  result = (char *)get_reg_info((char const *)arg1,arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_reg_1info_1t_1reg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  reg_info_t *arg1 = (reg_info_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(reg_info_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->reg = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_reg_1info_1t_1reg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  reg_info_t *arg1 = (reg_info_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(reg_info_t **)&jarg1; 
  result = (int) ((arg1)->reg);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_reg_1info_1t_1size_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  reg_info_t *arg1 = (reg_info_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(reg_info_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->size = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_reg_1info_1t_1size_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  reg_info_t *arg1 = (reg_info_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(reg_info_t **)&jarg1; 
  result = (int) ((arg1)->size);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_reg_1info_1t_1_1_1eq_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  reg_info_t *arg1 = (reg_info_t *) 0 ;
  reg_info_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(reg_info_t **)&jarg1; 
  arg2 = *(reg_info_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "reg_info_t const & reference is null");
    return 0;
  } 
  result = (bool)((reg_info_t const *)arg1)->operator ==((reg_info_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_reg_1info_1t_1_1_1ne_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  reg_info_t *arg1 = (reg_info_t *) 0 ;
  reg_info_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(reg_info_t **)&jarg1; 
  arg2 = *(reg_info_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "reg_info_t const & reference is null");
    return 0;
  } 
  result = (bool)((reg_info_t const *)arg1)->operator !=((reg_info_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1reg_1info_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  reg_info_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (reg_info_t *)new reg_info_t();
  *(reg_info_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1reg_1info_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  reg_info_t *arg1 = (reg_info_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(reg_info_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_parse_1reg_1name(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  reg_info_t *arg2 = (reg_info_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(reg_info_t **)&jarg2; 
  result = (bool)parse_reg_name((char const *)arg1,arg2);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_sizeof_1ldbl(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  result = sizeof_ldbl();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_intel_1data(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  intel_data(arg1);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_gen_1spcdef(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  uchar arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (uchar)jarg2; 
  result = (bool)gen_spcdef(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_gen_1extern(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)gen_extern(arg1,(char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_gen_1abssym(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)gen_abssym(arg1,(char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_gen_1comvar(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)gen_comvar(arg1,(char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1processor_1type(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (int)jarg2; 
  result = (char *)set_processor_type((char const *)arg1,arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1idp_1name(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (size_t)jarg2; 
  result = (char *)get_idp_name(arg1,arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1target_1assembler(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (bool)set_target_assembler(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_nbits(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (int)nbits(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_bytesize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (int)bytesize(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_create_1tform(JNIEnv *jenv, jclass jcls, jstring jarg1, jintArray jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  HWND *arg2 = (HWND *) 0 ;
  HWND temp2 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  {
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg2) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    arg2 = &temp2; 
  }
  result = (TForm *)create_tform((char const *)arg1,arg2);
  *(TForm **)&jresult = result; 
  {
    jint jvalue = (jint)temp2;
    jenv->SetIntArrayRegion(jarg2, 0, 1, &jvalue);
  }
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_askaddr(JNIEnv *jenv, jclass jcls, jlongArray jarg1, jstring jarg2) {
  jint jresult = 0 ;
  ea_t *arg1 = (ea_t *) 0 ;
  char *arg2 = (char *) 0 ;
  void *arg3 = 0 ;
  ea_t temp1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    if (!jarg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg1) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    arg1 = &temp1; 
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)askaddr(arg1,(char const *)arg2,arg3);
  jresult = (jint)result; 
  {
    jlong jvalue = (jlong)temp1;
    jenv->SetLongArrayRegion(jarg1, 0, 1, &jvalue);
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dirty_1infos_1set(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  dirty_infos = arg1;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dirty_1infos_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)dirty_infos;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_request_1refresh(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  request_refresh(arg1);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_exec_1request_1t_1valid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  exec_request_t *arg1 = (exec_request_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(exec_request_t **)&jarg1; 
  result = (bool)((exec_request_t const *)arg1)->valid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_exec_1request_1t_1code_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  exec_request_t *arg1 = (exec_request_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(exec_request_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->code = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_exec_1request_1t_1code_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  exec_request_t *arg1 = (exec_request_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(exec_request_t **)&jarg1; 
  result = (int) ((arg1)->code);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_exec_1request_1t_1sem_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  exec_request_t *arg1 = (exec_request_t *) 0 ;
  qsemaphore_t arg2 = (qsemaphore_t) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(exec_request_t **)&jarg1; 
  arg2 = *(qsemaphore_t *)&jarg2; 
  if (arg1) (arg1)->sem = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_exec_1request_1t_1sem_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  exec_request_t *arg1 = (exec_request_t *) 0 ;
  qsemaphore_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(exec_request_t **)&jarg1; 
  result = (qsemaphore_t) ((arg1)->sem);
  *(qsemaphore_t *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_exec_1request_1t_1execute(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  exec_request_t *arg1 = (exec_request_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(exec_request_t **)&jarg1; 
  result = (int)(arg1)->execute();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1exec_1request_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  exec_request_t *arg1 = (exec_request_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(exec_request_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_jumpto_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)jumpto(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_jumpto_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (bool)jumpto(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_banner(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (bool)banner(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1msg_1inited(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)is_msg_inited();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refresh_1idaview(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  refresh_idaview();
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refresh_1idaview_1anyway(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  refresh_idaview_anyway();
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_analyzer_1options(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  analyzer_options();
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1screen_1ea(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  result = (ea_t)get_screen_ea();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1opnum(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)get_opnum();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1cursor(JNIEnv *jenv, jclass jcls, jintArray jarg1, jintArray jarg2) {
  jboolean jresult = 0 ;
  int *arg1 = (int *) 0 ;
  int *arg2 = (int *) 0 ;
  int temp1 ;
  int temp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  {
    if (!jarg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg1) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    arg1 = &temp1; 
  }
  {
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg2) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    arg2 = &temp2; 
  }
  result = (bool)get_cursor(arg1,arg2);
  jresult = (jboolean)result; 
  {
    jint jvalue = (jint)temp1;
    jenv->SetIntArrayRegion(jarg1, 0, 1, &jvalue);
  }
  {
    jint jvalue = (jint)temp2;
    jenv->SetIntArrayRegion(jarg2, 0, 1, &jvalue);
  }
  
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1curline(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)get_curline();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_read_1selection(JNIEnv *jenv, jclass jcls, jlongArray jarg1, jlongArray jarg2) {
  jboolean jresult = 0 ;
  ea_t *arg1 = (ea_t *) 0 ;
  ea_t *arg2 = (ea_t *) 0 ;
  ea_t temp1 ;
  ea_t temp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  {
    if (!jarg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg1) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    arg1 = &temp1; 
  }
  {
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg2) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    arg2 = &temp2; 
  }
  result = (bool)read_selection(arg1,arg2);
  jresult = (jboolean)result; 
  {
    jlong jvalue = (jlong)temp1;
    jenv->SetLongArrayRegion(jarg1, 0, 1, &jvalue);
  }
  {
    jlong jvalue = (jlong)temp2;
    jenv->SetLongArrayRegion(jarg2, 0, 1, &jvalue);
  }
  
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_unmark_1selection(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  unmark_selection();
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1url(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  open_url((char const *)arg1);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1hexdump_1ea(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (ea_t)get_hexdump_ea(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1xml_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jstring jarg3) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (bool)set_xml((char const *)arg1,(char const *)arg2,(char const *)arg3);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1xml(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  idc_value_t *arg2 = (idc_value_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(idc_value_t **)&jarg2; 
  result = (bool)get_xml((char const *)arg1,arg2);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_del_1xml(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (bool)del_xml((char const *)arg1);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_push_1xml(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (bool)push_xml((char const *)arg1);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_pop_1xml(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)pop_xml();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1key_1code(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (ushort)get_key_code((char const *)arg1);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refresh_1navband(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  bool arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  refresh_navband(arg1);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refresh_1chooser(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (bool)refresh_chooser((char const *)arg1);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_close_1chooser(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (bool)close_chooser((char const *)arg1);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_install_1command_1interpreter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  cli_t *arg1 = (cli_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(cli_t **)&jarg1; 
  install_command_interpreter((cli_t const *)arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_remove_1command_1interpreter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  cli_t *arg1 = (cli_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(cli_t **)&jarg1; 
  remove_command_interpreter((cli_t const *)arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_gen_1disasm_1text(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jboolean jarg4) {
  ea_t arg1 ;
  ea_t arg2 ;
  text_t *arg3 = 0 ;
  bool arg4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = *(text_t **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "text_t & reference is null");
    return ;
  } 
  arg4 = jarg4 ? true : false; 
  gen_disasm_text(arg1,arg2,*arg3,arg4);
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_execute_1sync(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  exec_request_t *arg1 = 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(exec_request_t **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "exec_request_t & reference is null");
    return 0;
  } 
  arg2 = (int)jarg2; 
  result = (int)execute_sync(*arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1dock_1pos_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6, jint jarg7) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int arg6 ;
  int arg7 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (int)jarg6; 
  arg7 = (int)jarg7; 
  result = (bool)set_dock_pos((char const *)arg1,(char const *)arg2,arg3,arg4,arg5,arg6,arg7);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1dock_1pos_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int arg6 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (int)jarg6; 
  result = (bool)set_dock_pos((char const *)arg1,(char const *)arg2,arg3,arg4,arg5,arg6);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1dock_1pos_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jint jarg3, jint jarg4, jint jarg5) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  result = (bool)set_dock_pos((char const *)arg1,(char const *)arg2,arg3,arg4,arg5);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1dock_1pos_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jint jarg3, jint jarg4) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (bool)set_dock_pos((char const *)arg1,(char const *)arg2,arg3,arg4);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1dock_1pos_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  result = (bool)set_dock_pos((char const *)arg1,(char const *)arg2,arg3);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_enable_1input_1hotkeys(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)enable_input_hotkeys(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_add_1menu_1item(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jstring jarg3, jint jarg4, jlong jarg5, jlong jarg6) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  menu_item_callback_t *arg5 = (menu_item_callback_t *) 0 ;
  void *arg6 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int)jarg4; 
  arg5 = *(menu_item_callback_t **)&jarg5; 
  arg6 = *(void **)&jarg6; 
  result = (bool)add_menu_item((char const *)arg1,(char const *)arg2,(char const *)arg3,arg4,arg5,arg6);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_del_1menu_1item(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (bool)del_menu_item((char const *)arg1);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1tform_1handle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  TForm *arg1 = (TForm *) 0 ;
  HWND result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TForm **)&jarg1; 
  result = (HWND)get_tform_handle(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1tform(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  TForm *arg1 = (TForm *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TForm **)&jarg1; 
  arg2 = (int)jarg2; 
  open_tform(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_close_1tform(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  TForm *arg1 = (TForm *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TForm **)&jarg1; 
  arg2 = (int)jarg2; 
  close_tform(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_switchto_1tform(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
  TForm *arg1 = (TForm *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TForm **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  switchto_tform(arg1,arg2);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_find_1tform(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (TForm *)find_tform((char const *)arg1);
  *(TForm **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1current_1tform(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (TForm *)get_current_tform();
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_create_1custom_1viewer(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jint jarg6, jlong jarg7) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  TWinControl *arg2 = (TWinControl *) 0 ;
  place_t *arg3 = (place_t *) 0 ;
  place_t *arg4 = (place_t *) 0 ;
  place_t *arg5 = (place_t *) 0 ;
  int arg6 ;
  void *arg7 = (void *) 0 ;
  TCustomControl *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(TWinControl **)&jarg2; 
  arg3 = *(place_t **)&jarg3; 
  arg4 = *(place_t **)&jarg4; 
  arg5 = *(place_t **)&jarg5; 
  arg6 = (int)jarg6; 
  arg7 = *(void **)&jarg7; 
  result = (TCustomControl *)create_custom_viewer((char const *)arg1,arg2,(place_t const *)arg3,(place_t const *)arg4,(place_t const *)arg5,arg6,arg7);
  *(TCustomControl **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_refresh_1custom_1viewer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  TCustomControl *arg1 = (TCustomControl *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TCustomControl **)&jarg1; 
  refresh_custom_viewer(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_destroy_1custom_1viewer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  TCustomControl *arg1 = (TCustomControl *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TCustomControl **)&jarg1; 
  destroy_custom_viewer(arg1);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_jumpto_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jint jarg4) {
  jboolean jresult = 0 ;
  TCustomControl *arg1 = (TCustomControl *) 0 ;
  place_t *arg2 = (place_t *) 0 ;
  int arg3 ;
  int arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TCustomControl **)&jarg1; 
  arg2 = *(place_t **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (bool)jumpto(arg1,arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1custom_1viewer_1place(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2, jintArray jarg3, jintArray jarg4) {
  jlong jresult = 0 ;
  TCustomControl *arg1 = (TCustomControl *) 0 ;
  bool arg2 ;
  int *arg3 = (int *) 0 ;
  int *arg4 = (int *) 0 ;
  int temp3 ;
  int temp4 ;
  place_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TCustomControl **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg3) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    arg3 = &temp3; 
  }
  {
    if (!jarg4) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg4) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    arg4 = &temp4; 
  }
  result = (place_t *)get_custom_viewer_place(arg1,arg2,arg3,arg4);
  *(place_t **)&jresult = result; 
  {
    jint jvalue = (jint)temp3;
    jenv->SetIntArrayRegion(jarg3, 0, 1, &jvalue);
  }
  {
    jint jvalue = (jint)temp4;
    jenv->SetIntArrayRegion(jarg4, 0, 1, &jvalue);
  }
  
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1custom_1viewer_1popup_1menu(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  TCustomControl *arg1 = (TCustomControl *) 0 ;
  TPopupMenu *arg2 = (TPopupMenu *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TCustomControl **)&jarg1; 
  arg2 = *(TPopupMenu **)&jarg2; 
  set_custom_viewer_popup_menu(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_add_1custom_1viewer_1popup_1item(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jlong jarg4, jlong jarg5) {
  TCustomControl *arg1 = (TCustomControl *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  menu_item_callback_t *arg4 = (menu_item_callback_t *) 0 ;
  void *arg5 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TCustomControl **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = *(menu_item_callback_t **)&jarg4; 
  arg5 = *(void **)&jarg5; 
  add_custom_viewer_popup_item(arg1,(char const *)arg2,(char const *)arg3,arg4,arg5);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1custom_1viewer_1handlers(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7) {
  TCustomControl *arg1 = (TCustomControl *) 0 ;
  custom_viewer_keydown_t *arg2 = (custom_viewer_keydown_t *) 0 ;
  custom_viewer_popup_t *arg3 = (custom_viewer_popup_t *) 0 ;
  custom_viewer_dblclick_t *arg4 = (custom_viewer_dblclick_t *) 0 ;
  custom_viewer_curpos_t *arg5 = (custom_viewer_curpos_t *) 0 ;
  custom_viewer_close_t *arg6 = (custom_viewer_close_t *) 0 ;
  void *arg7 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TCustomControl **)&jarg1; 
  arg2 = *(custom_viewer_keydown_t **)&jarg2; 
  arg3 = *(custom_viewer_popup_t **)&jarg3; 
  arg4 = *(custom_viewer_dblclick_t **)&jarg4; 
  arg5 = *(custom_viewer_curpos_t **)&jarg5; 
  arg6 = *(custom_viewer_close_t **)&jarg6; 
  arg7 = *(void **)&jarg7; 
  set_custom_viewer_handlers(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1custom_1viewer_1handler(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  TCustomControl *arg1 = (TCustomControl *) 0 ;
  custom_viewer_handler_id_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TCustomControl **)&jarg1; 
  arg2 = (custom_viewer_handler_id_t)jarg2; 
  arg3 = *(void **)&jarg3; 
  result = (void *)set_custom_viewer_handler(arg1,arg2,arg3);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1custom_1viewer_1curline(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
  jstring jresult = 0 ;
  TCustomControl *arg1 = (TCustomControl *) 0 ;
  bool arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TCustomControl **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (char *)get_custom_viewer_curline(arg1,arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1current_1viewer(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  TCustomControl *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (TCustomControl *)get_current_viewer();
  *(TCustomControl **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1custom_1viewer_1range(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  TCustomControl *arg1 = (TCustomControl *) 0 ;
  place_t *arg2 = (place_t *) 0 ;
  place_t *arg3 = (place_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TCustomControl **)&jarg1; 
  arg2 = *(place_t **)&jarg2; 
  arg3 = *(place_t **)&jarg3; 
  set_custom_viewer_range(arg1,(place_t const *)arg2,(place_t const *)arg3);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1idaview(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  TCustomControl *arg1 = (TCustomControl *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TCustomControl **)&jarg1; 
  result = (bool)is_idaview(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_readsel2(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  TCustomControl *arg1 = (TCustomControl *) 0 ;
  twinpos_t *arg2 = (twinpos_t *) 0 ;
  twinpos_t *arg3 = (twinpos_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TCustomControl **)&jarg1; 
  arg2 = *(twinpos_t **)&jarg2; 
  arg3 = *(twinpos_t **)&jarg3; 
  result = (bool)readsel2(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_clearBreak(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  clearBreak();
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_setBreak(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  setBreak();
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_wasBreak(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)wasBreak();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ui_1load_1new_1file(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  linput_t *arg2 = (linput_t *) 0 ;
  ushort arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(linput_t **)&jarg2; 
  arg3 = (ushort)jarg3; 
  result = (bool)ui_load_new_file((char const *)arg1,arg2,arg3);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ui_1run_1debugger(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jint jarg3, jlong jarg4) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  char **arg4 = (char **) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  arg4 = *(char ***)&jarg4; 
  result = (bool)ui_run_debugger((char const *)arg1,(char const *)arg2,arg3,arg4);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_add_1idc_1hotkey(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)add_idc_hotkey((char const *)arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_del_1idc_1hotkey(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (bool)del_idc_hotkey((char const *)arg1);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1exports_1window(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (TForm *)open_exports_window(arg1);
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1imports_1window(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (TForm *)open_imports_window(arg1);
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1names_1window(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (TForm *)open_names_window(arg1);
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1funcs_1window(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (TForm *)open_funcs_window(arg1);
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1strings_1window_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  ea_t arg3 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (ea_t)jarg3; 
  result = (TForm *)open_strings_window(arg1,arg2,arg3);
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1strings_1window_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (TForm *)open_strings_window(arg1,arg2);
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1strings_1window_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (TForm *)open_strings_window(arg1);
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1segments_1window(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (TForm *)open_segments_window(arg1);
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1segregs_1window(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (TForm *)open_segregs_window(arg1);
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1selectors_1window(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (TForm *)open_selectors_window();
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1signatures_1window(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (TForm *)open_signatures_window();
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1tils_1window(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (TForm *)open_tils_window();
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1loctypes_1window(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (TForm *)open_loctypes_window(arg1);
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1calls_1window(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (TForm *)open_calls_window(arg1);
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1problems_1window(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (TForm *)open_problems_window(arg1);
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1bpts_1window(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (TForm *)open_bpts_window(arg1);
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1threads_1window(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (TForm *)open_threads_window();
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1modules_1window(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (TForm *)open_modules_window();
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1trace_1window(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (TForm *)open_trace_window();
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1stack_1window(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (TForm *)open_stack_window();
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1xrefs_1window(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (TForm *)open_xrefs_window(arg1);
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1frame_1window(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  uval_t arg2 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = (uval_t)jarg2; 
  result = (TForm *)open_frame_window(arg1,arg2);
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1navband_1window(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (TForm *)open_navband_window(arg1,arg2);
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1enums_1window_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  tid_t arg1 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (tid_t)jarg1; 
  result = (TForm *)open_enums_window(arg1);
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1enums_1window_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (TForm *)open_enums_window();
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1structs_1window_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  tid_t arg1 ;
  uval_t arg2 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (tid_t)jarg1; 
  arg2 = (uval_t)jarg2; 
  result = (TForm *)open_structs_window(arg1,arg2);
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1structs_1window_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  tid_t arg1 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (tid_t)jarg1; 
  result = (TForm *)open_structs_window(arg1);
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1structs_1window_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (TForm *)open_structs_window();
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1disasm_1window_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  areavec_t *arg2 = (areavec_t *) 0 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(areavec_t **)&jarg2; 
  result = (TForm *)open_disasm_window((char const *)arg1,(areavec_t const *)arg2);
  *(TForm **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1disasm_1window_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (TForm *)open_disasm_window((char const *)arg1);
  *(TForm **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1hexdump_1window(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (TForm *)open_hexdump_window((char const *)arg1);
  *(TForm **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1notepad_1window(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  TForm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (TForm *)open_notepad_window();
  *(TForm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_choose_1idasgn(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)choose_idasgn();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_choose_1til(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (size_t)jarg2; 
  result = (bool)choose_til(arg1,arg2);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_choose_1entry(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (ea_t)choose_entry((char const *)arg1);
  jresult = (jlong)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_choose_1name(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (ea_t)choose_name((char const *)arg1);
  jresult = (jlong)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_choose_1stkvar_1xref(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  member_t *arg2 = (member_t *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = *(member_t **)&jarg2; 
  result = (ea_t)choose_stkvar_xref(arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_choose_1xref(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (ea_t)choose_xref(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_choose_1enum(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  enum_t arg2 ;
  enum_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (enum_t)jarg2; 
  result = (enum_t)choose_enum((char const *)arg1,arg2);
  jresult = (jlong)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_choose_1enum_1by_1value(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  enum_t arg2 ;
  uval_t arg3 ;
  uchar *arg4 = (uchar *) 0 ;
  enum_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (enum_t)jarg2; 
  arg3 = (uval_t)jarg3; 
  arg4 = *(uchar **)&jarg4; 
  result = (enum_t)choose_enum_by_value((char const *)arg1,arg2,arg3,arg4);
  jresult = (jlong)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_choose_1func(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  ea_t arg2 ;
  func_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (ea_t)jarg2; 
  result = (func_t *)choose_func((char const *)arg1,arg2);
  *(func_t **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_choose_1segm(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  ea_t arg2 ;
  segment_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (ea_t)jarg2; 
  result = (segment_t *)choose_segm((char const *)arg1,arg2);
  *(segment_t **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_choose_1segreg(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  segreg_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (segreg_t *)choose_segreg((char const *)arg1);
  *(segreg_t **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_choose_1struc(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  struc_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (struc_t *)choose_struc((char const *)arg1);
  *(struc_t **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_add_1chooser_1command_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3, jint jarg4, jint jarg5, jint jarg6) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  chooser_cb_t *arg3 = (chooser_cb_t *) 0 ;
  int arg4 ;
  int arg5 ;
  int arg6 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(chooser_cb_t **)&jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (int)jarg6; 
  result = (bool)add_chooser_command((char const *)arg1,(char const *)arg2,arg3,arg4,arg5,arg6);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_add_1chooser_1command_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3, jint jarg4, jint jarg5) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  chooser_cb_t *arg3 = (chooser_cb_t *) 0 ;
  int arg4 ;
  int arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(chooser_cb_t **)&jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  result = (bool)add_chooser_command((char const *)arg1,(char const *)arg2,arg3,arg4,arg5);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_add_1chooser_1command_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3, jint jarg4) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  chooser_cb_t *arg3 = (chooser_cb_t *) 0 ;
  int arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(chooser_cb_t **)&jarg3; 
  arg4 = (int)jarg4; 
  result = (bool)add_chooser_command((char const *)arg1,(char const *)arg2,arg3,arg4);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_add_1chooser_1command_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  chooser_cb_t *arg3 = (chooser_cb_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(chooser_cb_t **)&jarg3; 
  result = (bool)add_chooser_command((char const *)arg1,(char const *)arg2,arg3);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1chooser_1obj(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (void *)get_chooser_obj((char const *)arg1);
  *(void **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_enable_1chooser_1item_1attrs(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = jarg2 ? true : false; 
  result = (bool)enable_chooser_item_attrs((char const *)arg1,arg2);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_show_1wait_1box_1v(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  char *arg1 = (char *) 0 ;
  va_list arg2 ;
  va_list *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  argp2 = *(va_list **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null va_list");
    return ;
  }
  arg2 = *argp2; 
  show_wait_box_v((char const *)arg1,arg2);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_show_1wait_1box(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  show_wait_box((char const *)arg1,arg2);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_hide_1wait_1box(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  hide_wait_box();
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_replace_1wait_1box(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  replace_wait_box((char const *)arg1,arg2);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_AskUsingForm_1cv(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  va_list arg2 ;
  va_list *argp2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  argp2 = *(va_list **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null va_list");
    return 0;
  }
  arg2 = *argp2; 
  result = (int)AskUsingForm_cv((char const *)arg1,arg2);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_close_1form(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  TView **arg1 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TView ***)&jarg1; 
  arg2 = (int)jarg2; 
  close_form(arg1,arg2);
  
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_beep_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  beep_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (beep_t)jarg1; 
  beep(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_beep_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  beep();
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_askbuttons_1cv(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jstring jarg3, jint jarg4, jstring jarg5, jlong jarg6) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  char *arg5 = (char *) 0 ;
  va_list arg6 ;
  va_list *argp6 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int)jarg4; 
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  argp6 = *(va_list **)&jarg6; 
  if (!argp6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null va_list");
    return 0;
  }
  arg6 = *argp6; 
  result = (int)askbuttons_cv((char const *)arg1,(char const *)arg2,(char const *)arg3,arg4,(char const *)arg5,arg6);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_askfile_1cv(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jstring jarg3, jlong jarg4) {
  jstring jresult = 0 ;
  int arg1 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  va_list arg4 ;
  va_list *argp4 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  argp4 = *(va_list **)&jarg4; 
  if (!argp4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null va_list");
    return 0;
  }
  arg4 = *argp4; 
  result = (char *)askfile_cv(arg1,(char const *)arg2,(char const *)arg3,arg4);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ask_1for_1feedback(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  ask_for_feedback((char const *)arg1,arg2);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_askident(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  void *arg3 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)askident((char const *)arg1,(char const *)arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_askseg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  sel_t *arg1 = (sel_t *) 0 ;
  char *arg2 = (char *) 0 ;
  void *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sel_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)askseg(arg1,(char const *)arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asklong(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  sval_t *arg1 = (sval_t *) 0 ;
  char *arg2 = (char *) 0 ;
  void *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sval_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)asklong(arg1,(char const *)arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_vaskstr(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jstring jarg3, jlong jarg4) {
  jstring jresult = 0 ;
  int arg1 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  va_list arg4 ;
  va_list *argp4 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  argp4 = *(va_list **)&jarg4; 
  if (!argp4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null va_list");
    return 0;
  }
  arg4 = *argp4; 
  result = (char *)vaskstr(arg1,(char const *)arg2,(char const *)arg3,arg4);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_vasktext(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jlong jarg5) {
  jstring jresult = 0 ;
  size_t arg1 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  va_list arg5 ;
  va_list *argp5 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (size_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  argp5 = *(va_list **)&jarg5; 
  if (!argp5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null va_list");
    return 0;
  }
  arg5 = *argp5; 
  result = (char *)vasktext(arg1,arg2,(char const *)arg3,(char const *)arg4,arg5);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_vwarning(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  char *arg1 = (char *) 0 ;
  va_list arg2 ;
  va_list *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  argp2 = *(va_list **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null va_list");
    return ;
  }
  arg2 = *argp2; 
  vwarning((char const *)arg1,arg2);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_vinfo(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  char *arg1 = (char *) 0 ;
  va_list arg2 ;
  va_list *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  argp2 = *(va_list **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null va_list");
    return ;
  }
  arg2 = *argp2; 
  vinfo((char const *)arg1,arg2);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_vnomem(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  char *arg1 = (char *) 0 ;
  va_list arg2 ;
  va_list *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  argp2 = *(va_list **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null va_list");
    return ;
  }
  arg2 = *argp2; 
  vnomem((char const *)arg1,arg2);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_vmsg(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  va_list arg2 ;
  va_list *argp2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  argp2 = *(va_list **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null va_list");
    return 0;
  }
  arg2 = *argp2; 
  result = (int)vmsg((char const *)arg1,arg2);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_display_1copyright_1warning(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)display_copyright_warning();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1xml_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  result = (bool)set_xml((char const *)arg1,(char const *)arg2,arg3);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_batch_1set(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  batch = arg1;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_batch_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)batch;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_errorexit_1set(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  errorexit = arg1;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_errorexit_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)errorexit;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_error(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  error((char const *)arg1,arg2);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_warning(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  warning((char const *)arg1,arg2);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_info(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  info((char const *)arg1,arg2);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_nomem(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  nomem((char const *)arg1,arg2);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_msg(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  void *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (int)msg((char const *)arg1,arg2);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_askyn_1cv(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jlong jarg3) {
  jint jresult = 0 ;
  int arg1 ;
  char *arg2 = (char *) 0 ;
  va_list arg3 ;
  va_list *argp3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  argp3 = *(va_list **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null va_list");
    return 0;
  }
  arg3 = *argp3; 
  result = (int)askyn_cv(arg1,(char const *)arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_askyn_1c(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jint jresult = 0 ;
  int arg1 ;
  char *arg2 = (char *) 0 ;
  void *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)askyn_c(arg1,(char const *)arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_askbuttons_1c(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jstring jarg3, jint jarg4, jstring jarg5) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  char *arg5 = (char *) 0 ;
  void *arg6 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int)jarg4; 
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  result = (int)askbuttons_c((char const *)arg1,(char const *)arg2,(char const *)arg3,arg4,(char const *)arg5,arg6);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_askstr(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jstring jarg3) {
  jstring jresult = 0 ;
  int arg1 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  void *arg4 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (char *)askstr(arg1,(char const *)arg2,(char const *)arg3,arg4);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_askfile_1c(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jstring jarg3) {
  jstring jresult = 0 ;
  int arg1 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  void *arg4 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (char *)askfile_c(arg1,(char const *)arg2,(char const *)arg3,arg4);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_print_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jint jarg4, jint jarg5, jint jarg6) {
  jstring jresult = 0 ;
  uint32 arg1 ;
  uint32 arg2 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  int arg5 ;
  int arg6 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32)jarg1; 
  arg2 = (uint32)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (int)jarg6; 
  result = (char *)print(arg1,arg2,arg3,arg4,arg5,arg6);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_make_1longlong(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  uint32 arg1 ;
  int32 arg2 ;
  longlong result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32)jarg1; 
  arg2 = (int32)jarg2; 
  result = make_longlong(arg1,arg2);
  *(longlong **)&jresult = new longlong((const longlong &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_make_1ulonglong(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  uint32 arg1 ;
  int32 arg2 ;
  ulonglong result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32)jarg1; 
  arg2 = (int32)jarg2; 
  result = make_ulonglong(arg1,arg2);
  *(ulonglong **)&jresult = new ulonglong((const ulonglong &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_low_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ulonglong *arg1 = 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ulonglong **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "ulonglong const & reference is null");
    return 0;
  } 
  result = (uint32)low((ulonglong const &)*arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_high_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ulonglong *arg1 = 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ulonglong **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "ulonglong const & reference is null");
    return 0;
  } 
  result = (uint32)high((ulonglong const &)*arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_low_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  longlong *arg1 = 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(longlong **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "longlong const & reference is null");
    return 0;
  } 
  result = (uint32)low((longlong const &)*arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_high_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  longlong *arg1 = 0 ;
  int32 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(longlong **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "longlong const & reference is null");
    return 0;
  } 
  result = (int32)high((longlong const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_print_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jint jarg4) {
  jstring jresult = 0 ;
  longlong arg1 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int arg4 ;
  longlong *argp1 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(longlong **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null longlong");
    return 0;
  }
  arg1 = *argp1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (char *)print(arg1,arg2,arg3,arg4);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_print_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jint jarg4) {
  jstring jresult = 0 ;
  ulonglong arg1 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int arg4 ;
  ulonglong *argp1 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(ulonglong **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null ulonglong");
    return 0;
  }
  arg1 = *argp1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (char *)print(arg1,arg2,arg3,arg4);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_llong_1scan(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int arg2 ;
  char **arg3 = (char **) 0 ;
  longlong result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (int)jarg2; 
  arg3 = *(char ***)&jarg3; 
  result = llong_scan((char const *)arg1,arg2,(char const **)arg3);
  *(longlong **)&jresult = new longlong((const longlong &)result); 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_swap64_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ulonglong arg1 ;
  ulonglong *argp1 ;
  ulonglong result;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(ulonglong **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null ulonglong");
    return 0;
  }
  arg1 = *argp1; 
  result = swap64(arg1);
  *(ulonglong **)&jresult = new ulonglong((const ulonglong &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_swap64_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  longlong arg1 ;
  longlong *argp1 ;
  longlong result;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(longlong **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null longlong");
    return 0;
  }
  arg1 = *argp1; 
  result = swap64(arg1);
  *(longlong **)&jresult = new longlong((const longlong &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_swap128(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  uint128 *arg1 = (uint128 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uint128 **)&jarg1; 
  swap128(arg1);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ivalue(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  help_t arg1 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (help_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (char *)ivalue(arg1,arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qivalue(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  help_t arg1 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (help_t)jarg1; 
  result = (char *)qivalue(arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_Err(JNIEnv *jenv, jclass jcls, jint jarg1) {
  help_t arg1 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (help_t)jarg1; 
  Err(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_Warn(JNIEnv *jenv, jclass jcls, jint jarg1) {
  help_t arg1 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (help_t)jarg1; 
  Warn(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_Info(JNIEnv *jenv, jclass jcls, jint jarg1) {
  help_t arg1 ;
  void *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (help_t)jarg1; 
  Info(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_Message(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  help_t arg1 ;
  void *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (help_t)jarg1; 
  result = (int)Message(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_askyn_1v(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  int arg1 ;
  help_t arg2 ;
  va_list arg3 ;
  va_list *argp3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (help_t)jarg2; 
  argp3 = *(va_list **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null va_list");
    return 0;
  }
  arg3 = *argp3; 
  result = (int)askyn_v(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_askyn(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jint jresult = 0 ;
  int arg1 ;
  help_t arg2 ;
  void *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (help_t)jarg2; 
  result = (int)askyn(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1predef_1insn_1cmt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jint jresult = 0 ;
  insn_t *arg1 = 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "insn_t const & reference is null");
    return 0;
  } 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (ssize_t)get_predef_insn_cmt((insn_t const &)*arg1,arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1predef_1cmt(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2, jstring jarg3, jlong jarg4) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  size_t arg4 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (size_t)jarg4; 
  result = (ssize_t)get_predef_cmt((char const *)arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1vxd_1func_1name(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jstring jarg3, jlong jarg4) {
  jstring jresult = 0 ;
  int arg1 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  size_t arg4 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (size_t)jarg4; 
  result = (char *)get_vxd_func_name(arg1,arg2,arg3,arg4);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_enum_1processor_1modules_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4, jlong jarg5) {
  jint jresult = 0 ;
  enum_processor_modules_cb arg1 = (enum_processor_modules_cb) 0 ;
  void *arg2 = (void *) 0 ;
  char *arg3 = (char *) 0 ;
  size_t arg4 ;
  extlang_t **arg5 = (extlang_t **) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(enum_processor_modules_cb *)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (size_t)jarg4; 
  arg5 = *(extlang_t ***)&jarg5; 
  result = (int)enum_processor_modules(arg1,arg2,arg3,arg4,(extlang_t const **)arg5);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_enum_1processor_1modules_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4) {
  jint jresult = 0 ;
  enum_processor_modules_cb arg1 = (enum_processor_modules_cb) 0 ;
  void *arg2 = (void *) 0 ;
  char *arg3 = (char *) 0 ;
  size_t arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(enum_processor_modules_cb *)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (size_t)jarg4; 
  result = (int)enum_processor_modules(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_enum_1plugins_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4, jlong jarg5) {
  jint jresult = 0 ;
  enum_plugins_cb arg1 = (enum_plugins_cb) 0 ;
  void *arg2 = (void *) 0 ;
  char *arg3 = (char *) 0 ;
  size_t arg4 ;
  extlang_t **arg5 = (extlang_t **) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(enum_plugins_cb *)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (size_t)jarg4; 
  arg5 = *(extlang_t ***)&jarg5; 
  result = (int)enum_plugins(arg1,arg2,arg3,arg4,(extlang_t const **)arg5);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_enum_1plugins_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4) {
  jint jresult = 0 ;
  enum_plugins_cb arg1 = (enum_plugins_cb) 0 ;
  void *arg2 = (void *) 0 ;
  char *arg3 = (char *) 0 ;
  size_t arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(enum_plugins_cb *)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (size_t)jarg4; 
  result = (int)enum_plugins(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_loader_1t_1version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  loader_t *arg1 = (loader_t *) 0 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(loader_t **)&jarg1; 
  arg2 = (uint32)jarg2; 
  if (arg1) (arg1)->version = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_loader_1t_1version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  loader_t *arg1 = (loader_t *) 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(loader_t **)&jarg1; 
  result = (uint32) ((arg1)->version);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_loader_1t_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  loader_t *arg1 = (loader_t *) 0 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(loader_t **)&jarg1; 
  arg2 = (uint32)jarg2; 
  if (arg1) (arg1)->flags = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_loader_1t_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  loader_t *arg1 = (loader_t *) 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(loader_t **)&jarg1; 
  result = (uint32) ((arg1)->flags);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1loader_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  loader_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (loader_t *)new loader_t();
  *(loader_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1loader_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  loader_t *arg1 = (loader_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(loader_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_load_1info_1t_1next_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  load_info_t *arg1 = (load_info_t *) 0 ;
  load_info_t *arg2 = (load_info_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(load_info_t **)&jarg1; 
  arg2 = *(load_info_t **)&jarg2; 
  if (arg1) (arg1)->next = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_load_1info_1t_1next_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  load_info_t *arg1 = (load_info_t *) 0 ;
  load_info_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(load_info_t **)&jarg1; 
  result = (load_info_t *) ((arg1)->next);
  *(load_info_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_load_1info_1t_1dllname_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  load_info_t *arg1 = (load_info_t *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(load_info_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->dllname, (const char *)arg2, QMAXPATH-1);
      arg1->dllname[QMAXPATH-1] = 0;
    } else {
      arg1->dllname[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_load_1info_1t_1dllname_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  load_info_t *arg1 = (load_info_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(load_info_t **)&jarg1; 
  result = (char *)(char *) ((arg1)->dllname);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_load_1info_1t_1ftypename_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  load_info_t *arg1 = (load_info_t *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(load_info_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->ftypename, (const char *)arg2, 64-1);
      arg1->ftypename[64-1] = 0;
    } else {
      arg1->ftypename[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_load_1info_1t_1ftypename_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  load_info_t *arg1 = (load_info_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(load_info_t **)&jarg1; 
  result = (char *)(char *) ((arg1)->ftypename);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_load_1info_1t_1ftype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  load_info_t *arg1 = (load_info_t *) 0 ;
  filetype_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(load_info_t **)&jarg1; 
  arg2 = (filetype_t)jarg2; 
  if (arg1) (arg1)->ftype = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_load_1info_1t_1ftype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  load_info_t *arg1 = (load_info_t *) 0 ;
  filetype_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(load_info_t **)&jarg1; 
  result = (filetype_t) ((arg1)->ftype);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_load_1info_1t_1pri_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  load_info_t *arg1 = (load_info_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(load_info_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->pri = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_load_1info_1t_1pri_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  load_info_t *arg1 = (load_info_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(load_info_t **)&jarg1; 
  result = (int) ((arg1)->pri);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1load_1info_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  load_info_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (load_info_t *)new load_info_t();
  *(load_info_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1load_1info_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  load_info_t *arg1 = (load_info_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(load_info_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_build_1loaders_1list(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  load_info_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  result = (load_info_t *)build_loaders_list(arg1);
  *(load_info_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_free_1loaders_1list(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  load_info_t *arg1 = (load_info_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(load_info_t **)&jarg1; 
  free_loaders_list(arg1);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1loader_1name_1from_1dll(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (char *)get_loader_name_from_dll(arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1loader_1name(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (size_t)jarg2; 
  result = (ssize_t)get_loader_name(arg1,arg2);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_init_1loader_1options(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  load_info_t *arg2 = (load_info_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(linput_t **)&jarg1; 
  arg2 = *(load_info_t **)&jarg2; 
  result = (bool)init_loader_options(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_load_1binary_1file(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jint jarg3, jint jarg4, jlong jarg5, jlong jarg6, jlong jarg7) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  linput_t *arg2 = (linput_t *) 0 ;
  ushort arg3 ;
  int32 arg4 ;
  ea_t arg5 ;
  ea_t arg6 ;
  uint32 arg7 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(linput_t **)&jarg2; 
  arg3 = (ushort)jarg3; 
  arg4 = (int32)jarg4; 
  arg5 = (ea_t)jarg5; 
  arg6 = (ea_t)jarg6; 
  arg7 = (uint32)jarg7; 
  result = (bool)load_binary_file((char const *)arg1,arg2,arg3,arg4,arg5,arg6,arg7);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_load_1nonbinary_1file(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jstring jarg3, jint jarg4, jlong jarg5, jobject jarg5_) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  linput_t *arg2 = (linput_t *) 0 ;
  char *arg3 = (char *) 0 ;
  ushort arg4 ;
  load_info_t *arg5 = (load_info_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg5_;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(linput_t **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (ushort)jarg4; 
  arg5 = *(load_info_t **)&jarg5; 
  result = (bool)load_nonbinary_file((char const *)arg1,arg2,(char const *)arg3,arg4,arg5);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_OFILE_1MAP_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ofile_type_t result;
  
  (void)jenv;
  (void)jcls;
  result = (ofile_type_t)(ofile_type_t)OFILE_MAP;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_OFILE_1EXE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ofile_type_t result;
  
  (void)jenv;
  (void)jcls;
  result = (ofile_type_t)(ofile_type_t)OFILE_EXE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_OFILE_1IDC_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ofile_type_t result;
  
  (void)jenv;
  (void)jcls;
  result = (ofile_type_t)(ofile_type_t)OFILE_IDC;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_OFILE_1LST_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ofile_type_t result;
  
  (void)jenv;
  (void)jcls;
  result = (ofile_type_t)(ofile_type_t)OFILE_LST;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_OFILE_1ASM_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ofile_type_t result;
  
  (void)jenv;
  (void)jcls;
  result = (ofile_type_t)(ofile_type_t)OFILE_ASM;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_OFILE_1DIF_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  ofile_type_t result;
  
  (void)jenv;
  (void)jcls;
  result = (ofile_type_t)(ofile_type_t)OFILE_DIF;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_gen_1file(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
  jint jresult = 0 ;
  ofile_type_t arg1 ;
  FILE *arg2 = (FILE *) 0 ;
  ea_t arg3 ;
  ea_t arg4 ;
  int arg5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ofile_type_t)jarg1; 
  arg2 = *(FILE **)&jarg2; 
  arg3 = (ea_t)jarg3; 
  arg4 = (ea_t)jarg4; 
  arg5 = (int)jarg5; 
  result = (int)gen_file(arg1,arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_file2base(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
  jint jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  int32 arg2 ;
  ea_t arg3 ;
  ea_t arg4 ;
  int arg5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  arg2 = (int32)jarg2; 
  arg3 = (ea_t)jarg3; 
  arg4 = (ea_t)jarg4; 
  arg5 = (int)jarg5; 
  result = (int)file2base(arg1,arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_mem2base(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
  jint jresult = 0 ;
  void *arg1 = (void *) 0 ;
  ea_t arg2 ;
  ea_t arg3 ;
  int32 arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (ea_t)jarg3; 
  arg4 = (int32)jarg4; 
  result = (int)mem2base((void const *)arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_base2file(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  int32 arg2 ;
  ea_t arg3 ;
  ea_t arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = (int32)jarg2; 
  arg3 = (ea_t)jarg3; 
  arg4 = (ea_t)jarg4; 
  result = (int)base2file(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_load_1loader_1module(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jboolean jarg4) {
  jint jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  bool arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = jarg4 ? true : false; 
  result = (int)load_loader_module(arg1,(char const *)arg2,(char const *)arg3,arg4);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_create_1filename_1cmt(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  create_filename_cmt();
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1basic_1file_1type(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  filetype_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  result = (filetype_t)get_basic_file_type(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1file_1type_1name(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (size_t)jarg2; 
  result = get_file_type_name(arg1,arg2);
  jresult = (jlong)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_import_1module(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3, jlong jarg4, jstring jarg5) {
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  uval_t arg3 ;
  importer_t arg4 = (importer_t) 0 ;
  char *arg5 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (uval_t)jarg3; 
  arg4 = *(importer_t *)&jarg4; 
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return ;
  }
  import_module((char const *)arg1,(char const *)arg2,arg3,arg4,(char const *)arg5);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_load_1ids_1module(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (int)load_ids_module(arg1);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1t_1version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  plugin_t *arg1 = (plugin_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->version = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1t_1version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  plugin_t *arg1 = (plugin_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_t **)&jarg1; 
  result = (int) ((arg1)->version);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1t_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  plugin_t *arg1 = (plugin_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->flags = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1t_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  plugin_t *arg1 = (plugin_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_t **)&jarg1; 
  result = (int) ((arg1)->flags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1t_1comment_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  plugin_t *arg1 = (plugin_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg2) {
      arg1->comment = (char const *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->comment, (const char *)arg2);
    } else {
      arg1->comment = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1t_1comment_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  plugin_t *arg1 = (plugin_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_t **)&jarg1; 
  result = (char *) ((arg1)->comment);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1t_1help_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  plugin_t *arg1 = (plugin_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg2) {
      arg1->help = (char const *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->help, (const char *)arg2);
    } else {
      arg1->help = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1t_1help_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  plugin_t *arg1 = (plugin_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_t **)&jarg1; 
  result = (char *) ((arg1)->help);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1t_1wanted_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  plugin_t *arg1 = (plugin_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg2) {
      arg1->wanted_name = (char const *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->wanted_name, (const char *)arg2);
    } else {
      arg1->wanted_name = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1t_1wanted_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  plugin_t *arg1 = (plugin_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_t **)&jarg1; 
  result = (char *) ((arg1)->wanted_name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1t_1wanted_1hotkey_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  plugin_t *arg1 = (plugin_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg2) {
      arg1->wanted_hotkey = (char const *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->wanted_hotkey, (const char *)arg2);
    } else {
      arg1->wanted_hotkey = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1t_1wanted_1hotkey_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  plugin_t *arg1 = (plugin_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_t **)&jarg1; 
  result = (char *) ((arg1)->wanted_hotkey);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1plugin_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  plugin_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (plugin_t *)new plugin_t();
  *(plugin_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1plugin_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  plugin_t *arg1 = (plugin_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(plugin_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_hook_1to_1notification_1point(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  hook_type_t arg1 ;
  hook_cb_t *arg2 = (hook_cb_t *) 0 ;
  void *arg3 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (hook_type_t)jarg1; 
  arg2 = *(hook_cb_t **)&jarg2; 
  arg3 = *(void **)&jarg3; 
  result = (bool)hook_to_notification_point(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_unhook_1from_1notification_1point_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  hook_type_t arg1 ;
  hook_cb_t *arg2 = (hook_cb_t *) 0 ;
  void *arg3 = (void *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (hook_type_t)jarg1; 
  arg2 = *(hook_cb_t **)&jarg2; 
  arg3 = *(void **)&jarg3; 
  result = (int)unhook_from_notification_point(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_unhook_1from_1notification_1point_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2) {
  jint jresult = 0 ;
  hook_type_t arg1 ;
  hook_cb_t *arg2 = (hook_cb_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (hook_type_t)jarg1; 
  arg2 = *(hook_cb_t **)&jarg2; 
  result = (int)unhook_from_notification_point(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_invoke_1callbacks(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  hook_type_t arg1 ;
  int arg2 ;
  va_list arg3 ;
  va_list *argp3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (hook_type_t)jarg1; 
  arg2 = (int)jarg2; 
  argp3 = *(va_list **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null va_list");
    return 0;
  }
  arg3 = *argp3; 
  result = (int)invoke_callbacks(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1plugin_1options(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (char *)get_plugin_options((char const *)arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idadll_1t_1dllinfo_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idadll_t *arg1 = (idadll_t *) 0 ;
  void **arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idadll_t **)&jarg1; 
  arg2 = *(void ***)&jarg2; 
  {
    size_t ii;
    void * *b = (void * *) arg1->dllinfo;
    for (ii = 0; ii < (size_t)10; ii++) b[ii] = *((void * *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idadll_1t_1dllinfo_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idadll_t *arg1 = (idadll_t *) 0 ;
  void **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idadll_t **)&jarg1; 
  result = (void **)(void **) ((arg1)->dllinfo);
  *(void ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idadll_1t_1entry_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idadll_t *arg1 = (idadll_t *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idadll_t **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  if (arg1) (arg1)->entry = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idadll_1t_1entry_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idadll_t *arg1 = (idadll_t *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idadll_t **)&jarg1; 
  result = (void *) ((arg1)->entry);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1idadll_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  idadll_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (idadll_t *)new idadll_t();
  *(idadll_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idadll_1t_1is_1loaded(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  idadll_t *arg1 = (idadll_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idadll_t **)&jarg1; 
  result = (bool)((idadll_t const *)arg1)->is_loaded();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1idadll_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  idadll_t *arg1 = (idadll_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(idadll_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_load_1dll_1or_1say(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  idadll_t *arg2 = (idadll_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(idadll_t **)&jarg2; 
  result = (int)load_dll_or_say((char const *)arg1,arg2);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_free_1dll(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  idadll_t *arg1 = (idadll_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idadll_t **)&jarg1; 
  free_dll(arg1);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1idp_1desc(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (char *)get_idp_desc((char const *)arg1,arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1info_1t_1next_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  plugin_info_t *arg2 = (plugin_info_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(plugin_info_t **)&jarg1; 
  arg2 = *(plugin_info_t **)&jarg2; 
  if (arg1) (arg1)->next = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1info_1t_1next_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  plugin_info_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_info_t **)&jarg1; 
  result = (plugin_info_t *) ((arg1)->next);
  *(plugin_info_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1info_1t_1path_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_info_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->path) delete [] arg1->path;
    if (arg2) {
      arg1->path = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->path, (const char *)arg2);
    } else {
      arg1->path = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1info_1t_1path_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_info_t **)&jarg1; 
  result = (char *) ((arg1)->path);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1info_1t_1org_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_info_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->org_name) delete [] arg1->org_name;
    if (arg2) {
      arg1->org_name = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->org_name, (const char *)arg2);
    } else {
      arg1->org_name = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1info_1t_1org_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_info_t **)&jarg1; 
  result = (char *) ((arg1)->org_name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1info_1t_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_info_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->name) delete [] arg1->name;
    if (arg2) {
      arg1->name = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->name, (const char *)arg2);
    } else {
      arg1->name = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1info_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_info_t **)&jarg1; 
  result = (char *) ((arg1)->name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1info_1t_1org_1hotkey_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  ushort arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_info_t **)&jarg1; 
  arg2 = (ushort)jarg2; 
  if (arg1) (arg1)->org_hotkey = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1info_1t_1org_1hotkey_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_info_t **)&jarg1; 
  result = (ushort) ((arg1)->org_hotkey);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1info_1t_1hotkey_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  ushort arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_info_t **)&jarg1; 
  arg2 = (ushort)jarg2; 
  if (arg1) (arg1)->hotkey = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1info_1t_1hotkey_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_info_t **)&jarg1; 
  result = (ushort) ((arg1)->hotkey);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1info_1t_1arg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_info_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->arg = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1info_1t_1arg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_info_t **)&jarg1; 
  result = (int) ((arg1)->arg);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1info_1t_1entry_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  plugin_t *arg2 = (plugin_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(plugin_info_t **)&jarg1; 
  arg2 = *(plugin_t **)&jarg2; 
  if (arg1) (arg1)->entry = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1info_1t_1entry_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  plugin_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_info_t **)&jarg1; 
  result = (plugin_t *) ((arg1)->entry);
  *(plugin_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1info_1t_1dllmem_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  idadll_t *arg2 = (idadll_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(plugin_info_t **)&jarg1; 
  arg2 = *(idadll_t **)&jarg2; 
  if (arg1) (arg1)->dllmem = *arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1info_1t_1dllmem_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  idadll_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_info_t **)&jarg1; 
  result = (idadll_t *)& ((arg1)->dllmem);
  *(idadll_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1info_1t_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_info_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->flags = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_plugin_1info_1t_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_info_t **)&jarg1; 
  result = (int) ((arg1)->flags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1plugin_1info_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  plugin_info_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (plugin_info_t *)new plugin_info_t();
  *(plugin_info_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1plugin_1info_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(plugin_info_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1plugins(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  plugin_info_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (plugin_info_t *)get_plugins();
  *(plugin_info_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_load_1plugin(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  plugin_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (plugin_t *)load_plugin((char const *)arg1);
  *(plugin_t **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_run_1plugin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  plugin_t *arg1 = (plugin_t *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_t **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)run_plugin(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_load_1and_1run_1plugin(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (int)jarg2; 
  result = (bool)load_and_run_plugin((char const *)arg1,arg2);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_invoke_1plugin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(plugin_info_t **)&jarg1; 
  result = (bool)invoke_plugin(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dbg_1info_1t_1pi_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  dbg_info_t *arg1 = (dbg_info_t *) 0 ;
  plugin_info_t *arg2 = (plugin_info_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(dbg_info_t **)&jarg1; 
  arg2 = *(plugin_info_t **)&jarg2; 
  if (arg1) (arg1)->pi = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dbg_1info_1t_1pi_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  dbg_info_t *arg1 = (dbg_info_t *) 0 ;
  plugin_info_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dbg_info_t **)&jarg1; 
  result = (plugin_info_t *) ((arg1)->pi);
  *(plugin_info_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dbg_1info_1t_1dbg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  dbg_info_t *arg1 = (dbg_info_t *) 0 ;
  debugger_t *arg2 = (debugger_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(dbg_info_t **)&jarg1; 
  arg2 = *(debugger_t **)&jarg2; 
  if (arg1) (arg1)->dbg = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dbg_1info_1t_1dbg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  dbg_info_t *arg1 = (dbg_info_t *) 0 ;
  debugger_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(dbg_info_t **)&jarg1; 
  result = (debugger_t *) ((arg1)->dbg);
  *(debugger_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1dbg_1info_1t(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  plugin_info_t *arg1 = (plugin_info_t *) 0 ;
  debugger_t *arg2 = (debugger_t *) 0 ;
  dbg_info_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(plugin_info_t **)&jarg1; 
  arg2 = *(debugger_t **)&jarg2; 
  result = (dbg_info_t *)new dbg_info_t(arg1,arg2);
  *(dbg_info_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1dbg_1info_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  dbg_info_t *arg1 = (dbg_info_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(dbg_info_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1debugger_1plugins(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  dbg_info_t **arg1 = (dbg_info_t **) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(dbg_info_t ***)&jarg1; 
  result = get_debugger_plugins((dbg_info_t const **)arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_init_1plugins(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  init_plugins(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_term_1plugins(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  term_plugins(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_save_1fileregions(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  save_fileregions();
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1fileregion_1offset(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int32 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (int32)get_fileregion_offset(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1fileregion_1ea(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int32 arg1 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32)jarg1; 
  result = (ea_t)get_fileregion_ea(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_gen_1exe_1file(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  result = (int)gen_exe_file(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_reload_1file(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = jarg2 ? true : false; 
  result = (int)reload_file((char const *)arg1,arg2);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_command_1line_1file_1set(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  {
    if(arg1) {
      strncpy((char*)command_line_file, (const char *)arg1, QMAXPATH-1);
      command_line_file[QMAXPATH-1] = 0;
    } else {
      command_line_file[0] = 0;
    }
  }
  
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_command_1line_1file_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)command_line_file;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_database_1idb_1set(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  {
    if(arg1) {
      strncpy((char*)database_idb, (const char *)arg1, QMAXPATH-1);
      database_idb[QMAXPATH-1] = 0;
    } else {
      database_idb[0] = 0;
    }
  }
  
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_database_1idb_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)database_idb;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1database_1ext(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (bool)is_database_ext((char const *)arg1);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_database_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  uint32 arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32)jarg1; 
  database_flags = arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_database_1flags_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  result = (uint32)database_flags;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1temp_1database(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)is_temp_database();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_DBCHK_1NONE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  dbcheck_t result;
  
  (void)jenv;
  (void)jcls;
  result = (dbcheck_t)(dbcheck_t)DBCHK_NONE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_DBCHK_1OK_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  dbcheck_t result;
  
  (void)jenv;
  (void)jcls;
  result = (dbcheck_t)(dbcheck_t)DBCHK_OK;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_DBCHK_1BAD_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  dbcheck_t result;
  
  (void)jenv;
  (void)jcls;
  result = (dbcheck_t)(dbcheck_t)DBCHK_BAD;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_DBCHK_1NEW_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  dbcheck_t result;
  
  (void)jenv;
  (void)jcls;
  result = (dbcheck_t)(dbcheck_t)DBCHK_NEW;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_flush_1buffers(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)flush_buffers();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_save_1database(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = jarg2 ? true : false; 
  result = (bool)save_database((char const *)arg1,arg2);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_enumerate_1files(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jlong jarg5, jlong jarg6) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  enumerate_files_cb arg5 = (enumerate_files_cb) 0 ;
  void *arg6 = (void *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (size_t)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = *(enumerate_files_cb *)&jarg5; 
  arg6 = *(void **)&jarg6; 
  result = (int)enumerate_files(arg1,arg2,(char const *)arg3,(char const *)arg4,arg5,arg6);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_enumerate_1system_1files(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jlong jarg5, jlong jarg6) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  enumerate_files_cb arg5 = (enumerate_files_cb) 0 ;
  void *arg6 = (void *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (size_t)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = *(enumerate_files_cb *)&jarg5; 
  arg6 = *(void **)&jarg6; 
  result = (int)enumerate_system_files(arg1,arg2,(char const *)arg3,(char const *)arg4,arg5,arg6);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idadir(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (char *)idadir((char const *)arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_getsysfile(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jstring jarg3, jstring jarg4) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (size_t)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (char *)getsysfile(arg1,arg2,(char const *)arg3,(char const *)arg4);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1user_1idadir(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)get_user_idadir();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_fopenWT(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  FILE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (FILE *)fopenWT((char const *)arg1);
  *(FILE **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_fopenWB(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  FILE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (FILE *)fopenWB((char const *)arg1);
  *(FILE **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_fopenRT(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  FILE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (FILE *)fopenRT((char const *)arg1);
  *(FILE **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_fopenRB(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  FILE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (FILE *)fopenRB((char const *)arg1);
  *(FILE **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_fopenM(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  FILE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (FILE *)fopenM((char const *)arg1);
  *(FILE **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_fopenA(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  FILE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (FILE *)fopenA((char const *)arg1);
  *(FILE **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_openR(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  FILE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (FILE *)openR((char const *)arg1);
  *(FILE **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_openRT(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  FILE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (FILE *)openRT((char const *)arg1);
  *(FILE **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_openM(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  FILE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (FILE *)openM((char const *)arg1);
  *(FILE **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ecreate(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  FILE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (FILE *)ecreate((char const *)arg1);
  *(FILE **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ecreateT(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  FILE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (FILE *)ecreateT((char const *)arg1);
  *(FILE **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_eclose(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  FILE *arg1 = (FILE *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  eclose(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_eread(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  FILE *arg1 = (FILE *) 0 ;
  void *arg2 = (void *) 0 ;
  ssize_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (ssize_t)jarg3; 
  eread(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ewrite(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  FILE *arg1 = (FILE *) 0 ;
  void *arg2 = (void *) 0 ;
  ssize_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (ssize_t)jarg3; 
  ewrite(arg1,(void const *)arg2,arg3);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_eseek(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  FILE *arg1 = (FILE *) 0 ;
  int32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = (int32)jarg2; 
  eseek(arg1,arg2);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_efilelength(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  result = (uint32)efilelength(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_echsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  FILE *arg1 = (FILE *) 0 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  arg2 = (uint32)jarg2; 
  echsize(arg1,arg2);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_getdspace(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  uint64 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = getdspace((char const *)arg1);
  *(uint64 **)&jresult = new uint64((const uint64 &)result); 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ioport_1bit_1t_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  ioport_bit_t *arg1 = (ioport_bit_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ioport_bit_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->name) delete [] arg1->name;
    if (arg2) {
      arg1->name = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->name, (const char *)arg2);
    } else {
      arg1->name = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ioport_1bit_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  ioport_bit_t *arg1 = (ioport_bit_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ioport_bit_t **)&jarg1; 
  result = (char *) ((arg1)->name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ioport_1bit_1t_1cmt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  ioport_bit_t *arg1 = (ioport_bit_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ioport_bit_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->cmt) delete [] arg1->cmt;
    if (arg2) {
      arg1->cmt = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->cmt, (const char *)arg2);
    } else {
      arg1->cmt = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ioport_1bit_1t_1cmt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  ioport_bit_t *arg1 = (ioport_bit_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ioport_bit_t **)&jarg1; 
  result = (char *) ((arg1)->cmt);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1ioport_1bit_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ioport_bit_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (ioport_bit_t *)new ioport_bit_t();
  *(ioport_bit_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1ioport_1bit_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ioport_bit_t *arg1 = (ioport_bit_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ioport_bit_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ioport_1t_1address_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  ioport_t *arg1 = (ioport_t *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ioport_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->address = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ioport_1t_1address_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ioport_t *arg1 = (ioport_t *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ioport_t **)&jarg1; 
  result = (ea_t) ((arg1)->address);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ioport_1t_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  ioport_t *arg1 = (ioport_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ioport_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->name) delete [] arg1->name;
    if (arg2) {
      arg1->name = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->name, (const char *)arg2);
    } else {
      arg1->name = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ioport_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  ioport_t *arg1 = (ioport_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ioport_t **)&jarg1; 
  result = (char *) ((arg1)->name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ioport_1t_1cmt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  ioport_t *arg1 = (ioport_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ioport_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->cmt) delete [] arg1->cmt;
    if (arg2) {
      arg1->cmt = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->cmt, (const char *)arg2);
    } else {
      arg1->cmt = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ioport_1t_1cmt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  ioport_t *arg1 = (ioport_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ioport_t **)&jarg1; 
  result = (char *) ((arg1)->cmt);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ioport_1t_1bits_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  ioport_t *arg1 = (ioport_t *) 0 ;
  ioport_bits_t *arg2 = (ioport_bits_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ioport_t **)&jarg1; 
  arg2 = *(ioport_bits_t **)&jarg2; 
  if (arg1) (arg1)->bits = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ioport_1t_1bits_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ioport_t *arg1 = (ioport_t *) 0 ;
  ioport_bits_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ioport_t **)&jarg1; 
  result = (ioport_bits_t *) ((arg1)->bits);
  *(ioport_bits_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ioport_1t_1userdata_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  ioport_t *arg1 = (ioport_t *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ioport_t **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  if (arg1) (arg1)->userdata = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ioport_1t_1userdata_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ioport_t *arg1 = (ioport_t *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ioport_t **)&jarg1; 
  result = (void *) ((arg1)->userdata);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1ioport_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ioport_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (ioport_t *)new ioport_t();
  *(ioport_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1ioport_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ioport_t *arg1 = (ioport_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ioport_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_find_1ioport(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  ioport_t *arg1 = (ioport_t *) 0 ;
  size_t arg2 ;
  ea_t arg3 ;
  ioport_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ioport_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (ea_t)jarg3; 
  result = (ioport_t *)find_ioport((ioport_t const *)arg1,arg2,arg3);
  *(ioport_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_find_1ioport_1bit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  ioport_t *arg1 = (ioport_t *) 0 ;
  size_t arg2 ;
  ea_t arg3 ;
  size_t arg4 ;
  ioport_bit_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ioport_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (ea_t)jarg3; 
  arg4 = (size_t)jarg4; 
  result = (ioport_bit_t *)find_ioport_bit((ioport_t const *)arg1,arg2,arg3,arg4);
  *(ioport_bit_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_free_1ioports(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  ioport_t *arg1 = (ioport_t *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ioport_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  free_ioports(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_call_1system(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (int)call_system((char const *)arg1);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1thread_1priority(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jint jresult = 0 ;
  ushort arg1 ;
  int32 arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ushort)jarg1; 
  arg2 = (int32)jarg2; 
  result = (int)set_thread_priority(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_lread(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  linput_t *arg1 = (linput_t *) 0 ;
  void *arg2 = (void *) 0 ;
  size_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (size_t)jarg3; 
  lread(arg1,arg2,arg3);
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qlread(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  void *arg2 = (void *) 0 ;
  size_t arg3 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (size_t)jarg3; 
  result = (ssize_t)qlread(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qlgets(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  linput_t *arg3 = (linput_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (size_t)jarg2; 
  arg3 = *(linput_t **)&jarg3; 
  result = (char *)qlgets(arg1,arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qlgetc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  result = (int)qlgetc(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_lreadbytes(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jboolean jarg4) {
  jint jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  void *arg2 = (void *) 0 ;
  size_t arg3 ;
  bool arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (size_t)jarg3; 
  arg4 = jarg4 ? true : false; 
  result = (int)lreadbytes(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_lread2bytes_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  int16 *arg2 = (int16 *) 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  arg2 = *(int16 **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (int)lread2bytes(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_lread2bytes_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  uint16 *arg2 = (uint16 *) 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  arg2 = *(uint16 **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (int)lread2bytes(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_lread4bytes_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  int32 *arg2 = (int32 *) 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  arg2 = *(int32 **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (int)lread4bytes(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_lread4bytes_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  uint32 *arg2 = (uint32 *) 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  arg2 = *(uint32 **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (int)lread4bytes(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_lread8bytes_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  int64 *arg2 = (int64 *) 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  arg2 = *(int64 **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (int)lread8bytes(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_lread8bytes_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  uint64 *arg2 = (uint64 *) 0 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  arg2 = *(uint64 **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (int)lread8bytes(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qlgetz(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jlong jarg4) {
  jstring jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  int32 arg2 ;
  char *arg3 = (char *) 0 ;
  size_t arg4 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  arg2 = (int32)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (size_t)jarg4; 
  result = (char *)qlgetz(arg1,arg2,arg3,arg4);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qlsize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  int32 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  result = (int32)qlsize(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qlseek_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  jint jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  int32 arg2 ;
  int arg3 ;
  int32 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  arg2 = (int32)jarg2; 
  arg3 = (int)jarg3; 
  result = (int32)qlseek(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qlseek_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  int32 arg2 ;
  int32 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  arg2 = (int32)jarg2; 
  result = (int32)qlseek(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qltell(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  int32 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  result = (int32)qltell(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_open_1linput(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool arg2 ;
  linput_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = jarg2 ? true : false; 
  result = (linput_t *)open_linput((char const *)arg1,arg2);
  *(linput_t **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_close_1linput(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  linput_t *arg1 = (linput_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  close_linput(arg1);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qlfile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  FILE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  result = (FILE *)qlfile(arg1);
  *(FILE **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_make_1linput(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  FILE *arg1 = (FILE *) 0 ;
  linput_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FILE **)&jarg1; 
  result = (linput_t *)make_linput(arg1);
  *(linput_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_unmake_1linput(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  linput_t *arg1 = (linput_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  unmake_linput(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_generic_1linput_1t_1filesize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  generic_linput_t *arg1 = (generic_linput_t *) 0 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(generic_linput_t **)&jarg1; 
  arg2 = (uint32)jarg2; 
  if (arg1) (arg1)->filesize = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_generic_1linput_1t_1filesize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  generic_linput_t *arg1 = (generic_linput_t *) 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(generic_linput_t **)&jarg1; 
  result = (uint32) ((arg1)->filesize);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_generic_1linput_1t_1blocksize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  generic_linput_t *arg1 = (generic_linput_t *) 0 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(generic_linput_t **)&jarg1; 
  arg2 = (uint32)jarg2; 
  if (arg1) (arg1)->blocksize = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_generic_1linput_1t_1blocksize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  generic_linput_t *arg1 = (generic_linput_t *) 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(generic_linput_t **)&jarg1; 
  result = (uint32) ((arg1)->blocksize);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_generic_1linput_1t_1read(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  generic_linput_t *arg1 = (generic_linput_t *) 0 ;
  off_t arg2 ;
  void *arg3 = (void *) 0 ;
  size_t arg4 ;
  off_t *argp2 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(generic_linput_t **)&jarg1; 
  argp2 = *(off_t **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null off_t");
    return 0;
  }
  arg2 = *argp2; 
  arg3 = *(void **)&jarg3; 
  arg4 = (size_t)jarg4; 
  result = (ssize_t)(arg1)->read(arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1generic_1linput_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  generic_linput_t *arg1 = (generic_linput_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(generic_linput_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_create_1generic_1linput(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  generic_linput_t *arg1 = (generic_linput_t *) 0 ;
  linput_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(generic_linput_t **)&jarg1; 
  result = (linput_t *)create_generic_linput(arg1);
  *(linput_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_create_1memory_1linput(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  linput_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  result = (linput_t *)create_memory_linput(arg1,arg2);
  *(linput_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1linput_1type(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  linput_t *arg1 = (linput_t *) 0 ;
  linput_type_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(linput_t **)&jarg1; 
  result = (linput_type_t)get_linput_type(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_funcset_1t_1qnty_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  funcset_t *arg1 = (funcset_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(funcset_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->qnty = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_funcset_1t_1qnty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  funcset_t *arg1 = (funcset_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(funcset_t **)&jarg1; 
  result = (int) ((arg1)->qnty);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_funcset_1t_1f_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  funcset_t *arg1 = (funcset_t *) 0 ;
  extfun_t *arg2 = (extfun_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(funcset_t **)&jarg1; 
  arg2 = *(extfun_t **)&jarg2; 
  if (arg1) (arg1)->f = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_funcset_1t_1f_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  funcset_t *arg1 = (funcset_t *) 0 ;
  extfun_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(funcset_t **)&jarg1; 
  result = (extfun_t *) ((arg1)->f);
  *(extfun_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_funcset_1t_1startup_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  funcset_t *arg1 = (funcset_t *) 0 ;
  funcset_t_cb arg2 = (funcset_t_cb) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(funcset_t **)&jarg1; 
  arg2 = *(funcset_t_cb *)&jarg2; 
  if (arg1) (arg1)->startup = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_funcset_1t_1startup_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  funcset_t *arg1 = (funcset_t *) 0 ;
  funcset_t_cb result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(funcset_t **)&jarg1; 
  result = (funcset_t_cb) ((arg1)->startup);
  *(funcset_t_cb *)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_funcset_1t_1shutdown_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  funcset_t *arg1 = (funcset_t *) 0 ;
  funcset_t_cb arg2 = (funcset_t_cb) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(funcset_t **)&jarg1; 
  arg2 = *(funcset_t_cb *)&jarg2; 
  if (arg1) (arg1)->shutdown = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_funcset_1t_1shutdown_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  funcset_t *arg1 = (funcset_t *) 0 ;
  funcset_t_cb result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(funcset_t **)&jarg1; 
  result = (funcset_t_cb) ((arg1)->shutdown);
  *(funcset_t_cb *)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1funcset_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  funcset_t *arg1 = (funcset_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(funcset_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1size_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  extlang_t *arg1 = (extlang_t *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  if (arg1) (arg1)->size = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1size_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  extlang_t *arg1 = (extlang_t *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  result =  ((arg1)->size);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  extlang_t *arg1 = (extlang_t *) 0 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  arg2 = (uint32)jarg2; 
  if (arg1) (arg1)->flags = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  extlang_t *arg1 = (extlang_t *) 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  result = (uint32) ((arg1)->flags);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  extlang_t *arg1 = (extlang_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  result = (char *) ((arg1)->name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1compile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  extlang_t *arg1 = (extlang_t *) 0 ;
  extlang_t_compile_cb arg2 = (extlang_t_compile_cb) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  arg2 = *(extlang_t_compile_cb *)&jarg2; 
  if (arg1) (arg1)->compile = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1compile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  extlang_t *arg1 = (extlang_t *) 0 ;
  extlang_t_compile_cb result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  result = (extlang_t_compile_cb) ((arg1)->compile);
  *(extlang_t_compile_cb *)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1run_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  extlang_t *arg1 = (extlang_t *) 0 ;
  extlang_t_run_cb arg2 = (extlang_t_run_cb) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  arg2 = *(extlang_t_run_cb *)&jarg2; 
  if (arg1) (arg1)->run = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1run_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  extlang_t *arg1 = (extlang_t *) 0 ;
  extlang_t_run_cb result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  result = (extlang_t_run_cb) ((arg1)->run);
  *(extlang_t_run_cb *)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1calcexpr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  extlang_t *arg1 = (extlang_t *) 0 ;
  extlang_t_calcexpr_cb arg2 = (extlang_t_calcexpr_cb) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  arg2 = *(extlang_t_calcexpr_cb *)&jarg2; 
  if (arg1) (arg1)->calcexpr = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1calcexpr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  extlang_t *arg1 = (extlang_t *) 0 ;
  extlang_t_calcexpr_cb result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  result = (extlang_t_calcexpr_cb) ((arg1)->calcexpr);
  *(extlang_t_calcexpr_cb *)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1compile_1file_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  extlang_t *arg1 = (extlang_t *) 0 ;
  extlang_t_compile_file_cb arg2 = (extlang_t_compile_file_cb) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  arg2 = *(extlang_t_compile_file_cb *)&jarg2; 
  if (arg1) (arg1)->compile_file = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1compile_1file_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  extlang_t *arg1 = (extlang_t *) 0 ;
  extlang_t_compile_file_cb result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  result = (extlang_t_compile_file_cb) ((arg1)->compile_file);
  *(extlang_t_compile_file_cb *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1fileext_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  extlang_t *arg1 = (extlang_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  result = (char *) ((arg1)->fileext);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1create_1object_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  extlang_t *arg1 = (extlang_t *) 0 ;
  extlang_t_create_object_cb arg2 = (extlang_t_create_object_cb) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  arg2 = *(extlang_t_create_object_cb *)&jarg2; 
  if (arg1) (arg1)->create_object = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1create_1object_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  extlang_t *arg1 = (extlang_t *) 0 ;
  extlang_t_create_object_cb result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  result = (extlang_t_create_object_cb) ((arg1)->create_object);
  *(extlang_t_create_object_cb *)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1get_1attr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  extlang_t *arg1 = (extlang_t *) 0 ;
  extlang_t_get_attr_cb arg2 = (extlang_t_get_attr_cb) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  arg2 = *(extlang_t_get_attr_cb *)&jarg2; 
  if (arg1) (arg1)->get_attr = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1get_1attr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  extlang_t *arg1 = (extlang_t *) 0 ;
  extlang_t_get_attr_cb result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  result = (extlang_t_get_attr_cb) ((arg1)->get_attr);
  *(extlang_t_get_attr_cb *)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1set_1attr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  extlang_t *arg1 = (extlang_t *) 0 ;
  extlang_t_set_attr_cb arg2 = (extlang_t_set_attr_cb) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  arg2 = *(extlang_t_set_attr_cb *)&jarg2; 
  if (arg1) (arg1)->set_attr = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1set_1attr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  extlang_t *arg1 = (extlang_t *) 0 ;
  extlang_t_set_attr_cb result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  result = (extlang_t_set_attr_cb) ((arg1)->set_attr);
  *(extlang_t_set_attr_cb *)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1call_1method_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  extlang_t *arg1 = (extlang_t *) 0 ;
  extlang_t_call_method_cb arg2 = (extlang_t_call_method_cb) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  arg2 = *(extlang_t_call_method_cb *)&jarg2; 
  if (arg1) (arg1)->call_method = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1t_1call_1method_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  extlang_t *arg1 = (extlang_t *) 0 ;
  extlang_t_call_method_cb result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  result = (extlang_t_call_method_cb) ((arg1)->call_method);
  *(extlang_t_call_method_cb *)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1extlang_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  extlang_t *arg1 = (extlang_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(extlang_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1extlangs_1t_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  qvector< extlang_t const * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (qvector< extlang_t const * > *)new qvector< extlang_t const * >();
  *(qvector< extlang_t const * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1extlangs_1t_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< extlang_t const * > *arg1 = 0 ;
  qvector< extlang_t const * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "qvector< extlang_t const * > const & reference is null");
    return 0;
  } 
  result = (qvector< extlang_t const * > *)new qvector< extlang_t const * >((qvector< extlang_t const * > const &)*arg1);
  *(qvector< extlang_t const * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1extlangs_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1push_1back_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  extlang_t **arg2 = 0 ;
  extlang_t *temp2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  temp2 = *(extlang_t **)&jarg2;
  arg2 = (extlang_t **)&temp2; 
  (arg1)->push_back((extlang_t const *const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1push_1back_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  extlang_t **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  result = (extlang_t **) &(arg1)->push_back();
  *(extlang_t ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1pop_1back(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  (arg1)->pop_back();
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  result = ((qvector< extlang_t const * > const *)arg1)->size();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  result = (bool)((qvector< extlang_t const * > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1_1_1aref_1_1_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  size_t arg2 ;
  extlang_t **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (extlang_t **) &((qvector< extlang_t const * > const *)arg1)->operator [](arg2);
  *(extlang_t **)&jresult = *result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1at_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  size_t arg2 ;
  extlang_t **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (extlang_t **) &((qvector< extlang_t const * > const *)arg1)->at(arg2);
  *(extlang_t **)&jresult = *result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1front_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  extlang_t **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  result = (extlang_t **) &((qvector< extlang_t const * > const *)arg1)->front();
  *(extlang_t **)&jresult = *result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1back_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  extlang_t **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  result = (extlang_t **) &((qvector< extlang_t const * > const *)arg1)->back();
  *(extlang_t **)&jresult = *result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1qclear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  (arg1)->qclear();
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1_1_1assign_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  qvector< extlang_t const * > *arg2 = 0 ;
  qvector< extlang_t const * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  arg2 = *(qvector< extlang_t const * > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "qvector< extlang_t const * > const & reference is null");
    return 0;
  } 
  result = (qvector< extlang_t const * > *) &(arg1)->operator =((qvector< extlang_t const * > const &)*arg2);
  *(qvector< extlang_t const * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1resize_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_) {
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  size_t arg2 ;
  extlang_t **arg3 = 0 ;
  extlang_t *temp3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  temp3 = *(extlang_t **)&jarg3;
  arg3 = (extlang_t **)&temp3; 
  (arg1)->resize(arg2,(extlang_t const *const &)*arg3);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1resize_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  (arg1)->resize(arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1grow_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  extlang_t **arg2 = 0 ;
  extlang_t *temp2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  temp2 = *(extlang_t **)&jarg2;
  arg2 = (extlang_t **)&temp2; 
  (arg1)->grow((extlang_t const *const &)*arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1grow_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  (arg1)->grow();
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  result = ((qvector< extlang_t const * > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  (arg1)->reserve(arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1move(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  extlang_t **arg2 = (extlang_t **) 0 ;
  extlang_t **arg3 = (extlang_t **) 0 ;
  size_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  arg2 = *(extlang_t ***)&jarg2; 
  arg3 = *(extlang_t ***)&jarg3; 
  arg4 = (size_t)jarg4; 
  (arg1)->move((extlang_t const **)arg2,(extlang_t const **)arg3,arg4);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1truncate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  (arg1)->truncate();
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1swap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  qvector< extlang_t const * > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  arg2 = *(qvector< extlang_t const * > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "qvector< extlang_t const * > & reference is null");
    return ;
  } 
  (arg1)->swap(*arg2);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1extract(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  extlang_t **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  result = (extlang_t **)(arg1)->extract();
  *(extlang_t ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1inject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  extlang_t **arg2 = (extlang_t **) 0 ;
  size_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  arg2 = *(extlang_t ***)&jarg2; 
  arg3 = (size_t)jarg3; 
  (arg1)->inject((extlang_t const **)arg2,arg3);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1_1_1eq_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  qvector< extlang_t const * > *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  arg2 = *(qvector< extlang_t const * > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "qvector< extlang_t const * > const & reference is null");
    return 0;
  } 
  result = (bool)((qvector< extlang_t const * > const *)arg1)->operator ==((qvector< extlang_t const * > const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1_1_1ne_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  qvector< extlang_t const * > *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  arg2 = *(qvector< extlang_t const * > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "qvector< extlang_t const * > const & reference is null");
    return 0;
  } 
  result = (bool)((qvector< extlang_t const * > const *)arg1)->operator !=((qvector< extlang_t const * > const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1begin_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  qvector< extlang_t const * >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  result = (qvector< extlang_t const * >::iterator)(arg1)->begin();
  *(qvector< extlang_t const * >::iterator *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1end_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  qvector< extlang_t const * >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  result = (qvector< extlang_t const * >::iterator)(arg1)->end();
  *(qvector< extlang_t const * >::iterator *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1insert(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  qvector< extlang_t const * >::iterator arg2 = (qvector< extlang_t const * >::iterator) 0 ;
  extlang_t **arg3 = 0 ;
  extlang_t *temp3 = 0 ;
  qvector< extlang_t const * >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  arg2 = *(qvector< extlang_t const * >::iterator *)&jarg2; 
  temp3 = *(extlang_t **)&jarg3;
  arg3 = (extlang_t **)&temp3; 
  result = (qvector< extlang_t const * >::iterator)(arg1)->insert(arg2,(extlang_t const *const &)*arg3);
  *(qvector< extlang_t const * >::iterator *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1erase_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  qvector< extlang_t const * >::iterator arg2 = (qvector< extlang_t const * >::iterator) 0 ;
  qvector< extlang_t const * >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  arg2 = *(qvector< extlang_t const * >::iterator *)&jarg2; 
  result = (qvector< extlang_t const * >::iterator)(arg1)->erase(arg2);
  *(qvector< extlang_t const * >::iterator *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1erase_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  qvector< extlang_t const * >::iterator arg2 = (qvector< extlang_t const * >::iterator) 0 ;
  qvector< extlang_t const * >::iterator arg3 = (qvector< extlang_t const * >::iterator) 0 ;
  qvector< extlang_t const * >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  arg2 = *(qvector< extlang_t const * >::iterator *)&jarg2; 
  arg3 = *(qvector< extlang_t const * >::iterator *)&jarg3; 
  result = (qvector< extlang_t const * >::iterator)(arg1)->erase(arg2,arg3);
  *(qvector< extlang_t const * >::iterator *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1find_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  extlang_t **arg2 = 0 ;
  extlang_t *temp2 = 0 ;
  qvector< extlang_t const * >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  temp2 = *(extlang_t **)&jarg2;
  arg2 = (extlang_t **)&temp2; 
  result = (qvector< extlang_t const * >::iterator)(arg1)->find((extlang_t const *const &)*arg2);
  *(qvector< extlang_t const * >::iterator *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1has(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  extlang_t **arg2 = 0 ;
  extlang_t *temp2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  temp2 = *(extlang_t **)&jarg2;
  arg2 = (extlang_t **)&temp2; 
  result = (bool)((qvector< extlang_t const * > const *)arg1)->has((extlang_t const *const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1add_1unique(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  extlang_t **arg2 = 0 ;
  extlang_t *temp2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  temp2 = *(extlang_t **)&jarg2;
  arg2 = (extlang_t **)&temp2; 
  result = (bool)(arg1)->add_unique((extlang_t const *const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlangs_1t_1del(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  qvector< extlang_t const * > *arg1 = (qvector< extlang_t const * > *) 0 ;
  extlang_t **arg2 = 0 ;
  extlang_t *temp2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< extlang_t const * > **)&jarg1; 
  temp2 = *(extlang_t **)&jarg2;
  arg2 = (extlang_t **)&temp2; 
  result = (bool)(arg1)->del((extlang_t const *const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_CompileLine_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3, jlong jarg4) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  getname_cb arg4 = (getname_cb) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  arg4 = *(getname_cb *)&jarg4; 
  result = (bool)CompileLine((char const *)arg1,arg2,arg3,arg4);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_CompileLine_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (bool)CompileLine((char const *)arg1,arg2,arg3);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ExecuteLine(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3, jint jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_, jstring jarg7, jlong jarg8) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  getname_cb arg3 = (getname_cb) 0 ;
  int arg4 ;
  idc_value_t *arg5 ;
  idc_value_t *arg6 = (idc_value_t *) 0 ;
  char *arg7 = (char *) 0 ;
  size_t arg8 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(getname_cb *)&jarg3; 
  arg4 = (int)jarg4; 
  arg5 = *(idc_value_t **)&jarg5; 
  arg6 = *(idc_value_t **)&jarg6; 
  arg7 = 0;
  if (jarg7) {
    arg7 = (char *)jenv->GetStringUTFChars(jarg7, 0);
    if (!arg7) return 0;
  }
  arg8 = (size_t)jarg8; 
  result = (bool)ExecuteLine((char const *)arg1,(char const *)arg2,arg3,arg4,(idc_value_t const (*))arg5,arg6,arg7,arg8);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  
  if (arg7) jenv->ReleaseStringUTFChars(jarg7, (const char *)arg7);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarLong(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = VarLong(arg1);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarInt64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = VarInt64(arg1);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarNum(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = VarNum(arg1);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarString2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = VarString2(arg1);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = VarFloat(arg1);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarObject_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  idc_class_t *arg2 = (idc_class_t *) 0 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = *(idc_class_t **)&jarg2; 
  result = VarObject(arg1,arg2);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarObject_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = VarObject(arg1);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarCopy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  idc_value_t *arg2 = (idc_value_t *) 0 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = *(idc_value_t **)&jarg2; 
  result = VarCopy(arg1,(idc_value_t const *)arg2);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarFree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  VarFree(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarSwap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  idc_value_t *arg2 = (idc_value_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = *(idc_value_t **)&jarg2; 
  VarSwap(arg1,arg2);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarGetClassName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  qstring *arg2 = (qstring *) 0 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = *(qstring **)&jarg2; 
  result = VarGetClassName((idc_value_t const *)arg1,arg2);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarGetAttr_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_, jboolean jarg4) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char *arg2 = (char *) 0 ;
  idc_value_t *arg3 = (idc_value_t *) 0 ;
  bool arg4 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(idc_value_t **)&jarg3; 
  arg4 = jarg4 ? true : false; 
  result = VarGetAttr((idc_value_t const *)arg1,(char const *)arg2,arg3,arg4);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarGetAttr_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char *arg2 = (char *) 0 ;
  idc_value_t *arg3 = (idc_value_t *) 0 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(idc_value_t **)&jarg3; 
  result = VarGetAttr((idc_value_t const *)arg1,(char const *)arg2,arg3);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarSetAttr_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_, jboolean jarg4) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char *arg2 = (char *) 0 ;
  idc_value_t *arg3 = (idc_value_t *) 0 ;
  bool arg4 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(idc_value_t **)&jarg3; 
  arg4 = jarg4 ? true : false; 
  result = VarSetAttr(arg1,(char const *)arg2,(idc_value_t const *)arg3,arg4);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarSetAttr_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char *arg2 = (char *) 0 ;
  idc_value_t *arg3 = (idc_value_t *) 0 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(idc_value_t **)&jarg3; 
  result = VarSetAttr(arg1,(char const *)arg2,(idc_value_t const *)arg3);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarDelAttr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char *arg2 = (char *) 0 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = VarDelAttr(arg1,(char const *)arg2);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarFirstAttr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = (char *)VarFirstAttr((idc_value_t const *)arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarLastAttr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = (char *)VarLastAttr((idc_value_t const *)arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarNextAttr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)VarNextAttr((idc_value_t const *)arg1,(char const *)arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarPrevAttr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)VarPrevAttr((idc_value_t const *)arg1,(char const *)arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarAssign(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  idc_value_t *arg2 = (idc_value_t *) 0 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = *(idc_value_t **)&jarg2; 
  result = VarAssign(arg1,(idc_value_t const *)arg2);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarMove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  idc_value_t *arg2 = (idc_value_t *) 0 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = *(idc_value_t **)&jarg2; 
  result = VarMove(arg1,arg2);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarPrint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_, jstring jarg3, jint jarg4) {
  qstring *arg1 = (qstring *) 0 ;
  idc_value_t *arg2 = (idc_value_t *) 0 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(qstring **)&jarg1; 
  arg2 = *(idc_value_t **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = (int)jarg4; 
  VarPrint(arg1,(idc_value_t const *)arg2,(char const *)arg3,arg4);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarPrint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_, jstring jarg3) {
  qstring *arg1 = (qstring *) 0 ;
  idc_value_t *arg2 = (idc_value_t *) 0 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(qstring **)&jarg1; 
  arg2 = *(idc_value_t **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  VarPrint(arg1,(idc_value_t const *)arg2,(char const *)arg3);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarPrint_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_) {
  qstring *arg1 = (qstring *) 0 ;
  idc_value_t *arg2 = (idc_value_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(qstring **)&jarg1; 
  arg2 = *(idc_value_t **)&jarg2; 
  VarPrint(arg1,(idc_value_t const *)arg2);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarGetSlice_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jobject jarg4_, jint jarg5) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  uval_t arg2 ;
  uval_t arg3 ;
  idc_value_t *arg4 = (idc_value_t *) 0 ;
  int arg5 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = (uval_t)jarg2; 
  arg3 = (uval_t)jarg3; 
  arg4 = *(idc_value_t **)&jarg4; 
  arg5 = (int)jarg5; 
  result = VarGetSlice((idc_value_t const *)arg1,arg2,arg3,arg4,arg5);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarGetSlice_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  uval_t arg2 ;
  uval_t arg3 ;
  idc_value_t *arg4 = (idc_value_t *) 0 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = (uval_t)jarg2; 
  arg3 = (uval_t)jarg3; 
  arg4 = *(idc_value_t **)&jarg4; 
  result = VarGetSlice((idc_value_t const *)arg1,arg2,arg3,arg4);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarSetSlice_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jobject jarg4_, jint jarg5) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  uval_t arg2 ;
  uval_t arg3 ;
  idc_value_t *arg4 = (idc_value_t *) 0 ;
  int arg5 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = (uval_t)jarg2; 
  arg3 = (uval_t)jarg3; 
  arg4 = *(idc_value_t **)&jarg4; 
  arg5 = (int)jarg5; 
  result = VarSetSlice(arg1,arg2,arg3,(idc_value_t const *)arg4,arg5);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarSetSlice_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  uval_t arg2 ;
  uval_t arg3 ;
  idc_value_t *arg4 = (idc_value_t *) 0 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = (uval_t)jarg2; 
  arg3 = (uval_t)jarg3; 
  arg4 = *(idc_value_t **)&jarg4; 
  result = VarSetSlice(arg1,arg2,arg3,(idc_value_t const *)arg4);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_add_1idc_1class_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  idc_class_t *arg2 = (idc_class_t *) 0 ;
  idc_class_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(idc_class_t **)&jarg2; 
  result = (idc_class_t *)add_idc_class((char const *)arg1,arg2);
  *(idc_class_t **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_add_1idc_1class_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  idc_class_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (idc_class_t *)add_idc_class((char const *)arg1);
  *(idc_class_t **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_find_1idc_1class(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  idc_class_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (idc_class_t *)find_idc_class((char const *)arg1);
  *(idc_class_t **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1idc_1method(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jboolean jresult = 0 ;
  idc_class_t *arg1 = (idc_class_t *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(idc_class_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)set_idc_method(arg1,(char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1idc_1getattr(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jstring jresult = 0 ;
  idc_class_t *arg1 = (idc_class_t *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(idc_class_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)set_idc_getattr(arg1,(char const *)arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1idc_1setattr(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jstring jresult = 0 ;
  idc_class_t *arg1 = (idc_class_t *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(idc_class_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)set_idc_setattr(arg1,(char const *)arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1idc_1dtor(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jstring jresult = 0 ;
  idc_class_t *arg1 = (idc_class_t *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(idc_class_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)set_idc_dtor(arg1,(char const *)arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarDeref(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  int arg2 ;
  idc_value_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (idc_value_t *)VarDeref(arg1,arg2);
  *(idc_value_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarRef(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  idc_value_t *arg2 = (idc_value_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = *(idc_value_t **)&jarg2; 
  result = (bool)VarRef(arg1,(idc_value_t const *)arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_add_1idc_1gvar(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  idc_value_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (idc_value_t *)add_idc_gvar((char const *)arg1);
  *(idc_value_t **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_find_1idc_1gvar(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  idc_value_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (idc_value_t *)find_idc_gvar((char const *)arg1);
  *(idc_value_t **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1vtype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = (char)jarg2; 
  if (arg1) (arg1)->vtype = arg2;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1vtype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jchar jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = (char) ((arg1)->vtype);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1str_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->str) delete [] arg1->str;
    if (arg2) {
      arg1->str = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->str, (const char *)arg2);
    } else {
      arg1->str = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1str_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = (char *) ((arg1)->str);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1num_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  sval_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = (sval_t)jarg2; 
  if (arg1) (arg1)->num = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1num_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  sval_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = (sval_t) ((arg1)->num);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1e_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  ushort *arg2 ;
  jint *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUshort(jenv, &jarr2, &arg2, jarg2)) return ; 
  {
    size_t ii;
    ushort *b = (ushort *) arg1->e;
    for (ii = 0; ii < (size_t)6; ii++) b[ii] = *((ushort *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUshort(jenv, jarr2, arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jintArray JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1e_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  ushort *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = (ushort *)(ushort *) ((arg1)->e);
  jresult = SWIG_JavaArrayOutUshort(jenv, result, 6); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1obj_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  idc_object_t *arg2 = (idc_object_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = *(idc_object_t **)&jarg2; 
  if (arg1) (arg1)->obj = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1obj_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  idc_object_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = (idc_object_t *) ((arg1)->obj);
  *(idc_object_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1funcidx_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->funcidx = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1funcidx_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = (int) ((arg1)->funcidx);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1pvoid_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  if (arg1) (arg1)->pvoid = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1pvoid_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = (void *) ((arg1)->pvoid);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1i64_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  int64 arg2 ;
  int64 *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  argp2 = *(int64 **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null int64");
    return ;
  }
  arg2 = *argp2; 
  if (arg1) (arg1)->i64 = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1i64_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  int64 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result =  ((arg1)->i64);
  *(int64 **)&jresult = new int64((const int64 &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1reserve_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshortArray jarg2) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  uchar *arg2 ;
  jshort *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != sizeof(qstring)) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUchar(jenv, &jarr2, &arg2, jarg2)) return ; 
  {
    size_t ii;
    uchar *b = (uchar *) arg1->reserve;
    for (ii = 0; ii < (size_t)sizeof(qstring); ii++) b[ii] = *((uchar *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUchar(jenv, jarr2, arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jshortArray JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1reserve_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshortArray jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  uchar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = (uchar *)(uchar *) ((arg1)->reserve);
  jresult = SWIG_JavaArrayOutUchar(jenv, result, sizeof(qstring)); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1idc_1value_1t_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  idc_value_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (idc_value_t *)new idc_value_t(arg1);
  *(idc_value_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1idc_1value_1t_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  idc_value_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (idc_value_t *)new idc_value_t();
  *(idc_value_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1idc_1value_1t_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = 0 ;
  idc_value_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "idc_value_t const & reference is null");
    return 0;
  } 
  result = (idc_value_t *)new idc_value_t((idc_value_t const &)*arg1);
  *(idc_value_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1idc_1value_1t_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  idc_value_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (idc_value_t *)new idc_value_t((char const *)arg1);
  *(idc_value_t **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1idc_1value_1t_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  qstring *arg1 = 0 ;
  idc_value_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(qstring **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "qstring const & reference is null");
    return 0;
  } 
  result = (idc_value_t *)new idc_value_t((qstring const &)*arg1);
  *(idc_value_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1idc_1value_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(idc_value_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1_1_1assign_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  idc_value_t *arg2 = 0 ;
  idc_value_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = *(idc_value_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "idc_value_t const & reference is null");
    return 0;
  } 
  result = (idc_value_t *) &(arg1)->operator =((idc_value_t const &)*arg2);
  *(idc_value_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1qstr_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  qstring *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = (qstring *) &(arg1)->qstr();
  *(qstring **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1c_1str(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = (char *)((idc_value_t const *)arg1)->c_str();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1u_1str(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  uchar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = (uchar *)((idc_value_t const *)arg1)->u_str();
  *(uchar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1swap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  idc_value_t *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = *(idc_value_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "idc_value_t & reference is null");
    return ;
  } 
  (arg1)->swap(*arg2);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1is_1zero(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = (bool)((idc_value_t const *)arg1)->is_zero();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1is_1convertible(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = (bool)((idc_value_t const *)arg1)->is_convertible();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1_1create_1empty_1string(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  (arg1)->_create_empty_string();
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1_1set_1string_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (size_t)jarg3; 
  (arg1)->_set_string((char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1_1set_1string_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->_set_string((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1_1set_1long(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  sval_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = (sval_t)jarg2; 
  (arg1)->_set_long(arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1create_1empty_1string(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  (arg1)->create_empty_string();
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1set_1string_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (size_t)jarg3; 
  (arg1)->set_string((char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1set_1string_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->set_string((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1set_1long(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  sval_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = (sval_t)jarg2; 
  (arg1)->set_long(arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1set_1pvoid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  (arg1)->set_pvoid(arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1value_1t_1set_1int64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  int64 arg2 ;
  int64 *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  argp2 = *(int64 **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null int64");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->set_int64(arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1global_1t_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  idc_global_t *arg1 = (idc_global_t *) 0 ;
  qstring *arg2 = (qstring *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_global_t **)&jarg1; 
  arg2 = *(qstring **)&jarg2; 
  if (arg1) (arg1)->name = *arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1global_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idc_global_t *arg1 = (idc_global_t *) 0 ;
  qstring *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_global_t **)&jarg1; 
  result = (qstring *)& ((arg1)->name);
  *(qstring **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1global_1t_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  idc_global_t *arg1 = (idc_global_t *) 0 ;
  idc_value_t *arg2 = (idc_value_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(idc_global_t **)&jarg1; 
  arg2 = *(idc_value_t **)&jarg2; 
  if (arg1) (arg1)->value = *arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_idc_1global_1t_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idc_global_t *arg1 = (idc_global_t *) 0 ;
  idc_value_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_global_t **)&jarg1; 
  result = (idc_value_t *)& ((arg1)->value);
  *(idc_value_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1idc_1global_1t_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  idc_global_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (idc_global_t *)new idc_global_t();
  *(idc_global_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1idc_1global_1t_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  idc_global_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (idc_global_t *)new idc_global_t((char const *)arg1);
  *(idc_global_t **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1idc_1global_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  idc_global_t *arg1 = (idc_global_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(idc_global_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extfun_1t_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  extfun_t *arg1 = (extfun_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extfun_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg2) {
      arg1->name = (char const *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->name, (const char *)arg2);
    } else {
      arg1->name = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extfun_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  extfun_t *arg1 = (extfun_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extfun_t **)&jarg1; 
  result = (char *) ((arg1)->name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extfun_1t_1fp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  extfun_t *arg1 = (extfun_t *) 0 ;
  idc_func_t *arg2 = (idc_func_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extfun_t **)&jarg1; 
  arg2 = *(idc_func_t **)&jarg2; 
  if (arg1) (arg1)->fp = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extfun_1t_1fp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  extfun_t *arg1 = (extfun_t *) 0 ;
  idc_func_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extfun_t **)&jarg1; 
  result = (idc_func_t *) ((arg1)->fp);
  *(idc_func_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extfun_1t_1args_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  extfun_t *arg1 = (extfun_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extfun_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg2) {
      arg1->args = (char const *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->args, (const char *)arg2);
    } else {
      arg1->args = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extfun_1t_1args_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  extfun_t *arg1 = (extfun_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extfun_t **)&jarg1; 
  result = (char *) ((arg1)->args);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extfun_1t_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  extfun_t *arg1 = (extfun_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extfun_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->flags = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extfun_1t_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  extfun_t *arg1 = (extfun_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extfun_t **)&jarg1; 
  result = (int) ((arg1)->flags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1extfun_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  extfun_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (extfun_t *)new extfun_t();
  *(extfun_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1extfun_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  extfun_t *arg1 = (extfun_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(extfun_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_IDCFuncs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  funcset_t *arg1 = (funcset_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(funcset_t **)&jarg1; 
  IDCFuncs = *arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_IDCFuncs_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  funcset_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (funcset_t *)&IDCFuncs;
  *(funcset_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1idc_1func_1ex(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jstring jarg3, jint jarg4) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  idc_func_t *arg2 = (idc_func_t *) 0 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(idc_func_t **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int)jarg4; 
  result = (bool)set_idc_func_ex((char const *)arg1,arg2,(char const *)arg3,arg4);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  extlang_t *arg1 = (extlang_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  extlang = (extlang_t const *)arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  extlang_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (extlang_t *)extlang;
  *(extlang_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_install_1extlang(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  extlang_t *arg1 = (extlang_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  result = (bool)install_extlang((extlang_t const *)arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_remove_1extlang(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  extlang_t *arg1 = (extlang_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  result = (bool)remove_extlang((extlang_t const *)arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_select_1extlang(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  extlang_t *arg1 = (extlang_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  result = (bool)select_extlang((extlang_t const *)arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1extlang_1fileext(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)get_extlang_fileext();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1extlangs(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  extlangs_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (extlangs_t *)get_extlangs();
  *(extlangs_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_find_1extlang_1by_1ext(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  extlang_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (extlang_t *)find_extlang_by_ext((char const *)arg1);
  *(extlang_t **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1idcpath(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)get_idcpath();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1header_1path(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = jarg2 ? true : false; 
  result = (bool)set_header_path((char const *)arg1,arg2);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1idc_1filename(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jstring jarg3) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  char *arg3 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (size_t)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (char *)get_idc_filename(arg1,arg2,(char const *)arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dosysfile(JNIEnv *jenv, jclass jcls, jboolean jarg1, jstring jarg2) {
  jboolean jresult = 0 ;
  bool arg1 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)dosysfile(arg1,(char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_calcexpr_1long_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jstring jarg4, jlong jarg5) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  char *arg2 = (char *) 0 ;
  sval_t *arg3 = (sval_t *) 0 ;
  char *arg4 = (char *) 0 ;
  size_t arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(sval_t **)&jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = (size_t)jarg5; 
  result = (bool)calcexpr_long(arg1,(char const *)arg2,arg3,arg4,arg5);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_calcexpr_1long_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jstring jarg4, jlong jarg5) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  char *arg2 = (char *) 0 ;
  uval_t *arg3 = (uval_t *) 0 ;
  char *arg4 = (char *) 0 ;
  size_t arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(uval_t **)&jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = (size_t)jarg5; 
  result = (bool)calcexpr_long(arg1,(char const *)arg2,arg3,arg4,arg5);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_calcexpr(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jobject jarg3_, jstring jarg4, jlong jarg5) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  char *arg2 = (char *) 0 ;
  idc_value_t *arg3 = (idc_value_t *) 0 ;
  char *arg4 = (char *) 0 ;
  size_t arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  arg1 = (ea_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(idc_value_t **)&jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = (size_t)jarg5; 
  result = (bool)calcexpr(arg1,(char const *)arg2,arg3,arg4,arg5);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_calc_1idc_1expr(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jobject jarg3_, jstring jarg4, jlong jarg5) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  char *arg2 = (char *) 0 ;
  idc_value_t *arg3 = (idc_value_t *) 0 ;
  char *arg4 = (char *) 0 ;
  size_t arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  arg1 = (ea_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(idc_value_t **)&jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = (size_t)jarg5; 
  result = (bool)calc_idc_expr(arg1,(char const *)arg2,arg3,arg4,arg5);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_execute(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (bool)execute((char const *)arg1);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_CompileEx(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2, jstring jarg3, jlong jarg4) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  size_t arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (size_t)jarg4; 
  result = (bool)CompileEx((char const *)arg1,arg2,arg3,arg4);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_Compile(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (bool)Compile((char const *)arg1,arg2,arg3);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1compile_1file_1exists_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  extlang_t *arg1 = (extlang_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(extlang_t **)&jarg1; 
  result = (bool)extlang_compile_file_exists((extlang_t const *)arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1compile_1file_1exists_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)extlang_compile_file_exists();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_compile_1script_1file(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (bool)compile_script_file((char const *)arg1,arg2,arg3);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1compile_1file(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3, jlong jarg4) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  extlang_t **arg4 = (extlang_t **) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  arg4 = *(extlang_t ***)&jarg4; 
  result = (bool)extlang_compile_file((char const *)arg1,arg2,arg3,(extlang_t const **)arg4);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_compile_1script_1func(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jlong jarg5) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  ea_t arg2 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  size_t arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (ea_t)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = (size_t)jarg5; 
  result = (bool)compile_script_func((char const *)arg1,arg2,(char const *)arg3,arg4,arg5);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_Run(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jstring jarg5, jlong jarg6) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int arg2 ;
  idc_value_t *arg3 ;
  idc_value_t *arg4 = (idc_value_t *) 0 ;
  char *arg5 = (char *) 0 ;
  size_t arg6 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (int)jarg2; 
  arg3 = *(idc_value_t **)&jarg3; 
  arg4 = *(idc_value_t **)&jarg4; 
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  arg6 = (size_t)jarg6; 
  result = (bool)Run((char const *)arg1,arg2,(idc_value_t const (*))arg3,arg4,arg5,arg6);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_run_1script_1func(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jstring jarg5, jlong jarg6) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int arg2 ;
  idc_value_t *arg3 ;
  idc_value_t *arg4 = (idc_value_t *) 0 ;
  char *arg5 = (char *) 0 ;
  size_t arg6 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (int)jarg2; 
  arg3 = *(idc_value_t **)&jarg3; 
  arg4 = *(idc_value_t **)&jarg4; 
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  arg6 = (size_t)jarg6; 
  result = (bool)run_script_func((char const *)arg1,arg2,(idc_value_t const (*))arg3,arg4,arg5,arg6);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_create_1idc_1object(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jstring jarg5, jlong jarg6) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int arg2 ;
  idc_value_t *arg3 ;
  idc_value_t *arg4 = (idc_value_t *) 0 ;
  char *arg5 = (char *) 0 ;
  size_t arg6 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (int)jarg2; 
  arg3 = *(idc_value_t **)&jarg3; 
  arg4 = *(idc_value_t **)&jarg4; 
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  arg6 = (size_t)jarg6; 
  result = (bool)create_idc_object((char const *)arg1,arg2,(idc_value_t const (*))arg3,arg4,arg5,arg6);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1get_1attr_1exists(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)extlang_get_attr_exists();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1script_1attr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char *arg2 = (char *) 0 ;
  idc_value_t *arg3 = (idc_value_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(idc_value_t **)&jarg3; 
  result = (bool)get_script_attr((idc_value_t const *)arg1,(char const *)arg2,arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1set_1attr_1exists(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)extlang_set_attr_exists();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1script_1attr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char *arg2 = (char *) 0 ;
  idc_value_t *arg3 = (idc_value_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(idc_value_t **)&jarg3; 
  result = (bool)set_script_attr(arg1,(char const *)arg2,arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1create_1object_1exists(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)extlang_create_object_exists();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_create_1script_1object(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jstring jarg5, jlong jarg6) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int arg2 ;
  idc_value_t *arg3 ;
  idc_value_t *arg4 = (idc_value_t *) 0 ;
  char *arg5 = (char *) 0 ;
  size_t arg6 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (int)jarg2; 
  arg3 = *(idc_value_t **)&jarg3; 
  arg4 = *(idc_value_t **)&jarg4; 
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  arg6 = (size_t)jarg6; 
  result = (bool)create_script_object((char const *)arg1,arg2,(idc_value_t const (*))arg3,arg4,arg5,arg6);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_call_1idc_1method(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_, jstring jarg6, jlong jarg7) {
  jboolean jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  idc_value_t *arg4 ;
  idc_value_t *arg5 = (idc_value_t *) 0 ;
  char *arg6 = (char *) 0 ;
  size_t arg7 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  arg4 = *(idc_value_t **)&jarg4; 
  arg5 = *(idc_value_t **)&jarg5; 
  arg6 = 0;
  if (jarg6) {
    arg6 = (char *)jenv->GetStringUTFChars(jarg6, 0);
    if (!arg6) return 0;
  }
  arg7 = (size_t)jarg7; 
  result = (bool)call_idc_method((idc_value_t const *)arg1,(char const *)arg2,arg3,(idc_value_t const (*))arg4,arg5,arg6,arg7);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  
  if (arg6) jenv->ReleaseStringUTFChars(jarg6, (const char *)arg6);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_extlang_1call_1method_1exists(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)extlang_call_method_exists();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_call_1script_1method(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_, jstring jarg6, jlong jarg7) {
  jboolean jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  idc_value_t *arg4 ;
  idc_value_t *arg5 = (idc_value_t *) 0 ;
  char *arg6 = (char *) 0 ;
  size_t arg7 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(idc_value_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  arg4 = *(idc_value_t **)&jarg4; 
  arg5 = *(idc_value_t **)&jarg5; 
  arg6 = 0;
  if (jarg6) {
    arg6 = (char *)jenv->GetStringUTFChars(jarg6, 0);
    if (!arg6) return 0;
  }
  arg7 = (size_t)jarg7; 
  result = (bool)call_script_method((idc_value_t const *)arg1,(char const *)arg2,arg3,(idc_value_t const (*))arg4,arg5,arg6,arg7);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  
  if (arg6) jenv->ReleaseStringUTFChars(jarg6, (const char *)arg6);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ExecuteFile(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jint jarg3, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_, jstring jarg6, jlong jarg7) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  idc_value_t *arg4 ;
  idc_value_t *arg5 = (idc_value_t *) 0 ;
  char *arg6 = (char *) 0 ;
  size_t arg7 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  arg4 = *(idc_value_t **)&jarg4; 
  arg5 = *(idc_value_t **)&jarg5; 
  arg6 = 0;
  if (jarg6) {
    arg6 = (char *)jenv->GetStringUTFChars(jarg6, 0);
    if (!arg6) return 0;
  }
  arg7 = (size_t)jarg7; 
  result = (bool)ExecuteFile((char const *)arg1,(char const *)arg2,arg3,(idc_value_t const (*))arg4,arg5,arg6,arg7);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  
  if (arg6) jenv->ReleaseStringUTFChars(jarg6, (const char *)arg6);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1idc_1func_1body(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
  char *arg1 = (char *) 0 ;
  int arg2 ;
  uchar *arg3 = (uchar *) 0 ;
  size_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  arg2 = (int)jarg2; 
  arg3 = *(uchar **)&jarg3; 
  arg4 = (size_t)jarg4; 
  set_idc_func_body((char const *)arg1,arg2,(unsigned char const *)arg3,arg4);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1idc_1func_1body(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int *arg2 = (int *) 0 ;
  size_t *arg3 = (size_t *) 0 ;
  uchar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(int **)&jarg2; 
  arg3 = *(size_t **)&jarg3; 
  result = (uchar *)get_idc_func_body((char const *)arg1,arg2,arg3);
  *(uchar **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_VarString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  idc_value_t *arg1 = (idc_value_t *) 0 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(idc_value_t **)&jarg1; 
  result = VarString(arg1);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1idc_1func(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jstring jarg3) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  idc_func_t *arg2 = (idc_func_t *) 0 ;
  char *arg3 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(idc_func_t **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (bool)set_idc_func((char const *)arg1,arg2,(char const *)arg3);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_construct_1macro(JNIEnv *jenv, jclass jcls, jboolean jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  bool arg1 ;
  construct_macro_cb arg2 = (construct_macro_cb) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  arg2 = *(construct_macro_cb *)&jarg2; 
  result = (bool)construct_macro(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1n_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  op_t *arg1 = (op_t *) 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  arg2 = (char)jarg2; 
  if (arg1) (arg1)->n = arg2;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1n_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jchar jresult = 0 ;
  op_t *arg1 = (op_t *) 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  result = (char) ((arg1)->n);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  op_t *arg1 = (op_t *) 0 ;
  optype_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  arg2 = (optype_t)jarg2; 
  if (arg1) (arg1)->type = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  op_t *arg1 = (op_t *) 0 ;
  optype_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  result = (optype_t) ((arg1)->type);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1offb_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  op_t *arg1 = (op_t *) 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  arg2 = (char)jarg2; 
  if (arg1) (arg1)->offb = arg2;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1offb_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jchar jresult = 0 ;
  op_t *arg1 = (op_t *) 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  result = (char) ((arg1)->offb);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1offo_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  op_t *arg1 = (op_t *) 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  arg2 = (char)jarg2; 
  if (arg1) (arg1)->offo = arg2;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1offo_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jchar jresult = 0 ;
  op_t *arg1 = (op_t *) 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  result = (char) ((arg1)->offo);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  op_t *arg1 = (op_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->flags = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  op_t *arg1 = (op_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  result = (uchar) ((arg1)->flags);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1set_1showed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  op_t *arg1 = (op_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  (arg1)->set_showed();
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1clr_1showed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  op_t *arg1 = (op_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  (arg1)->clr_showed();
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1showed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  op_t *arg1 = (op_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  result = (bool)((op_t const *)arg1)->showed();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1dtyp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  op_t *arg1 = (op_t *) 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  arg2 = (char)jarg2; 
  if (arg1) (arg1)->dtyp = arg2;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1dtyp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jchar jresult = 0 ;
  op_t *arg1 = (op_t *) 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  result = (char) ((arg1)->dtyp);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1reg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  op_t *arg1 = (op_t *) 0 ;
  uint16 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  arg2 = (uint16)jarg2; 
  if (arg1) (arg1)->reg = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1reg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  op_t *arg1 = (op_t *) 0 ;
  uint16 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  result = (uint16) ((arg1)->reg);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1is_1reg(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  op_t *arg1 = (op_t *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)((op_t const *)arg1)->is_reg(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  op_t *arg1 = (op_t *) 0 ;
  uval_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  arg2 = (uval_t)jarg2; 
  if (arg1) (arg1)->value = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  op_t *arg1 = (op_t *) 0 ;
  uval_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  result = (uval_t) ((arg1)->value);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1is_1imm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  op_t *arg1 = (op_t *) 0 ;
  uval_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  arg2 = (uval_t)jarg2; 
  result = (bool)((op_t const *)arg1)->is_imm(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1addr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  op_t *arg1 = (op_t *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->addr = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1addr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  op_t *arg1 = (op_t *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  result = (ea_t) ((arg1)->addr);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1specval_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  op_t *arg1 = (op_t *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->specval = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1specval_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  op_t *arg1 = (op_t *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  result = (ea_t) ((arg1)->specval);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1specflag1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  op_t *arg1 = (op_t *) 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  arg2 = (char)jarg2; 
  if (arg1) (arg1)->specflag1 = arg2;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1specflag1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jchar jresult = 0 ;
  op_t *arg1 = (op_t *) 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  result = (char) ((arg1)->specflag1);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1specflag2_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  op_t *arg1 = (op_t *) 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  arg2 = (char)jarg2; 
  if (arg1) (arg1)->specflag2 = arg2;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1specflag2_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jchar jresult = 0 ;
  op_t *arg1 = (op_t *) 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  result = (char) ((arg1)->specflag2);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1specflag3_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  op_t *arg1 = (op_t *) 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  arg2 = (char)jarg2; 
  if (arg1) (arg1)->specflag3 = arg2;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1specflag3_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jchar jresult = 0 ;
  op_t *arg1 = (op_t *) 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  result = (char) ((arg1)->specflag3);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1specflag4_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  op_t *arg1 = (op_t *) 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  arg2 = (char)jarg2; 
  if (arg1) (arg1)->specflag4 = arg2;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1specflag4_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jchar jresult = 0 ;
  op_t *arg1 = (op_t *) 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  result = (char) ((arg1)->specflag4);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1t_1hasSIB(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  op_t *arg1 = (op_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1; 
  result = (bool)op_t_hasSIB(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1op_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  op_t *arg1 = (op_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(op_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1cs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  insn_t *arg1 = (insn_t *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->cs = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1cs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  insn_t *arg1 = (insn_t *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  result = (ea_t) ((arg1)->cs);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1ip_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  insn_t *arg1 = (insn_t *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->ip = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1ip_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  insn_t *arg1 = (insn_t *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  result = (ea_t) ((arg1)->ip);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1ea_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  insn_t *arg1 = (insn_t *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->ea = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1ea_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  insn_t *arg1 = (insn_t *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  result = (ea_t) ((arg1)->ea);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1itype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  insn_t *arg1 = (insn_t *) 0 ;
  uint16 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  arg2 = (uint16)jarg2; 
  if (arg1) (arg1)->itype = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1itype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  insn_t *arg1 = (insn_t *) 0 ;
  uint16 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  result = (uint16) ((arg1)->itype);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1is_1canon_1insn(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  insn_t *arg1 = (insn_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  result = (bool)((insn_t const *)arg1)->is_canon_insn();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1get_1canon_1feature(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  insn_t *arg1 = (insn_t *) 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  result = (uint32)((insn_t const *)arg1)->get_canon_feature();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1get_1canon_1mnem(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  insn_t *arg1 = (insn_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  result = (char *)((insn_t const *)arg1)->get_canon_mnem();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1size_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  insn_t *arg1 = (insn_t *) 0 ;
  uint16 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  arg2 = (uint16)jarg2; 
  if (arg1) (arg1)->size = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1size_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  insn_t *arg1 = (insn_t *) 0 ;
  uint16 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  result = (uint16) ((arg1)->size);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1auxpref_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  insn_t *arg1 = (insn_t *) 0 ;
  uint16 arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  arg2 = (uint16)jarg2; 
  if (arg1) (arg1)->auxpref = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1auxpref_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  insn_t *arg1 = (insn_t *) 0 ;
  uint16 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  result = (uint16) ((arg1)->auxpref);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1segpref_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  insn_t *arg1 = (insn_t *) 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  arg2 = (char)jarg2; 
  if (arg1) (arg1)->segpref = arg2;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1segpref_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jchar jresult = 0 ;
  insn_t *arg1 = (insn_t *) 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  result = (char) ((arg1)->segpref);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1insnpref_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  insn_t *arg1 = (insn_t *) 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  arg2 = (char)jarg2; 
  if (arg1) (arg1)->insnpref = arg2;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1insnpref_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jchar jresult = 0 ;
  insn_t *arg1 = (insn_t *) 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  result = (char) ((arg1)->insnpref);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1Operands_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  insn_t *arg1 = (insn_t *) 0 ;
  op_t *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(insn_t **)&jarg1; 
  arg2 = *(op_t **)&jarg2; 
  {
    size_t ii;
    op_t *b = (op_t *) arg1->Operands;
    for (ii = 0; ii < (size_t)UA_MAXOP; ii++) b[ii] = *((op_t *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1Operands_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  insn_t *arg1 = (insn_t *) 0 ;
  op_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  result = (op_t *)(op_t *) ((arg1)->Operands);
  *(op_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  insn_t *arg1 = (insn_t *) 0 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  arg2 = (char)jarg2; 
  if (arg1) (arg1)->flags = arg2;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jchar jresult = 0 ;
  insn_t *arg1 = (insn_t *) 0 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  result = (char) ((arg1)->flags);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1is_1macro(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  insn_t *arg1 = (insn_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  result = (bool)((insn_t const *)arg1)->is_macro();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1getOperand(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  insn_t *arg1 = (insn_t *) 0 ;
  int arg2 ;
  op_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (op_t *)insn_t_getOperand(arg1,arg2);
  *(op_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_insn_1t_1setOperand(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  insn_t *arg1 = (insn_t *) 0 ;
  int arg2 ;
  op_t arg3 ;
  op_t *argp3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(insn_t **)&jarg1; 
  arg2 = (int)jarg2; 
  argp3 = *(op_t **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null op_t");
    return 0;
  }
  arg3 = *argp3; 
  result = (bool)insn_t_setOperand(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1insn_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  insn_t *arg1 = (insn_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(insn_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1operand_1immvals(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  uval_t *arg3 = (uval_t *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(uval_t **)&jarg3; 
  result = get_operand_immvals(arg1,arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_cmd_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  insn_t *arg1 = (insn_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(insn_t **)&jarg1; 
  cmd = *arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_cmd_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  insn_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (insn_t *)&cmd;
  *(insn_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_lookback_1set(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  lookback = arg1;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_lookback_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lookback;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_uFlag_1set(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  flags_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  uFlag = arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_uFlag_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)uFlag;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dataSeg_1opreg(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  result = (ea_t)dataSeg_opreg(arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dataSeg_1op(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (ea_t)dataSeg_op(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dataSeg(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  result = (ea_t)dataSeg();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_codeSeg(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (ea_t)codeSeg(arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ua_1next_1byte(JNIEnv *jenv, jclass jcls) {
  jshort jresult = 0 ;
  uint8 result;
  
  (void)jenv;
  (void)jcls;
  result = (uint8)ua_next_byte();
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ua_1next_1word(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  uint16 result;
  
  (void)jenv;
  (void)jcls;
  result = (uint16)ua_next_word();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ua_1next_1long(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  result = (uint32)ua_next_long();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ua_1next_1qword(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  uint64 result;
  
  (void)jenv;
  (void)jcls;
  result = ua_next_qword();
  *(uint64 **)&jresult = new uint64((const uint64 &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_init_1output_1buffer(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  arg2 = (size_t)jarg2; 
  init_output_buffer(arg1,arg2);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_term_1output_1buffer(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)term_output_buffer();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_out_1snprintf(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  void *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (int)out_snprintf((char const *)arg1,arg2);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1output_1ptr(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (char *)set_output_ptr(arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1output_1ptr(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)get_output_ptr();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_out_1insert(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  out_insert(arg1,(char const *)arg2);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_OutMnem_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jint jresult = 0 ;
  int arg1 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)OutMnem(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_OutMnem_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  int arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (int)OutMnem(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_OutMnem_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)OutMnem();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_OutBadInstruction(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  OutBadInstruction();
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_out_1one_1operand(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  int arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (int)out_one_operand(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_OutValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  op_t *arg1 = 0 ;
  int arg2 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "op_t & reference is null");
    return 0;
  } 
  arg2 = (int)jarg2; 
  result = (flags_t)OutValue(*arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_OutValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  op_t *arg1 = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "op_t & reference is null");
    return 0;
  } 
  result = (flags_t)OutValue(*arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_out_1symbol(JNIEnv *jenv, jclass jcls, jchar jarg1) {
  char arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (char)jarg1; 
  out_symbol(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_out_1line(JNIEnv *jenv, jclass jcls, jstring jarg1, jshort jarg2) {
  char *arg1 = (char *) 0 ;
  color_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  arg2 = (color_t)jarg2; 
  out_line((char const *)arg1,arg2);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_out_1keyword(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  out_keyword((char const *)arg1);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_out_1register(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  out_register((char const *)arg1);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_out_1tagon(JNIEnv *jenv, jclass jcls, jshort jarg1) {
  color_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (color_t)jarg1; 
  out_tagon(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_out_1tagoff(JNIEnv *jenv, jclass jcls, jshort jarg1) {
  color_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (color_t)jarg1; 
  out_tagoff(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_out_1addr_1tag(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  out_addr_tag(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_out_1colored_1register_1line(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  out_colored_register_line((char const *)arg1);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_OutLine(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  OutLine((char const *)arg1);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_OutChar(JNIEnv *jenv, jclass jcls, jchar jarg1) {
  char arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (char)jarg1; 
  OutChar(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_OutLong(JNIEnv *jenv, jclass jcls, jlong jarg1, jchar jarg2) {
  uval_t arg1 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uval_t)jarg1; 
  arg2 = (char)jarg2; 
  OutLong(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_OutImmChar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  op_t *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "op_t & reference is null");
    return ;
  } 
  OutImmChar(*arg1);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_showAsChar(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  void *arg1 = (void *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  result = (bool)showAsChar((void const *)arg1,arg2,arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_out_1real(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jlong jarg4) {
  jboolean jresult = 0 ;
  void *arg1 = (void *) 0 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  size_t arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (size_t)jarg4; 
  result = (bool)out_real((void const *)arg1,arg2,arg3,arg4);
  jresult = (jboolean)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_voidop_1set(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  voidop = arg1;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_voidop_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)voidop;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_out_1long(JNIEnv *jenv, jclass jcls, jint jarg1, jchar jarg2) {
  sval_t arg1 ;
  char arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sval_t)jarg1; 
  arg2 = (char)jarg2; 
  out_long(arg1,arg2);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_out_1name_1expr_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  op_t *arg1 = 0 ;
  ea_t arg2 ;
  adiff_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "op_t const & reference is null");
    return 0;
  } 
  arg2 = (ea_t)jarg2; 
  arg3 = (adiff_t)jarg3; 
  result = (bool)out_name_expr((op_t const &)*arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_out_1name_1expr_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  op_t *arg1 = 0 ;
  ea_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "op_t const & reference is null");
    return 0;
  } 
  arg2 = (ea_t)jarg2; 
  result = (bool)out_name_expr((op_t const &)*arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ua_1dodata2(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  int arg1 ;
  ea_t arg2 ;
  int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (int)jarg3; 
  result = (bool)ua_dodata2(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ua_1stkvar2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  op_t *arg1 = 0 ;
  adiff_t arg2 ;
  int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "op_t const & reference is null");
    return 0;
  } 
  arg2 = (adiff_t)jarg2; 
  arg3 = (int)jarg3; 
  result = (bool)ua_stkvar2((op_t const &)*arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ua_1add_1cref(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jint jarg3) {
  int arg1 ;
  ea_t arg2 ;
  cref_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (cref_t)jarg3; 
  ua_add_cref(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ua_1add_1dref(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jint jarg3) {
  int arg1 ;
  ea_t arg2 ;
  dref_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (dref_t)jarg3; 
  ua_add_dref(arg1,arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ua_1add_1off_1drefs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  op_t *arg1 = 0 ;
  dref_t arg2 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "op_t const & reference is null");
    return 0;
  } 
  arg2 = (dref_t)jarg2; 
  result = (ea_t)ua_add_off_drefs((op_t const &)*arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ua_1add_1off_1drefs2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  op_t *arg1 = 0 ;
  dref_t arg2 ;
  int arg3 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "op_t const & reference is null");
    return 0;
  } 
  arg2 = (dref_t)jarg2; 
  arg3 = (int)jarg3; 
  result = (ea_t)ua_add_off_drefs2((op_t const &)*arg1,arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1dtyp_1flag(JNIEnv *jenv, jclass jcls, jchar jarg1) {
  jlong jresult = 0 ;
  char arg1 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (char)jarg1; 
  result = (flags_t)get_dtyp_flag(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1dtyp_1size(JNIEnv *jenv, jclass jcls, jchar jarg1) {
  jlong jresult = 0 ;
  char arg1 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (char)jarg1; 
  result = get_dtyp_size(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jchar JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1dtyp_1by_1size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jchar jresult = 0 ;
  asize_t arg1 ;
  char result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (asize_t)jarg1; 
  result = (char)get_dtyp_by_size(arg1);
  jresult = (jchar)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_create_1insn(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (int)create_insn(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_decode_1insn(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (int)decode_insn(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ua_1outop2_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jint jarg4, jint jarg5) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  int arg4 ;
  int arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  result = (bool)ua_outop2(arg1,arg2,arg3,arg4,arg5);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ua_1outop2_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jint jarg4) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  int arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  arg4 = (int)jarg4; 
  result = (bool)ua_outop2(arg1,arg2,arg3,arg4);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ua_1mnem(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  ea_t arg1 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (char *)ua_mnem(arg1,arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_decode_1prev_1insn(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (ea_t)decode_prev_insn(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_decode_1preceding_1insn(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  bool *arg2 = (bool *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = *(bool **)&jarg2; 
  result = (ea_t)decode_preceding_insn(arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_guess_1table_1address(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  result = (ea_t)guess_table_address();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_guess_1table_1size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  asize_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (asize_t)guess_table_size(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1spoiled_1reg(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  uint32 *arg1 = (uint32 *) 0 ;
  size_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uint32 **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (int)get_spoiled_reg((unsigned int const *)arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ua_1dodata(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  ea_t arg1 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  ua_dodata(arg1,arg2);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ua_1outop(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jint jarg4) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  int arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  arg4 = (int)jarg4; 
  result = (bool)ua_outop(arg1,arg2,arg3,arg4);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ua_1stkvar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  op_t *arg1 = 0 ;
  adiff_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(op_t **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "op_t const & reference is null");
    return 0;
  } 
  arg2 = (adiff_t)jarg2; 
  result = (bool)ua_stkvar((op_t const &)*arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ua_1ana0(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (int)ua_ana0(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ua_1code(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (int)ua_code(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1qvector_1area_1t_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  qvector< area_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (qvector< area_t > *)new qvector< area_t >();
  *(qvector< area_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1qvector_1area_1t_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< area_t > *arg1 = 0 ;
  qvector< area_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< area_t > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "qvector< area_t > const & reference is null");
    return 0;
  } 
  result = (qvector< area_t > *)new qvector< area_t >((qvector< area_t > const &)*arg1);
  *(qvector< area_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1qvector_1area_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(qvector< area_t > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1push_1back_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  area_t *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  arg2 = *(area_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return ;
  } 
  (arg1)->push_back((area_t const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1push_1back_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  result = (area_t *) &(arg1)->push_back();
  *(area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1pop_1back(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  (arg1)->pop_back();
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  result = ((qvector< area_t > const *)arg1)->size();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  result = (bool)((qvector< area_t > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1_1_1aref_1_1_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  size_t arg2 ;
  area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (area_t *) &((qvector< area_t > const *)arg1)->operator [](arg2);
  *(area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1at_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  size_t arg2 ;
  area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (area_t *) &((qvector< area_t > const *)arg1)->at(arg2);
  *(area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1front_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  result = (area_t *) &((qvector< area_t > const *)arg1)->front();
  *(area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1back_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  result = (area_t *) &((qvector< area_t > const *)arg1)->back();
  *(area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1qclear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  (arg1)->qclear();
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1_1_1assign_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  qvector< area_t > *arg2 = 0 ;
  qvector< area_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  arg2 = *(qvector< area_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "qvector< area_t > const & reference is null");
    return 0;
  } 
  result = (qvector< area_t > *) &(arg1)->operator =((qvector< area_t > const &)*arg2);
  *(qvector< area_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1resize_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_) {
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  size_t arg2 ;
  area_t *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = *(area_t **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return ;
  } 
  (arg1)->resize(arg2,(area_t const &)*arg3);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1resize_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  (arg1)->resize(arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1grow_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  area_t *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  arg2 = *(area_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return ;
  } 
  (arg1)->grow((area_t const &)*arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1grow_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  (arg1)->grow();
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  result = ((qvector< area_t > const *)arg1)->capacity();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  (arg1)->reserve(arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1move(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4) {
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  area_t *arg2 = (area_t *) 0 ;
  area_t *arg3 = (area_t *) 0 ;
  size_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  arg2 = *(area_t **)&jarg2; 
  arg3 = *(area_t **)&jarg3; 
  arg4 = (size_t)jarg4; 
  (arg1)->move(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1truncate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  (arg1)->truncate();
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1swap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  qvector< area_t > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  arg2 = *(qvector< area_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "qvector< area_t > & reference is null");
    return ;
  } 
  (arg1)->swap(*arg2);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1extract(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  result = (area_t *)(arg1)->extract();
  *(area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1inject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  area_t *arg2 = (area_t *) 0 ;
  size_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  arg2 = *(area_t **)&jarg2; 
  arg3 = (size_t)jarg3; 
  (arg1)->inject(arg2,arg3);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1_1_1eq_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  qvector< area_t > *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  arg2 = *(qvector< area_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "qvector< area_t > const & reference is null");
    return 0;
  } 
  result = (bool)((qvector< area_t > const *)arg1)->operator ==((qvector< area_t > const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1_1_1ne_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  qvector< area_t > *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  arg2 = *(qvector< area_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "qvector< area_t > const & reference is null");
    return 0;
  } 
  result = (bool)((qvector< area_t > const *)arg1)->operator !=((qvector< area_t > const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1begin_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  qvector< area_t >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  result = (qvector< area_t >::iterator)(arg1)->begin();
  *(qvector< area_t >::iterator *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1end_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  qvector< area_t >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  result = (qvector< area_t >::iterator)(arg1)->end();
  *(qvector< area_t >::iterator *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1insert(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  qvector< area_t >::iterator arg2 = (qvector< area_t >::iterator) 0 ;
  area_t *arg3 = 0 ;
  qvector< area_t >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  arg2 = *(qvector< area_t >::iterator *)&jarg2; 
  arg3 = *(area_t **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return 0;
  } 
  result = (qvector< area_t >::iterator)(arg1)->insert(arg2,(area_t const &)*arg3);
  *(qvector< area_t >::iterator *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1erase_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  qvector< area_t >::iterator arg2 = (qvector< area_t >::iterator) 0 ;
  qvector< area_t >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  arg2 = *(qvector< area_t >::iterator *)&jarg2; 
  result = (qvector< area_t >::iterator)(arg1)->erase(arg2);
  *(qvector< area_t >::iterator *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1erase_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  qvector< area_t >::iterator arg2 = (qvector< area_t >::iterator) 0 ;
  qvector< area_t >::iterator arg3 = (qvector< area_t >::iterator) 0 ;
  qvector< area_t >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  arg2 = *(qvector< area_t >::iterator *)&jarg2; 
  arg3 = *(qvector< area_t >::iterator *)&jarg3; 
  result = (qvector< area_t >::iterator)(arg1)->erase(arg2,arg3);
  *(qvector< area_t >::iterator *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1find_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  area_t *arg2 = 0 ;
  qvector< area_t >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  arg2 = *(area_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return 0;
  } 
  result = (qvector< area_t >::iterator)(arg1)->find((area_t const &)*arg2);
  *(qvector< area_t >::iterator *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1has(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  area_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  arg2 = *(area_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return 0;
  } 
  result = (bool)((qvector< area_t > const *)arg1)->has((area_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1add_1unique(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  area_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  arg2 = *(area_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->add_unique((area_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qvector_1area_1t_1del(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  qvector< area_t > *arg1 = (qvector< area_t > *) 0 ;
  area_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(qvector< area_t > **)&jarg1; 
  arg2 = *(area_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->del((area_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_area_1t_1startEA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  area_t *arg1 = (area_t *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(area_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->startEA = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_area_1t_1startEA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  area_t *arg1 = (area_t *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(area_t **)&jarg1; 
  result = (ea_t) ((arg1)->startEA);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_area_1t_1endEA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  area_t *arg1 = (area_t *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(area_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->endEA = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_area_1t_1endEA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  area_t *arg1 = (area_t *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(area_t **)&jarg1; 
  result = (ea_t) ((arg1)->endEA);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1area_1t_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (area_t *)new area_t();
  *(area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1area_1t_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (area_t *)new area_t(arg1,arg2);
  *(area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_area_1t_1compare(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  area_t *arg1 = (area_t *) 0 ;
  area_t *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(area_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return 0;
  } 
  result = (int)((area_t const *)arg1)->compare((area_t const &)*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_area_1t_1_1_1eq_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  area_t *arg1 = (area_t *) 0 ;
  area_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(area_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return 0;
  } 
  result = (bool)((area_t const *)arg1)->operator ==((area_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_area_1t_1_1_1ne_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  area_t *arg1 = (area_t *) 0 ;
  area_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(area_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return 0;
  } 
  result = (bool)((area_t const *)arg1)->operator !=((area_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_area_1t_1_1_1gt_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  area_t *arg1 = (area_t *) 0 ;
  area_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(area_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return 0;
  } 
  result = (bool)((area_t const *)arg1)->operator >((area_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_area_1t_1_1_1lt_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  area_t *arg1 = (area_t *) 0 ;
  area_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(area_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return 0;
  } 
  result = (bool)((area_t const *)arg1)->operator <((area_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_area_1t_1contains_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  area_t *arg1 = (area_t *) 0 ;
  ea_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(area_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (bool)((area_t const *)arg1)->contains(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_area_1t_1contains_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  area_t *arg1 = (area_t *) 0 ;
  area_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(area_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return 0;
  } 
  result = (bool)((area_t const *)arg1)->contains((area_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_area_1t_1overlaps(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  area_t *arg1 = (area_t *) 0 ;
  area_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(area_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return 0;
  } 
  result = (bool)((area_t const *)arg1)->overlaps((area_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_area_1t_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  area_t *arg1 = (area_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(area_t **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_area_1t_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  area_t *arg1 = (area_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(area_t **)&jarg1; 
  result = (bool)((area_t const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_area_1t_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  area_t *arg1 = (area_t *) 0 ;
  asize_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(area_t **)&jarg1; 
  result = (asize_t)((area_t const *)arg1)->size();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_area_1t_1intersect(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  area_t *arg1 = (area_t *) 0 ;
  area_t *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(area_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return ;
  } 
  (arg1)->intersect((area_t const &)*arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_area_1t_1extend(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  area_t *arg1 = (area_t *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(area_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  (arg1)->extend(arg2);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_area_1t_1print(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  area_t *arg1 = (area_t *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(area_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = ((area_t const *)arg1)->print(arg2,arg3);
  jresult = (jlong)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1area_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  area_t *arg1 = (area_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(area_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1areavec_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  areavec_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (areavec_t *)new areavec_t();
  *(areavec_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1areavec_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  areavec_t *arg1 = (areavec_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(areavec_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1areaset_1t_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  areaset_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (areaset_t *)new areaset_t();
  *(areaset_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1areaset_1t_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  area_t *arg1 = 0 ;
  areaset_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(area_t **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return 0;
  } 
  result = (areaset_t *)new areaset_t((area_t const &)*arg1);
  *(areaset_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1areaset_1t_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  areaset_t *arg1 = 0 ;
  areaset_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areaset_t **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "areaset_t const & reference is null");
    return 0;
  } 
  result = (areaset_t *)new areaset_t((areaset_t const &)*arg1);
  *(areaset_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1swap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  areaset_t *arg1 = (areaset_t *) 0 ;
  areaset_t *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = *(areaset_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "areaset_t & reference is null");
    return ;
  } 
  (arg1)->swap(*arg2);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1add_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  area_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->add((area_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1add_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  ea_t arg2 ;
  ea_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (ea_t)jarg3; 
  result = (bool)(arg1)->add(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1add_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  areaset_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = *(areaset_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "areaset_t const & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->add((areaset_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1sub_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  ea_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (bool)(arg1)->sub(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1sub_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  area_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->sub((area_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1sub_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  areaset_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = *(areaset_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "areaset_t const & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->sub((areaset_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1has_1common_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  jboolean jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  area_t *arg2 = 0 ;
  bool arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return 0;
  } 
  arg3 = jarg3 ? true : false; 
  result = (bool)((areaset_t const *)arg1)->has_common((area_t const &)*arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1has_1common_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  area_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_t const & reference is null");
    return 0;
  } 
  result = (bool)((areaset_t const *)arg1)->has_common((area_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1print(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = ((areaset_t const *)arg1)->print(arg2,arg3);
  jresult = (jlong)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1getarea(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  int arg2 ;
  area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (area_t *) &((areaset_t const *)arg1)->getarea(arg2);
  *(area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1lastarea(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areaset_t **)&jarg1; 
  result = (area_t *) &((areaset_t const *)arg1)->lastarea();
  *(area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1nareas(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areaset_t **)&jarg1; 
  result = ((areaset_t const *)arg1)->nareas();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areaset_t **)&jarg1; 
  result = (bool)((areaset_t const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  areaset_t *arg1 = (areaset_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areaset_t **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1has_1common_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  areaset_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = *(areaset_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "areaset_t const & reference is null");
    return 0;
  } 
  result = (bool)((areaset_t const *)arg1)->has_common((areaset_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1contains_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  ea_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (bool)((areaset_t const *)arg1)->contains(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1contains_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  areaset_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = *(areaset_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "areaset_t const & reference is null");
    return 0;
  } 
  result = (bool)((areaset_t const *)arg1)->contains((areaset_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1intersect(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  areaset_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = *(areaset_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "areaset_t const & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->intersect((areaset_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1is_1subset_1of(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  areaset_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = *(areaset_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "areaset_t const & reference is null");
    return 0;
  } 
  result = (bool)((areaset_t const *)arg1)->is_subset_of((areaset_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1is_1equal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  areaset_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = *(areaset_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "areaset_t const & reference is null");
    return 0;
  } 
  result = (bool)((areaset_t const *)arg1)->is_equal((areaset_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1_1_1eq_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  areaset_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = *(areaset_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "areaset_t const & reference is null");
    return 0;
  } 
  result = (bool)((areaset_t const *)arg1)->operator ==((areaset_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1_1_1ne_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  areaset_t *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = *(areaset_t **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "areaset_t const & reference is null");
    return 0;
  } 
  result = (bool)((areaset_t const *)arg1)->operator !=((areaset_t const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1begin_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  areaset_t::const_iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areaset_t **)&jarg1; 
  result = (areaset_t::const_iterator)((areaset_t const *)arg1)->begin();
  *(areaset_t::const_iterator *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1end_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  areaset_t::const_iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areaset_t **)&jarg1; 
  result = (areaset_t::const_iterator)((areaset_t const *)arg1)->end();
  *(areaset_t::const_iterator *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1find_1area(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  ea_t arg2 ;
  area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (area_t *)((areaset_t const *)arg1)->find_area(arg2);
  *(area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1cached_1area(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areaset_t **)&jarg1; 
  result = (area_t *)((areaset_t const *)arg1)->cached_area();
  *(area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1next_1addr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  ea_t arg2 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (ea_t)((areaset_t const *)arg1)->next_addr(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1prev_1addr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  ea_t arg2 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (ea_t)((areaset_t const *)arg1)->prev_addr(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1next_1area(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  ea_t arg2 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (ea_t)((areaset_t const *)arg1)->next_area(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areaset_1t_1prev_1area(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  ea_t arg2 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (ea_t)((areaset_t const *)arg1)->prev_area(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1areaset_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  areaset_t *arg1 = (areaset_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(areaset_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_area_1visitor2_1t_1visit_1area(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  area_visitor2_t *arg1 = (area_visitor2_t *) 0 ;
  area_t *arg2 = (area_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(area_visitor2_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2; 
  result = (int)(arg1)->visit_area(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1area_1visitor2_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  area_visitor2_t *arg1 = (area_visitor2_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(area_visitor2_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1zero(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  areacb_t *arg1 = (areacb_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  (arg1)->zero();
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1areacb_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  areacb_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (areacb_t *)new areacb_t();
  *(areacb_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1terminate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  areacb_t *arg1 = (areacb_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  (arg1)->terminate();
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1areacb_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  areacb_t *arg1 = (areacb_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(areacb_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1save(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  areacb_t *arg1 = (areacb_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  (arg1)->save();
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1link(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jint jarg4) {
  jboolean jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int)jarg4; 
  result = (bool)(arg1)->link((char const *)arg2,(char const *)arg3,arg4);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1create(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jlong jarg4) {
  jboolean jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  uint arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (uint)jarg4; 
  result = (bool)(arg1)->create((char const *)arg2,(char const *)arg3,arg4);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1kill(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  areacb_t *arg1 = (areacb_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  (arg1)->kill();
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1create_1area(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  area_t *arg2 = (area_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2; 
  result = (bool)(arg1)->create_area((area_t const *)arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1update(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  area_t *arg2 = (area_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2; 
  result = (bool)(arg1)->update((area_t const *)arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1get_1area(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  ea_t arg2 ;
  area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (area_t *)(arg1)->get_area(arg2);
  *(area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1getn_1area(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  unsigned int arg2 ;
  area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  result = (area_t *)(arg1)->getn_area(arg2);
  *(area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1get_1area_1num(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  ea_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (int)(arg1)->get_area_num(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1prepare_1to_1create(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  ea_t arg2 ;
  ea_t arg3 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (ea_t)jarg3; 
  result = (ea_t)(arg1)->prepare_to_create(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1get_1next_1area(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  ea_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (int)(arg1)->get_next_area(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1get_1prev_1area(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  ea_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (int)(arg1)->get_prev_area(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1next_1area_1ptr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  ea_t arg2 ;
  area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (area_t *)(arg1)->next_area_ptr(arg2);
  *(area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1prev_1area_1ptr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  ea_t arg2 ;
  area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (area_t *)(arg1)->prev_area_ptr(arg2);
  *(area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1first_1area_1ptr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  result = (area_t *)(arg1)->first_area_ptr();
  *(area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1last_1area_1ptr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  result = (area_t *)(arg1)->last_area_ptr();
  *(area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1del_1area_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jboolean jarg3) {
  jboolean jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  ea_t arg2 ;
  bool arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (bool)(arg1)->del_area(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1del_1area_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  ea_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (bool)(arg1)->del_area(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1may_1start_1at(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  uint arg2 ;
  ea_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = (uint)jarg2; 
  arg3 = (ea_t)jarg3; 
  result = (bool)(arg1)->may_start_at(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1may_1end_1at(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  uint arg2 ;
  ea_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = (uint)jarg2; 
  arg3 = (ea_t)jarg3; 
  result = (bool)(arg1)->may_end_at(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1set_1start(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  uint arg2 ;
  ea_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = (uint)jarg2; 
  arg3 = (ea_t)jarg3; 
  result = (bool)(arg1)->set_start(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1set_1end(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  uint arg2 ;
  ea_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = (uint)jarg2; 
  arg3 = (ea_t)jarg3; 
  result = (bool)(arg1)->set_end(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1make_1hole(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jboolean jarg4) {
  areacb_t *arg1 = (areacb_t *) 0 ;
  ea_t arg2 ;
  ea_t arg3 ;
  bool arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (ea_t)jarg3; 
  arg4 = jarg4 ? true : false; 
  (arg1)->make_hole(arg2,arg3,arg4);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1resize_1areas(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  uint arg2 ;
  ea_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = (uint)jarg2; 
  arg3 = (ea_t)jarg3; 
  result = (bool)(arg1)->resize_areas(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1get_1area_1qty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  uint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  result = (uint)(arg1)->get_area_qty();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1set_1area_1cmt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jboolean jarg4) {
  jboolean jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  area_t *arg2 = (area_t *) 0 ;
  char *arg3 = (char *) 0 ;
  bool arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = jarg4 ? true : false; 
  result = (bool)(arg1)->set_area_cmt((area_t const *)arg2,(char const *)arg3,arg4);
  jresult = (jboolean)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1del_1area_1cmt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  areacb_t *arg1 = (areacb_t *) 0 ;
  area_t *arg2 = (area_t *) 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  (arg1)->del_area_cmt((area_t const *)arg2,arg3);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1get_1area_1cmt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  jstring jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  area_t *arg2 = (area_t *) 0 ;
  bool arg3 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (char *)(arg1)->get_area_cmt((area_t const *)arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_areacb_1t_1for_1all_1areas2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jint jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  ea_t arg2 ;
  ea_t arg3 ;
  area_visitor2_t *arg4 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (ea_t)jarg3; 
  arg4 = *(area_visitor2_t **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "area_visitor2_t & reference is null");
    return 0;
  } 
  result = (int)(arg1)->for_all_areas2(arg2,arg3,*arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1lock_1area(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  areacb_t *arg1 = (areacb_t *) 0 ;
  area_t *arg2 = (area_t *) 0 ;
  lock_area *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areacb_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2; 
  result = (lock_area *)new lock_area(arg1,arg2);
  *(lock_area **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1lock_1area(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lock_area *arg1 = (lock_area *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lock_area **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1true_1segm_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jint jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (ssize_t)get_true_segm_name((segment_t const *)arg1,arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  areacb_t *arg1 = (areacb_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  segs = *arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segs_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  areacb_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (areacb_t *)&segs;
  *(areacb_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1segment_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  segment_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (segment_t *)new segment_t();
  *(segment_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  segment_t *arg1 = (segment_t *) 0 ;
  uval_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = (uval_t)jarg2; 
  if (arg1) (arg1)->name = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  uval_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (uval_t) ((arg1)->name);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1sclass_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  segment_t *arg1 = (segment_t *) 0 ;
  uval_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = (uval_t)jarg2; 
  if (arg1) (arg1)->sclass = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1sclass_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  uval_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (uval_t) ((arg1)->sclass);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1orgbase_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  segment_t *arg1 = (segment_t *) 0 ;
  uval_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = (uval_t)jarg2; 
  if (arg1) (arg1)->orgbase = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1orgbase_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  uval_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (uval_t) ((arg1)->orgbase);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1align_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  segment_t *arg1 = (segment_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->align = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1align_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (uchar) ((arg1)->align);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1comb_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  segment_t *arg1 = (segment_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->comb = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1comb_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (uchar) ((arg1)->comb);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1perm_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  segment_t *arg1 = (segment_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->perm = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1perm_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (uchar) ((arg1)->perm);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1bitness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  segment_t *arg1 = (segment_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->bitness = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1bitness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (uchar) ((arg1)->bitness);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1use32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (bool)((segment_t const *)arg1)->use32();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1use64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (bool)((segment_t const *)arg1)->use64();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1abits(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (int)((segment_t const *)arg1)->abits();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1abytes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (int)((segment_t const *)arg1)->abytes();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  segment_t *arg1 = (segment_t *) 0 ;
  ushort arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = (ushort)jarg2; 
  if (arg1) (arg1)->flags = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (ushort) ((arg1)->flags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1comorg(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (bool)((segment_t const *)arg1)->comorg();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1set_1comorg(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  segment_t *arg1 = (segment_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  (arg1)->set_comorg();
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1clr_1comorg(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  segment_t *arg1 = (segment_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  (arg1)->clr_comorg();
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1ob_1ok(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (bool)((segment_t const *)arg1)->ob_ok();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1set_1ob_1ok(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  segment_t *arg1 = (segment_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  (arg1)->set_ob_ok();
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1clr_1ob_1ok(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  segment_t *arg1 = (segment_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  (arg1)->clr_ob_ok();
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1is_1visible_1segm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (bool)((segment_t const *)arg1)->is_visible_segm();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1set_1visible_1segm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  segment_t *arg1 = (segment_t *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->set_visible_segm(arg2);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1is_1debugger_1segm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (bool)((segment_t const *)arg1)->is_debugger_segm();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1set_1debugger_1segm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  segment_t *arg1 = (segment_t *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->set_debugger_segm(arg2);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1is_1loader_1segm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (bool)((segment_t const *)arg1)->is_loader_segm();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1set_1loader_1segm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  segment_t *arg1 = (segment_t *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->set_loader_segm(arg2);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1is_1hidden_1segtype(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (bool)((segment_t const *)arg1)->is_hidden_segtype();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1set_1hidden_1segtype(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  segment_t *arg1 = (segment_t *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->set_hidden_segtype(arg2);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1is_1ephemeral_1segm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (bool)((segment_t const *)arg1)->is_ephemeral_segm();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1sel_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  segment_t *arg1 = (segment_t *) 0 ;
  sel_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = (sel_t)jarg2; 
  if (arg1) (arg1)->sel = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1sel_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  sel_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (sel_t) ((arg1)->sel);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1defsr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlongArray jarg2) {
  segment_t *arg1 = (segment_t *) 0 ;
  sel_t *arg2 ;
  jlong *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 16) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUint(jenv, &jarr2, &arg2, jarg2)) return ; 
  {
    size_t ii;
    sel_t *b = (sel_t *) arg1->defsr;
    for (ii = 0; ii < (size_t)16; ii++) b[ii] = *((sel_t *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUint(jenv, jarr2, arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jlongArray JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1defsr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlongArray jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  sel_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (sel_t *)(sel_t *) ((arg1)->defsr);
  jresult = SWIG_JavaArrayOutUint(jenv, result, 16); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  segment_t *arg1 = (segment_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  if (arg1) (arg1)->type = arg2;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (uchar) ((arg1)->type);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1color_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  segment_t *arg1 = (segment_t *) 0 ;
  bgcolor_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = (bgcolor_t)jarg2; 
  if (arg1) (arg1)->color = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1color_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  bgcolor_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (bgcolor_t) ((arg1)->color);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segment_1t_1update(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (int)(arg1)->update();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1segment_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  segment_t *arg1 = (segment_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(segment_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1visible_1segm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (bool)is_visible_segm(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1finally_1visible_1segm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (bool)is_finally_visible_segm(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1visible_1segm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  segment_t *arg1 = (segment_t *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  set_visible_segm(arg1,arg2);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1spec_1segm(JNIEnv *jenv, jclass jcls, jshort jarg1) {
  jboolean jresult = 0 ;
  uchar arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uchar)jarg1; 
  result = (bool)is_spec_segm(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1spec_1ea(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (bool)is_spec_ea(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1lock_1segment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  lock_segment *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (lock_segment *)new lock_segment((segment_t const *)arg1);
  *(lock_segment **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1lock_1segment(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lock_segment *arg1 = (lock_segment *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lock_segment **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1segm_1locked(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (bool)is_segm_locked((segment_t const *)arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_getn_1selector(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  int arg1 ;
  sel_t *arg2 = (sel_t *) 0 ;
  ea_t *arg3 = (ea_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = *(sel_t **)&jarg2; 
  arg3 = *(ea_t **)&jarg3; 
  result = (bool)getn_selector(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1selector_1qty(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)get_selector_qty();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_setup_1selector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  sel_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (sel_t)setup_selector(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_allocate_1selector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  sel_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (sel_t)allocate_selector(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_find_1free_1selector(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  sel_t result;
  
  (void)jenv;
  (void)jcls;
  result = (sel_t)find_free_selector();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1selector(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  sel_t arg1 ;
  ea_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sel_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (int)set_selector(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_del_1selector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  sel_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sel_t)jarg1; 
  del_selector(arg1);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_ask_1selector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  sel_t arg1 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sel_t)jarg1; 
  result = (ea_t)ask_selector(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_sel2ea(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  sel_t arg1 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sel_t)jarg1; 
  result = (ea_t)sel2ea(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_find_1selector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  sel_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (sel_t)find_selector(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1segm_1by_1sel(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  sel_t arg1 ;
  segment_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sel_t)jarg1; 
  result = (segment_t *)get_segm_by_sel(arg1);
  *(segment_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_add_1segm_1ex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jint jarg4) {
  jint jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int)jarg4; 
  result = (int)add_segm_ex(arg1,(char const *)arg2,(char const *)arg3,arg4);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_add_1segm(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jstring jarg4, jstring jarg5) {
  jint jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  ea_t arg3 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (ea_t)jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  result = (int)add_segm(arg1,arg2,arg3,(char const *)arg4,(char const *)arg5);
  jresult = (jint)result; 
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_del_1segm(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (int)del_segm(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1segm_1qty(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)get_segm_qty();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_getseg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  segment_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (segment_t *)getseg(arg1);
  *(segment_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_getnseg(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  segment_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (segment_t *)getnseg(arg1);
  *(segment_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1next_1seg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  segment_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (segment_t *)get_next_seg(arg1);
  *(segment_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1prev_1seg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  segment_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (segment_t *)get_prev_seg(arg1);
  *(segment_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1first_1seg(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  segment_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (segment_t *)get_first_seg();
  *(segment_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1last_1seg(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  segment_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (segment_t *)get_last_seg();
  *(segment_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1segm_1by_1name(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  segment_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (segment_t *)get_segm_by_name((char const *)arg1);
  *(segment_t **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1segm_1end(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jint jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (int)jarg3; 
  result = (int)set_segm_end(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1segm_1start(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jint jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (int)jarg3; 
  result = (int)set_segm_start(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_move_1segm_1start(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jint jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (int)jarg3; 
  result = (int)move_segm_start(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_move_1segm_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  jint jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  ea_t arg2 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (int)jarg3; 
  result = (int)move_segm(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_move_1segm_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  ea_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (int)move_segm(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_rebase_1program(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jint jresult = 0 ;
  adiff_t arg1 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (adiff_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (int)rebase_program(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_change_1segment_1status(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jint jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  bool arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (int)change_segment_status(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_take_1memory_1snapshot(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)take_memory_snapshot(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1miniidb(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)is_miniidb();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1segm_1base(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  ea_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (bool)set_segm_base(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_save_1groups(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  save_groups();
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_term_1groups(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  term_groups();
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1group_1selector(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  sel_t arg1 ;
  sel_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sel_t)jarg1; 
  arg2 = (sel_t)jarg2; 
  result = (int)set_group_selector(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1group_1selector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  sel_t arg1 ;
  sel_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sel_t)jarg1; 
  result = (sel_t)get_group_selector(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_add_1segment_1translation(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (bool)add_segment_translation(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1segment_1translations(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  ea_t *arg2 = (ea_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = *(ea_t **)&jarg2; 
  result = (bool)set_segment_translations(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_del_1segment_1translations(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (bool)del_segment_translations(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1segment_1translations(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t *arg2 = (ea_t *) 0 ;
  int arg3 ;
  ea_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = *(ea_t **)&jarg2; 
  arg3 = (int)jarg3; 
  result = (ea_t *)get_segment_translations(arg1,arg2,arg3);
  *(ea_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1segment_1cmt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jstring jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  bool arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (char *)get_segment_cmt((segment_t const *)arg1,arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1segment_1cmt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jboolean jarg3) {
  segment_t *arg1 = (segment_t *) 0 ;
  char *arg2 = (char *) 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = jarg3 ? true : false; 
  set_segment_cmt(arg1,(char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_del_1segment_1cmt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  segment_t *arg1 = (segment_t *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  del_segment_cmt(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_std_1gen_1segm_1footer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  std_gen_segm_footer(arg1);
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_vset_1segm_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jint jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  char *arg2 = (char *) 0 ;
  va_list arg3 ;
  va_list *argp3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  argp3 = *(va_list **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null va_list");
    return 0;
  }
  arg3 = *argp3; 
  result = (int)vset_segm_name(arg1,(char const *)arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1segm_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  char *arg2 = (char *) 0 ;
  void *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)set_segm_name(arg1,(char const *)arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1segm_1name_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jint jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (ssize_t)get_segm_name((segment_t const *)arg1,arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1segm_1name_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  jint jresult = 0 ;
  ea_t arg1 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (ssize_t)get_segm_name(arg1,arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1segm_1class(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jint jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (ssize_t)get_segm_class((segment_t const *)arg1,arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1segm_1class(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)set_segm_class(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segtype(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jshort jresult = 0 ;
  ea_t arg1 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (uchar)segtype(arg1);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1segment_1alignment(JNIEnv *jenv, jclass jcls, jshort jarg1) {
  jstring jresult = 0 ;
  uchar arg1 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uchar)jarg1; 
  result = (char *)get_segment_alignment(arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1segment_1combination(JNIEnv *jenv, jclass jcls, jshort jarg1) {
  jstring jresult = 0 ;
  uchar arg1 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uchar)jarg1; 
  result = (char *)get_segment_combination(arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1segm_1para(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (ea_t)get_segm_para((segment_t const *)arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1segm_1base(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  result = (ea_t)get_segm_base((segment_t const *)arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1segm_1addressing(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  size_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (bool)set_segm_addressing(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1debugger_1segm(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (bool)is_debugger_segm(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1ephemeral_1segm(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (bool)is_ephemeral_segm(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_correct_1address(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  ea_t arg3 ;
  ea_t arg4 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (ea_t)jarg3; 
  arg4 = (ea_t)jarg4; 
  result = (ea_t)correct_address(arg1,arg2,arg3,arg4);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segm_1adjust_1diff(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  adiff_t arg2 ;
  adiff_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = (adiff_t)jarg2; 
  result = (adiff_t)segm_adjust_diff(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segm_1adjust_1ea(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  ea_t arg2 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (ea_t)segm_adjust_ea(arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segreg_1t_1reg_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  segreg_t *arg1 = (segreg_t *) 0 ;
  int arg2 ;
  sel_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segreg_t **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (sel_t *) &(arg1)->reg(arg2);
  *(sel_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segreg_1t_1tag_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  segreg_t *arg1 = (segreg_t *) 0 ;
  int arg2 ;
  uchar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segreg_t **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (uchar *) &(arg1)->tag(arg2);
  *(uchar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segreg_1t_1undefregs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  segreg_t *arg1 = (segreg_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segreg_t **)&jarg1; 
  (arg1)->undefregs();
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segreg_1t_1setregs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlongArray jarg2) {
  segreg_t *arg1 = (segreg_t *) 0 ;
  sel_t *arg2 ;
  jlong *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segreg_t **)&jarg1; 
  if (!SWIG_JavaArrayInUint(jenv, &jarr2, &arg2, jarg2)) return ; 
  (arg1)->setregs(arg2);
  SWIG_JavaArrayArgoutUint(jenv, jarr2, arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segreg_1t_1settags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  segreg_t *arg1 = (segreg_t *) 0 ;
  uchar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segreg_t **)&jarg1; 
  arg2 = (uchar)jarg2; 
  (arg1)->settags(arg2);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1segreg_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  segreg_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (segreg_t *)new segreg_t();
  *(segreg_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1segreg_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  segreg_t *arg1 = (segreg_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(segreg_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_SRareas_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  areacb_t *arg1 = (areacb_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  SRareas = *arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_SRareas_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  areacb_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (areacb_t *)&SRareas;
  *(areacb_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1lock_1segreg(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  segreg_t *arg1 = (segreg_t *) 0 ;
  lock_segreg *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segreg_t **)&jarg1; 
  result = (lock_segreg *)new lock_segreg((segreg_t const *)arg1);
  *(lock_segreg **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1lock_1segreg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lock_segreg *arg1 = (lock_segreg *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lock_segreg **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1segreg_1locked(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  segreg_t *arg1 = (segreg_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segreg_t **)&jarg1; 
  result = (bool)is_segreg_locked((segreg_t const *)arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_getSR(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  sel_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (sel_t)getSR(arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_SetDefaultRegisterValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  segment_t *arg1 = (segment_t *) 0 ;
  int arg2 ;
  sel_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(segment_t **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (sel_t)jarg3; 
  result = (bool)SetDefaultRegisterValue(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_splitSRarea1_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jshort jarg4, jboolean jarg5) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  sel_t arg3 ;
  uchar arg4 ;
  bool arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (sel_t)jarg3; 
  arg4 = (uchar)jarg4; 
  arg5 = jarg5 ? true : false; 
  result = (bool)splitSRarea1(arg1,arg2,arg3,arg4,arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_splitSRarea1_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jshort jarg4) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  sel_t arg3 ;
  uchar arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (sel_t)jarg3; 
  arg4 = (uchar)jarg4; 
  result = (bool)splitSRarea1(arg1,arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1sreg_1at_1next_1code(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jlong jarg4) {
  ea_t arg1 ;
  ea_t arg2 ;
  int arg3 ;
  sel_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (sel_t)jarg4; 
  set_sreg_at_next_code(arg1,arg2,arg3,arg4);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_getSRarea(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  segreg_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (segreg_t *)getSRarea(arg1);
  *(segreg_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_getnSRarea(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  segreg_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (segreg_t *)getnSRarea(arg1);
  *(segreg_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1default_1dataseg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  sel_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sel_t)jarg1; 
  set_default_dataseg(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1dbgmem_1source(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  set_dbgmem_source_dbg_get_memory_config_cb arg1 = (set_dbgmem_source_dbg_get_memory_config_cb) 0 ;
  set_dbgmem_source_memory_read_cb arg2 = (set_dbgmem_source_memory_read_cb) 0 ;
  set_dbgmem_source_memory_write_cb arg3 = (set_dbgmem_source_memory_write_cb) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(set_dbgmem_source_dbg_get_memory_config_cb *)&jarg1; 
  arg2 = *(set_dbgmem_source_memory_read_cb *)&jarg2; 
  arg3 = *(set_dbgmem_source_memory_write_cb *)&jarg3; 
  set_dbgmem_source(arg1,arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_enable_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  storage_type_t arg3 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (storage_type_t)jarg3; 
  result = enable_flags(arg1,arg2,arg3);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_disable_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  result = disable_flags(arg1,arg2);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_change_1storage_1type(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  storage_type_t arg3 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (storage_type_t)jarg3; 
  result = change_storage_type(arg1,arg2,arg3);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_nextaddr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (ea_t)nextaddr(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_prevaddr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (ea_t)prevaddr(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_nextchunk(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (ea_t)nextchunk(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_prevchunk(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (ea_t)prevchunk(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_chunkstart(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (ea_t)chunkstart(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_chunksize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  asize_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (asize_t)chunksize(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_freechunk(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  int32 arg3 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  arg3 = (int32)jarg3; 
  result = (ea_t)freechunk(arg1,arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_nextthat(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  testf_t *arg3 = (testf_t *) 0 ;
  void *arg4 = (void *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = *(testf_t **)&jarg3; 
  arg4 = *(void **)&jarg4; 
  result = (ea_t)nextthat(arg1,arg2,arg3,arg4);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_next_1unknown(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (ea_t)next_unknown(arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_prevthat(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  testf_t *arg3 = (testf_t *) 0 ;
  void *arg4 = (void *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = *(testf_t **)&jarg3; 
  arg4 = *(void **)&jarg4; 
  result = (ea_t)prevthat(arg1,arg2,arg3,arg4);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_prev_1unknown(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (ea_t)prev_unknown(arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_prev_1head(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (ea_t)prev_head(arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_next_1head(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (ea_t)next_head(arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_prev_1not_1tail(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (ea_t)prev_not_tail(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_next_1not_1tail(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (ea_t)next_not_tail(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_prev_1visea(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (ea_t)prev_visea(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_next_1visea(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (ea_t)next_visea(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_invalidate_1visea_1cache(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  invalidate_visea_cache();
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1item_1head(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (ea_t)get_item_head(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1item_1end(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (ea_t)get_item_end(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_calc_1max_1item_1end_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (ea_t)calc_max_item_end(arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_calc_1max_1item_1end_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (ea_t)calc_max_item_end(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1item_1size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  asize_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (asize_t)get_item_size(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isEnabled(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (bool)isEnabled(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1flags_1ex(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (flags_t)get_flags_ex(arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1flags_1novalue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (flags_t)get_flags_novalue(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_getFlags(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (flags_t)getFlags(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1item_1flag(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  ea_t arg3 ;
  bool arg4 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (ea_t)jarg3; 
  arg4 = jarg4 ? true : false; 
  result = (flags_t)get_item_flag(arg1,arg2,arg3,arg4);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_setFlags(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  ea_t arg1 ;
  flags_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (flags_t)jarg2; 
  setFlags(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_setFlbits(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  ea_t arg1 ;
  flags_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (flags_t)jarg2; 
  setFlbits(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_clrFlbits(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  ea_t arg1 ;
  flags_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (flags_t)jarg2; 
  clrFlbits(arg1,arg2);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_hasValue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)hasValue(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1hasValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_hasValue(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delValue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  delValue(arg1);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isLoaded(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (bool)isLoaded(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1byte(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jshort jresult = 0 ;
  ea_t arg1 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (uchar)get_byte(arg1);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1db_1byte(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jshort jresult = 0 ;
  ea_t arg1 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (uchar)get_db_byte(arg1);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1dbg_1byte(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  uint32 *arg2 = (uint32 *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = *(uint32 **)&jarg2; 
  result = (bool)get_dbg_byte(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1word(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  ea_t arg1 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (ushort)get_word(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_13byte(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (uint32)get_3byte(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1long(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (uint32)get_long(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1qword(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  uint64 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = get_qword(arg1);
  *(uint64 **)&jresult = new uint64((const uint64 &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1full_1byte(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (uint32)get_full_byte(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1full_1word(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  uint64 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = get_full_word(arg1);
  *(uint64 **)&jresult = new uint64((const uint64 &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1full_1long(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  uint64 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = get_full_long(arg1);
  *(uint64 **)&jresult = new uint64((const uint64 &)result); 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_18bit(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jshort jresult = 0 ;
  ea_t *arg1 = 0 ;
  uint32 *arg2 = 0 ;
  int *arg3 = 0 ;
  uchar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ea_t **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "ea_t & reference is null");
    return 0;
  } 
  arg2 = *(uint32 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "uint32 & reference is null");
    return 0;
  } 
  arg3 = *(int **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return 0;
  } 
  result = (uchar)get_8bit(*arg1,*arg2,*arg3);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_116bit(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (uint32)get_16bit(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_132bit(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (uint32)get_32bit(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_164bit(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  uint64 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = get_64bit(arg1);
  *(uint64 **)&jresult = new uint64((const uint64 &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1data_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  uval_t *arg2 = (uval_t *) 0 ;
  asize_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = *(uval_t **)&jarg2; 
  arg3 = (asize_t)jarg3; 
  result = (bool)get_data_value(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1original_1byte(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  uint32 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (uint32)get_original_byte(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1original_1word(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  uint64 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = get_original_word(arg1);
  *(uint64 **)&jresult = new uint64((const uint64 &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1original_1long(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  uint64 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = get_original_long(arg1);
  *(uint64 **)&jresult = new uint64((const uint64 &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_put_1byte(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  uint32 arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (uint32)jarg2; 
  result = (bool)put_byte(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_put_1dbg_1byte(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  uint32 arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (uint32)jarg2; 
  result = (bool)put_dbg_byte(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_put_1word(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  ea_t arg1 ;
  uint64 arg2 ;
  uint64 *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  argp2 = *(uint64 **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null uint64");
    return ;
  }
  arg2 = *argp2; 
  put_word(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_put_1long(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  ea_t arg1 ;
  uint64 arg2 ;
  uint64 *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  argp2 = *(uint64 **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null uint64");
    return ;
  }
  arg2 = *argp2; 
  put_long(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_put_1qword(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  ea_t arg1 ;
  uint64 arg2 ;
  uint64 *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  argp2 = *(uint64 **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null uint64");
    return ;
  }
  arg2 = *argp2; 
  put_qword(arg1,arg2);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_patch_1byte(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  uint32 arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (uint32)jarg2; 
  result = (bool)patch_byte(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_patch_1word(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  uint64 arg2 ;
  uint64 *argp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  argp2 = *(uint64 **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null uint64");
    return 0;
  }
  arg2 = *argp2; 
  result = (bool)patch_word(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_patch_1long(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  uint64 arg2 ;
  uint64 *argp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  argp2 = *(uint64 **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null uint64");
    return 0;
  }
  arg2 = *argp2; 
  result = (bool)patch_long(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_add_1byte(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  ea_t arg1 ;
  uint32 arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (uint32)jarg2; 
  add_byte(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_add_1word(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  ea_t arg1 ;
  uint64 arg2 ;
  uint64 *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  argp2 = *(uint64 **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null uint64");
    return ;
  }
  arg2 = *argp2; 
  add_word(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_add_1long(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  ea_t arg1 ;
  uint64 arg2 ;
  uint64 *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  argp2 = *(uint64 **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null uint64");
    return ;
  }
  arg2 = *argp2; 
  add_long(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_add_1qword(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  ea_t arg1 ;
  uint64 arg2 ;
  uint64 *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  argp2 = *(uint64 **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null uint64");
    return ;
  }
  arg2 = *argp2; 
  add_qword(arg1,arg2);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1zero_1areas(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  areaset_t *arg1 = (areaset_t *) 0 ;
  area_t *arg2 = (area_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(areaset_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2; 
  result = (bool)get_zero_areas(arg1,(area_t const *)arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1many_1bytes(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  void *arg2 = (void *) 0 ;
  ssize_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (ssize_t)jarg3; 
  result = (bool)get_many_bytes(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_put_1many_1bytes(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  ea_t arg1 ;
  void *arg2 = (void *) 0 ;
  size_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (size_t)jarg3; 
  put_many_bytes(arg1,(void const *)arg2,arg3);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_patch_1many_1bytes(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  ea_t arg1 ;
  void *arg2 = (void *) 0 ;
  size_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (size_t)jarg3; 
  patch_many_bytes(arg1,(void const *)arg2,arg3);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isCode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isCode(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1isCode(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_isCode(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isData(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1isData(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_isData(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isTail(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isTail(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1isTail(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_isTail(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isNotTail(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isNotTail(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1isNotTail(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_isNotTail(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isUnknown(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isUnknown(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isHead(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isHead(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1isHead(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_isHead(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_do_1unknown(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  ea_t arg1 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  do_unknown(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_do_1unknown_1range(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  ea_t arg1 ;
  size_t arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (int)jarg3; 
  do_unknown_range(arg1,arg2,arg3);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1manual_1insn(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (bool)is_manual_insn(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1manual_1insn(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  ea_t arg1 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (char *)get_manual_insn(arg1,arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1manual_1insn(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  ea_t arg1 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  set_manual_insn(arg1,(char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isFlow(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isFlow(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isVar(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isVar(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_hasExtra(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)hasExtra(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_has_1cmt(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)has_cmt(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_hasRef(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)hasRef(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1hasRef(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_hasRef(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_has_1name(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)has_name(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1has_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_has_name(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_has_1dummy_1name(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)has_dummy_name(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1has_1dummy_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_has_dummy_name(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_has_1auto_1name(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)has_auto_name(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_has_1any_1name(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)has_any_name(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_has_1user_1name(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)has_user_name(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1has_1user_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_has_user_name(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1invsign(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  flags_t arg2 ;
  int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (flags_t)jarg2; 
  arg3 = (int)jarg3; 
  result = (bool)is_invsign(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_toggle_1sign(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)toggle_sign(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_signed_1data_1flag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)signed_data_flag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1signed_1data(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)is_signed_data(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1bnot(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  flags_t arg2 ;
  int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (flags_t)jarg2; 
  arg3 = (int)jarg3; 
  result = (bool)is_bnot(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_toggle_1bnot(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)toggle_bnot(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_bnot_1data_1flag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)bnot_data_flag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1bnot_1data(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)is_bnot_data(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1lzero(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)is_lzero(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1lzero(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)set_lzero(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_clr_1lzero(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)clr_lzero(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_toggle_1lzero(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)toggle_lzero(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_leading_1zero_1important(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)leading_zero_important(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_doVar_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
  ea_t arg1 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = jarg2 ? true : false; 
  doVar(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_doVar_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  doVar(arg1);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isDefArg0(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isDefArg0(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isDefArg1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isDefArg1(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isOff0(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isOff0(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isOff1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isOff1(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isChar0(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isChar0(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isChar1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isChar1(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isSeg0(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isSeg0(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isSeg1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isSeg1(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isEnum0(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isEnum0(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isEnum1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isEnum1(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isFop0(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isFop0(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isFop1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isFop1(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isStroff0(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isStroff0(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isStroff1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isStroff1(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isStkvar0(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isStkvar0(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isStkvar1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isStkvar1(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isFloat0(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isFloat0(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isFloat1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isFloat1(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isCustFmt0(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isCustFmt0(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isCustFmt1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isCustFmt1(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isNum0(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isNum0(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isNum1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isNum1(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1optype_1flags0(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  flags_t arg1 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (flags_t)get_optype_flags0(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1optype_1flags1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  flags_t arg1 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (flags_t)get_optype_flags1(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isDefArg(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)isDefArg(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isOff(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)isOff(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isChar(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)isChar(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isSeg(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)isSeg(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isEnum(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)isEnum(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isFop(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)isFop(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isStroff(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)isStroff(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isStkvar(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)isStkvar(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isFltnum(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)isFltnum(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isCustFmt(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)isCustFmt(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isNum(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)isNum(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isVoid(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  flags_t arg2 ;
  int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (flags_t)jarg2; 
  arg3 = (int)jarg3; 
  result = (bool)isVoid(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1op_1type(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  flags_t arg2 ;
  int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (flags_t)jarg2; 
  arg3 = (int)jarg3; 
  result = (bool)set_op_type(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_typeflag(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  flags_t arg2 ;
  flags_t arg3 ;
  int arg4 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (flags_t)jarg2; 
  arg3 = (flags_t)jarg3; 
  arg4 = (int)jarg4; 
  result = (flags_t)typeflag(arg1,arg2,arg3,arg4);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1seg(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)op_seg(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1enum(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jshort jarg4) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  enum_t arg3 ;
  uchar arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (enum_t)jarg3; 
  arg4 = (uchar)jarg4; 
  result = (bool)op_enum(arg1,arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1enum_1id(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  uchar *arg3 = (uchar *) 0 ;
  enum_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(uchar **)&jarg3; 
  result = (enum_t)get_enum_id(arg1,arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1stroff(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jint jarg4, jint jarg5) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  tid_t *arg3 = (tid_t *) 0 ;
  int arg4 ;
  adiff_t arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(tid_t **)&jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (adiff_t)jarg5; 
  result = (bool)op_stroff(arg1,arg2,(unsigned int const *)arg3,arg4,arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1stroff_1path(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jint jarg4, jint jarg5) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  tid_t *arg3 = (tid_t *) 0 ;
  int arg4 ;
  adiff_t arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(tid_t **)&jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (adiff_t)jarg5; 
  result = (bool)set_stroff_path(arg1,arg2,(unsigned int const *)arg3,arg4,arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1stroff_1path(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  tid_t *arg3 = (tid_t *) 0 ;
  adiff_t *arg4 = (adiff_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(tid_t **)&jarg3; 
  arg4 = *(adiff_t **)&jarg4; 
  result = (int)get_stroff_path(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_del_1stroff_1path(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)del_stroff_path(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1stkvar(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)op_stkvar(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1forced_1operand(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (bool)set_forced_operand(arg1,arg2,(char const *)arg3);
  jresult = (jboolean)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1forced_1operand(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jlong jarg4) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  size_t arg4 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (size_t)jarg4; 
  result = (ssize_t)get_forced_operand(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1forced_1operand(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)is_forced_operand(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_charflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)charflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_offflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)offflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_enumflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)enumflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_stroffflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)stroffflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_stkvarflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)stkvarflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_fltflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)fltflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_custfmtflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)custfmtflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_segflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)segflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_numflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)numflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_hexflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)hexflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_decflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)decflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_octflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)octflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_binflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)binflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1chr(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)op_chr(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1num(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)op_num(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1hex(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)op_hex(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1dec(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)op_dec(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1oct(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)op_oct(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1bin(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)op_bin(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1flt(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)op_flt(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_op_1custfmt(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (bool)op_custfmt(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_noType(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)noType(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_getDefaultRadix(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)getDefaultRadix();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_getRadix(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  flags_t arg1 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (int)getRadix(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_getRadixEA(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (int)getRadixEA(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_codeflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)codeflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_byteflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)byteflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_wordflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)wordflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_dwrdflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)dwrdflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_qwrdflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)qwrdflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_owrdflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)owrdflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_tbytflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)tbytflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_asciflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)asciflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_struflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)struflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_custflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)custflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_alignflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)alignflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_floatflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)floatflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_doubleflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)doubleflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_tribyteflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)tribyteflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_packrealflag(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  result = (flags_t)packrealflag();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1flags_1by_1size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  size_t arg1 ;
  flags_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (size_t)jarg1; 
  result = (flags_t)get_flags_by_size(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_do_1data_1ex(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  flags_t arg2 ;
  asize_t arg3 ;
  tid_t arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (flags_t)jarg2; 
  arg3 = (asize_t)jarg3; 
  arg4 = (tid_t)jarg4; 
  result = (bool)do_data_ex(arg1,arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_doByte(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  result = (bool)doByte(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_doWord(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  result = (bool)doWord(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_doDwrd(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  result = (bool)doDwrd(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_doQwrd(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  result = (bool)doQwrd(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_doOwrd(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  result = (bool)doOwrd(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_doTbyt(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  result = (bool)doTbyt(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_doFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  result = (bool)doFloat(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_doDouble(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  result = (bool)doDouble(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_doPackReal(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  result = (bool)doPackReal(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_doASCI(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  result = (bool)doASCI(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_do3byte(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  result = (bool)do3byte(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_doStruct(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  tid_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  arg3 = (tid_t)jarg3; 
  result = (bool)doStruct(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_doCustomData(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jint jarg4) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  int arg3 ;
  int arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (bool)doCustomData(arg1,arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_doAlign(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  arg3 = (int)jarg3; 
  result = (bool)doAlign(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_calc_1min_1align(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  asize_t arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (asize_t)jarg1; 
  result = (int)calc_min_align(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_calc_1max_1align(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (int)calc_max_align(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_calc_1def_1align(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (int)calc_def_align(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_do16bit(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  result = (bool)do16bit(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_do32bit(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  result = (bool)do32bit(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isByte(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isByte(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isWord(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isWord(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isDwrd(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isDwrd(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isQwrd(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isQwrd(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isOwrd(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isOwrd(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isTbyt(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isTbyt(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isFloat(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isFloat(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isDouble(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isDouble(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isPackReal(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isPackReal(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isASCII(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isASCII(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isStruct(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isStruct(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isAlign(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isAlign(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is3byte(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)is3byte(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isCustom(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isCustom(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1isByte(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_isByte(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1isWord(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_isWord(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1isDwrd(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_isDwrd(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1isQwrd(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_isQwrd(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1isOwrd(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_isOwrd(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1isTbyt(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_isTbyt(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1isFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_isFloat(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1isDouble(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_isDouble(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1isPackReal(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_isPackReal(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1isASCII(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_isASCII(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1isStruct(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_isStruct(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1isAlign(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_isAlign(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1is3byte(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_is3byte(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1isCustom(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_isCustom(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1same_1data_1type(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  flags_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = (flags_t)jarg2; 
  result = (bool)is_same_data_type(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1max_1ascii_1length_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  int32 arg2 ;
  bool arg3 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int32)jarg2; 
  arg3 = jarg3 ? true : false; 
  result = get_max_ascii_length(arg1,arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1max_1ascii_1length_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  int32 arg2 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int32)jarg2; 
  result = get_max_ascii_length(arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1ascii_1contents(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jstring jarg4, jlong jarg5) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  size_t arg2 ;
  int32 arg3 ;
  char *arg4 = (char *) 0 ;
  size_t arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (int32)jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = (size_t)jarg5; 
  result = (bool)get_ascii_contents(arg1,arg2,arg3,arg4,arg5);
  jresult = (jboolean)result; 
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_make_1ascii_1string(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  size_t arg2 ;
  int32 arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (int32)jarg3; 
  result = (bool)make_ascii_string(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_print_1ascii_1string_1type(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jint jarg3) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  int32 arg3 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (size_t)jarg2; 
  arg3 = (int32)jarg3; 
  result = (char *)print_ascii_string_type(arg1,arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1opinfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  flags_t arg3 ;
  opinfo_t *arg4 = (opinfo_t *) 0 ;
  opinfo_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg4_;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (flags_t)jarg3; 
  arg4 = *(opinfo_t **)&jarg4; 
  result = (opinfo_t *)get_opinfo(arg1,arg2,arg3,arg4);
  *(opinfo_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1opinfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  flags_t arg3 ;
  opinfo_t *arg4 = (opinfo_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg4_;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (flags_t)jarg3; 
  arg4 = *(opinfo_t **)&jarg4; 
  result = (bool)set_opinfo(arg1,arg2,arg3,(opinfo_t const *)arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1data_1elsize_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  flags_t arg2 ;
  opinfo_t *arg3 = (opinfo_t *) 0 ;
  asize_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  arg1 = (ea_t)jarg1; 
  arg2 = (flags_t)jarg2; 
  arg3 = *(opinfo_t **)&jarg3; 
  result = (asize_t)get_data_elsize(arg1,arg2,(opinfo_t const *)arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1data_1elsize_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  flags_t arg2 ;
  asize_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (flags_t)jarg2; 
  result = (asize_t)get_data_elsize(arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1varsize_1item_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jobject jarg3_, jlong jarg4) {
  jint jresult = 0 ;
  ea_t arg1 ;
  flags_t arg2 ;
  opinfo_t *arg3 = (opinfo_t *) 0 ;
  asize_t *arg4 = (asize_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  arg1 = (ea_t)jarg1; 
  arg2 = (flags_t)jarg2; 
  arg3 = *(opinfo_t **)&jarg3; 
  arg4 = *(asize_t **)&jarg4; 
  result = (int)is_varsize_item(arg1,arg2,(opinfo_t const *)arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1varsize_1item_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  ea_t arg1 ;
  flags_t arg2 ;
  opinfo_t *arg3 = (opinfo_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  arg1 = (ea_t)jarg1; 
  arg2 = (flags_t)jarg2; 
  arg3 = *(opinfo_t **)&jarg3; 
  result = (int)is_varsize_item(arg1,arg2,(opinfo_t const *)arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1varsize_1item_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  ea_t arg1 ;
  flags_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (flags_t)jarg2; 
  result = (int)is_varsize_item(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_can_1define_1item(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  flags_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  arg3 = (flags_t)jarg3; 
  result = (bool)can_define_item(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isImmd(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isImmd(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_isFunc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (bool)isFunc(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_doImmd(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  doImmd(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_noImmd(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  noImmd(arg1);
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_gettof(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  flags_t arg1 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  result = (ushort)gettof(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_register_1custom_1data_1type(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  data_type_t *arg1 = (data_type_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(data_type_t **)&jarg1; 
  result = (int)register_custom_data_type((data_type_t const *)arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_unregister_1custom_1data_1type(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  int arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (bool)unregister_custom_data_type(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_register_1custom_1data_1format(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2) {
  jint jresult = 0 ;
  int arg1 ;
  data_format_t *arg2 = (data_format_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = *(data_format_t **)&jarg2; 
  result = (int)register_custom_data_format(arg1,(data_format_t const *)arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_unregister_1custom_1data_1format(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  int arg1 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)unregister_custom_data_format(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1custom_1data_1type(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  data_type_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (data_type_t *)get_custom_data_type(arg1);
  *(data_type_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1custom_1data_1format(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  data_format_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  result = (data_format_t *)get_custom_data_format(arg1,arg2);
  *(data_format_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1custom_1data_1types_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  intvec_t *arg1 = (intvec_t *) 0 ;
  asize_t arg2 ;
  asize_t arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(intvec_t **)&jarg1; 
  arg2 = (asize_t)jarg2; 
  arg3 = (asize_t)jarg3; 
  result = (int)get_custom_data_types(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1custom_1data_1types_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  intvec_t *arg1 = (intvec_t *) 0 ;
  asize_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(intvec_t **)&jarg1; 
  arg2 = (asize_t)jarg2; 
  result = (int)get_custom_data_types(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1custom_1data_1types_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  intvec_t *arg1 = (intvec_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(intvec_t **)&jarg1; 
  result = (int)get_custom_data_types(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1custom_1data_1formats(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  intvec_t *arg1 = (intvec_t *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(intvec_t **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)get_custom_data_formats(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_find_1custom_1data_1type(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (int)find_custom_data_type((char const *)arg1);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_find_1custom_1data_1format(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (int)find_custom_data_format((char const *)arg1);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1cmt(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jboolean jarg3) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  char *arg2 = (char *) 0 ;
  bool arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = jarg3 ? true : false; 
  result = (bool)set_cmt(arg1,(char const *)arg2,arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1cmt(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2, jstring jarg3, jlong jarg4) {
  jint jresult = 0 ;
  ea_t arg1 ;
  bool arg2 ;
  char *arg3 = (char *) 0 ;
  size_t arg4 ;
  ssize_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (size_t)jarg4; 
  result = (ssize_t)get_cmt(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_append_1cmt(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jboolean jarg3) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  char *arg2 = (char *) 0 ;
  bool arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = jarg3 ? true : false; 
  result = (bool)append_cmt(arg1,(char const *)arg2,arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_find_1byte(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jshort jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  uchar arg3 ;
  bool arg4 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  arg3 = (uchar)jarg3; 
  arg4 = jarg4 ? true : false; 
  result = (ea_t)find_byte(arg1,arg2,arg3,arg4);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_find_1byter(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jshort jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  asize_t arg2 ;
  uchar arg3 ;
  bool arg4 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  arg3 = (uchar)jarg3; 
  arg4 = jarg4 ? true : false; 
  result = (ea_t)find_byter(arg1,arg2,arg3,arg4);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_bin_1search(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jint jarg6, jint jarg7) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  uchar *arg3 = (uchar *) 0 ;
  uchar *arg4 = (uchar *) 0 ;
  size_t arg5 ;
  int arg6 ;
  int arg7 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = *(uchar **)&jarg3; 
  arg4 = *(uchar **)&jarg4; 
  arg5 = (size_t)jarg5; 
  arg6 = (int)jarg6; 
  arg7 = (int)jarg7; 
  result = (ea_t)bin_search(arg1,arg2,(unsigned char const *)arg3,(unsigned char const *)arg4,arg5,arg6,arg7);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_equal_1bytes(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jboolean jarg5) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  uchar *arg2 = (uchar *) 0 ;
  uchar *arg3 = (uchar *) 0 ;
  size_t arg4 ;
  bool arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = *(uchar **)&jarg2; 
  arg3 = *(uchar **)&jarg3; 
  arg4 = (size_t)jarg4; 
  arg5 = jarg5 ? true : false; 
  result = (bool)equal_bytes(arg1,(unsigned char const *)arg2,(unsigned char const *)arg3,arg4,arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_invalidate_1dbgmem_1config(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  invalidate_dbgmem_config();
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_invalidate_1dbgmem_1contents(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  ea_t arg1 ;
  asize_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (asize_t)jarg2; 
  invalidate_dbgmem_contents(arg1,arg2);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1debugger_1on(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)is_debugger_on();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_hidden_1area_1t_1description_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  hidden_area_t *arg1 = (hidden_area_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(hidden_area_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->description) delete [] arg1->description;
    if (arg2) {
      arg1->description = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->description, (const char *)arg2);
    } else {
      arg1->description = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_hidden_1area_1t_1description_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  hidden_area_t *arg1 = (hidden_area_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(hidden_area_t **)&jarg1; 
  result = (char *) ((arg1)->description);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_hidden_1area_1t_1header_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  hidden_area_t *arg1 = (hidden_area_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(hidden_area_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->header) delete [] arg1->header;
    if (arg2) {
      arg1->header = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->header, (const char *)arg2);
    } else {
      arg1->header = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_hidden_1area_1t_1header_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  hidden_area_t *arg1 = (hidden_area_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(hidden_area_t **)&jarg1; 
  result = (char *) ((arg1)->header);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_hidden_1area_1t_1footer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  hidden_area_t *arg1 = (hidden_area_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(hidden_area_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->footer) delete [] arg1->footer;
    if (arg2) {
      arg1->footer = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->footer, (const char *)arg2);
    } else {
      arg1->footer = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_hidden_1area_1t_1footer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  hidden_area_t *arg1 = (hidden_area_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(hidden_area_t **)&jarg1; 
  result = (char *) ((arg1)->footer);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_hidden_1area_1t_1visible_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  hidden_area_t *arg1 = (hidden_area_t *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(hidden_area_t **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->visible = arg2;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_hidden_1area_1t_1visible_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  hidden_area_t *arg1 = (hidden_area_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(hidden_area_t **)&jarg1; 
  result = (bool) ((arg1)->visible);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_hidden_1area_1t_1color_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  hidden_area_t *arg1 = (hidden_area_t *) 0 ;
  bgcolor_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(hidden_area_t **)&jarg1; 
  arg2 = (bgcolor_t)jarg2; 
  if (arg1) (arg1)->color = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_hidden_1area_1t_1color_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  hidden_area_t *arg1 = (hidden_area_t *) 0 ;
  bgcolor_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(hidden_area_t **)&jarg1; 
  result = (bgcolor_t) ((arg1)->color);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1hidden_1area_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  hidden_area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (hidden_area_t *)new hidden_area_t();
  *(hidden_area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1hidden_1area_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  hidden_area_t *arg1 = (hidden_area_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(hidden_area_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_hidden_1areas_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  areacb_t *arg1 = (areacb_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  hidden_areas = *arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_hidden_1areas_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  areacb_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (areacb_t *)&hidden_areas;
  *(areacb_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_update_1hidden_1area(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  hidden_area_t *arg1 = (hidden_area_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(hidden_area_t **)&jarg1; 
  result = (bool)update_hidden_area(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_add_1hidden_1area(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jlong jarg6) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  bgcolor_t arg6 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  arg6 = (bgcolor_t)jarg6; 
  result = (bool)add_hidden_area(arg1,arg2,(char const *)arg3,(char const *)arg4,(char const *)arg5,arg6);
  jresult = (jboolean)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1hidden_1area(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  hidden_area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (hidden_area_t *)get_hidden_area(arg1);
  *(hidden_area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_getn_1hidden_1area(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  hidden_area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (hidden_area_t *)getn_hidden_area(arg1);
  *(hidden_area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1hidden_1area_1qty(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)get_hidden_area_qty();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1hidden_1area_1num(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (int)get_hidden_area_num(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1prev_1hidden_1area(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  hidden_area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (hidden_area_t *)get_prev_hidden_area(arg1);
  *(hidden_area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1next_1hidden_1area(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  hidden_area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (hidden_area_t *)get_next_hidden_area(arg1);
  *(hidden_area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_del_1hidden_1area(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (bool)del_hidden_area(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_doFlow(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  doFlow(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_noFlow(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  noFlow(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_doExtra(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  doExtra(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_noExtra(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  noExtra(arg1);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1data_1type_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  flags_t arg1 ;
  opinfo_t *arg2 = (opinfo_t *) 0 ;
  asize_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = (flags_t)jarg1; 
  arg2 = *(opinfo_t **)&jarg2; 
  result = (asize_t)get_data_type_size(arg1,(opinfo_t const *)arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_f_1isUnknown(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  flags_t arg1 ;
  void *arg2 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (flags_t)jarg1; 
  arg2 = *(void **)&jarg2; 
  result = (bool)f_isUnknown(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlongArray JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_power2_1get(JNIEnv *jenv, jclass jcls) {
  jlongArray jresult = 0 ;
  uint32 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (uint32 *)(uint32 *)power2;
  jresult = SWIG_JavaArrayOutUint(jenv, result, 32); 
  return jresult;
}


SWIGEXPORT jlongArray JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_lowbits_1get(JNIEnv *jenv, jclass jcls) {
  jlongArray jresult = 0 ;
  uint32 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (uint32 *)(uint32 *)lowbits;
  jresult = SWIG_JavaArrayOutUint(jenv, result, 33); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1enum_1id(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jshort jarg4) {
  ea_t arg1 ;
  int arg2 ;
  enum_t arg3 ;
  uchar arg4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (enum_t)jarg3; 
  arg4 = (uchar)jarg4; 
  set_enum_id(arg1,arg2,arg3,arg4);
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_FlagsEnable(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  result = FlagsEnable(arg1,arg2);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_FlagsDisable(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  error_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  result = FlagsDisable(arg1,arg2);
  *(error_t **)&jresult = new error_t((const error_t &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1typeinfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  flags_t arg3 ;
  opinfo_t *arg4 = (opinfo_t *) 0 ;
  opinfo_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg4_;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (flags_t)jarg3; 
  arg4 = *(opinfo_t **)&jarg4; 
  result = (opinfo_t *)get_typeinfo(arg1,arg2,arg3,arg4);
  *(opinfo_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1typeinfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  int arg2 ;
  flags_t arg3 ;
  opinfo_t *arg4 = (opinfo_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg4_;
  arg1 = (ea_t)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (flags_t)jarg3; 
  arg4 = *(opinfo_t **)&jarg4; 
  result = (bool)set_typeinfo(arg1,arg2,arg3,(opinfo_t const *)arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_AU_1NONE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  atype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (atype_t)(atype_t)AU_NONE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_AU_1UNK_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  atype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (atype_t)(atype_t)AU_UNK;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_AU_1CODE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  atype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (atype_t)(atype_t)AU_CODE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_AU_1WEAK_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  atype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (atype_t)(atype_t)AU_WEAK;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_AU_1PROC_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  atype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (atype_t)(atype_t)AU_PROC;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_AU_1TAIL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  atype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (atype_t)(atype_t)AU_TAIL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_AU_1TRSP_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  atype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (atype_t)(atype_t)AU_TRSP;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_AU_1USED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  atype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (atype_t)(atype_t)AU_USED;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_AU_1TYPE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  atype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (atype_t)(atype_t)AU_TYPE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_AU_1LIBF_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  atype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (atype_t)(atype_t)AU_LIBF;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_AU_1LBF2_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  atype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (atype_t)(atype_t)AU_LBF2;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_AU_1LBF3_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  atype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (atype_t)(atype_t)AU_LBF3;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_AU_1CHLB_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  atype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (atype_t)(atype_t)AU_CHLB;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_AU_1FINAL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  atype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (atype_t)(atype_t)AU_FINAL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_st_1Ready_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  idastate_t result;
  
  (void)jenv;
  (void)jcls;
  result = (idastate_t)(idastate_t)st_Ready;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_st_1Think_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  idastate_t result;
  
  (void)jenv;
  (void)jcls;
  result = (idastate_t)(idastate_t)st_Think;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_st_1Waiting_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  idastate_t result;
  
  (void)jenv;
  (void)jcls;
  result = (idastate_t)(idastate_t)st_Waiting;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_st_1Work_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  idastate_t result;
  
  (void)jenv;
  (void)jcls;
  result = (idastate_t)(idastate_t)st_Work;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_autoEnabled_1set(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  autoEnabled = arg1;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_autoEnabled_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)autoEnabled;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_auto_1state_1set(JNIEnv *jenv, jclass jcls, jint jarg1) {
  atype_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (atype_t)jarg1; 
  auto_state = arg1;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_auto_1state_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  atype_t result;
  
  (void)jenv;
  (void)jcls;
  result = (atype_t)auto_state;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_auto_1display_1t_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  auto_display_t *arg1 = (auto_display_t *) 0 ;
  atype_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(auto_display_t **)&jarg1; 
  arg2 = (atype_t)jarg2; 
  if (arg1) (arg1)->type = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_auto_1display_1t_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  auto_display_t *arg1 = (auto_display_t *) 0 ;
  atype_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(auto_display_t **)&jarg1; 
  result = (atype_t) ((arg1)->type);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_auto_1display_1t_1ea_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  auto_display_t *arg1 = (auto_display_t *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(auto_display_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->ea = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_auto_1display_1t_1ea_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  auto_display_t *arg1 = (auto_display_t *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(auto_display_t **)&jarg1; 
  result = (ea_t) ((arg1)->ea);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_auto_1display_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  auto_display_t *arg1 = (auto_display_t *) 0 ;
  idastate_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(auto_display_t **)&jarg1; 
  arg2 = (idastate_t)jarg2; 
  if (arg1) (arg1)->state = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_auto_1display_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  auto_display_t *arg1 = (auto_display_t *) 0 ;
  idastate_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(auto_display_t **)&jarg1; 
  result = (idastate_t) ((arg1)->state);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1auto_1display_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  auto_display_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (auto_display_t *)new auto_display_t();
  *(auto_display_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1auto_1display_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  auto_display_t *arg1 = (auto_display_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(auto_display_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_auto_1display_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  auto_display_t *arg1 = (auto_display_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(auto_display_t **)&jarg1; 
  auto_display = *arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_auto_1display_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  auto_display_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (auto_display_t *)&auto_display;
  *(auto_display_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_showAuto_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  ea_t arg1 ;
  atype_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (atype_t)jarg2; 
  showAuto(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_showAuto_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  showAuto(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_showAddr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  showAddr(arg1);
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_setStat(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  idastate_t arg1 ;
  idastate_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (idastate_t)jarg1; 
  result = (idastate_t)setStat(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_may_1create_1stkvars(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)may_create_stkvars();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_may_1trace_1sp(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)may_trace_sp();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_auto_1mark_1range(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  ea_t arg1 ;
  ea_t arg2 ;
  atype_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (atype_t)jarg3; 
  auto_mark_range(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_autoMark(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  ea_t arg1 ;
  atype_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (atype_t)jarg2; 
  autoMark(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_autoUnmark(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  ea_t arg1 ;
  ea_t arg2 ;
  atype_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (atype_t)jarg3; 
  autoUnmark(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_noUsed_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  noUsed(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_noUsed_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  ea_t arg1 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  noUsed(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_auto_1make_1code(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  auto_make_code(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_auto_1make_1proc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ea_t arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  auto_make_proc(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_reanalyze_1callers(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
  ea_t arg1 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = jarg2 ? true : false; 
  reanalyze_callers(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_auto_1apply_1type(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  ea_t arg1 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  auto_apply_type(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_analyze_1area(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (int)analyze_area(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_autoWait(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)autoWait();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_autoCancel(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  ea_t arg1 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  autoCancel(arg1,arg2);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_autoIsOk(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)autoIsOk();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_autoStep(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)autoStep();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_auto_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  atype_t *arg3 = (atype_t *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = *(atype_t **)&jarg3; 
  result = (ea_t)auto_get(arg1,arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_autoGetName(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  atype_t arg1 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (atype_t)jarg1; 
  result = (char *)autoGetName(arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_regarg_1t_1reg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  regarg_t *arg1 = (regarg_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(regarg_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->reg = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_regarg_1t_1reg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  regarg_t *arg1 = (regarg_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(regarg_t **)&jarg1; 
  result = (int) ((arg1)->reg);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_regarg_1t_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  regarg_t *arg1 = (regarg_t *) 0 ;
  type_t *arg2 = (type_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(regarg_t **)&jarg1; 
  arg2 = *(type_t **)&jarg2; 
  if (arg1) (arg1)->type = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_regarg_1t_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  regarg_t *arg1 = (regarg_t *) 0 ;
  type_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(regarg_t **)&jarg1; 
  result = (type_t *) ((arg1)->type);
  *(type_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_regarg_1t_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  regarg_t *arg1 = (regarg_t *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(regarg_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->name) delete [] arg1->name;
    if (arg2) {
      arg1->name = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->name, (const char *)arg2);
    } else {
      arg1->name = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_regarg_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  regarg_t *arg1 = (regarg_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(regarg_t **)&jarg1; 
  result = (char *) ((arg1)->name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1regarg_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  regarg_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (regarg_t *)new regarg_t();
  *(regarg_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1regarg_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  regarg_t *arg1 = (regarg_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(regarg_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  func_t *arg1 = (func_t *) 0 ;
  ushort arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = (ushort)jarg2; 
  if (arg1) (arg1)->flags = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (ushort) ((arg1)->flags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1is_1far(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (bool)((func_t const *)arg1)->is_far();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1does_1return(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (bool)((func_t const *)arg1)->does_return();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1analyzed_1sp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (bool)((func_t const *)arg1)->analyzed_sp();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1frame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  func_t *arg1 = (func_t *) 0 ;
  uval_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = (uval_t)jarg2; 
  if (arg1) (arg1)->frame = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1frame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  uval_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (uval_t) ((arg1)->frame);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1frsize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  func_t *arg1 = (func_t *) 0 ;
  asize_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = (asize_t)jarg2; 
  if (arg1) (arg1)->frsize = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1frsize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  asize_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (asize_t) ((arg1)->frsize);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1frregs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  func_t *arg1 = (func_t *) 0 ;
  ushort arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = (ushort)jarg2; 
  if (arg1) (arg1)->frregs = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1frregs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (ushort) ((arg1)->frregs);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1argsize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  func_t *arg1 = (func_t *) 0 ;
  asize_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = (asize_t)jarg2; 
  if (arg1) (arg1)->argsize = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1argsize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  asize_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (asize_t) ((arg1)->argsize);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1fpd_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  func_t *arg1 = (func_t *) 0 ;
  asize_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = (asize_t)jarg2; 
  if (arg1) (arg1)->fpd = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1fpd_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  asize_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (asize_t) ((arg1)->fpd);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1color_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  func_t *arg1 = (func_t *) 0 ;
  bgcolor_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = (bgcolor_t)jarg2; 
  if (arg1) (arg1)->color = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1color_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  bgcolor_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (bgcolor_t) ((arg1)->color);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1pntqty_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  func_t *arg1 = (func_t *) 0 ;
  ushort arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = (ushort)jarg2; 
  if (arg1) (arg1)->pntqty = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1pntqty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  ushort result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (ushort) ((arg1)->pntqty);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1points_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  func_t *arg1 = (func_t *) 0 ;
  stkpnt_t *arg2 = (stkpnt_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = *(stkpnt_t **)&jarg2; 
  if (arg1) (arg1)->points = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1points_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  stkpnt_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (stkpnt_t *) ((arg1)->points);
  *(stkpnt_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1regvarqty_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  func_t *arg1 = (func_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->regvarqty = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1regvarqty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (int) ((arg1)->regvarqty);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1regvars_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  func_t *arg1 = (func_t *) 0 ;
  regvar_t *arg2 = (regvar_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = *(regvar_t **)&jarg2; 
  if (arg1) (arg1)->regvars = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1regvars_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  regvar_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (regvar_t *) ((arg1)->regvars);
  *(regvar_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1llabelqty_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  func_t *arg1 = (func_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->llabelqty = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1llabelqty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (int) ((arg1)->llabelqty);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1llabels_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  func_t *arg1 = (func_t *) 0 ;
  llabel_t *arg2 = (llabel_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = *(llabel_t **)&jarg2; 
  if (arg1) (arg1)->llabels = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1llabels_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  llabel_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (llabel_t *) ((arg1)->llabels);
  *(llabel_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1regargqty_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  func_t *arg1 = (func_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->regargqty = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1regargqty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (int) ((arg1)->regargqty);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1regargs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  func_t *arg1 = (func_t *) 0 ;
  regarg_t *arg2 = (regarg_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = *(regarg_t **)&jarg2; 
  if (arg1) (arg1)->regargs = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1regargs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  regarg_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (regarg_t *) ((arg1)->regargs);
  *(regarg_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1tailqty_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  func_t *arg1 = (func_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->tailqty = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1tailqty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (int) ((arg1)->tailqty);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1tails_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  func_t *arg1 = (func_t *) 0 ;
  area_t *arg2 = (area_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2; 
  if (arg1) (arg1)->tails = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1tails_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  area_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (area_t *) ((arg1)->tails);
  *(area_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1owner_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  func_t *arg1 = (func_t *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  if (arg1) (arg1)->owner = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1owner_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (ea_t) ((arg1)->owner);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1refqty_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  func_t *arg1 = (func_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->refqty = arg2;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1refqty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (int) ((arg1)->refqty);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1referers_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  func_t *arg1 = (func_t *) 0 ;
  ea_t *arg2 = (ea_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = *(ea_t **)&jarg2; 
  if (arg1) (arg1)->referers = arg2;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1t_1referers_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  ea_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (ea_t *) ((arg1)->referers);
  *(ea_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1func_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  func_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (func_t *)new func_t();
  *(func_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1func_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  func_t *arg1 = (func_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(func_t **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1func_1entry(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (bool)is_func_entry((func_t const *)arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1func_1tail(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (bool)is_func_tail((func_t const *)arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_funcs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  areacb_t *arg1 = (areacb_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(areacb_t **)&jarg1; 
  funcs = *arg1;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_funcs_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  areacb_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (areacb_t *)&funcs;
  *(areacb_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_new_1lock_1func(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  lock_func *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (lock_func *)new lock_func((func_t const *)arg1);
  *(lock_func **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_delete_1lock_1func(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lock_func *arg1 = (lock_func *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lock_func **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1func_1locked(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (bool)is_func_locked((func_t const *)arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1func(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  func_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (func_t *)get_func(arg1);
  *(func_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1func_1chunknum(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  ea_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (int)get_func_chunknum(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1contains(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  ea_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (bool)func_contains(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_getn_1func(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  size_t arg1 ;
  func_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (size_t)jarg1; 
  result = (func_t *)getn_func(arg1);
  *(func_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1func_1qty(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  result = get_func_qty();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1func_1num(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (int)get_func_num(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1prev_1func(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  func_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (func_t *)get_prev_func(arg1);
  *(func_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1next_1func(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  func_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (func_t *)get_next_func(arg1);
  *(func_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1func_1limits(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  area_t *arg2 = (area_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = *(area_t **)&jarg2; 
  result = (bool)get_func_limits(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1func_1cmt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jstring jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  bool arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (char *)get_func_cmt(arg1,arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1func_1cmt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jboolean jarg3) {
  jboolean jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  char *arg2 = (char *) 0 ;
  bool arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = jarg3 ? true : false; 
  result = (bool)set_func_cmt(arg1,(char const *)arg2,arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_del_1func_1cmt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  func_t *arg1 = (func_t *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  del_func_cmt(arg1,arg2);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_update_1func(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (bool)update_func(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_add_1func_1ex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (bool)add_func_ex(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_add_1func(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (bool)add_func(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_del_1func(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (bool)del_func(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1setstart(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (int)func_setstart(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1setend(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  ea_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = (ea_t)jarg2; 
  result = (bool)func_setend(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_reanalyze_1function_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jboolean jarg4) {
  func_t *arg1 = (func_t *) 0 ;
  ea_t arg2 ;
  ea_t arg3 ;
  bool arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (ea_t)jarg3; 
  arg4 = jarg4 ? true : false; 
  reanalyze_function(arg1,arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_reanalyze_1function_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  func_t *arg1 = (func_t *) 0 ;
  ea_t arg2 ;
  ea_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  arg3 = (ea_t)jarg3; 
  reanalyze_function(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_reanalyze_1function_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  func_t *arg1 = (func_t *) 0 ;
  ea_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = (ea_t)jarg2; 
  reanalyze_function(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_reanalyze_1function_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  func_t *arg1 = (func_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  reanalyze_function(arg1);
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_clear_1func_1struct(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  func_t *arg1 = (func_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  clear_func_struct(arg1);
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_find_1func_1bounds(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_, jint jarg3) {
  jint jresult = 0 ;
  ea_t arg1 ;
  func_t *arg2 = (func_t *) 0 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = (ea_t)jarg1; 
  arg2 = *(func_t **)&jarg2; 
  arg3 = (int)jarg3; 
  result = (int)find_func_bounds(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1func_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  ea_t arg1 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (char *)get_func_name(arg1,arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1func_1bitness(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (int)get_func_bitness(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1func_1bits(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (int)get_func_bits(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1func_1bytes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (int)get_func_bytes(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1visible_1func(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (bool)is_visible_func(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_is_1finally_1visible_1func(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  result = (bool)is_finally_visible_func(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1visible_1func(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  func_t *arg1 = (func_t *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  set_visible_func(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1func_1name_1if_1jumpfunc(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)set_func_name_if_jumpfunc(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_calc_1thunk_1func_1target(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  func_t *arg1 = (func_t *) 0 ;
  ea_t *arg2 = (ea_t *) 0 ;
  ea_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  arg2 = *(ea_t **)&jarg2; 
  result = (ea_t)calc_thunk_func_target(arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_a2funcoff(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  ea_t arg1 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (char *)a2funcoff(arg1,arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_std_1gen_1func_1header(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  func_t *arg1 = (func_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(func_t **)&jarg1; 
  std_gen_func_header(arg1);
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_func_1does_1return(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (bool)func_does_return(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_set_1noret_1insn(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
  jboolean jresult = 0 ;
  ea_t arg1 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)set_noret_insn(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1fchunk(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  func_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (func_t *)get_fchunk(arg1);
  *(func_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_getn_1fchunk(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  func_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (func_t *)getn_fchunk(arg1);
  *(func_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1fchunk_1qty(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  result = get_fchunk_qty();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1fchunk_1num(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  ea_t arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (int)get_fchunk_num(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1prev_1fchunk(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  func_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (func_t *)get_prev_fchunk(arg1);
  *(func_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_de_blichmann_idajava_natives_IdaJavaJNI_get_1next_1fchunk(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ea_t arg1 ;
  func_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (ea_t)jarg1; 
  result = (func_t *)get_n