class NQueens {
    private boolean[][] Field; // For output only
    private int Size;
    private int Queens = 0;
    private int Solutions = 0;

    public NQueens(int N) {
        Field = new boolean[N][N];
        Size = N;
    }

    public boolean canSetQueen(int x, int y) {
        for (int i = -Size + 1; i < Size; i++)
            if ((y + i >= 0 && y + i < Size && Field[x][y + i]) || (
                (x + i >= 0 && x + i < Size) && (Field[x + i][y] ||
                (y + i >= 0 && y + i < Size && Field[x + i][y + i]) ||
                (y - i >= 0 && y - i < Size && Field[x + i][y - i]))))
                return false;
        return true;
    }

    private void setQueens(int startX, int j) {
        if (j < Size) {
            for (int i = startX; i < Size; i++)
                if (canSetQueen(i, j)) {
                    Field[i][j] = true;
                    Queens++;
                    printField();
                    setQueens(startX, j + 1);
                } else {
                    printField();
                    setQueens(startX + 1, j + 1);
                }
        }
    }

    public void Solve() {
        setQueens(0, 0);
    }

    public void printField() {
        String s = " ";
        for (int x = 0; x < Size; x++) s += " " + ((char)(x + 65));

        for (int y = 0; y < Size; y++) {
            s += "\n" + ((char)(y + 65));
            for (int x = 0; x < Size; x++)
                s += (Field[x][y] ? " *" : " -");
        }

        System.out.println(s);
    }
}

public class Queens {
    private static final int FIELD_SIZE = 4;

    public static void main(String[] args) {
        int fieldSize = (args.length == 1) ? fieldSize =
            Integer.parseInt(args[0]) : FIELD_SIZE;
        NQueens myQueens = new NQueens(fieldSize);

        myQueens.Solve();
    }
}
