interface Iterator {
    Object getNextElement();
    boolean hasNextElement();
}

interface BoundedContainer {
    int getMaxCapacity();
    int getNumberOfElements();
    void addElement(Object o);
    Iterator getElements();
}

class ListItem {
    private ListItem Next = null;
    private Object Data = null;

    public ListItem() {
    }

    public ListItem(Object Data) {
        this.Data = Data;
    }

    public Object getData() {
        return Data;
    }

    public void setData(Object Data) {
        this.Data = Data;
    }

    public ListItem getNext() {
        return Next;
    }

    public void setNext(ListItem Next) {
        this.Next = Next;
    }
}

class MaxCapException extends Exception {}

class LinearContainer implements BoundedContainer {
    private ListItem First = null;

    public class LinearIterator implements Iterator {
        private ListItem Current;

        public LinearIterator() {
            Current = new ListItem();
            Current.setNext(First);
        }

        public Object getNextElement() {
            if (hasNextElement()) {
                Current = Current.getNext();
                return (Current.getData());
            }
            return null;
        }

        public boolean hasNextElement() {
            return (Current.getNext() != null);
        }
    }

    public int getMaxCapacity() {
        return Integer.MAX_VALUE;
    }

    public int getNumberOfElements() {
        LinearIterator myIterator = new LinearIterator();
        int r = 0;
        while (myIterator.hasNextElement()) {
            myIterator.getNextElement();
            r++;
        }
        return r;
    }

    public void addElement(Object o) throws MaxCapException {
        if (First == null) First = new ListItem(o); else {
            ListItem p = First;
            while (p.getNext() != null) p = p.getNext();
            p.setNext(new ListItem(o));
        }
    }

    public Iterator getElements() {
        return new LinearIterator();
    }
}

class ArrayContainer implements BoundedContainer {
    private Object[] Field;
    private int Items = 0;

    public class ArrayIterator implements Iterator {
        private int Current = -1;

        public Object getNextElement() {
            if (hasNextElement()) {
                Current++;
                return (Field[Current]);
            }
            return null;
        }

        public boolean hasNextElement() {
            return (Current < Items - 1);
        }
    }

    public ArrayContainer(int Cap) {
        Field = new Object[Cap];
    }

    public int getMaxCapacity() {
        return Field.length;
    }

    public int getNumberOfElements() {
        return Items;
    }

    public void addElement(Object o) throws MaxCapException {
        if (Items < Field.length) {
            Field[Items] = o;
            Items++;
        } throw new MaxCapException();
    }

    public Iterator getElements() {
        return new ArrayIterator();
    }
}

public class ContMain {
    public static void main(String[] args) {
        ArrayContainer myContainer = new ArrayContainer(2);
        Iterator myIterator;

        myContainer.test();

        myContainer.addElement(new Integer(10));
        myContainer.addElement(new Integer(20));
        myContainer.addElement(new Integer(30));

        System.out.println(myContainer.getNumberOfElements() + " items added:");

        myIterator = myContainer.getElements();
        while (myIterator.hasNextElement())
            System.out.println(myIterator.getNextElement());
    }
}
