/*
 * public class PerfekteZahl
 *
 * Beschreibung:
 *   Programm zur Berechnung und Ausgabe der Perfekten Zahlen von eins bis
 *   1000.
 */
public class PerfekteZahl extends Object{                    // Programmklasse
    // Konstanten
    static final int MAX_NUMBER = 1000;       // Konstante, die die Anzahl der
       // Durchlufe der Hauptschleife festlegt, d.h. wieviele Zahlen getestet
                                                                     // werden

    // Methoden
    /*
     * public static boolean istPerfekt(int Zahl)
     *
     * Parameter:
     *   Zahl - Integervariable, die die auf "Perfektheit" zu testende Zahl
     *          enthlt.
     *
     * Beschreibung:
     *   berprft, ob Zahl Perfekt ist. Leicht Optimierte Version.
     *
     * Rckgabewert:
     *   Liefert true, falls Zahl Perfekte Zahl, andernfalls false.
     */
    public static boolean istPerfekt(int Zahl) {
        int z =   0;      // Deklaration, nimmt die Teilersumme exkl. Zahl auf
        int Inc = (Zahl % 2 == 0) ? 1 : 2;          // Schleifeninkrement (fr
                                                               // Optimierung)

        for(int i = 1; i < Zahl; i += Inc)  // alle Zahlen zw. 1 und Zahl (bei
                                         // Optimierung nur jede 2.) durlaufen
            if (Zahl % i == 0) z += i;     // Wenn Zahl i als Teiler hat, auf-
                                                                  // addieren.
        return(z == Zahl);   // true oder false zurckliefern, je nach dem, ob
                                          // Zahl nun Perfekte Zahl oder nicht
    }

    /*
     * public static void main(java.lang.String[] args)
     *
     * Parameter:
     *   args - Array, das die Kommandozeilenparameter aufnimmt. Wird nicht
     *          benutzt.
     *
     * Beschreibung:
     *   Gibt die Perfekten Zahlen zwischen eins und 1000 auf der Standard-
     *   ausgabe aus.
     *
     * Rckgabewert:
     *   (kein Rckgabewert, void)
     */
    public static void main(String[] args) {       // Programmeinstiegsmethode
        for (int i = 1; i <= MAX_NUMBER; i++)
            if (istPerfekt(i)) System.out.println(i + " ist perfekte Zahl!");
    }
}
