/*
 * class Rational extends Object
 *
 * Beschreibung:
 *   Rational ist eine Klasse, die Bruchrechnung implementiert, ein Feature,
 *   dass in Java (wie auch in vielen anderen Programmiersprachen) nicht in der
 *   Syntax implementiert ist.
 *   Diese Klasse implementiert die vier Grundrechenarten und weitestgehendes
 *   krzen.
 *   Grenzen: Implementationsbedingt sind sowohl die minimal als auch die maxi-
 *   mal darstellbare Zahl dieselben wie beim Typ "int", wenngleich der Werte-
 *   bereich "dichter" ist (es handelt sich schlielich um Brche). Eine Erwei-
 *   terung auf "double"-Wertebereich wre denkbar.
 */
class Rational extends Object {            // neue Klasse, von Object abgeleitet
    // Vordefinierte Konstanten
    static final String DIV_BY_ZERO =             // Fehlermeldung bei Zuweisung
        "Division durch null nicht definiert!";   // einer null an den Zhler

    // Attribute
    private int p, q;         // Attribute, nehmen Zhler (p) und Nenner (q) auf

    // Methoden
    /*
     * public Rational()
     *
     * Parameter:
     *   (keine)
     *
     * Beschreibung:
     *   Konstruktor der Klasse "Rational", initialisiert p mit null und q mit
     *   1, damit der Bruch den Anfangswert null hat (0/0 ist n. def.).
     *
     * Rckgabewert:
     *   (kein Rckgabewert)
     *
     * Exceptions:
     *   (keine)
     */
    public Rational() {               // Konstruktor, initialisiert Bruch
        setFract(0, 1);               // mit dem Wert 0 (Nenner egal, aber != 0)
    }

    /*
     * public Rational()
     *
     * Parameter:
     *   p - Zu setzender Zhler
     *   q - Zu setzender Nenner
     *
     * Beschreibung:
     *   berladener Konstruktor der Klasse "Rational", initialisiert p und q
     *   mit den in den Parametern angegebenen Werten, "wirft"
     *   ArithmeticException, wenn q null ist (x/0 n. def.).
     *
     * Rckgabewert:
     *   (kein Rckgabewert)
     *
     * Exceptions:
     *   ArithmeticException - wird "geworfen", wenn q gleich null, da x/0 nicht
     *                         definiert.
     */
    public Rational(int p, int q) throws ArithmeticException {
        setFract(p, q);                   // Setzt Zhler und Nenner auf p und q
    }

    /*
     * public void setDivdnd(java.lang.int p)
     *
     * Parameter:
     *   p - Zu setzender Zhler
     *
     * Beschreibung:
     *   Reine Zugriffsmethode (ganz im Sinne von OOP).
     *
     * Rckgabewert:
     *   (kein Rckgabewert, void)
     *
     * Exceptions:
     *   (keine)
     */
    public void setDivdnd(int p) {
        this.p = p;                                       // neuen Wert zuweisen
    }

    /*
     * public void setDivsor(java.lang.int q)
     *
     * Parameter:
     *   q - Zu setzender Nenner
     *
     * Beschreibung:
     *   Reine Zugriffsmethode (ganz im Sinne von OOP), "wirft"
     *   ArithmeticException, wenn Parameter null ist.
     *
     * Rckgabewert:
     *   (kein Rckgabewert, void)
     *
     * Exceptions:
     *   ArithmeticException - wird "geworfen", wenn q gleich null, da x/0 nicht
     *                         definiert.
     */
    public void setDivsor(int q) throws ArithmeticException {
        if (q == 0) throw new ArithmeticException(DIV_BY_ZERO);     // Exception
                                                    // werfen, falls Nenner null
        this.q = q;                                 // sonst neuen Wert zuweisen
    }

    /*
     * public void setFract(java.lang.int p, java.lang.int q)
     *
     * Parameter:
     *   p - Zu setzender Zhler
     *   q - Zu setzender Nenner
     *
     * Beschreibung:
     *   Reine Zugriffsmethode (ganz im Sinne von OOP), "wirft"
     *   ArithmeticException, wenn Parameter q null ist.
     *
     * Rckgabewert:
     *   (kein Rckgabewert, void)
     *
     * Exceptions:
     *   ArithmeticException - wird "geworfen", wenn q gleich null, da x/0 nicht
     *                         definiert.
     */
    public void setFract(int p, int q) throws ArithmeticException {
        if (q == 0) throw new ArithmeticException(DIV_BY_ZERO);     // Exception
                                                    // werfen, falls Nenner null
        this.p = p;                                                // sonst neue
        this.q = q;                                            // Werte zuweisen
    }

    /*
     * public int getDivdnd()
     *
     * Parameter:
     *   (keine)
     *
     * Beschreibung:
     *   Reine Zugriffsmethode (ganz im Sinne von OOP).
     *
     * Rckgabewert:
     *   Gibt den Wert des Zhlers (p) zurck.
     *
     * Exceptions:
     *   (keine)
     */
    public int getDivdnd() {
        return p;
    }

    /*
     * public int getDivsor()
     *
     * Parameter:
     *   (keine)
     *
     * Beschreibung:
     *   Reine Zugriffsmethode (ganz im Sinne von OOP).
     *
     * Rckgabewert:
     *   Gibt den Wert des Nenners (q) zurck.
     *
     * Exceptions:
     *   (keine)
     */
    public int getDivsor() {
        return q;
    }

    /*
     * public static Rational add(Rational a, Rational b)
     *
     * Parameter:
     *   a, b - Brche, die addiert werden sollen
     *
     * Beschreibung:
     *   Addiert die beiden Brche a und b durch gleichnamig machen und krzen.
     *
     * Rckgabewert:
     *   Gibt das Ergebnis wiederum als Bruch zurck.
     *
     * Exceptions:
     *   (keine)
     */
    public static Rational add(Rational a, Rational b) {
        Rational r = new Rational(             // neuen Bruch erzeugen, und
            a.getDivdnd() * b.getDivsor() +    // gleich Ergebnis initialisieren
            b.getDivdnd() * a.getDivsor(),
            a.getDivsor() * b.getDivsor()
        );
        r.shorten();                                                   // krzen
        return r;                                       // Ergebnis zurck geben
    }

    /*
     * public static Rational subtract(Rational a, Rational b)
     *
     * Parameter:
     *   a - Minuend
     *   b - Subtrahend
     *
     * Beschreibung:
     *   Subtrahiert den Bruch b von dem Bruch a. Ruft die Methode "add" auf,
     *   da Subtraktion nichts anderes als Addition mit umgekehrten Vorzeichen.
     *
     * Rckgabewert:
     *   Gibt das Ergebnis wiederum als Bruch zurck.
     *
     * Exceptions:
     *   (keine)
     */
    public static Rational subtract(Rational a, Rational b) {
             // Da wir ja nicht die Attribute der Parameter (die ja als Referenz
             // bergeben werden) ndern wollen, wird hier ein neuer Temporrer
             // Bruch erzeugt, der das umgekehrte Vorzeichen von b erhlt.
        return add(a, new Rational(-b.getDivdnd(),   // Subtraktion als Addition
            b.getDivsor()));                   // ausfhren und Wert zurckgeben
    }

    /*
     * public static Rational multiply(Rational a, Rational b)
     *
     * Parameter:
     *   a, b - Brche, die multipliziert werden sollen
     *
     * Beschreibung:
     *   Multipliziert die beiden Brche a und b und krzt.
     *
     * Rckgabewert:
     *   Gibt das Ergebnis wiederum als Bruch zurck.
     *
     * Exceptions:
     *   (ArithmeticException, ungeprft)
     */
    public static Rational multiply(Rational a, Rational b) {
        Rational r = new Rational(a.getDivdnd() * b.getDivdnd(),
            a.getDivsor() * b.getDivsor());                    // Multiplizieren
        r.shorten();                                                   // krzen
        return r;                                       // Ergebnis zurck geben
    }

    /*
     * public static Rational divide(Rational a, Rational b)
     *
     * Parameter:
     *   a - Dividend
     *   b - Divisor
     *
     * Beschreibung:
     *   Dividiert den Bruch a durch den Bruch b und krzt.
     *
     * Rckgabewert:
     *   Gibt das Ergebnis wiederum als Bruch zurck.
     *
     * Exceptions:
     *   (ArithmeticException, ungeprft)
     */
    public static Rational divide(Rational a, Rational b) {
             // Da wir ja nicht die Attribute der Parameter (die ja als Referenz
             // bergeben werden) ndern wollen, wird hier ein neuer Temporrer
             // Bruch erzeugt, der den Kehrbruch von b reprsentiert.
        return multiply(a, new Rational(b.getDivsor(), // Division als Multipli-
            b.getDivdnd()));       // kation ausfhren und Ergebnis zurck geben
    }

    /*
     * public static Rational shorten(Rational a)
     *
     * Parameter:
     *   a - Bruch, der gekrzt werden soll.
     *
     * Beschreibung:
     *   Krzt den Bruch a in ca. round(max(p, q) / 2) Durchlufen (wobei p und
     *   q Attribute von a).
     *
     * Rckgabewert:
     *   Gibt den gekrzten Bruch zurck.
     *
     * Exceptions:
     *   (keine)
     */
    public static Rational shorten(Rational a) {
        int p = a.getDivdnd();  // Zhler und Nenner fr einfachere Manipulation
        int q = a.getDivsor();  // in Integer Variablen

        if (p == q) p = q = 1; else {     // eigentlich trivial, nur wg. Geschw.
                          // Schleife mit ca. round(max(p, q) / 2) Durchlufen,
                          // startet bei 2, da 1 immer Teiler von p und q
            for (int i = Math.max(p, q) / 2; i > 0; i--) {
                if (p % i == 0 && q % i == 0) {  // Wenn p und q durch i teilbar
                    p /= i;                                           // durch i
                    q /= i;                                           // krzen
                }
            }
        }

        return new Rational(p, q);           // und als neuen Bruch zurck geben
    }

    /*
     * public void Rational shorten()
     *
     * Parameter:
     *   (keine)
     *
     * Beschreibung:
     *   Krzt den Bruch durch Aufruf der statischen Mehtode gleichen Namens.
     *
     * Rckgabewert:
     *   (kein Rckgabewert, void)
     *
     * Exceptions:
     *   (keine)
     */
    public void shorten() {
        Rational r = shorten(this);          // temporrer neuer Bruch (gekrzt)
        p = r.getDivdnd();                               // Werte fr Zhler und
        q = r.getDivsor();                               // Nenner zuweisen
    }

    /*
     * public static java.lang.String to_String()
     *
     * Parameter:
     *   a - Bruch, der in eine Zeichenfolge konvertiert werden soll
     *
     * Beschreibung:
     *   Konvertiert den Bruch a in einen String der Form: Zhler/Nenner.
     *
     * Rckgabewert:
     *   Gibt den konvertierten Bruch als String zurck.
     *
     * Exceptions:
     *   (keine)
     */
    public static String to_String(Rational a) {
        return a.getDivdnd() + "/" + a.getDivsor();
    }

    /*
     * public java.lang.String to_String()
     *
     * Parameter:
     *   (keine)
     *
     * Beschreibung:
     *   Konvertiert den Bruch in einen String der Form Zhler/Nenner, durch
     *   Aufruf der statischen Methode gleichen Namens.
     *
     * Rckgabewert:
     *   Gibt den konvertierten Bruch als String zurck.
     *
     * Exceptions:
     *   (keine)
     */
    public String to_String() {
        return to_String(this);                     // statische Methode aufrufen
    }
}

/*
 * class Bruchrechnung extends Object
 *
 * Beschreibung:
 *   Bruchrechnung ist die Hauptklasse um die Programmeinstiegs-Methode main.
 *   Die Bruchrechnung mittels der Klasse Rational wird demonstriert.
 */
public class Bruchrechnung extends Object {// neue Klasse, von Object abgeleitet
    /*
     * public static void main(java.lang.String[] args)
     *
     * Parameter:
     *   args - Array, das die Kommandozeilenparameter aufnimmt. Wird nicht
     *          benutzt.
     *
     * Beschreibung:
     *   Demonstriert die Bruchrechnung mit der Klasse Rational.
     *
     * Rckgabewert:
     *   (kein Rckgabewert, void)
     *
     * Exceptions:
     *   (keine)
     */
    public static void main(String[] args) {
        System.out.println("1/4 - 1/8 = " + // Erste Testaufgabe ausgeben...
            Rational.subtract(              // und gleich mit
                new Rational(1, 4),         // zwei on-the-fly erzeugten Brchen
                new Rational(1, 8)          // ausfhren und als String ausgeben
            ).to_String()
        );

        System.out.println("5/9 * 19/20 = " +           // Zweite Testaufgabe...
            Rational.multiply(
                new Rational(5, 9),
                new Rational(19, 20)
            ).to_String()
        );

        System.out.println("(1/3 + 2/5) / (12/13) = " + // Dritte Testaufgabe...
            Rational.divide(
                Rational.add(
                    new Rational(1, 3),
                    new Rational(2, 5)
                ),
                new Rational(12, 13)
            )
        );
    }
}
