/*
 * class Converter extends Object
 *
 * Beschreibung:
 *   Klasse zum umrechnen metrischer Lngen in englische
 */
class Converter extends Object {           // neue Klasse, von Object abgeleitet
    // vordefinierte Konstanten
    static final double TO_METRIC =     2.54d;    // Faktor englisch -> metrisch
    static final double TO_INCH =   1 / 2.54d;    // Faktor metrisch -> englisch

    // Methoden
    /*
     * public static java.lang.String metric2EnString(java.lang.double cm)
     *
     * Parameter:
     *   cm - Umzurechnende Lnge in Zentimetern.
     *
     * Beschreibung:
     *   Rechnet den bergebenen, metrischen Wert in eine englische Lnge um.
     *
     * Rckgabewert:
     *   Die umgewandelte Lnge als String.
     *   Grenzen: Keinerlei berprfung auf Nulllngen, bei cm == 0 wird ein
     *   leerer String zurckgegeben.
     *
     * Exceptions:
     *   (keine)
     */
    public static String metric2EnString(double cm) {
        double inchLen = cm * TO_INCH;   // Wert in Gesamtlnge (Inch) umwandeln
        int Yards =      (int)(inchLen / 36);                  // Ganze Yards
        int Feet =       (int)(inchLen % 36 / 12);             // Ganze Feet
        float Inches = (float)(inchLen % 36 % 12);             // restliche Inch

          // Der folgende bedingte Ausdruck ergibt einen String der Form
          // x Yard y Foot z Inch. Wenn jedoch eine der Gren x, y, oder z null
          // sein sollte, wird die betreffende Gre ausgelassen. Um das (bei z
          // manchmal auftretende) ".0" wegzulassen, wird noch berprft, ob
          // Inches == (int)Inches.
        return (Yards !=  0 ? Yards + " Yard " : "") +
               (Feet !=   0 ? Feet  + " Foot " : "") +
               (Inches != 0 ? (Inches == (int)Inches ? (int)Inches +
                   " Inch" : Inches + " Inch") : "");
    }

    /*
     * public static java.lang.String en2MetricString(java.lang.int Yards,
     *     java.lang.int Feet, java.lang.double Inches)
     *
     * Parameter:
     *   Yards -  Anzahl ganzer englischer Yards, die in die Lnge hineinpassen
     *   Feet -   Anzahl ganzer "Foot", die in die Lnge - Yards hineinpassen
     *   Inches - Resliche Lnge
     *
     * Beschreibung:
     *   Rechnet die bergebenen, englische Lnge in eine metrische Lnge um.
     *
     * Rckgabewert:
     *   Die umgewandelte Lnge als String.
     *   Grenzen: Keinerlei berprfung auf Nulllngen, bei (Yards == Feet) ==
     *   (Inches == 0) wird ein leerer String zurckgegeben.
     *
     * Exceptions:
     *   (keine)
     */
    public static String en2MetricString(int Yards, int Feet, double Inches) {
        double cmLen = (Yards * 36 + Feet * 12 +         // in metrische Gesamt-
            Inches) * TO_METRIC;                         // lnge umwandeln
        int m =      (int)(cmLen / 100);                 // Ganze Meter
        float cm = (float)(cmLen % 100);                 // restliche Zentimeter

          // Die berlegungen fr den folgenden bedingten Ausdruck gelten analog
          // zu denen in metric2EnString.
        return (m  != 0 ? m +  " m "  : "") +
               (cm != 0 ? (cm == (int)cm ? (int)cm + " cm" : cm + " cm") : "");
    }
}

public class Massumrechnung extends Object {
    /*
     * public static void main(java.lang.String[] args)
     *
     * Parameter:
     *   args - Array, das die Kommandozeilenparameter aufnimmt. Wird nicht
     *          benutzt.
     *
     * Beschreibung:
     *   Demonstriert die Umrechnung metrischer Lngen in englische und
     *   umgekehrt.
     *
     * Rckgabewert:
     *   (kein Rckgabewert, void)
     *
     * Exceptions:
     *   (keine)
     */
    public static void main(String[] args) {
                                     // Hinweis ausgeben, das nun gerechnet wird
        System.out.println("Umrechnung englischer Maeinheiten "+
            "in metrische und umgekehrt:\n");

        System.out.println("100cm =                  " +   // Umrechnen und aus-
            Converter.metric2EnString(100));               // geben
        System.out.println("386,486cm =              " +   // dito
            Converter.metric2EnString(386.486));

        System.out.println("1 Yard 2 Foot 7 Inch =   " +   // s.o.
            Converter.en2MetricString(1, 2, 7));
        System.out.println("13 Yard 1 Foot 11 Inch = " +   // s.o.
            Converter.en2MetricString(13, 1, 11));
    }
}
