// Hilfsklasse, kapselt ein Ganzzahliges Intervall
class Interval {
    // Attribute
    private int lowerLimit;               // untere und obere Intervallgrenzen
    private int upperLimit;

    // Methoden
    // Konstruktor, erzeugt neues Intervall mit den angegebenen Grenzen
    public Interval(int lowerLimit, int upperLimit) {
       this.lowerLimit = lowerLimit;
       this.upperLimit = upperLimit;
    }

    // Vertauscht die Grenzen ohne(!) weitere berprfung
    public void swapBounds() {
        int t = lowerLimit;
        lowerLimit = upperLimit;
        upperLimit = t;
    }

    // Liefert Untergrenze zurck
    public int getLowerLimit() {
        return lowerLimit;
    }

    // Liefert Obergrenze zurck
    public int getUpperLimit() {
        return upperLimit;
    }

    // Wandelt Intervall in String um, wird automatisch aufgerufen, wenn ein
    // Intervall mit einem String verkettet wird.
    public String toString() {
        return ("[" + lowerLimit + ", " + upperLimit + "]");
    }
}

// Klasse zur Lsung der Aufgabe
class Quadrat {
    // Attribute
    private Interval Range;                   // enthlt Ober- und Untergrenze

    // Methoden
    // Konstruktor, erzeugt ein neues Quadrat-Objekt mit angegebenem Intervall
    public Quadrat(Interval Range) {
        this.Range = new Interval(Range.getLowerLimit(), Range.getUpperLimit());
    }

    // Liefert Intervall zurck
    public Interval getInterval() {
        return Range;
    }

    // berprft die Intervallgrenzen und vertauscht falls og < ug
    private void doCheckBounds() {
        if (Range.getUpperLimit() < Range.getLowerLimit()) {
            Range.swapBounds();
            System.out.println("  Hinweis: Intervallobergrenze kleiner " +
                "als Untergrenze,\n           Grenzen wurden vertauscht. " +
                "Betrachte nun " + Range + ": \n");
        }
    }

    // Gibt Zahl ohne berprfung als Qudratzahl aus, wird nur intern aufgerufen
    private void outputSquareNumber(int n) {
        System.out.println("    " + n + " ist eine Quadratzahl!");
    }

    // Gibt die Quadratzahlen N+ im Intervall aus, benutzt "for"-Schleife
    public void berechneMitFor() {
        doCheckBounds();
        System.out.println("  Berechnung mit \"for\"-Schleife:");

        int lowerLimit = Range.getLowerLimit();
        if (lowerLimit <= 0 && Range.getUpperLimit() > 0) lowerLimit = 1;

        for (int i = lowerLimit; i <= Range.getUpperLimit(); i++)
            if (Math.sqrt(i) == (double)((int)Math.sqrt(i)))
                outputSquareNumber(i);

        System.out.println();
    }

    // Gibt die Quadratzahlen N+ im Intervall aus, benutzt "while"-Schleife
    public void berechneMitWhile() {
        doCheckBounds();
        System.out.println("  Berechnung mit \"while\"-Schleife:");

        int i = Range.getLowerLimit();
        if (i <= 0 && Range.getUpperLimit() > 0) i = 1;

        while (i <= Range.getUpperLimit()) {
            if (Math.sqrt(i) == (double)((int)Math.sqrt(i)))
                outputSquareNumber(i);
            i++;
        }

        System.out.println();
    }
}

// Klasse fr Hauptprogramm
public class Quadratzahlen {
    // Methoden
    // Programmeinstiegsmethode, gibt die Quadratzahlen in verschienen
    // Intervallen aus
    public static void main(String[] args) {
        int[][] Bounds = {{1, 25}, {-16, 4}, {9, 3}};

        for (int i = 0; i < Bounds.length; i++) {
            Quadrat myQuadrat = new Quadrat(new Interval(Bounds[i][0],
                Bounds[i][1]));

            System.out.println("Ausgabe der natuerlichen Quadratzahlen im " +
                "Intervall " + myQuadrat.getInterval() + ":\n");

            myQuadrat.berechneMitFor();
            myQuadrat.berechneMitWhile();

            System.out.println();
        }
    }
}


