@echo off
::
::  Limited User Account Tools
::  - A utillity collection for working without administrative privileges
::
::  Copyright (c)2005,2006 Christian Blichmann (luat@blichmann.de)
::
::  This program is free software; you can redistribute it and/or modify
::  it under the terms of the GNU General Public License as published by
::  the Free Software Foundation; either version 2 of the License, or
::  (at your option) any later version.
::
::  This program is distributed in the hope that it will be useful,
::  but WITHOUT ANY WARRANTY; without even the implied warranty of
::  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
::  GNU General Public License for more details.
::
::  You should have received a copy of the GNU General Public License along
::  with this program; if not, write to the Free Software Foundation, Inc.,
::  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
::
setlocal enabledelayedexpansion

:: Set default values for installer script
set PRODUCT=Limited User Account Tools
set PRODUCTSHORT=LUAT
set LICENSE=license.txt
set LICENSEURL=http://www.gnu.org/licenses/gpl.txt
set DEFAULTPATH=%ProgramFiles%\blichmann.de\LUAT

:: Files to copy
set FILES=admin-explorer-background.bmp admin-console.cmd admin-explorer.cmd
set FILES=!FILES! admin-mgmt.cmd admin-network.cmd admin-runas.cmd
set FILES=!FILES! admin-taskmgr.cmd clean.cmd clear.cmd hostname.cmd
set FILES=!FILES! persistpath.cmd license.txt

:: Used variables
:: CONT
:: INSTALLPATH

set WINDOWTITLE=%PRODUCT% batch-file installer 0.6

:displayIntro
title %WINDOWTITLE%
echo ^<^<
echo ^<^<
echo ^<^< %PRODUCT% batch-file installer 0.6
echo ^<^< (c)2005,2006 Christian Blichmann (luat@blichmann.de)
echo ^<^< %PRODUCTSHORT% program comes with ABSOLUTELY NO WARRANTY.
echo ^<^< This is free software, and you are welcome to redistribute it
echo ^<^< under certain conditions; see %LICENSE% for details.

:: Were administrative privileges missing on first run?
if "%1" == "/rerunasadmin" goto :reRunAsAdmin

echo ^<^<
echo ^<^<
echo ^<^< Preparing %PRODUCT% for installation...

:: Determine path of the desktop folder
set DESKTOP=%USERPROFILE%\Desktop
for /f "skip=2 tokens=3,*" %%I in ('reg query "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders" /v Desktop') do (
	set DESKTOP=%%I %%J
)

:displayInstallQuestion
echo ^<^<
echo ^<^<
echo ^<^< Setup
echo ^<^< 
echo ^<^< This will install %PRODUCT% on your computer.
:askInstall
	set CONT=y
	set /p CONT=^>^> Do you want do continue (Yes/No)? [Y] 
	set CONT=%CONT:Y=y%
	set CONT=%CONT:N=n%
	
	if "%CONT%" == "y" goto :exitLoopAskInstall
	if "%CONT%" == "n" goto :quit
goto :askInstall
:exitLoopAskInstall

:displayLicenseQuestion
echo ^<^<
echo ^<^<
echo ^<^< License Agreement
echo ^<^< 
echo ^<^< Please read the License Agreement by pressing enter or typing 'R'.
echo ^<^< Do you accept all the terms of the License Agreement? If you choose No,
echo ^<^< the Installer will close. To install Limited User Account Scripts, you
echo ^<^< must accept this agreement.
:askLicense
	set CONT=r
	set /p CONT=^>^> Do you accept all the terms of the License Agreement (Yes/No/Read)? [R] 
	set CONT=%CONT:Y=y%
	set CONT=%CONT:N=n%
	set CONT=%CONT:R=r%
	
	if "%CONT%" == "y" goto :exitLoopAskLicense
	if "%CONT%" == "n" goto :quit
	if "%CONT%" == "r" (
		if not exist "%~dp0%LICENSE%" (
			echo ^<^< Error: License file not found. Please visit
			echo ^<^<       %LICENSEURL%
			echo ^<^< for licensing information.
		) else (
			more /c "%~dp0%LICENSE%"
		)
		goto :displayLicenseQuestion
	)
goto :askLicense
:exitLoopAskLicense

:: Check for administrative privilege
openfiles > nul 2>&1
if errorlevel == 1 (
	echo ^<^<
	echo ^<^< The system administrator has set policies to prevent this installation.
	echo ^<^< You can however re-run this installer by entering the password of the
	echo ^<^< local administrator.
	goto :askReRunAsAdmin
)
goto :skipAskReRunAsAdmin

:askReRunAsAdmin
	set CONT=y
	set /p CONT=^>^> Do you want to enter the password of the local administrator (Yes/No)? [Y] 
	set CONT=%CONT:Y=y%
	set CONT=%CONT:N=n%
	
	if "%CONT%" == "y" (
		echo.|set /p=^^^>^^^> 
		runas /noprofile /env /user:Administrator "%COMSPEC% /c start /max %~s0 /rerunasadmin"
		
		echo ^<^<
		echo ^<^< Please wait for the installer to finish, then close this window.
		goto :awaitKillLoop
	)
	if "%CONT%" == "n" goto :quit
goto :askReRunAsAdmin

:awaitKillLoop
	pause > nul
goto :awaitKillLoop

:skipAskReRunAsAdmin
:reRunAsAdmin

:displayInstallPathQuestion
echo ^<^<
echo ^<^<
echo ^<^< Select Destination Directory
echo ^<^<
echo ^<^< Type in the folder where you would like %PRODUCT%
echo ^<^< to be installed.
:askInstallPath
	set CONT=%DEFAULTPATH%
	echo ^>^> Where should %PRODUCT% be installed?
	set /p CONT=^>^> [%DEFAULTPATH%] 
	
	if not "%CONT%" == "" (
		:: Strip trailing '\'
		set INSTALLPATH=%CONT%
		if "%CONT:~-1%" == "\" set INSTALLPATH=%CONT:~0,-1%
		
		goto :exitLoopAskInstallPath
	)
goto :askInstallPath
:exitLoopAskInstallPath

if exist "%INSTALLPATH%" (
	echo ^<^<
	echo ^<^< "%INSTALLPATH%" already exists.
	goto :askUseThisPath
)
goto :skipAskUseThisPath

:askUseThisPath
	set CONT=y
	set /p CONT=^>^> Do you want to use this installation path (Yes/No)? [Y] 
	set CONT=%CONT:Y=y%
	set CONT=%CONT:N=n%
	
	if "%CONT%" == "y" goto :exitUseThisPath
	if "%CONT%" == "n" goto :askInstallPath
goto :askUseThisPath
:exitUseThisPath
:skipAskUseThisPath

:install
echo ^<^<
echo ^<^<
echo ^<^< Install %PRODUCT%
echo ^<^<

echo ^<^< Creating directories...
mkdir "%INSTALLPATH%" > nul 2>&1
cd /d "%INSTALLPATH%"

:: Copy files, displaying a dot for each file
echo.|set /p=^^^>^^^> Copying files
for %%I in (%FILES%) do (
	copy /y "%~dp0%%I" > nul 2>&1
	echo.|set /p=.
)
echo.

:: Setup short name for initialization script file
set ISF=%TEMP%\create-admin-shortcuts.vbs

:: Backup any existing files
if exist %ISF% move %ISF% %ISF%.bak > nul

:: Create script file. Note: Must use VBScript, because we cannot properly
:: escape expanded environment strings for JScript.
:: FIXME: Replace with an INF-file based solution
(
echo Set Shell = CreateObject^("WScript.Shell"^)
echo. 
echo ' Create shortcut to Admin Console
echo Set link = Shell.CreateShortcut^("%DESKTOP%\Admin Console.lnk"^)
echo link.Description = "Admin Console"
echo link.IconLocation = "%COMSPEC%,0"
echo link.TargetPath = "%~dp0admin-console.cmd"
echo link.WindowStyle = 2 
echo link.Save^(^)
echo. 
echo ' Create shortcut to Admin Explorer
echo Set link = Shell.CreateShortcut^("%DESKTOP%\Admin Explorer.lnk"^)
echo link.Description = "Admin Explorer"
echo link.IconLocation = "%SystemRoot%\explorer.exe,0"
echo link.TargetPath = "%~dp0admin-explorer.cmd"
echo link.WindowStyle = 2 
echo link.Save^(^)
echo. 
echo ' Create shortcut to Admin Computer Management
echo Set link = Shell.CreateShortcut^("%DESKTOP%\Admin Computer Management.lnk"^)
echo link.Description = "Admin Computer Management"
echo link.IconLocation = "%SystemRoot%\system32\mycomput.dll,2"
echo link.TargetPath = "%~dp0admin-mgmt.cmd"
echo link.WindowStyle = 1 
echo link.Save^(^)
echo. 
echo ' Create shortcut to Admin Explorer
echo Set link = Shell.CreateShortcut^("%DESKTOP%\Admin Task Manager.lnk"^)
echo link.Description = "Admin Task Manager"
echo link.IconLocation = "%SYSTEMROOT%\system32\taskmgr.exe,0"
echo link.TargetPath = "%~dp0admin-taskmgr.cmd"
echo link.WindowStyle = 1 
echo link.Save^(^)
echo. 
echo ' Create shortcut to Admin Network Connections
echo Set link = Shell.CreateShortcut^("%DESKTOP%\Admin Network Connections.lnk"^)
echo link.Description = "Admin Network Connections"
echo link.IconLocation = "%SYSTEMROOT%\system32\netshell.dll,0"
echo link.TargetPath = "%~dp0admin-network.cmd"
echo link.WindowStyle = 1
echo link.Save^(^)
echo.
echo ' Create shortcut to "Run as Administrator" in Send To folder
echo Set link = Shell.CreateShortcut^("%USERPROFILE%\SendTo\Run as Administrator.lnk"^)
echo link.Description = "Run as Administrator"
echo link.IconLocation = "%COMSPEC%,0"
echo link.TargetPath = "%~dp0admin-runas.cmd"
echo link.WindowStyle = 1
echo link.Save^(^)
) >> %ISF%

echo ^<^< Creating desktop shortcuts...
%SystemRoot%\system32\CScript //NoLogo %ISF%

echo.|set /p=^^^>^^^> Installing "Run as Administrator" context menu
for %%I in (batfile cmdfile comfile exefile lnkfile Msi.Package Msi.Patch piffile) do (
	reg add HKCR\%%I\shell\runasadministrator\command /f /t REG_SZ /d "\"%INSTALLPATH%\admin-runas.cmd\" \"%%1\"" > nul
	echo.|set /p=.
)
echo.

echo ^<^< Adding installation folder to system PATH-environment variable...

:: Get current path from registry
set CUR_PATH=%PATH%
for /f "skip=2 tokens=3,*" %%I in ('reg query "HKLM\System\CurrentControlSet\Control\Session Manager\Environment" /v PATH') do (
	set CUR_PATH=%%I %%J
)

:: Strip trailing ';'
if "%CUR_PATH:~-1%" == ";" set CUR_PATH=%CUR_PATH:~0,-1%

set CUR_PATH | find /i "%INSTALLPATH%" > nul
if errorlevel == 1 (
 	reg add "HKLM\System\CurrentControlSet\Control\Session Manager\Environment" /v PATH /d "%CUR_PATH%;%INSTALLPATH%" /f > nul
) else (
	echo ^<^<   Folder was already on system path.
)

echo ^<^< Removing temporary files...
del %ISF%
if exist %ISF%.bak move %ISF%.bak %ISF% > nul

echo ^<^<
echo ^<^<
echo ^<^< Install complete. Visit
echo ^<^<     http://www.blichmann.de/products/luat
echo ^<^< 
echo ^<^< for more information and the most current version.

:quit
echo ^<^< 
echo ^<^< 
echo.|set /p=^^^>^^^> Press any key to close this window. 
pause > nul
echo.

:: Ensure window is closed
if "%1" == "/rerunasadmin" taskkill /fi "WINDOWTITLE eq %WINDOWTITLE%" > nul

:end
endlocal