@echo off
setlocal

if "%1" == "/?" (
	echo Deletes temporary files from various locations.
	echo.
	echo %~n0 [/U] [/S] [/W] [/M]
	echo.
	echo   /U      Cleans user temporary files.
	echo   /S      Deletes system temporary files.
	echo   /W      Removes unnecessary files from the Windows directory.
	echo   /M      Deletes memory dumps from the windows directory, if any.
	goto :eof
)

if "%1" == "" (
	set USR=1
	set SYS=1
	set WIN=1
	set DMP=1
	goto exitLoop0
)


:loop0
if "%1" == "" goto :exitLoop0

if /i "%1" == "/u" (
	set USR=1
) else if /i "%1" == "/s" (
	set SYS=1
) else if /i "%1" == "/w" (
	set WIN=1
) else if /i "%1" == "/m" (
	set DMP=1
) else (
	echo The syntax of the command is incorrect.
	goto :eof
)

shift
goto loop0
:exitLoop0

rem Determine path of the system temporary files folder
set SYSTMP=%SystemDrive%\Temp
for /f "skip=2 tokens=3,*" %%I in ('reg query "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment" /v TEMP') do (
	set SYSTMP=%%I %%J
)

if defined USR (
	echo Cleaning user temporary files ^(%TEMP%^)...
	if "%TEMP%" == "" (
		echo Warning: ^%TEMP^%-variable not set!
	) else (
		del /q /f /s %TEMP%\*.* > nul 2>&1
	)
)

if defined SYS (
	echo Cleaning system temporary files...
	echo   %windir%\Temp ^(Default location^)
	del /q /f /s %windir%\Temp\*.* > nul 2>&1
	
	if exist %SYSTMP% (
		echo   %SYSTMP%
	) else (
		del /q /f /s %SYSTMP%\*.* > nul 2>&1
		echo Warning: %SYSTMP% does not exist!
	)

)

if defined WIN (
	echo Cleaning Windows directory ^(%windir%^)...
	del /q /f %windir%\*.log > nul 2>&1
	del /q /f %windir%\*.txt > nul 2>&1
	del /q /f /s %windir%\*.old > nul 2>&1
	del /q /f /s %windir%\*.tmp > nul 2>&1
)

if defined DMP (
	echo Cleaning memory dumps...
	echo   %windir%\Minidump
	del /q /f %windir%\Minidump\*.dmp > nul 2>&1
	
	echo   %windir%\MEMORY.DMP
	del /q /f %windir%\MEMORY.DMP > nul 2>&1
)

:eof
endlocal