/* Generated by Together */
import java.awt.*;
import java.awt.Graphics.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.io.*;

/**
 * @stereotype entity
 */
public class Brett implements Serializable {
    // Shortcuts auf Farben setzen
    public static final Color BLACK = Color.black;
    public static final Color WHITE = Color.white;
    
    public static final Color RED =    Color.red;
    public static final Color GREEN =  Color.green;
    public static final Color YELLOW = Color.yellow;
    public static final Color BLUE =   Color.blue;
    
    public static final Color[] playerLightColor = {
        new Color(255, 192, 192), // Leichtrot
        new Color(192, 192, 255), // Pastellblau
        new Color(255, 255, 192), // Pissgelb
        new Color(192, 255, 192)  // Gras... gruen (boah, die Farben!)
    };
    
    public Brett(int spieler) {
        anzahlSpieler = spieler;
        if (spieler <= 3) {
            fields = new Feld[17][9];

            // Zeile 0
            fields[ 4][0] = new Feld( 4, 0);
            fields[ 6][0] = new Feld( 6, 0);
            fields[ 8][0] = new Feld( 8, 0);
            fields[10][0] = new Feld(10, 0);
            fields[12][0] = new Feld(12, 0);
            
            // Zeile 1
            fields[ 3][1] = new Feld( 3, 1);
            fields[ 5][1] = new Feld( 5, 1);
            fields[ 7][1] = new Feld( 7, 1);
            fields[ 9][1] = new Feld( 9, 1);
            fields[11][1] = new Feld(11, 1);
            fields[13][1] = new Feld(13, 1);

            // Zeile 2
            fields[ 2][2] = new Feld( 2, 2);
            fields[ 4][2] = new Feld( 4, 2);
            fields[ 6][2] = new Feld( 6, 2);
            fields[ 8][2] = new Feld( 8, 2);
            fields[10][2] = new Feld(10, 2);
            fields[12][2] = new Feld(12, 2);
            fields[14][2] = new Feld(14, 2);

            // Zeile 3
            fields[ 1][3] = new Feld( 1, 3);
            fields[ 3][3] = new Feld( 3, 3);
            fields[ 5][3] = new Feld( 5, 1);
            fields[ 7][3] = new Feld( 7, 3);
            fields[ 9][3] = new Feld( 9, 3);
            fields[11][3] = new Feld(11, 3);
            fields[13][3] = new Feld(13, 3);
            fields[15][3] = new Feld(15, 3);

            // Zeile 4
            fields[ 0][4] = new Feld( 0, 4);
            fields[ 2][4] = new Feld( 2, 4);
            fields[ 4][4] = new Feld( 4, 4);
            fields[ 6][4] = new Feld( 6, 4);
            fields[ 8][4] = new Feld( 8, 4);
            fields[10][4] = new Feld(10, 4);
            fields[12][4] = new Feld(12, 4);
            fields[14][4] = new Feld(14, 4);
            fields[16][4] = new Feld(16, 4);

            // Zeile 5
            fields[ 1][5] = new Feld( 1, 5);
            fields[ 3][5] = new Feld( 3, 5);
            fields[ 5][5] = new Feld( 5, 5);
            fields[ 7][5] = new Feld( 7, 5);
            fields[ 9][5] = new Feld( 9, 5);
            fields[11][5] = new Feld(11, 5);
            fields[13][5] = new Feld(13, 5);
            fields[15][5] = new Feld(15, 5);

            // Zeile 6
            fields[ 2][6] = new Feld( 2, 6);
            fields[ 4][6] = new Feld( 4, 6);
            fields[ 6][6] = new Feld( 6, 6);
            fields[ 8][6] = new Feld( 8, 6);
            fields[10][6] = new Feld(10, 6);
            fields[12][6] = new Feld(12, 6);
            fields[14][6] = new Feld(14, 6);

            // Zeile 7
            fields[ 3][7] = new Feld( 3, 7);
            fields[ 5][7] = new Feld( 5, 7);
            fields[ 7][7] = new Feld( 7, 7);
            fields[ 9][7] = new Feld( 9, 7);
            fields[11][7] = new Feld(11, 7);
            fields[13][7] = new Feld(13, 7);

            // Zeile 8
            fields[ 4][8] = new Feld( 4, 8);
            fields[ 6][8] = new Feld( 6, 8);
            fields[ 8][8] = new Feld( 8, 8);
            fields[10][8] = new Feld(10, 8);
            fields[12][8] = new Feld(12, 8);
        } else {
            fields = new Feld[25][9];

            // Zeile 0
            fields[ 4][0] = new Feld( 4, 0);
            fields[ 6][0] = new Feld( 6, 0);
            fields[ 8][0] = new Feld( 8, 0);
            fields[10][0] = new Feld(10, 0);
            fields[12][0] = new Feld(12, 0);
            fields[14][0] = new Feld(14, 0);
            fields[16][0] = new Feld(16, 0);
            fields[18][0] = new Feld(18, 0);
            fields[20][0] = new Feld(20, 0);

            // Zeile 1
            fields[ 3][1] = new Feld( 3, 1);
            fields[ 5][1] = new Feld( 5, 1);
            fields[ 7][1] = new Feld( 7, 1);
            fields[ 9][1] = new Feld( 9, 1);
            fields[11][1] = new Feld(11, 1);
            fields[13][1] = new Feld(13, 1);
            fields[15][1] = new Feld(15, 1);
            fields[17][1] = new Feld(17, 1);
            fields[19][1] = new Feld(19, 1);
            fields[21][1] = new Feld(21, 1);

            // Zeile 2
            fields[ 2][2] = new Feld( 2, 2);
            fields[ 4][2] = new Feld( 4, 2);
            fields[ 6][2] = new Feld( 6, 2);
            fields[ 8][2] = new Feld( 8, 2);
            fields[10][2] = new Feld(10, 2);
            fields[12][2] = new Feld(12, 2);
            fields[14][2] = new Feld(14, 2);
            fields[16][2] = new Feld(16, 2);
            fields[18][2] = new Feld(18, 2);
            fields[20][2] = new Feld(20, 2);
            fields[22][2] = new Feld(22, 2);

            // Zeile 3
            fields[ 1][3] = new Feld( 1, 3);
            fields[ 3][3] = new Feld( 3, 3);
            fields[ 5][3] = new Feld( 5, 3);
            fields[ 7][3] = new Feld( 7, 3);
            fields[ 9][3] = new Feld( 9, 3);
            fields[11][3] = new Feld(11, 3);
            fields[13][3] = new Feld(13, 3);
            fields[15][3] = new Feld(15, 3);
            fields[17][3] = new Feld(17, 3);
            fields[19][3] = new Feld(19, 3);
            fields[21][3] = new Feld(21, 3);
            fields[23][3] = new Feld(23, 3);

            // Zeile 4
            fields[ 0][4] = new Feld( 0, 4);
            fields[ 2][4] = new Feld( 2, 4);
            fields[ 4][4] = new Feld( 4, 4);
            fields[ 6][4] = new Feld( 6, 4);
            fields[ 8][4] = new Feld( 8, 4);
            fields[10][4] = new Feld(10, 4);
            fields[12][4] = new Feld(12, 4);
            fields[14][4] = new Feld(14, 4);
            fields[16][4] = new Feld(16, 4);
            fields[18][4] = new Feld(18, 4);
            fields[20][4] = new Feld(20, 4);
            fields[22][4] = new Feld(22, 4);
            fields[24][4] = new Feld(24, 4);

            // Zeile 5
            fields[ 1][5] = new Feld( 1, 5);
            fields[ 3][5] = new Feld( 3, 5);
            fields[ 5][5] = new Feld( 5, 5);
            fields[ 7][5] = new Feld( 7, 5);
            fields[ 9][5] = new Feld( 9, 5);
            fields[11][5] = new Feld(11, 5);
            fields[13][5] = new Feld(13, 5);
            fields[15][5] = new Feld(15, 5);
            fields[17][5] = new Feld(17, 5);
            fields[19][5] = new Feld(19, 5);
            fields[21][5] = new Feld(21, 5);
            fields[23][5] = new Feld(23, 5);

            // Zeile 6
            fields[ 2][6] = new Feld( 2, 6);
            fields[ 4][6] = new Feld( 4, 6);
            fields[ 6][6] = new Feld( 6, 6);
            fields[ 8][6] = new Feld( 8, 6);
            fields[10][6] = new Feld(10, 6);
            fields[12][6] = new Feld(12, 6);
            fields[14][6] = new Feld(14, 6);
            fields[16][6] = new Feld(16, 6);
            fields[18][6] = new Feld(18, 6);
            fields[20][6] = new Feld(20, 6);
            fields[22][6] = new Feld(22, 6);

            // Zeile 7
            fields[ 3][7] = new Feld( 3, 7);
            fields[ 5][7] = new Feld( 5, 7);
            fields[ 7][7] = new Feld( 7, 7);
            fields[ 9][7] = new Feld( 9, 7);
            fields[11][7] = new Feld(11, 7);
            fields[13][7] = new Feld(13, 7);
            fields[15][7] = new Feld(15, 7);
            fields[17][7] = new Feld(17, 7);
            fields[19][7] = new Feld(19, 7);
            fields[21][7] = new Feld(21, 7);

            // Zeile 8
            fields[ 4][8] = new Feld( 4, 8);
            fields[ 6][8] = new Feld( 6, 8);
            fields[ 8][8] = new Feld( 8, 8);
            fields[10][8] = new Feld(10, 8);
            fields[12][8] = new Feld(12, 8);
            fields[14][8] = new Feld(14, 8);
            fields[16][8] = new Feld(16, 8);
            fields[18][8] = new Feld(18, 8);
            fields[20][8] = new Feld(20, 8);
        }
 	
        verlinkeFelder();

    }
    
    public void verlinkeFelder() {
        for (int x = 0; x < fields.length; x++)
            for (int y = 0; y < fields[0].length; y++)
                if (fields[x][y] != null) {
                    // Fuer das setzen der Nachbarn mu? ?berpr?ft werden ob das Element im Array existiert (die Koordinate nicht au?erhalb des Array ist) und ob es nicht null ist!
                    if (x + 1 < fields.length && y-1 >= 0                && fields[x + 1][y - 1] != null) fields[x][y].setMyNachbar(fields[x+1][y-1], 0); // rechts oben
                    if (x + 2 < fields.length                            && fields[x + 2][y    ] != null) fields[x][y].setMyNachbar(fields[x+2][y  ], 1); // rechts
                    if (x + 1 < fields.length && y+1 < fields[0].length  && fields[x + 1][y + 1] != null) fields[x][y].setMyNachbar(fields[x+1][y+1], 2); // rechts unten
                    if (x - 1 >= 0 && y+1 < fields[0].length             && fields[x - 1][y + 1] != null) fields[x][y].setMyNachbar(fields[x-1][y+1], 3); // links unten
                    if (x - 2 >= 0                                       && fields[x - 2][y    ] != null) fields[x][y].setMyNachbar(fields[x-2][y  ], 4); // links
                    if (x - 1 >= 0 && y-1 >= 0                           && fields[x - 1][y - 1] != null) fields[x][y].setMyNachbar(fields[x-1][y-1], 5); // links oben
                }
    }
    
    public void setGamePane(GamePane value) { myGamePane = value; }
    
    /**
     * @postcondition Gibt das Feld an der PixelPosition x,y zurueck
     */
    public Feld getFeldAtPos(int x, int y) {
        Feld f;
        int fx = 0;
        int fy = 0;
        
        for (fy = 0; fy < fields[0].length; fy++)
            for (fx = 0; fx < fields.length; fx++) {
                f = fields[fx][fy];
                if (f != null && f.contains(x, y))
                    return f;
            }
        
        return null;
    }
    
    public Feld getFeld(int row, int col) { return fields[row][col]; }
    public void setFeld(Feld feld, int row, int col) { fields[row][col] = feld; }
    
    /**
     * @param g Graphics2D-Objekt, auf das gezeichnet werden soll
     * @param x X-Koordinate des Hexagon-Mittelpunkts
     * @param y Y-Koordinate des Hexagon-Mittelpunkts
     * @param a Kantenlaenge/Radius des Hexagons
     * @param border Rahmenfarbe
     * @param fill Fuellfarbe
     * @return Ein neues Shape-Objekt (fuer Hit-Test)
     */
    protected Shape drawHex(Graphics2D g2, int x, int y, int a, Color border,
        Color fill) {
        
        int ah = a / 2;        // Halbe Kantenlaenge
        int as = a * 87 / 100; // Hoehe vom Mittelpunkt aus (ca. a/2 * sqrt(3))
        
        // Punkte (hard-coded)
        int xPoints[] = {x,     x - as, x - as, x,     x + as, x + as};
        int yPoints[] = {y - a, y - ah, y + ah, y + a, y + ah, y - ah};
        
        // Polygon erzeugen
        Polygon hex = new Polygon(xPoints, yPoints, 6);
        
        // Mit fill fuellen
        if (fill != null) {
            g2.setPaint(fill);
            g2.fill(hex);
        }
        
        // Umrisse zeichnen in border
        g2.setPaint(border);
        g2.draw(hex);
        
        return hex; // Shape-Objekt zurueck
    }
    
    protected void drawScaledBoard(Graphics2D g2, Dimension canvasSize,
        Dimension margins, Dimension fieldSize) {
        // Effektiv verfuegbare Breite und Hoehe ermitteln
        int w = canvasSize.width -  margins.width *  2;
        int h = canvasSize.height - margins.height * 2;
        
        // Kantenlaenge in Bezug auf Breite und Hoehe bestimmen
        int ax = (int) ( w / (0.866 * (fieldSize.width - 1) + 0.433) );
        int ay = (int) ( h / (1.5 * fieldSize.height + 0.25) );
        
        // F?r Zentrierung
        int xa = ax < ay ? 0 : (int) (
            (w - ay * (0.866 * (fieldSize.width - 1) + 0.433)) * 0.5
        );
        int ya = ay < ax ? 0 : (int) (
            (h - ax * (1.5 * fieldSize.height + 0.25)) * 0.5
        );

        // Kleinere Kantenlaenge waehlen und neue Parameter fuer Hexes
        // ausrechnen
        int a = ax < ay ? ax : ay;
        ax = (int) (a * 0.866);
        ay = a;
		
        // Offset (nuetzlich fuer ungerade Zeilenanzahl)
        int ox, fx;
        Feld f;
        Figur s;
        
        for (int y = 0; y < fieldSize.height; y++) {
            // Offset fuer gerade/ungerade Zeilen
            if (y % 2 == 0) {
                ox = 0;
                fx = 0;
            } else {
                ox = ax;
                fx = 1;
            }

            int x = 0;
            int px, py;
            Color c;
            Spieler pl;
            do {
                if ((f = fields[x + fx][y]) != null) {
                    f.setShape(drawHex(g2,
                        px = xa +        margins.width +  ax +       x * ax + ox,
                        py = ya + (int) (margins.height + ay + 1.5 * y * ay), a,
                        BLACK, f.getFillColor()));
                    
                    if ((pl = f.getMyZiel()) != null) {
                        c = playerLightColor[pl.getMySpielerNummer()];
                        drawHex(g2, px, py, a - 2, c, null);
                        drawHex(g2, px, py, a - 3, c, null);
                        drawHex(g2, px, py, a - 4, c, null);
                    }
                    
                    if ((s = f.getMyFigur()) != null) {
                        pl = s.getMySpieler();
                        
                        if (pl == null) break;
                        Image img = myGamePane.getStoneImage(
                            pl.getMySpielerNummer(), s.getMyTyp());

                        if (img == null) break;
                        g2.drawImage(img, px - 26, py - 26, myGamePane);
                    }
                }
                x += 2;
            } while (x + fx < fieldSize.width);
        }
    }
    
    public void paintTo(Graphics2D g2, Dimension size, Dimension margins) {
        drawScaledBoard(g2, size, margins, new Dimension(fields.length,
            fields[0].length));
    }
    
    public void setzeStartPositionen(Spieler[] mySpieler) {
       int anz = mySpieler.length;
        Figur[] myFiguren;
        switch (anz) {
            // zwei Spieler Aufstellung
            case 2: { 
                myFiguren = mySpieler[0].getMyFiguren();
                ersterSpieler = mySpieler[0]; {
                    // Start Felder erster Spieler
                    fields[ 2][2].setMyFigur(myFiguren[0]);
                    fields[ 1][3].setMyFigur(myFiguren[1]);
                    fields[ 0][4].setMyFigur(myFiguren[2]);
                    fields[ 2][4].setMyFigur(myFiguren[3]);
                    fields[ 1][5].setMyFigur(myFiguren[4]);
                    fields[ 2][6].setMyFigur(myFiguren[5]);
                        //jetzt muessen die Figuren ja auch wissen wo sie stehen ;-)
                        myFiguren[0].setMyFeld(fields[ 2][2]);
                        myFiguren[1].setMyFeld(fields[ 1][3]);
                        myFiguren[2].setMyFeld(fields[ 0][4]);
                        myFiguren[3].setMyFeld(fields[ 2][4]);
                        myFiguren[4].setMyFeld(fields[ 1][5]);
                        myFiguren[5].setMyFeld(fields[ 2][6]);
                    // Zielfelder erster Spieler
                    fields[14][2].setMyZiel(mySpieler[0]);
                    fields[16][4].setMyZiel(mySpieler[0]);
                    fields[14][6].setMyZiel(mySpieler[0]);
                }
                myFiguren = mySpieler[1].getMyFiguren();
                zweiterSpieler = mySpieler[1];{
                    // Startfelder zweiter Spieler
                    fields[14][2].setMyFigur(myFiguren[0]);
                    fields[15][3].setMyFigur(myFiguren[1]);
                    fields[14][4].setMyFigur(myFiguren[2]);
                    fields[16][4].setMyFigur(myFiguren[3]);
                    fields[15][5].setMyFigur(myFiguren[4]);
                    fields[14][6].setMyFigur(myFiguren[5]);
                        //jetzt muessen die Figuren ja auch wissen wo sie stehen ;-)
                        myFiguren[0].setMyFeld(fields[14][2]);
                        myFiguren[1].setMyFeld(fields[15][3]);
                        myFiguren[2].setMyFeld(fields[14][4]);
                        myFiguren[3].setMyFeld(fields[16][4]);
                        myFiguren[4].setMyFeld(fields[15][5]);
                        myFiguren[5].setMyFeld(fields[14][6]);
                    // Zielfelder zweiter Spieler
                    fields[ 2][2].setMyZiel(mySpieler[1]);
                    fields[ 0][4].setMyZiel(mySpieler[1]);
                    fields[ 2][6].setMyZiel(mySpieler[1]);
                }
                break;
            }
            //drei Spieler Aufstellung
            case 3: {
                myFiguren = mySpieler[0].getMyFiguren();
                ersterSpieler = mySpieler[0]; {
                    // Start Felder erster Spieler
                    fields[ 4][0].setMyFigur(myFiguren[0]);
                    fields[ 6][0].setMyFigur(myFiguren[1]);
                    fields[ 8][0].setMyFigur(myFiguren[2]);
                    fields[ 3][1].setMyFigur(myFiguren[3]);
                    fields[ 5][1].setMyFigur(myFiguren[4]);
                    fields[ 2][2].setMyFigur(myFiguren[5]);
                        //jetzt muessen die Figuren ja auch wissen wo sie stehen ;-)
                        myFiguren[0].setMyFeld(fields[ 4][0]);
                        myFiguren[1].setMyFeld(fields[ 6][0]);
                        myFiguren[2].setMyFeld(fields[ 8][0]);
                        myFiguren[3].setMyFeld(fields[ 3][1]);
                        myFiguren[4].setMyFeld(fields[ 5][1]);
                        myFiguren[5].setMyFeld(fields[ 2][2]);
                    // Zielfelder erster Spieler
                    fields[14][6].setMyZiel(mySpieler[0]);
                    fields[12][8].setMyZiel(mySpieler[0]);
                    fields[ 8][8].setMyZiel(mySpieler[0]);
                }
                myFiguren = mySpieler[1].getMyFiguren();
                zweiterSpieler = mySpieler[1]; {
                    // Start Felder zweiter Spieler
                    fields[14][2].setMyFigur(myFiguren[0]);
                    fields[15][3].setMyFigur(myFiguren[1]);
                    fields[14][4].setMyFigur(myFiguren[2]);
                    fields[16][4].setMyFigur(myFiguren[3]);
                    fields[15][5].setMyFigur(myFiguren[4]);
                    fields[14][6].setMyFigur(myFiguren[5]);
                        //jetzt muessen die Figuren ja auch wissen wo sie stehen ;-)
                        myFiguren[0].setMyFeld(fields[14][2]);
                        myFiguren[1].setMyFeld(fields[15][3]);
                        myFiguren[2].setMyFeld(fields[14][4]);
                        myFiguren[3].setMyFeld(fields[16][4]);
                        myFiguren[4].setMyFeld(fields[15][5]);
                        myFiguren[5].setMyFeld(fields[14][6]);
                    // Zielfelder zweiter Spieler
                    fields[2][2].setMyZiel(mySpieler[1]);
                    fields[0][4].setMyZiel(mySpieler[1]);
                    fields[2][6].setMyZiel(mySpieler[1]);
                }
                myFiguren = mySpieler[2].getMyFiguren();
                dritterSpieler = mySpieler[2]; {
                    // Start Felder dritter Spieler
                    fields[ 2][6].setMyFigur(myFiguren[0]);
                    fields[ 3][7].setMyFigur(myFiguren[1]);
                    fields[ 5][7].setMyFigur(myFiguren[2]);
                    fields[ 4][8].setMyFigur(myFiguren[3]);
                    fields[ 6][8].setMyFigur(myFiguren[4]);
                    fields[ 8][8].setMyFigur(myFiguren[5]);
                        //jetzt muessen die Figuren ja auch wissen wo sie stehen ;-)
                        myFiguren[0].setMyFeld(fields[ 2][6]);
                        myFiguren[1].setMyFeld(fields[ 3][7]);
                        myFiguren[2].setMyFeld(fields[ 5][7]);
                        myFiguren[3].setMyFeld(fields[ 4][8]);
                        myFiguren[4].setMyFeld(fields[ 6][8]);
                        myFiguren[5].setMyFeld(fields[ 8][8]);
                    // Zielfelder dritter Spieler
                    fields[ 8][0].setMyZiel(mySpieler[2]);
                    fields[12][0].setMyZiel(mySpieler[2]);
                    fields[14][2].setMyZiel(mySpieler[2]);
                }
                break;
            }
            //vier Spieler Aufstellung
            case 4: {
                myFiguren = mySpieler[0].getMyFiguren();
                ersterSpieler = mySpieler[0]; {
                    // Start Felder erster Spieler
                    fields[ 4][0].setMyFigur(myFiguren[0]);
                    fields[ 6][0].setMyFigur(myFiguren[1]);
                    fields[ 8][0].setMyFigur(myFiguren[2]);
                    fields[ 3][1].setMyFigur(myFiguren[3]);
                    fields[ 5][1].setMyFigur(myFiguren[4]);
                    fields[ 2][2].setMyFigur(myFiguren[5]);
                        //jetzt muessen die Figuren ja auch wissen wo sie stehen ;-)
                        myFiguren[0].setMyFeld(fields[ 4][0]);
                        myFiguren[1].setMyFeld(fields[ 6][0]);
                        myFiguren[2].setMyFeld(fields[ 8][0]);
                        myFiguren[3].setMyFeld(fields[ 3][1]);
                        myFiguren[4].setMyFeld(fields[ 5][1]);
                        myFiguren[5].setMyFeld(fields[ 2][2]);
                    // Zielfelder erster Spieler
                    fields[16][8].setMyZiel(mySpieler[0]);
                    fields[20][8].setMyZiel(mySpieler[0]);
                    fields[22][6].setMyZiel(mySpieler[0]);
                }
                myFiguren = mySpieler[1].getMyFiguren();
                zweiterSpieler = mySpieler[1]; {
                    // Start Felder zweiter Spieler
                    fields[16][0].setMyFigur(myFiguren[0]);
                    fields[18][0].setMyFigur(myFiguren[1]);
                    fields[20][0].setMyFigur(myFiguren[2]);
                    fields[19][1].setMyFigur(myFiguren[3]);
                    fields[21][1].setMyFigur(myFiguren[4]);
                    fields[22][2].setMyFigur(myFiguren[5]);
                        //jetzt muessen die Figuren ja auch wissen wo sie stehen ;-)
                        myFiguren[0].setMyFeld(fields[16][0]);
                        myFiguren[1].setMyFeld(fields[18][0]);
                        myFiguren[2].setMyFeld(fields[20][0]);
                        myFiguren[3].setMyFeld(fields[19][1]);
                        myFiguren[4].setMyFeld(fields[21][1]);
                        myFiguren[5].setMyFeld(fields[22][2]);
                    // Zielfelder zweiter Spieler
                    fields[2][6].setMyZiel(mySpieler[1]);
                    fields[4][8].setMyZiel(mySpieler[1]);
                    fields[8][8].setMyZiel(mySpieler[1]);
                }
                myFiguren = mySpieler[2].getMyFiguren();
                vierterSpieler = mySpieler[2]; {
                    // Start Felder dritter Spieler
                    fields[ 2][6].setMyFigur(myFiguren[0]);
                    fields[ 3][7].setMyFigur(myFiguren[1]);
                    fields[ 5][7].setMyFigur(myFiguren[2]);
                    fields[ 4][8].setMyFigur(myFiguren[3]);
                    fields[ 6][8].setMyFigur(myFiguren[4]);
                    fields[ 8][8].setMyFigur(myFiguren[5]);
                        //jetzt muessen die Figuren ja auch wissen wo sie stehen ;-)
                        myFiguren[0].setMyFeld(fields[ 2][6]);
                        myFiguren[1].setMyFeld(fields[ 3][7]);
                        myFiguren[2].setMyFeld(fields[ 5][7]);
                        myFiguren[3].setMyFeld(fields[ 4][8]);
                        myFiguren[4].setMyFeld(fields[ 6][8]);
                        myFiguren[5].setMyFeld(fields[ 8][8]);
                    // Zielfelder dritter Spieler
                    fields[16][0].setMyZiel(mySpieler[3]);
                    fields[20][0].setMyZiel(mySpieler[3]);
                    fields[22][2].setMyZiel(mySpieler[3]);
                }
                myFiguren = mySpieler[3].getMyFiguren();
                dritterSpieler = mySpieler[3]; {
                    // Start Felder vierter Spieler
                    fields[22][6].setMyFigur(myFiguren[0]);
                    fields[19][7].setMyFigur(myFiguren[1]);
                    fields[21][7].setMyFigur(myFiguren[2]);
                    fields[16][8].setMyFigur(myFiguren[3]);
                    fields[18][8].setMyFigur(myFiguren[4]);
                    fields[20][8].setMyFigur(myFiguren[5]);
                        //jetzt muessen die Figuren ja auch wissen wo sie stehen ;-)
                        myFiguren[0].setMyFeld(fields[22][6]);
                        myFiguren[1].setMyFeld(fields[19][7]);
                        myFiguren[2].setMyFeld(fields[21][7]);
                        myFiguren[3].setMyFeld(fields[16][8]);
                        myFiguren[4].setMyFeld(fields[18][8]);
                        myFiguren[5].setMyFeld(fields[20][8]);
                    // Zielfelder vierter Spieler
                    fields[ 4][0].setMyZiel(mySpieler[2]);
                    fields[ 8][0].setMyZiel(mySpieler[2]);
                    fields[ 2][2].setMyZiel(mySpieler[2]);
                }
                
                break;
            }
        }
    }
    
    /**
     * Gibt die Zielfelder der Spieler zurueck, sollte ein leeres Array zurueckgegeben werden ist etwas schief gelaufen.
     */
    public Feld[] getZielfelder(Spieler myPlayer){
            Feld[] tmpFeld = new Feld[3];
            switch (anzahlSpieler) {
            // zwei Spieler Aufstellung
            case 2: { 
                if(ersterSpieler == myPlayer){
                    // Zielfelder erster Spieler
                    tmpFeld[0] = fields[14][2];
                    tmpFeld[1] = fields[16][4];
                    tmpFeld[2] = fields[14][6];
                }
                if(zweiterSpieler == myPlayer){
                    // Zielfelder zweiter Spieler
                    tmpFeld[0] = fields[ 2][2];
                    tmpFeld[1] = fields[ 0][4];
                    tmpFeld[2] = fields[ 2][6];
                }
                break;
            }
            //drei Spieler Aufstellung
            case 3: {
                if(ersterSpieler == myPlayer){
                    // Zielfelder erster Spieler
                    tmpFeld[0] = fields[14][2];
                    tmpFeld[1] = fields[16][4];
                    tmpFeld[2] = fields[14][6];
                }
                if(zweiterSpieler == myPlayer){
                    // Zielfelder zweiter Spieler
                    tmpFeld[0] = fields[4][0];
                    tmpFeld[1] = fields[8][0];
                    tmpFeld[2] = fields[2][2];
                }
                if(dritterSpieler == myPlayer){
                    // Zielfelder dritter Spieler
                    tmpFeld[0] = fields[2][6];
                    tmpFeld[1] = fields[4][8];
                    tmpFeld[2] = fields[8][8];
                }
                break;
            }
            //vier Spieler Aufstellung
            case 4: {
                if(ersterSpieler == myPlayer){
                    // Zielfelder erster Spieler
                    tmpFeld[0] = fields[16][8];
                    tmpFeld[1] = fields[20][8];
                    tmpFeld[2] = fields[22][6];
                }
                if(zweiterSpieler == myPlayer){
                    // Zielfelder zweiter Spieler
                    tmpFeld[0] = fields[2][6];
                    tmpFeld[1] = fields[4][8];
                    tmpFeld[2] = fields[8][8];
                }
                if(dritterSpieler == myPlayer){
                    // Zielfelder dritter Spieler
                    tmpFeld[0] = fields[ 4][0];
                    tmpFeld[1] = fields[ 8][0];
                    tmpFeld[2] = fields[ 2][2];
                }
                if(vierterSpieler == myPlayer){
                    // Zielfelder vierter Spieler
                    tmpFeld[0] = fields[16][0];
                    tmpFeld[1] = fields[20][0];
                    tmpFeld[2] = fields[22][2];
                }
                break;
            }
         }
         return tmpFeld;        
    }
    
    // merkt sich welcher Spieler welche Zielposition zugeordnet wurde: siehe auch getZielfelder()
    private Spieler ersterSpieler;
    private Spieler zweiterSpieler;
    private Spieler dritterSpieler;
    private Spieler vierterSpieler;
    private int anzahlSpieler;

    private Feld[][] fields;
    private Feld lnkFeld;
    private GamePane myGamePane;
}
