/* Generated by Together */
import java.io.*;

/**
 * @stereotype control 
 */
public class Engine implements Serializable {
    public Engine(Spiel mySpiel) {
        this.mySpiel = mySpiel;
    }

    public Spiel getMySpiel(){
            return mySpiel;
        }

    public void setMySpiel(Spiel mySpiel){
            this.mySpiel = mySpiel;
        }

    public void setMyKI(KI myKI){
            this.myKI = myKI;
        }

    /**
     * @postconditions bestimmt die fuer eine Figur moeglichen Spielzuege und gibt ein array moeglicher Zuege zurueck. (Methode ist fuer KI gedacht) 
     */
    public Feld[] bestimmeSpielzuege(Figur figur) {
        if (figur == null) return null;
        
        Feld[] tmpFeldArray;
        Feld[] returnFeldArray = new Feld[6];
        tmpFeldArray = (Feld[]) ((figur.getMyFeld()).getMyNachbarn()).clone();
        // wir muessen Alle 6 Felder abchecken ob ein Zug auf Sie erlaubt ist.
        for(int i=0; i<6;i++){
            
            int iWenigerEins;
            if(i==0) iWenigerEins = 5;
            else iWenigerEins = i-1;
            int iPlusEins;
            if(i==5) iPlusEins = 0;
            else iPlusEins = i+1;
            
            // Existiert das Feld ?berhaupt?
            if(tmpFeldArray[i] != null){
                //Falls Feld +-1 in Zugrichtung liegt und keine Figur drauf ist - Feld als gueltig makieren
                if((tmpFeldArray[i].getMyFigur() == null) && ((i == (figur.getMySpieler()).getMyZugrichtung()) || (iWenigerEins ==(figur.getMySpieler()).getMyZugrichtung()) || (iPlusEins ==(figur.getMySpieler()).getMyZugrichtung()))){
                    returnFeldArray[i] = tmpFeldArray[i];
                }
                //hier wird ueberprueft ob ich etwaige vorhandene Figuren schlagen darf
                if ((tmpFeldArray[i].getMyFigur() != null) && ((((tmpFeldArray[i].getMyFigur()).getMySpieler()).equals(figur.getMySpieler())) != true)){
                    if((figur.getMyTyp() == figur.WASSERKRUG) && ((tmpFeldArray[i].getMyFigur()).getMyTyp() == figur.FEUER)) returnFeldArray[i] = tmpFeldArray[i];
                    if((figur.getMyTyp( )== figur.FEUER)      && ((tmpFeldArray[i].getMyFigur()).getMyTyp() == figur.KNUEPPEL)) returnFeldArray[i] = tmpFeldArray[i];
                    if((figur.getMyTyp() == figur.KNUEPPEL)   && ((tmpFeldArray[i].getMyFigur()).getMyTyp() == figur.WASSERKRUG)) returnFeldArray[i] = tmpFeldArray[i];
                }
            }
        }
        return returnFeldArray;
    }

    /**
     * @postconditions fuehrt einen Spielzug durch und setzt die Figur auf das neue feld 
     */
    public void spielzugDurchfuehren(Figur figur, Feld zielFeld) {
        if (zielFeld == null || figur == null) return;

        Feld[] tmpFeld;
        tmpFeld = bestimmeSpielzuege(figur);
        for (int i = 0; i < tmpFeld.length; i++) {
            if(tmpFeld[i] == zielFeld) break;
            if(i == tmpFeld.length-1 && tmpFeld[tmpFeld.length-1] == null) return;
        }

        // is da schon Wer? Wenn ja dem sein Zeiger auf das Feld killen :-)
        if (zielFeld.getMyFigur() != null)
            zielFeld.getMyFigur().setMyFeld(null);

        // nu koennen wir uns auf diesem Feld breit machen :-)
        figur.getMyFeld().setMyFigur(null); // altes feld loeschen
        zielFeld.setMyFigur(figur); // auf neues Feld setzen
        figur.setMyFeld(zielFeld); // Figur Referenz aktualisieren
    }

    /**
     * Fuehrt einen Kompletten Spielzug von der KI aus.
     * gibt true zurueck wenn die KI dabei eines ihrer Zielfelder erreicht. 
     */
    public boolean spielzugKI(Spieler kiSpieler) {
        Feld tmpFeld = (new KI(kiSpieler, this)).macheZug();
        System.out.println("        cpu moves to: " + tmpFeld);
        if(tmpFeld != null && tmpFeld.getMyZiel() == kiSpieler) return true;
        return false;
    }

    /**
     * @undirected
     * @supplierCardinality 1
     * @clientCardinality 1*/
    private Spiel mySpiel;

    /**
     * @clientCardinality 1
     * @supplierCardinality 1 
     * @undirected
     */
    private KI myKI;
}
