/* Generated by Together */
import java.awt.*;
import java.io.*;

/**
 * @stereotype entity 
 */
public class Feld implements Serializable {
    public Feld(int row, int col) {
        myPosition.move(row, col);
    }

    public Feld[] getMyNachbarn() { return myNeighbor; }
    public void setMyNachbarn(Feld[] value) { myNeighbor = value; }

    public Feld getMyNachbar(int index) { return myNeighbor[index]; }
    public void setMyNachbar(Feld value, int index) { myNeighbor[index] = value; }

    public Figur getMyFigur() { return myFigure; }
    public void setMyFigur(Figur value) {
        myFigure = value;
        if (value != null)
            myFigure.setMyFeld(this);
    }

    public Spieler getMyZiel() { return myFinish; }
    public void setMyZiel(Spieler value) { myFinish = value; }

    public Point getMyPosition() { return myPosition; }
    public void setMyPosition(java.awt.Point value) { myPosition = value; }

    public Point getPixelPosition() { return myPixelPosition; }
    public void setPixelPosition(java.awt.Point value) { myPixelPosition = value; }

    public double getMyDistanz(int index) { return myDistance[index]; }
    public void setMyDistanz(double value, int index) { myDistance[index] = value; }
    
    public Shape getShape() { return myShape; }
    public void setShape(Shape value) { myShape = value; }
    
    public void deselect() {
        Feld t;
        myFillColor = Brett.WHITE;
        myMarked = false;
        for (int i = 0; i < 6; i++)
            if ((t = myNeighbor[i]) != null) {
                t.setFillColor(Brett.WHITE);
                t.setMarked(false);
            }
    }
    
    public Color getFillColor() { return myFillColor; }
    public void setFillColor(Color value) { myFillColor = value; }
    
    public boolean isMarked() { return myMarked; }
    public void setMarked(boolean value) { myMarked = value; }
    
    public boolean contains(int x, int y) { return myShape.contains(x, y); }

    /**
     * @clientCardinality 1
     * @supplierCardinality 2..6 
     */
    private Feld[] myNeighbor = new Feld[6];
    private Color myFillColor = Brett.WHITE;

    /**
     * @undirected 
     */
    private Figur myFigure;
    private Spieler myFinish;
    private Point myPosition = new Point();
    private Point myPixelPosition = new Point();
    private double[] myDistance = new double[4];
    private Shape myShape;
    private boolean myMarked = false;
}