/*
 * Main.java
 *
 * Created on March 13, 2002, 2:52 PM
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.Graphics.*;
import java.awt.Graphics2D.*;
import java.awt.Toolkit.*;
import javax.swing.*;

/**
 *
 * @author Christian Blichmann
 */
public class FullscreenTest extends JFrame {
    private Brett myBoard;
    
    /** Creates new Main */
    public FullscreenTest() {
        super();
        
        GraphicsDevice dev = GraphicsEnvironment.
            getLocalGraphicsEnvironment().getDefaultScreenDevice();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        
        setLocation(50, 50);
        dim.setSize(dim.getWidth() - 100, dim.getHeight() - 100);
        setSize(dim);

        setTitle("Feuer und Wasser");
        setUndecorated(false);
        
        myBoard = new Brett(2);
    }
    
    /**
     * @param g Ein Graphics-Objekt, um in das Fenster zu zeichnen
     */
    public void paint(Graphics g) {
        myBoard.paintTo((Graphics2D) g, getSize(), new Dimension(50, 50));
    }
    
    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        FullscreenTest f = new FullscreenTest();
        f.show();
    }
}
