/*
 * GamePane.java
 *
 * Created on March 20, 2002, 6:30 PM
 */


import java.awt.*;
import java.awt.event.*;
import java.awt.font.*;
import java.awt.geom.*;
import java.awt.Graphics.*;
import java.awt.Graphics2D.*;
import java.awt.image.*;
import javax.swing.*;

/**
 *
 * @author  sopr157
 */
public class GamePane extends JPanel {
    
    private int gameScreen = wizWar.TITLESCREEN;
    private Spiel game;
    private Image[] screenImages;
    private Image[] stoneImages;
    private MediaTracker mediaTracker;
    private IOControl myIOCtl;
    private Notifyable myNot;

    /** Creates new GamePane */
    public GamePane(Image[] screenImgs, Image[] stoneImgs) {
        super();
        
        screenImages = new Image[screenImgs.length];
        System.arraycopy(screenImgs, 0, screenImages, 0, screenImgs.length);
        
        stoneImages = new Image[stoneImgs.length];
        System.arraycopy(stoneImgs, 0, stoneImages, 0, stoneImgs.length);
        
        addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent evt) {
                handleMouseClicked(evt);
            }
        });
        
        repaint();
    }
    
    public int getScreen() { return gameScreen; }
    public void setScreen(int value) {
        if (value < 0 || value > 2) return;
        
        gameScreen = value;
        repaint();
    }
    
    public Image getStoneImage(int player, int index) {
        //System.out.println(player * 3 + index + " " + player + " " + index);
        
        if (player < 0 || player > 3 || index < 0 || index > 3) return null;
        
        return stoneImages[player * 3 + index];
    }
    
    public Spiel getGame() { return game; }
    public void setGame(Spiel value) {
        if (value == null) return;
        
        game = value;
        game.getMySpielBrett().setGamePane(this);
    }
    
    public Brett getBoard() { return game.getMySpielBrett(); }
    public void setBoard(Brett value) {
        if (value == null) return;
        
        game.setMySpielBrett(value);
        value.setGamePane(this);
    }
    
    public void setIOControl(IOControl ioCtl) { myIOCtl = ioCtl; }
    public void setNotifyable(Notifyable n) { myNot = n; }
    
    private Feld oldField = null; // Merkt sich das zuletzt markierte Feld
    private int clickMode = 0;    // Zeigt an, in welchem Modus wir uns befinden
    
    public void handleMouseClicked(MouseEvent evt) {
        // Abbrechen bei nicht sinnvoller Situation
        if (evt == null || game == null) return;
        
        // Mauskoordinaten aus MouseEvent holen
        int x = evt.getX();
        int y = evt.getY();
        
        // Angeklicktes Feld holen, wenn null -> raus
        Feld fld;
        if ((fld = getBoard().getFeldAtPos(x, y)) == null) return;
        
        if (clickMode == 0) {
            // Farben vom Brett loeschen
            if (oldField != null)
                oldField.deselect();
            oldField = fld;

            // Steht eine Figur auf dem Feld? Nein? -> raus
            Figur fig;
            if ((fig = fld.getMyFigur()) == null) return;

            // Figur vom anderen Spieler? -> Piepsen und raus
            Spieler cpl;
            if (fig.getMySpieler() != (cpl = game.getAktSpieler())) {
                oldField = null;
                getToolkit().beep();
                return;
            }

            // Moegliche Spielzuege ermitteln...
            Feld[] flds;
            if ((flds = game.figurAuswahl(fld.getMyFigur())) == null) return;

            // ...und einfaerben in passender Pastellfarbe (uuhh)
            Color c = Brett.playerLightColor[cpl.getMySpielerNummer()];

            for (int i = 0; i < 6; i++)
                if (flds[i] != null) {
                    flds[i].setFillColor(c);
                    flds[i].setMarked(true);
                }
            
            clickMode = 1;
            repaint(); // Und Brett aktualisieren
        } else
        if (clickMode == 1) {
            if (!fld.isMarked()) {
                if (fld.getMyFigur() != null && fld.getMyFigur().getMySpieler()
                    == game.getAktSpieler()) {
                    clickMode = 0;
                    handleMouseClicked(evt);
                }
                return;
            }
            
            fld.deselect();
            clickMode = 0;

            repaint(); // Und Brett aktualisieren
            if (game.spielzugDurchfuehren(fld) != null) {
                System.out.println("round " + game.getMySatz() + " won by player \"" +
                    game.getAktSpieler().getMyName() + "\"!");
                
                myNot.notifyMe();
            }
            
            // myIOCtl.putInUndo(game);
        }
    }
    
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D) g;

        switch (gameScreen) {
            case wizWar.TITLESCREEN:
                g2.drawImage(screenImages[wizWar.TITLESCREEN], 0, 0, this);
                break;
            case wizWar.PAUSESCREEN:
                g2.drawImage(screenImages[wizWar.PAUSESCREEN], 0, 0, this);
                break;
            case wizWar.GAMESCREEN:
                int w = getSize().width;
                int h = getSize().height;
                
                //AlphaComposite ac = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.8f);

                //BufferedImage buffImg = new BufferedImage(getSize().width, getSize().height, BufferedImage.TYPE_INT_ARGB);
                Graphics2D gbi = g2;/*g2;//*///buffImg.createGraphics();

                g2.drawImage(screenImages[wizWar.GAMESCREEN], 0, 0, this);

                //gbi.setComposite(ac);

                if (game != null)
                    getBoard().paintTo(gbi, getSize(), new Dimension(50, 50));

                //gbi.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 1));
                
                int curPlayer = game.getAktSpieler().getMySpielerNummer();
                
                gbi.setPaint(Brett.RED);
                gbi.setFont(new Font("Helvetica", curPlayer == 0 ? Font.ITALIC : Font.PLAIN, 20));
                gbi.drawString(game.getSpieler(0).getMyName(), 120, 40);

                gbi.setPaint(Brett.BLUE);
                gbi.setFont(new Font("Helvetica", curPlayer == 1 ? Font.ITALIC : Font.PLAIN, 20));
                gbi.drawString(game.getSpieler(1).getMyName(), 520, 40);

                Spieler sp;
                
                if ((sp = game.getSpieler(2)) != null) {
                    gbi.setPaint(Brett.YELLOW);
                    gbi.setFont(new Font("Helvetica", curPlayer == 2 ? Font.ITALIC : Font.PLAIN, 20));
                    gbi.drawString(sp.getMyName(), 120, 580);
                }
                
                if ((sp = game.getSpieler(3)) != null) {
                    gbi.setPaint(Brett.GREEN);
                    gbi.setFont(new Font("Helvetica", curPlayer == 3 ? Font.ITALIC : Font.PLAIN, 20));
                    gbi.drawString(sp.getMyName(), 520, 580);
                }
                
                gbi.setFont(new Font("Helvetica", Font.PLAIN, 32));
                
                String s = "Runde " + (game.getMySatz() + 1);
                FontMetrics fm = gbi.getFontMetrics();
                
                gbi.setPaint(Brett.WHITE);
                gbi.drawString(s, (w - fm.stringWidth(s)) / 2, 30);
                
                //g2.drawImage(buffImg, null, 0, 0);

                break;
        }
    }
}