/*
 * HighScoresDialog.java
 *
 * Created on March 25, 2002, 9:08 AM
 */

import java.awt.*;
import javax.swing.*;

/**
 *
 * @author  sopr157
 */
public class HighScoresDialog extends JDialog implements ModalDialog {

    private HighScoresPane highScoresPane;
    private HighscoreTable highScoresTable;
    
    private int internalResult = ModalDialog.CANCEL;
    //private HighScores highScores;

    /** Creates new form HighScoresDialog */
    public HighScoresDialog(Frame parent, Image highScoresImage) {
        super(parent, true);
        System.out.println("        high scores dialog");

        initComponents();
        
        highScoresPane = new HighScoresPane(highScoresImage);
        InteriorPanel.add(highScoresPane, BorderLayout.CENTER);
        highScoresPane.setPreferredSize(new Dimension(500, 600));
        pack();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        DialogInteriorPanel = new javax.swing.JPanel();
        InteriorPanel = new javax.swing.JPanel();
        DialogCommandPanel = new javax.swing.JPanel();
        OkButton = new javax.swing.JButton();
        
        setTitle("High Scores");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        
        DialogInteriorPanel.setLayout(new java.awt.BorderLayout());
        
        DialogInteriorPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(8, 8, 0, 8)));
        DialogInteriorPanel.setFont(new java.awt.Font("Dialog", 0, 11));
        DialogInteriorPanel.setMaximumSize(new java.awt.Dimension(520, 612));
        DialogInteriorPanel.setMinimumSize(new java.awt.Dimension(520, 612));
        DialogInteriorPanel.setPreferredSize(new java.awt.Dimension(520, 612));
        InteriorPanel.setLayout(new java.awt.BorderLayout());
        
        InteriorPanel.setBorder(new javax.swing.border.EtchedBorder());
        DialogInteriorPanel.add(InteriorPanel, java.awt.BorderLayout.CENTER);
        
        getContentPane().add(DialogInteriorPanel, java.awt.BorderLayout.CENTER);
        
        DialogCommandPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT, 8, 8));
        
        DialogCommandPanel.setFont(new java.awt.Font("Dialog", 0, 11));
        OkButton.setFont(new java.awt.Font("Dialog", 0, 11));
        OkButton.setText("OK");
        OkButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                OkButtonActionPerformed(evt);
            }
        });
        
        DialogCommandPanel.add(OkButton);
        
        getContentPane().add(DialogCommandPanel, java.awt.BorderLayout.SOUTH);
        
        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(360, 400));
        setLocation((screenSize.width-360)/2,(screenSize.height-400)/2);
    }//GEN-END:initComponents

    private void OkButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_OkButtonActionPerformed
        internalResult = ModalDialog.OK;
        closeDialog(null);
    }//GEN-LAST:event_OkButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
    }//GEN-LAST:event_closeDialog

    public int getModalResult() { return internalResult; }
    
    public void setHighScoresTable(HighscoreTable hs) {
        highScoresPane.setHighScoresTable(hs);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel DialogInteriorPanel;
    private javax.swing.JPanel InteriorPanel;
    private javax.swing.JPanel DialogCommandPanel;
    private javax.swing.JButton OkButton;
    // End of variables declaration//GEN-END:variables
}
