/*
 * HighScoresPane.java
 *
 * Created on March 27, 2002, 8:50 AM
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.Graphics.*;
import java.awt.Graphics2D.*;
import java.util.*;
import javax.swing.*;

/**
 *
 * @author  sopr157
 */
public class HighScoresPane extends javax.swing.JPanel {

    private Image highScoresImage;
    private HighscoreTable highScoresTable;
    
    /** Creates new form HighScoresPane */
    public HighScoresPane(Image highScoresImg) {
        super();
        highScoresImage = highScoresImg;
    }

    public void setHighScoresTable(HighscoreTable hs) {
        highScoresTable = hs;
        repaint();
    }
    
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D) g;

        g2.fill(new Rectangle(0, 0, getSize().width, getSize().height));
        g2.drawImage(highScoresImage, 0, 0, this);

        g2.setFont(new Font("Helvetica", 0, 20));
        g2.setPaint(Brett.WHITE);
        
        if (highScoresTable == null) return;
        
        Vector v = highScoresTable.getHighScoresList();
        Highscore hs;
        int y;
        
        for (int i = 0; i < v.size(); i++) {
            hs = (Highscore) v.elementAt(i);
            y = 120 + i * 20;
            
            g2.drawString("" + i,               40, y);
            g2.drawString(hs.getName(),         60, y);
            g2.drawString("" + hs.getPunkte(), 200, y);
        }
    }
}
