/*
 * IOControl.java
 *
 * Created on March 21, 2002, 9:24 AM
 */

/**
 *
 * @author  Ken
 * @version 
 */
import java.io.*;
import java.util.*;

public class IOControl implements Serializable {
    
    private static final int MAXUNDO = 32;
    
    private static final String OPTIONSFILENAME = "options.conf";
    private static final String HIGHSCORESFILENAME = "highscores";
    private String myPath;
    
    private Stack Undo;
    
    /** Creates new IOControl */
    public IOControl(String path) {
        super();
        myPath = path;
        
        Undo = new Stack();
    }
    
    public Options loadOptions() {
        Options r = null;
        try {
            ObjectInputStream inputStream = new ObjectInputStream(
                new FileInputStream(myPath + File.separatorChar +
                OPTIONSFILENAME));
            
            r = (Options) inputStream.readObject();
        } catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                r = new Options();
                System.out.println("options file not found - creating default file...");
                saveOptions(r);
            } else
                System.out.println("<" + e.getClass() + ">: "+ e.getMessage());
        } catch (Exception e) {
            System.out.println("<" + e.getClass() + ">: "+ e.getMessage());
            System.exit(1);
        }
        
        return r;
    }
    
    public void saveOptions(Options options) {
        try {
            String fileName = myPath + File.separatorChar + OPTIONSFILENAME;
            File file = new File(fileName);
            
            if (!file.exists())
                file.createNewFile();
            
            ObjectOutputStream outputStream = new ObjectOutputStream(
                new FileOutputStream(fileName));
            
            outputStream.writeObject(options);
        } catch (Exception e) {
            System.out.println("<" + e.getClass() + ">: "+ e.getMessage());
            System.exit(1);
        }
    }
    
    public Spiel spielLaden(String dateiname) {
        Spiel dasSpiel = null;
        try {
            FileInputStream fs = new FileInputStream(dateiname);
            ObjectInputStream is = new ObjectInputStream(fs);
            
            dasSpiel = (Spiel) is.readObject();
            is.close();
        } catch (Exception e) {
            System.out.println("<" + e.getClass() + ">: "+ e.getMessage());
            System.exit(1);
        }
        
        return dasSpiel;   
    }

    public void spielSpeichern(String dateiname, Spiel dasObject) { 
        try {
            FileOutputStream ostream = new FileOutputStream(dateiname);
            ObjectOutputStream p = new ObjectOutputStream(ostream);

            p.writeObject(dasObject);
        
            p.flush();
            ostream.close();
        } catch (Exception e) {
            System.out.println("<" + e.getClass() + ">: "+ e.getMessage());
            System.exit(1);
        }
    }

    public HighscoreTable loadHighScores() {
        HighscoreTable r = null;
        try {
            ObjectInputStream inputStream = new ObjectInputStream(
                new FileInputStream(myPath + File.separatorChar +
                HIGHSCORESFILENAME));
            
            r = (HighscoreTable) inputStream.readObject();
        } catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                r = new HighscoreTable();
                System.out.println("highscores file not found - creating default file...");
                saveHighScores(r);
            } else
                System.out.println("<" + e.getClass() + ">: "+ e.getMessage());
        } catch (Exception e) {
            System.out.println("<" + e.getClass() + ">: "+ e.getMessage());
            System.exit(1);
        }
        
        return r;
    }

    public void saveHighScores(HighscoreTable highscore) {
        try {
            FileOutputStream ostream = new FileOutputStream(myPath +
                File.separatorChar + HIGHSCORESFILENAME);
            ObjectOutputStream p = new ObjectOutputStream(ostream);
            
            p.writeObject(highscore);
    
            p.flush();
            ostream.close();
        } catch (IOException e) {
            System.out.println("<" + e.getClass() + ">: "+ e.getMessage());
            System.exit(1);
        }
    }
    
    public Spiel undo() {
        Spiel opt = null;
        
        if (Undo.size() > 0) {
            ObjectInputStream oip = (ObjectInputStream) Undo.pop();
            try {
                opt = (Spiel) oip.readObject();
            } catch (Exception e) {
                System.out.println("<" + e.getClass() + ">: "+ e.getMessage());
                System.exit(1);
            }
        } else System.out.println("        undo stack empty");
        
        return opt;
    }
    
    public void putInUndo(Spiel dasSpiel) {
        if (Undo.size() <= MAXUNDO)
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ObjectOutputStream o = new ObjectOutputStream(out);
                o.writeObject(dasSpiel);
                o.flush();
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                ObjectInputStream is = new ObjectInputStream(in);
                Undo.push(is);
                is.close();
                o.close();
            } catch(Exception e) {
                System.out.println("<" + e.getClass() + ">: "+ e.getMessage());
                System.exit(1);
            }
        else if (Undo.size() > MAXUNDO) {
            try {
                Undo.remove(0);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ObjectOutputStream o = new ObjectOutputStream(out);
                o.writeObject(dasSpiel);
                o.flush();
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                ObjectInputStream is = new ObjectInputStream(in);
                Undo.push(is);
                is.close();
                o.close();
            }
            catch (Exception e) {
                System.out.println("<" + e.getClass() + ">: "+ e.getMessage());
                System.exit(1);
            }
        }
    }
}