/*
 * Options.java
 *
 * Created on March 20, 2002, 1:30 PM
 */

/**
 *
 * @author  Ken
 * @version
 */

import java.util.*;
import java.io.*;

public class Options implements Serializable {
    public static final int NOPLAYER =    0;
    public static final int CI1PLAYER =   1;
    public static final int CI2PLAYER =   2;
    public static final int CI3PLAYER =   3;
    public static final int HUMANPLAYER = 4;
    
    /** Creates new Options */
    public Options() {
        super();
        playerCount = 2;
        round = 0;
    }
    
    public int getSpielerTyp(int index) { return playerTypes[index]; }
    public void setSpielerTyp(int index, int value) { playerTypes[index] = value; }
    
    public int getGewinnSaetze() { return round; }
    public void setGewinnSaetze(int value) { round = value; }
    
    public void setSpielerName(int index, String value) {
        if (index < 0 || index > 3) return;
        
        playerNames[index] = value;
    }
    
    public String getSpielerName(int index) {
        if (index < 0 || index > 3) return null;
        
        return playerNames[index];
    }
    
    public int getSpielerAnzahl() { return playerCount; }
    public void setSpielerAnzahl(int value) {
        if (value > 1 && value < 5)
            playerCount = value;
    }
    
    /**
     * Array von 4 int Werten
     * 0 = kein Spieler
     * 1 - 3 = KI Staerke
     * 4 = Menschlicher Gegner
     */
    private String[] playerNames = {
        "Spielerin 1", "Spieler 2", "Spieler 3", "Spieler 4"
    };
    private int[] playerTypes = {
        HUMANPLAYER, CI1PLAYER, NOPLAYER, NOPLAYER
    };
    private int playerCount;
    private int round;
}