/*
 * JDialog.java
 *
 * Created on March 20, 2002, 5:09 PM
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.Graphics.*;
import java.awt.Graphics2D.*;
import javax.swing.*;

/**
 *
 * @author  sopr157
 */
public class OptionsDialog extends JDialog implements ModalDialog {
    
    private int internalResult = ModalDialog.CANCEL;
    private Image[] optionImages;
    private Options options;

    /** Creates new form JDialog */
    public OptionsDialog(java.awt.Frame parent, Image[] optionImgs) {
        super(parent, true);
        System.out.println("        options dialog");
        
        initComponents();
        getRootPane().setDefaultButton(OkButton);
        
        optionImages = new Image[optionImgs.length];
        System.arraycopy(optionImgs, 0, optionImages, 0, optionImgs.length);
        
        if (optionImgs.length > 3) {
            Player1IconLabel.setIcon(new ImageIcon(optionImgs[0]));
            Player2IconLabel.setIcon(new ImageIcon(optionImgs[1]));
            Player3IconLabel.setIcon(new ImageIcon(optionImgs[2]));
            Player4IconLabel.setIcon(new ImageIcon(optionImgs[3]));
        }
        
        // Player 2
        Player2ComboBox.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent e) {
                switch (Player2ComboBox.getSelectedIndex()) {
                    case 0:
                        Player2StrengthLabel.setEnabled(false);
                        Player2Slider.setEnabled(false);
                        break;
                    case 1:
                        Player2StrengthLabel.setEnabled(true);
                        Player2Slider.setEnabled(true);
                        break;
                }
            }
        });
        
        // Player 3
        Player3ComboBox.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent e) {
                switch (Player3ComboBox.getSelectedIndex()) {
                    case 0:
                        Player3StrengthLabel.setEnabled(false);
                        Player3Slider.setEnabled(false);
                        Player3NameLabel.setEnabled(false);
                        Player3TextField.setEnabled(false);
                        break;
                    case 1:
                        Player3StrengthLabel.setEnabled(false);
                        Player3Slider.setEnabled(false);
                        Player3NameLabel.setEnabled(true);
                        Player3TextField.setEnabled(true);
                        break;
                    case 2:
                        Player3StrengthLabel.setEnabled(true);
                        Player3Slider.setEnabled(true);
                        Player3NameLabel.setEnabled(true);
                        Player3TextField.setEnabled(true);
                        break;
                }
            }
        });

        // Player 4
        Player4ComboBox.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent e) {
                switch (Player4ComboBox.getSelectedIndex()) {
                    case 0:
                        Player4StrengthLabel.setEnabled(false);
                        Player4Slider.setEnabled(false);
                        Player4NameLabel.setEnabled(false);
                        Player4TextField.setEnabled(false);
                        break;
                    case 1:
                        Player4StrengthLabel.setEnabled(false);
                        Player4Slider.setEnabled(false);
                        Player4NameLabel.setEnabled(true);
                        Player4TextField.setEnabled(true);
                        break;
                    case 2:
                        Player4StrengthLabel.setEnabled(true);
                        Player4Slider.setEnabled(true);
                        Player4NameLabel.setEnabled(true);
                        Player4TextField.setEnabled(true);
                        break;
                }
            }
        });
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        DialogInteriorPanel = new javax.swing.JPanel();
        Player1Panel = new javax.swing.JPanel();
        Player1InteriorPanel = new javax.swing.JPanel();
        Player1IconLabel = new javax.swing.JLabel();
        Player1TypeLabel = new javax.swing.JLabel();
        Player1ComboBox = new javax.swing.JComboBox();
        Player1StrengthLabel = new javax.swing.JLabel();
        Player1Slider = new javax.swing.JSlider();
        Player1NameLabel = new javax.swing.JLabel();
        Player1TextField = new javax.swing.JTextField();
        Player2Panel = new javax.swing.JPanel();
        Player2InteriorPanel = new javax.swing.JPanel();
        Player2IconLabel = new javax.swing.JLabel();
        Player2TypeLabel = new javax.swing.JLabel();
        Player2ComboBox = new javax.swing.JComboBox();
        Player2StrengthLabel = new javax.swing.JLabel();
        Player2Slider = new javax.swing.JSlider();
        Player2NameLabel = new javax.swing.JLabel();
        Player2TextField = new javax.swing.JTextField();
        Player3Panel = new javax.swing.JPanel();
        Player3InteriorPanel = new javax.swing.JPanel();
        Player3IconLabel = new javax.swing.JLabel();
        Player3TypeLabel = new javax.swing.JLabel();
        Player3ComboBox = new javax.swing.JComboBox();
        Player3StrengthLabel = new javax.swing.JLabel();
        Player3Slider = new javax.swing.JSlider();
        Player3NameLabel = new javax.swing.JLabel();
        Player3TextField = new javax.swing.JTextField();
        Player4Panel = new javax.swing.JPanel();
        Player4InteriorPanel = new javax.swing.JPanel();
        Player4IconLabel = new javax.swing.JLabel();
        Player4TypeLabel = new javax.swing.JLabel();
        Player4ComboBox = new javax.swing.JComboBox();
        Player4StrengthLabel = new javax.swing.JLabel();
        Player4Slider = new javax.swing.JSlider();
        Player4NameLabel = new javax.swing.JLabel();
        Player4TextField = new javax.swing.JTextField();
        CommandPanel = new javax.swing.JPanel();
        OkButton = new javax.swing.JButton();
        CancelButton = new javax.swing.JButton();
        
        setTitle("Optionen");
        setModal(true);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        
        DialogInteriorPanel.setLayout(new java.awt.GridLayout(2, 2, 8, 8));
        
        DialogInteriorPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(8, 8, 0, 8)));
        Player1Panel.setLayout(new java.awt.BorderLayout());
        
        Player1Panel.setBorder(new javax.swing.border.TitledBorder("Spielerin 1: Bloody Mary"));
        Player1Panel.setMinimumSize(new java.awt.Dimension(248, 72));
        Player1Panel.setPreferredSize(new java.awt.Dimension(248, 72));
        Player1InteriorPanel.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        Player1IconLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        Player1IconLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridheight = 3;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.insets = new java.awt.Insets(8, 8, 8, 8);
        Player1InteriorPanel.add(Player1IconLabel, gridBagConstraints1);
        
        Player1TypeLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        Player1TypeLabel.setText("Spielertyp:");
        Player1TypeLabel.setEnabled(false);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new java.awt.Insets(8, 0, 8, 8);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        Player1InteriorPanel.add(Player1TypeLabel, gridBagConstraints1);
        
        Player1ComboBox.setFont(new java.awt.Font("Dialog", 0, 11));
        Player1ComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Human" }));
        Player1ComboBox.setMinimumSize(new java.awt.Dimension(160, 25));
        Player1ComboBox.setPreferredSize(new java.awt.Dimension(160, 25));
        Player1ComboBox.setEnabled(false);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new java.awt.Insets(8, 0, 8, 8);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        Player1InteriorPanel.add(Player1ComboBox, gridBagConstraints1);
        
        Player1StrengthLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        Player1StrengthLabel.setText("Spielstaerke:");
        Player1StrengthLabel.setEnabled(false);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new java.awt.Insets(0, 0, 8, 8);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        Player1InteriorPanel.add(Player1StrengthLabel, gridBagConstraints1);
        
        Player1Slider.setFont(new java.awt.Font("Dialog", 0, 11));
        Player1Slider.setMajorTickSpacing(1);
        Player1Slider.setMaximum(3);
        Player1Slider.setMinimum(1);
        Player1Slider.setPaintTicks(true);
        Player1Slider.setSnapToTicks(true);
        Player1Slider.setValue(1);
        Player1Slider.setMinimumSize(new java.awt.Dimension(167, 27));
        Player1Slider.setPreferredSize(new java.awt.Dimension(167, 27));
        Player1Slider.setEnabled(false);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new java.awt.Insets(0, 0, 8, 8);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        Player1InteriorPanel.add(Player1Slider, gridBagConstraints1);
        
        Player1NameLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        Player1NameLabel.setText("Name:");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.insets = new java.awt.Insets(0, 0, 8, 8);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        Player1InteriorPanel.add(Player1NameLabel, gridBagConstraints1);
        
        Player1TextField.setFont(new java.awt.Font("Dialog", 0, 11));
        Player1TextField.setText("Spielerin 1");
        Player1TextField.setMinimumSize(new java.awt.Dimension(160, 21));
        Player1TextField.setPreferredSize(new java.awt.Dimension(160, 21));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.insets = new java.awt.Insets(0, 0, 8, 8);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        Player1InteriorPanel.add(Player1TextField, gridBagConstraints1);
        
        Player1Panel.add(Player1InteriorPanel, java.awt.BorderLayout.CENTER);
        
        DialogInteriorPanel.add(Player1Panel);
        
        Player2Panel.setLayout(new java.awt.BorderLayout());
        
        Player2Panel.setBorder(new javax.swing.border.TitledBorder("Spieler 2: Gamdalf of Grey Earl"));
        Player2InteriorPanel.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints2;
        
        Player2IconLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        Player2IconLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridheight = 3;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints2.insets = new java.awt.Insets(8, 8, 8, 8);
        Player2InteriorPanel.add(Player2IconLabel, gridBagConstraints2);
        
        Player2TypeLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        Player2TypeLabel.setText("Spielertyp:");
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new java.awt.Insets(8, 0, 8, 8);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        Player2InteriorPanel.add(Player2TypeLabel, gridBagConstraints2);
        
        Player2ComboBox.setFont(new java.awt.Font("Dialog", 0, 11));
        Player2ComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Human", "CPU" }));
        Player2ComboBox.setSelectedIndex(1);
        Player2ComboBox.setMinimumSize(new java.awt.Dimension(160, 25));
        Player2ComboBox.setPreferredSize(new java.awt.Dimension(160, 25));
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new java.awt.Insets(8, 0, 8, 8);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        Player2InteriorPanel.add(Player2ComboBox, gridBagConstraints2);
        
        Player2StrengthLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        Player2StrengthLabel.setText("Spielstaerke:");
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new java.awt.Insets(0, 0, 8, 8);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        Player2InteriorPanel.add(Player2StrengthLabel, gridBagConstraints2);
        
        Player2Slider.setFont(new java.awt.Font("Dialog", 0, 11));
        Player2Slider.setMajorTickSpacing(1);
        Player2Slider.setMaximum(3);
        Player2Slider.setMinimum(1);
        Player2Slider.setPaintTicks(true);
        Player2Slider.setSnapToTicks(true);
        Player2Slider.setValue(1);
        Player2Slider.setMinimumSize(new java.awt.Dimension(167, 27));
        Player2Slider.setPreferredSize(new java.awt.Dimension(167, 27));
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new java.awt.Insets(0, 0, 8, 8);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        Player2InteriorPanel.add(Player2Slider, gridBagConstraints2);
        
        Player2NameLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        Player2NameLabel.setText("Name:");
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.insets = new java.awt.Insets(0, 0, 8, 8);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        Player2InteriorPanel.add(Player2NameLabel, gridBagConstraints2);
        
        Player2TextField.setFont(new java.awt.Font("Dialog", 0, 11));
        Player2TextField.setText("Spieler 2");
        Player2TextField.setMinimumSize(new java.awt.Dimension(160, 21));
        Player2TextField.setPreferredSize(new java.awt.Dimension(160, 21));
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.insets = new java.awt.Insets(0, 0, 8, 8);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        Player2InteriorPanel.add(Player2TextField, gridBagConstraints2);
        
        Player2Panel.add(Player2InteriorPanel, java.awt.BorderLayout.CENTER);
        
        DialogInteriorPanel.add(Player2Panel);
        
        Player3Panel.setLayout(new java.awt.BorderLayout());
        
        Player3Panel.setBorder(new javax.swing.border.TitledBorder("Spieler 3: Khan Mandrake"));
        Player3InteriorPanel.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints3;
        
        Player3IconLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        Player3IconLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridheight = 3;
        gridBagConstraints3.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints3.insets = new java.awt.Insets(8, 8, 8, 8);
        Player3InteriorPanel.add(Player3IconLabel, gridBagConstraints3);
        
        Player3TypeLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        Player3TypeLabel.setText("Spielertyp:");
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new java.awt.Insets(8, 0, 8, 8);
        gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
        Player3InteriorPanel.add(Player3TypeLabel, gridBagConstraints3);
        
        Player3ComboBox.setFont(new java.awt.Font("Dialog", 0, 11));
        Player3ComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "<nicht vorhanden>", "Human", "CPU" }));
        Player3ComboBox.setMinimumSize(new java.awt.Dimension(160, 25));
        Player3ComboBox.setPreferredSize(new java.awt.Dimension(160, 25));
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new java.awt.Insets(8, 0, 8, 8);
        gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
        Player3InteriorPanel.add(Player3ComboBox, gridBagConstraints3);
        
        Player3StrengthLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        Player3StrengthLabel.setText("Spielstaerke:");
        Player3StrengthLabel.setEnabled(false);
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.insets = new java.awt.Insets(0, 0, 8, 8);
        gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
        Player3InteriorPanel.add(Player3StrengthLabel, gridBagConstraints3);
        
        Player3Slider.setFont(new java.awt.Font("Dialog", 0, 11));
        Player3Slider.setMajorTickSpacing(1);
        Player3Slider.setMaximum(3);
        Player3Slider.setMinimum(1);
        Player3Slider.setPaintTicks(true);
        Player3Slider.setSnapToTicks(true);
        Player3Slider.setValue(1);
        Player3Slider.setMinimumSize(new java.awt.Dimension(167, 27));
        Player3Slider.setPreferredSize(new java.awt.Dimension(167, 27));
        Player3Slider.setEnabled(false);
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.insets = new java.awt.Insets(0, 0, 8, 8);
        gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
        Player3InteriorPanel.add(Player3Slider, gridBagConstraints3);
        
        Player3NameLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        Player3NameLabel.setText("Name:");
        Player3NameLabel.setEnabled(false);
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.insets = new java.awt.Insets(0, 0, 8, 8);
        gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
        Player3InteriorPanel.add(Player3NameLabel, gridBagConstraints3);
        
        Player3TextField.setFont(new java.awt.Font("Dialog", 0, 11));
        Player3TextField.setText("Spieler 3");
        Player3TextField.setMinimumSize(new java.awt.Dimension(160, 21));
        Player3TextField.setPreferredSize(new java.awt.Dimension(160, 21));
        Player3TextField.setEnabled(false);
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.insets = new java.awt.Insets(0, 0, 8, 8);
        gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
        Player3InteriorPanel.add(Player3TextField, gridBagConstraints3);
        
        Player3Panel.add(Player3InteriorPanel, java.awt.BorderLayout.CENTER);
        
        DialogInteriorPanel.add(Player3Panel);
        
        Player4Panel.setLayout(new java.awt.BorderLayout());
        
        Player4Panel.setBorder(new javax.swing.border.TitledBorder("Spieler 4: Hoodoo Voodoo"));
        Player4InteriorPanel.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints4;
        
        Player4IconLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        Player4IconLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        gridBagConstraints4 = new java.awt.GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.gridheight = 3;
        gridBagConstraints4.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints4.insets = new java.awt.Insets(8, 8, 8, 8);
        Player4InteriorPanel.add(Player4IconLabel, gridBagConstraints4);
        
        Player4TypeLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        Player4TypeLabel.setText("Spielertyp:");
        gridBagConstraints4 = new java.awt.GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.insets = new java.awt.Insets(8, 0, 8, 8);
        gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
        Player4InteriorPanel.add(Player4TypeLabel, gridBagConstraints4);
        
        Player4ComboBox.setFont(new java.awt.Font("Dialog", 0, 11));
        Player4ComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "<nicht vorhanden>", "Human", "CPU" }));
        Player4ComboBox.setMinimumSize(new java.awt.Dimension(160, 25));
        Player4ComboBox.setPreferredSize(new java.awt.Dimension(160, 25));
        gridBagConstraints4 = new java.awt.GridBagConstraints();
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.insets = new java.awt.Insets(8, 0, 8, 8);
        gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
        Player4InteriorPanel.add(Player4ComboBox, gridBagConstraints4);
        
        Player4StrengthLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        Player4StrengthLabel.setText("Spielstaerke:");
        Player4StrengthLabel.setEnabled(false);
        gridBagConstraints4 = new java.awt.GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.insets = new java.awt.Insets(0, 0, 8, 8);
        gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
        Player4InteriorPanel.add(Player4StrengthLabel, gridBagConstraints4);
        
        Player4Slider.setFont(new java.awt.Font("Dialog", 0, 11));
        Player4Slider.setMajorTickSpacing(1);
        Player4Slider.setMaximum(3);
        Player4Slider.setMinimum(1);
        Player4Slider.setPaintTicks(true);
        Player4Slider.setSnapToTicks(true);
        Player4Slider.setValue(1);
        Player4Slider.setMinimumSize(new java.awt.Dimension(167, 27));
        Player4Slider.setPreferredSize(new java.awt.Dimension(167, 27));
        Player4Slider.setEnabled(false);
        gridBagConstraints4 = new java.awt.GridBagConstraints();
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.insets = new java.awt.Insets(0, 0, 8, 8);
        gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
        Player4InteriorPanel.add(Player4Slider, gridBagConstraints4);
        
        Player4NameLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        Player4NameLabel.setText("Name:");
        Player4NameLabel.setEnabled(false);
        gridBagConstraints4 = new java.awt.GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.insets = new java.awt.Insets(0, 0, 8, 8);
        gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
        Player4InteriorPanel.add(Player4NameLabel, gridBagConstraints4);
        
        Player4TextField.setFont(new java.awt.Font("Dialog", 0, 11));
        Player4TextField.setText("Spieler 4");
        Player4TextField.setMinimumSize(new java.awt.Dimension(160, 21));
        Player4TextField.setPreferredSize(new java.awt.Dimension(160, 21));
        Player4TextField.setEnabled(false);
        gridBagConstraints4 = new java.awt.GridBagConstraints();
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.insets = new java.awt.Insets(0, 0, 8, 8);
        gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
        Player4InteriorPanel.add(Player4TextField, gridBagConstraints4);
        
        Player4Panel.add(Player4InteriorPanel, java.awt.BorderLayout.CENTER);
        
        DialogInteriorPanel.add(Player4Panel);
        
        getContentPane().add(DialogInteriorPanel, java.awt.BorderLayout.CENTER);
        
        CommandPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT, 8, 8));
        
        OkButton.setFont(new java.awt.Font("Dialog", 0, 11));
        OkButton.setText("OK");
        OkButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                OkButtonActionPerformed(evt);
            }
        });
        
        CommandPanel.add(OkButton);
        
        CancelButton.setFont(new java.awt.Font("Dialog", 0, 11));
        CancelButton.setText("Abbrechen");
        CancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                CancelButtonActionPerformed(evt);
            }
        });
        
        CommandPanel.add(CancelButton);
        
        getContentPane().add(CommandPanel, java.awt.BorderLayout.SOUTH);
        
        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(750, 360));
        setLocation((screenSize.width-750)/2,(screenSize.height-360)/2);
    }//GEN-END:initComponents

    private void Player2ComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Player2ComboBoxActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_Player2ComboBoxActionPerformed

    private void Player1ComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Player1ComboBoxActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_Player1ComboBoxActionPerformed

    private void Player3ComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Player3ComboBoxActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_Player3ComboBoxActionPerformed

    private void OkButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_OkButtonActionPerformed
        internalResult = ModalDialog.OK;
        closeDialog(null);
    }//GEN-LAST:event_OkButtonActionPerformed

    private void CancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_CancelButtonActionPerformed
        internalResult = ModalDialog.CANCEL;
        closeDialog(null);
    }//GEN-LAST:event_CancelButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
    }//GEN-LAST:event_closeDialog

    public int getModalResult() { return internalResult; }
    
    public void setOptions(Options value) {
        options = value;
        
        Player1TextField.setText(options.getSpielerName(0));
        Player2TextField.setText(options.getSpielerName(1));
        Player3TextField.setText(options.getSpielerName(2));
        Player4TextField.setText(options.getSpielerName(3));
        
        int pt;
        int[] playerStrength = {1, 1, 2, 3, 1};
        
        int[] player2Mapping =  {0, 1, 1, 1, 0};
        pt = options.getSpielerTyp(1);
        Player2ComboBox.setSelectedIndex(player2Mapping[pt]);
        Player2Slider.setValue(playerStrength[pt]);

        int[] player3Mapping =  {0, 2, 2, 2, 1};
        pt = options.getSpielerTyp(2);
        Player3ComboBox.setSelectedIndex(player3Mapping[pt]);
        Player3Slider.setValue(playerStrength[pt]);
        
        int[] player4Mapping =  {0, 2, 2, 2, 1};
        pt = options.getSpielerTyp(3);
        Player4ComboBox.setSelectedIndex(player4Mapping[pt]);
        Player4Slider.setValue(playerStrength[pt]);
    }
    
    public Options getOptions() {
        options.setSpielerName(0, Player1TextField.getText());
        options.setSpielerName(1, Player2TextField.getText());
        options.setSpielerName(2, Player3TextField.getText());
        options.setSpielerName(3, Player4TextField.getText());
        
        int pt;
        int si;
        options.setSpielerTyp(0, Options.HUMANPLAYER);
        
        pt = Player2ComboBox.getSelectedIndex();
        si = Player2Slider.getValue();
        options.setSpielerTyp(1, pt > 0 ? si : Options.HUMANPLAYER);
        
        pt = Player3ComboBox.getSelectedIndex();
        si = Player3Slider.getValue();
        options.setSpielerTyp(2, pt == 0 ? Options.NOPLAYER : pt == 1 ? Options.HUMANPLAYER : si);

        pt = Player4ComboBox.getSelectedIndex();
        si = Player4Slider.getValue();
        options.setSpielerTyp(3, pt == 0 ? Options.NOPLAYER : pt == 1 ? Options.HUMANPLAYER : si);
        
        int pc = 2; // Player 1 & 2
        if (Player3ComboBox.getSelectedIndex() != 0) pc++;
        if (Player4ComboBox.getSelectedIndex() != 0) pc++;
        options.setSpielerAnzahl(pc);

        return options;
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel DialogInteriorPanel;
    private javax.swing.JPanel Player1Panel;
    private javax.swing.JPanel Player1InteriorPanel;
    private javax.swing.JLabel Player1IconLabel;
    private javax.swing.JLabel Player1TypeLabel;
    private javax.swing.JComboBox Player1ComboBox;
    private javax.swing.JLabel Player1StrengthLabel;
    private javax.swing.JSlider Player1Slider;
    private javax.swing.JLabel Player1NameLabel;
    private javax.swing.JTextField Player1TextField;
    private javax.swing.JPanel Player2Panel;
    private javax.swing.JPanel Player2InteriorPanel;
    private javax.swing.JLabel Player2IconLabel;
    private javax.swing.JLabel Player2TypeLabel;
    private javax.swing.JComboBox Player2ComboBox;
    private javax.swing.JLabel Player2StrengthLabel;
    private javax.swing.JSlider Player2Slider;
    private javax.swing.JLabel Player2NameLabel;
    private javax.swing.JTextField Player2TextField;
    private javax.swing.JPanel Player3Panel;
    private javax.swing.JPanel Player3InteriorPanel;
    private javax.swing.JLabel Player3IconLabel;
    private javax.swing.JLabel Player3TypeLabel;
    private javax.swing.JComboBox Player3ComboBox;
    private javax.swing.JLabel Player3StrengthLabel;
    private javax.swing.JSlider Player3Slider;
    private javax.swing.JLabel Player3NameLabel;
    private javax.swing.JTextField Player3TextField;
    private javax.swing.JPanel Player4Panel;
    private javax.swing.JPanel Player4InteriorPanel;
    private javax.swing.JLabel Player4IconLabel;
    private javax.swing.JLabel Player4TypeLabel;
    private javax.swing.JComboBox Player4ComboBox;
    private javax.swing.JLabel Player4StrengthLabel;
    private javax.swing.JSlider Player4Slider;
    private javax.swing.JLabel Player4NameLabel;
    private javax.swing.JTextField Player4TextField;
    private javax.swing.JPanel CommandPanel;
    private javax.swing.JButton OkButton;
    private javax.swing.JButton CancelButton;
    // End of variables declaration//GEN-END:variables
}