/*
 * Spiel.java
 *
 * Created on March 22, 2002, 1:44 PM
 */

import java.io.*;

public class Spiel implements Serializable {
    
    public Spiel() { }
    
    public Options getOptions() { return myOptions; }
    public void setOptions(Options value) {
        if (value == null)
            myOptions = new Options();
        else
            myOptions = value;
        mySpielBrett = null;
    }
    
    /**
     * @preconditions Es existiert noch kein Spiel.
     * @postconditions Es wurden alle fuer ein Spiel notwendigen Objekte generiert (Engine, Brett, Felder, Figuren, Spieler,...) zurueckgegeben  wird der Spieler der bginnt.
     */
     public Spieler neuesSpiel() {
        mySpieler = new Spieler[myOptions.getSpielerAnzahl()];
        myEngine = new Engine(this);

        for (int i = 0, j = 0; i < myOptions.getSpielerAnzahl(); i++)
            if (myOptions.getSpielerTyp(i) != Options.NOPLAYER) {
                mySpieler[j] = new Spieler(myOptions.getSpielerTyp(i),
                    mittlereZugrichtung(i), i, myOptions.getSpielerName(i));
                j++;
            }
        
        mySpielBrett = new Brett(myOptions.getSpielerAnzahl());
        setzeFigurenStart();
        
        // Waehlt einen zufaelligen Startspieler aus
        //aktSpieler = mySpieler[(new java.util.Random()).nextInt(myOptions.getSpielerAnzahl())];

        // debug!!!!!!!!!!!!!!
        aktSpieler = mySpieler[0];
        return aktSpieler;
    }
    
    /**
     * gibt die mittlere Zugrichtung zurueck. (wird anhand der SpielerNummer festgestellt
     * Sollte keine passende Zugrichtung gefunden werden gibt es -1 zurueck
     */
    private int mittlereZugrichtung(int spielerNummer) {
        switch (myOptions.getSpielerAnzahl()) {
            case 0:
            case 1:
            case 2:
                switch (spielerNummer) {
                    case 0: return 1;
                    case 1: return 4;
                }

            case 3:
                switch (spielerNummer) {
                    case 0: return 2;
                    case 1: return 4;
                    case 2: return 0;
                }

            case 4:
                switch (spielerNummer) {
                    case 0: return 2;
                    case 1: return 3;
                    case 2: return 0;
                    case 3: return 5;
                }
        }
        return -1;
    }
    
    /**
     *Uebergibt dem Brett der Reihe nach saemtliche Spieler damit dieses dann deren Figuren auf die Start Positionen setzt
     */
    private void setzeFigurenStart() {
        mySpielBrett.setzeStartPositionen(mySpieler);
    }
    
   /**
    * gibt die Figur an die Engine und holt ein Array mit gueltigen Zuegen
    */
    public Feld[] figurAuswahl(Figur gewaehlteFigur) {
        aktFigur = gewaehlteFigur;
        return myEngine.bestimmeSpielzuege(gewaehlteFigur);
    }
    
   /**
    * gibt zurueck ob gewonnen wurde
    */
    public Spieler spielzugDurchfuehren(Feld zielfeld){
        if (zielfeld != null){
            if (zielfeld.getMyZiel() == aktSpieler) {
                aktSpieler.setMyGewinnSaetze(aktSpieler.getMyGewinnSaetze() + 1);
                mySatz++;
                return aktSpieler;
            }
            myEngine.spielzugDurchfuehren(aktFigur, zielfeld);
            aktSpieler = nextSpieler(aktSpieler);
        }
        // falls ein erster KI SPieler
        while (isSpielerKI(aktSpieler)) {
                if(myEngine.spielzugKI(aktSpieler)){
                    aktSpieler.setMyGewinnSaetze(aktSpieler.getMyGewinnSaetze() + 1);
                    mySatz++;
                    return aktSpieler;
                }
                aktSpieler = nextSpieler(aktSpieler);
        }
        return null;
    }
    
   /**
    * gibt zurueck wer als naechstes dran ist;
    */
    private Spieler nextSpieler(Spieler vorhergehenderSpieler){
        int index = 0;
        for (int i = 0; i < myOptions.getSpielerAnzahl(); i++) {
            if (aktSpieler.equals(mySpieler[i])) {
                index = i;
            }
        }
        if ((myOptions.getSpielerAnzahl() - 1) <= index) return mySpieler[0];
        
        return mySpieler[index+1];
    }
    /**
     * @preconditions Es existiert ein Spiel.
     * @postconditions Alles zu dem Spiel gehoerenden Objekte werden zerstoert. 
     */
    public void spielBeenden() {
        myEngine = null;
        for (int i = 0; i < myOptions.getSpielerAnzahl(); i++)
            mySpieler[i] = null;

        mySatz = 0;
    }

    /**
     * @preconditions Es exisitiert ein Spieler mit dieser SpielerNummer 
     */
    public Spieler getSpieler(int spielerNummer) {
        for (int i = 0; i < mySpieler.length; i++)
            if (mySpieler[i].getMyFarbe() == spielerNummer)
                return mySpieler[i];
        
        return null;
    }

    /**
     * liefert true wenn uebergebener Spieler KI Spieler ist. Andernfalls wird false zurueckgegeben.
     */
    public boolean isSpielerKI(Spieler potKI){
        return aktSpieler.getMyStaerke() == 1 || aktSpieler.getMyStaerke() == 2 ||
            aktSpieler.getMyStaerke() == 3;
    }

    /**
     * liefert den AktuellenSpieler zurueck
     */
    public Spieler getAktSpieler() { return aktSpieler; }

    public boolean spielzugDurchfuehrenKI() {
        boolean returnWert = myEngine.spielzugKI(aktSpieler);
        if (returnWert) {
            // Da hamma wohl nen Satz gewonnen ;-)
            aktSpieler.setMyGewinnSaetze(aktSpieler.getMyGewinnSaetze() + 1);
            mySatz++;
            return true;
        }
        aktSpieler = nextSpieler(aktSpieler);
        return returnWert;
    }

    public Engine getMyEngine() { return myEngine; }
    public void setMyEngine(Engine myEngine) { this.myEngine = myEngine; }

    public Brett getMySpielBrett() { return mySpielBrett; }
    public void setMySpielBrett(Brett mySpielBrett) { this.mySpielBrett = mySpielBrett; }

    public Options getMyOptions() { return myOptions; }
    public void setMyOptions(Options myOptions) { this.myOptions = myOptions; }

    public HighscoreTable getMyHighscore() { return myHighscore; }
    public void setMyHighscore(HighscoreTable myHighscore) { this.myHighscore = myHighscore; }

    public Spieler getMySpieler(int v) { return mySpieler[v]; }

    public Spieler[] getMySpieler() { return mySpieler; }
    public void setMySpieler(Spieler[] mySpieler) { this.mySpieler = mySpieler; }

    public int getMySatz() { return mySatz; }
    public void setMySatz(int mySatz) { this.mySatz = mySatz; }

    public boolean isMyHighScoreAn() { return myHighScoreAn; }
    public void setMyHighScoreAn(boolean myHighScoreAn) { this.myHighScoreAn = myHighScoreAn; }

    /**
     * @clientCardinality 1
     * @supplierCardinality 1 
     */
    private Brett mySpielBrett;

    /**
     * @clientCardinality 1
     * @supplierCardinality 1 
     */
    private Options myOptions;

    /**
     * @clientCardinality 1
     * @supplierCardinality 1 
     */
    private HighscoreTable myHighscore;

    /**
     * @supplierCardinality 2..4
     * @clientCardinality 1 
     */
    private Engine myEngine;
    private Spieler[] mySpieler;
    private int mySatz;
    private boolean myHighScoreAn;
    /**
     * Spieler der als naechstes dran ist
     * (pause resume etc ...)
     */
    private Spieler aktSpieler;
    private Figur aktFigur;
}