/*
 * JFrame.java
 *
 * Created on March 20, 2002, 3:53 PM
 */

import java.awt.*;
import java.io.*;
import javax.swing.*;

/**
 *
 * @author  sopr157
 */
public class wizWar extends JFrame implements Notifyable {
    public static final int TITLESCREEN = 0;
    public static final int PAUSESCREEN = 1;
    public static final int GAMESCREEN = 2;
    
    // Interne Klassenattribute
    private Image[] screenImages;
    private Image[] optionImages;
    private Image[] stoneImages;
    private Image[] highScoresImages;
    private MediaTracker mediaTracker;

    private int gameScreen = TITLESCREEN;
    private boolean gameStarted = false; // Spiel gestartet
    private boolean gamePaused = false;  // Spiel im Pause-Modus
    private GamePane gamePane;
    private Options gameOptions;
    private HighscoreTable gameHighScores;
    private IOControl gameIOControl;
    private Spiel game;
    
    private OptionsDialog gameOptionsDialog;
    private HighScoresDialog gameHighScoresDialog;
    private HelpFrame gameHelpFrame;
    private AboutDialog gameAboutDialog;
    
    private String path;
    
    // Bilder
    private static final String imgPrefix = "images" + File.separatorChar;
    
    private static final String[] screenImageFileNames = {
        imgPrefix + "title.jpg",
        imgPrefix + "pause.jpg",
        imgPrefix + "game.jpg"
    };

    private static final String[] optionImageFileNames = {
        imgPrefix + "bloody_mary_small.jpg",
        imgPrefix + "gamdalf_small.jpg",
        imgPrefix + "khan_small.jpg",
        imgPrefix + "hoodoo_voodoo_small.jpg"
    };
    
    private static final String[] stoneImageFileNames = {
        imgPrefix + "red_water.gif",
        imgPrefix + "red_fire.gif",
        imgPrefix + "red_bat.gif",
        imgPrefix + "blue_water.gif",
        imgPrefix + "blue_fire.gif",
        imgPrefix + "blue_bat.gif",
        imgPrefix + "yellow_water.gif",
        imgPrefix + "yellow_fire.gif",
        imgPrefix + "yellow_bat.gif",
        imgPrefix + "green_water.gif",
        imgPrefix + "green_fire.gif",
        imgPrefix + "green_bat.gif"
    };
    
    private static final String[] highScoresImageFileNames = {
        imgPrefix + "high_scores.jpg"
    };
    
    /** Creates new form JFrame */
    public wizWar() {
        // Pfad bestimmen, Systemunabh?ngig
/*        StringBuffer p = new StringBuffer(getClass().
            getResource("wizWar.class").getPath());
        
        if (p.length() > 0 && p.charAt(0) == '/') p.deleteCharAt(0);
        for (int i = 0; i < p.length(); i++)
            if (p.charAt(i) == '/') p.setCharAt(i, File.separatorChar);
            
        int li = p.lastIndexOf(new StringBuffer().append(
            File.separatorChar).toString());
        path = p.substring(0, li >= 0 ? li : 0);
*/
        // Pfad bestimmen
        String p = getClass().getResource("wizWar.class").getPath();
        path = p.substring(0, p.lastIndexOf(File.separatorChar));

        // Startup Meldungen ;-)
        System.out.println("wizWar 0.1 starting...");
        System.out.println("welcome \"" + System.getProperty("user.name") + "\"!");
        System.out.println("running on " + System.getProperty("os.name") + " [" +
            System.getProperty("os.arch") + "], version " + System.getProperty("os.version"));
        System.out.println("current directory is: " + path);
        System.out.println("loading images...");
        
        // Splash Screen anzeigen
        SplashScreen splash = new SplashScreen();
        splash.show();
        
        // Bilder laden
        MediaTracker mt = new MediaTracker(this);
        doLoadImagesAndWait(mt, path, screenImageFileNames,     screenImages =     new Image[3]);
        doLoadImagesAndWait(mt, path, optionImageFileNames,     optionImages =     new Image[4]);
        doLoadImagesAndWait(mt, path, stoneImageFileNames,      stoneImages =      new Image[12]);
        doLoadImagesAndWait(mt, path, highScoresImageFileNames, highScoresImages = new Image[1]);
        
        // Dialoge initialisieren
        System.out.println("initializing user interface...");
        gameOptionsDialog = new OptionsDialog(this, optionImages);
        gameHighScoresDialog = new HighScoresDialog(this, highScoresImages[0]);
        gameHelpFrame = new HelpFrame();
        gameAboutDialog = new AboutDialog(this);
        
        // Spiel-Objekt laden
        System.out.println("loading game engine...");
        gameIOControl = new IOControl(path + File.separatorChar + "etc");
        
        // Optionen laden
        gameOptions = gameIOControl.loadOptions();
        
        // Spiel initialisieren
        game = new Spiel();
        game.setOptions(gameOptions);
        
        // Splash Screen verstecken
        splash.setVisible(false);
        splash.dispose();
        
        // Komponenten initialisieren
        initComponents();
        
        // Spielbildschirm aufbauen
        gamePane = new GamePane(screenImages, stoneImages);
        gamePane.setPreferredSize(new Dimension(800, 600));
        getContentPane().add(gamePane, BorderLayout.CENTER);
        pack();
    }

    public void doLoadImagesAndWait(MediaTracker mt, String imgPath,
        String[] imageFileNames, Image[] images) {
        Toolkit tk = getToolkit();
        
        for (int i = 0; i < imageFileNames.length; i++) {
            System.out.println("        " + imgPath + File.separatorChar + imageFileNames[i]);
            images[i] = tk.getImage(imgPath + File.separatorChar + imageFileNames[i]);
            mt.addImage(images[i], i);
        }

        try {
            mt.waitForAll();
        } catch (InterruptedException e) {
            System.out.println("<" + e.getClass() + ">: " + e.getMessage());
            System.exit(1);
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        MainMenuBar = new javax.swing.JMenuBar();
        GameMenu = new javax.swing.JMenu();
        GameNew = new javax.swing.JMenuItem();
        GameLoadMenuItem = new javax.swing.JMenuItem();
        GameSaveMenuItem = new javax.swing.JMenuItem();
        GameSeparator1 = new javax.swing.JSeparator();
        GameUndoMenuItem = new javax.swing.JMenuItem();
        GamePauseResumeMenuItem = new javax.swing.JMenuItem();
        GameSeparator2 = new javax.swing.JSeparator();
        GameOptionsMenuItem = new javax.swing.JMenuItem();
        GameHighScoresItem = new javax.swing.JMenuItem();
        GameSeparator3 = new javax.swing.JSeparator();
        GameExitMenuItem = new javax.swing.JMenuItem();
        HelpMenu = new javax.swing.JMenu();
        HelpInstructionsMenuItem = new javax.swing.JMenuItem();
        HelpSeparator1 = new javax.swing.JSeparator();
        HelpAboutMenuItem = new javax.swing.JMenuItem();
        
        GameMenu.setText("Spiel");
        GameMenu.setFont(new java.awt.Font("Dialog", 0, 11));
        GameNew.setFont(new java.awt.Font("Dialog", 0, 11));
        GameNew.setText("Neu");
        GameNew.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                GameNewActionPerformed(evt);
            }
        });
        
        GameMenu.add(GameNew);
        GameLoadMenuItem.setFont(new java.awt.Font("Dialog", 0, 11));
        GameLoadMenuItem.setText("Laden...");
        GameLoadMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                GameLoadMenuItemActionPerformed(evt);
            }
        });
        
        GameMenu.add(GameLoadMenuItem);
        GameSaveMenuItem.setFont(new java.awt.Font("Dialog", 0, 11));
        GameSaveMenuItem.setText("Speichern...");
        GameSaveMenuItem.setEnabled(false);
        GameSaveMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                GameSaveMenuItemActionPerformed(evt);
            }
        });
        
        GameMenu.add(GameSaveMenuItem);
        GameMenu.add(GameSeparator1);
        GameUndoMenuItem.setFont(new java.awt.Font("Dialog", 0, 11));
        GameUndoMenuItem.setText("Rueckgaengig");
        GameUndoMenuItem.setEnabled(false);
        GameUndoMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                GameUndoMenuItemActionPerformed(evt);
            }
        });
        
        GameMenu.add(GameUndoMenuItem);
        GamePauseResumeMenuItem.setFont(new java.awt.Font("Dialog", 0, 11));
        GamePauseResumeMenuItem.setText("Pause/Fortsetzen");
        GamePauseResumeMenuItem.setEnabled(false);
        GamePauseResumeMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                GamePauseResumeMenuItemActionPerformed(evt);
            }
        });
        
        GameMenu.add(GamePauseResumeMenuItem);
        GameMenu.add(GameSeparator2);
        GameOptionsMenuItem.setFont(new java.awt.Font("Dialog", 0, 11));
        GameOptionsMenuItem.setText("Optionen...");
        GameOptionsMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                GameOptionsMenuItemActionPerformed(evt);
            }
        });
        
        GameMenu.add(GameOptionsMenuItem);
        GameHighScoresItem.setFont(new java.awt.Font("Dialog", 0, 11));
        GameHighScoresItem.setText("High Scores Anzeigen...");
        GameHighScoresItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                GameHighScoresItemActionPerformed(evt);
            }
        });
        
        GameMenu.add(GameHighScoresItem);
        GameMenu.add(GameSeparator3);
        GameExitMenuItem.setFont(new java.awt.Font("Dialog", 0, 11));
        GameExitMenuItem.setText("Beenden");
        GameExitMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                GameExitMenuItemActionPerformed(evt);
            }
        });
        
        GameMenu.add(GameExitMenuItem);
        MainMenuBar.add(GameMenu);
        HelpMenu.setText("Hilfe");
        HelpMenu.setFont(new java.awt.Font("Dialog", 0, 11));
        HelpInstructionsMenuItem.setFont(new java.awt.Font("Dialog", 0, 11));
        HelpInstructionsMenuItem.setText("Anleitung...");
        HelpInstructionsMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                HelpInstructionsMenuItemActionPerformed(evt);
            }
        });
        
        HelpMenu.add(HelpInstructionsMenuItem);
        HelpMenu.add(HelpSeparator1);
        HelpAboutMenuItem.setFont(new java.awt.Font("Dialog", 0, 11));
        HelpAboutMenuItem.setText("Info...");
        HelpAboutMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                HelpAboutMenuItemActionPerformed(evt);
            }
        });
        
        HelpMenu.add(HelpAboutMenuItem);
        MainMenuBar.add(HelpMenu);
        
        setTitle("wizWar");
        setFont(new java.awt.Font("", 0, 11));
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });
        
        setJMenuBar(MainMenuBar);
        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(800, 600));
        setLocation((screenSize.width-800)/2,(screenSize.height-600)/2);
    }//GEN-END:initComponents

    private void GameUndoMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_GameUndoMenuItemActionPerformed
        if (gameStarted) {
            gamePane.setGame(gameIOControl.undo());
            gamePane.setScreen(GAMESCREEN);
        }
    }//GEN-LAST:event_GameUndoMenuItemActionPerformed

    private void HelpInstructionsMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_HelpInstructionsMenuItemActionPerformed
        gameHelpFrame.show();
    }//GEN-LAST:event_HelpInstructionsMenuItemActionPerformed

    private void GameHighScoresItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_GameHighScoresItemActionPerformed
        gameHighScoresDialog.setHighScoresTable(gameHighScores);
        gameHighScoresDialog.show();
    }//GEN-LAST:event_GameHighScoresItemActionPerformed

    private void doUpdateMenuItems() {
        GameSaveMenuItem.setEnabled(gameStarted);
        GamePauseResumeMenuItem.setEnabled(gameStarted);
        GameUndoMenuItem.setEnabled(gameStarted);
        GameOptionsMenuItem.setEnabled(true);//!gameStarted);
    }
    
    public void notifyMe() {
        game.neuesSpiel();
        gamePane.setGame(game);
        gamePane.setIOControl(gameIOControl);
        gamePane.setNotifyable(this);
        if (game.getMySatz() == 2) {
            Spieler sp;
            int sn = 0;
            int mr = 0;
            
            for (int i = 0; i < 4; i++)
                if ((sp = game.getMySpieler(i)) != null) {
                    if (sp.getMyGewinnSaetze() > mr) {
                        mr = sp.getMyGewinnSaetze();
                        sn = i;
                    }
                }
            
            if (mr > 0) {
                gameHighScores.eintragEinfuegen(game.getMySpieler(sn), mr);
                
                JOptionPane.showConfirmDialog(this,
                    game.getMySpieler(sn).getMyName() + " hat gewonnen.",
                    "Hurra!", JOptionPane.OK_OPTION);
                
                gameHighScoresDialog.setHighScoresTable(gameHighScores);
                gameHighScoresDialog.show();
            }
        }
    }
    
    private void GameNewActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_GameNewActionPerformed
        if (gameStarted && JOptionPane.showConfirmDialog(this, "Sind Sie sich" +
            "er, dass Sie das aktuelle Spiel beenden wollen?", "wizWar",
            JOptionPane.YES_NO_OPTION) == JOptionPane.NO_OPTION) return;
        
        gameStarted = true;
        doUpdateMenuItems();

        game.setMySatz(0);
        game.neuesSpiel();
        gamePane.setGame(game);
        gamePane.setIOControl(gameIOControl);
        gamePane.setNotifyable(this);
        gamePane.setScreen(GAMESCREEN);
    }//GEN-LAST:event_GameNewActionPerformed

    private void GameLoadMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_GameLoadMenuItemActionPerformed
        if (gameStarted && JOptionPane.showConfirmDialog(this, "Sind Sie sich" +
            "er, dass Sie das aktuelle Spiel beenden wollen?", "wizWar",
            JOptionPane.YES_NO_OPTION) == JOptionPane.NO_OPTION) return;
        
        JFileChooser chooser = new JFileChooser();
        
        if (chooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
            game = gameIOControl.spielLaden(chooser.getSelectedFile().getName());
            gamePane.setGame(game);
            gamePane.setScreen(GAMESCREEN);
        }
        
/*        SelectGameSlotDialog loadGameSlotDialog = new SelectGameSlotDialog(this, true);
        
        loadGameSlotDialog.show();
        if (loadGameSlotDialog.getModalResult() == ModalDialog.OK) {
            
            //myGame.spielLaden();
        }
        
        loadGameSlotDialog.dispose();*/
    }//GEN-LAST:event_GameLoadMenuItemActionPerformed

    private void GameSaveMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_GameSaveMenuItemActionPerformed
        JFileChooser chooser = new JFileChooser();
        
        if (chooser.showSaveDialog(this) == JFileChooser.APPROVE_OPTION)
            gameIOControl.spielSpeichern(chooser.getSelectedFile().getName(), game);
        
/*        SelectGameSlotDialog saveGameSlotDialog = new SelectGameSlotDialog(this, false);
        
        saveGameSlotDialog.show();
        if (saveGameSlotDialog.getModalResult() == ModalDialog.OK) {
            //myGame.spielSpeichern();
        }
        
        saveGameSlotDialog.dispose();*/
    }//GEN-LAST:event_GameSaveMenuItemActionPerformed

    private void GamePauseResumeMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_GamePauseResumeMenuItemActionPerformed
        if (!gameStarted) return;
        
        gamePaused = !gamePaused;
        if (gamePaused)
            gamePane.setScreen(PAUSESCREEN);
        else
            gamePane.setScreen(GAMESCREEN);
    }//GEN-LAST:event_GamePauseResumeMenuItemActionPerformed

    private void GameOptionsMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_GameOptionsMenuItemActionPerformed
        gameOptionsDialog.setOptions(gameOptions);
        gameOptionsDialog.show();
        if (gameOptionsDialog.getModalResult() == ModalDialog.OK) {
            gameOptions = gameOptionsDialog.getOptions();

            System.out.println("saving options...");
            gameIOControl.saveOptions(gameOptions);

            System.out.println("saving highscores...");
            gameIOControl.saveHighScores(gameHighScores);
        }
    }//GEN-LAST:event_GameOptionsMenuItemActionPerformed

    private void GameExitMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_GameExitMenuItemActionPerformed
        exitForm(null);
    }//GEN-LAST:event_GameExitMenuItemActionPerformed

    private void HelpAboutMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_HelpAboutMenuItemActionPerformed
        gameAboutDialog.show();
    }//GEN-LAST:event_HelpAboutMenuItemActionPerformed

    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        if (gameStarted && JOptionPane.showConfirmDialog(this, "Sind Sie sich" +
            "er, dass Sie das aktuelle Spiel beenden wollen?", "wizWar",
            JOptionPane.YES_NO_OPTION) == JOptionPane.NO_OPTION) return;
        
        System.out.println("saving options...");
        gameIOControl.saveOptions(gameOptions);

        System.out.println("saving highscores...");
        gameIOControl.saveHighScores(gameHighScores);

        System.exit(0);
    }//GEN-LAST:event_exitForm

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuBar MainMenuBar;
    private javax.swing.JMenu GameMenu;
    private javax.swing.JMenuItem GameNew;
    private javax.swing.JMenuItem GameLoadMenuItem;
    private javax.swing.JMenuItem GameSaveMenuItem;
    private javax.swing.JSeparator GameSeparator1;
    private javax.swing.JMenuItem GameUndoMenuItem;
    private javax.swing.JMenuItem GamePauseResumeMenuItem;
    private javax.swing.JSeparator GameSeparator2;
    private javax.swing.JMenuItem GameOptionsMenuItem;
    private javax.swing.JMenuItem GameHighScoresItem;
    private javax.swing.JSeparator GameSeparator3;
    private javax.swing.JMenuItem GameExitMenuItem;
    private javax.swing.JMenu HelpMenu;
    private javax.swing.JMenuItem HelpInstructionsMenuItem;
    private javax.swing.JSeparator HelpSeparator1;
    private javax.swing.JMenuItem HelpAboutMenuItem;
    // End of variables declaration//GEN-END:variables

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        new wizWar().show();
    }
}