{
  (c)2002 by Christian Blichmann

  http://www.blichmann.de/en/programming/delphi/translucency/index.html
  feedback@blichmann.de

  This is freeware. Distribution, modification allowed, as long as proper
  credit is given.

  Have fun!
}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    procedure WMNCHitTest(var Message: TWMNCHitTest);message WM_NCHITTEST;
  public
  end;

var
  Form1: TForm1;

implementation

uses
  G32, G32_Filters; // This includes the Graphics32 library

{$R *.DFM}

const
  WS_EX_LAYERED = $80000;

  AC_SRC_OVER = $0;
  AC_SRC_ALPHA = $1;
  AC_SRC_NO_PREMULT_ALPHA = $1;
  AC_SRC_NO_ALPHA = $2;
  AC_DST_NO_PREMULT_ALPHA = $10;
  AC_DST_NO_ALPHA = $20;

  LWA_COLORKEY = $1;
  LWA_ALPHA = $2;

  ULW_COLORKEY = $1;
  ULW_ALPHA =$2;
  ULW_OPAQUE = $4;

function SetLayeredWindowAttributes(hwnd: HWND; crKey: TColor; bAlpha: byte;
  dwFlags: DWORD): BOOL; stdcall; external 'user32.dll';

function UpdateLayeredWindow(hwnd: HWND; hdcDst: HDC; pptDst: PPoint;
  psize: PSize; hdcSrc: HDC; pptSrc: PPoint; crKey: TColor;
  pblend: PBlendFunction; dwFlags: DWORD): BOOL; stdcall; external 'user32.dll';

{ TForm1 }
procedure TForm1.WMNCHitTest(var Message: TWMNCHitTest);
begin
  Message.Result := HTCaption;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
{ Insert here }
  AlphaBmp, SkinBmp: TBitmap32;
{ Insert end }
  TopLeft, BmpTopLeft: TPoint;
  Blend: TBlendFunction;
  WorkBmp: TBitmap;
  BmpSize: TSize;
  DC: HDC;
begin
  Button1.Enabled := False;

  if SetWindowLong(Handle, GWL_EXSTYLE, WS_EX_LAYERED) = 0 then Exit;

  WorkBmp := nil;
{ Insert here }
  AlphaBmp := nil;
  SkinBmp := nil;
{ Insert end }

  try
    WorkBmp := TBitmap.Create;
    with WorkBmp, Canvas, BmpSize do
    begin
      cx := ClientWidth;
      cy := ClientHeight;

      PixelFormat := pf32Bit;
      Width :=  cx;
      Height := cy;
      { Comment this out, or delete: }
      //CopyRect(Bounds(0, 0, cx, cy), GetFormImage.Canvas, Bounds(0, 0, cx, cy));
      { Comment this out end }
    end;

    { Insert here }
    AlphaBmp := TBitmap32.Create;
    AlphaBmp.LoadFromFile('circle_alpha.bmp');

    SkinBmp := TBitmap32.Create;
    with SkinBmp do
    begin
      LoadFromFile('circle.bmp');
      IntensityToAlpha(SkinBmp, AlphaBmp);

      DrawTo(WorkBmp.Canvas.Handle, 0, 0);
    end;

    { Insert end }
    TopLeft := BoundsRect.TopLeft;
    BmpTopLeft := Point(0, 0);
    
    DC := GetDC(0);
    if not Win32Check(LongBool(DC)) then
      RaiseLastWin32Error;

    with Blend do
    begin
      BlendOp :=             AC_SRC_OVER;
      BlendFlags :=          0;
      { Change here }
      SourceConstantAlpha := {*}255{*};
      AlphaFormat :=         {*}AC_SRC_ALPHA{*};
      { Change end }
    end;

    if not Win32Check(UpdateLayeredWindow(Handle, DC, @TopLeft, @BmpSize,
      WorkBmp.Canvas.Handle, @BmpTopLeft, clNone, @Blend, ULW_ALPHA)) then
      RaiseLastWin32Error;
  finally
    WorkBmp.Free;
    { Insert here }
    AlphaBmp.Free;
    SkinBmp.Free;
    { Insert end }
  end;
end;

end.
 
