/*
 * Decompiled with CFR 0.152.
 */
package VisBdd;

import VisBdd.Bdd;
import VisBdd.Spline;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.LinkedList;
import java.util.ListIterator;

public class Node {
    Node high;
    Node low;
    boolean mark = false;
    int index;
    int posX;
    int posY;
    static int maxDepth = 0;
    static int maxNodeAndEdge = 0;
    static int stepNumber = 0;
    static boolean drawZeroLeaf = false;
    static boolean drawOneLeaf = false;
    static LinkedList collisionTable = new LinkedList();
    static final int ONE = -1;
    static final int ZERO = -2;
    static int[][] varCount = new int[100][2];
    static BasicStroke bs;

    Node(int n) {
        this.index = n;
        this.high = null;
        this.low = null;
    }

    Node(int n, Node node, Node node2) {
        this.index = n;
        this.high = node;
        this.low = node2;
    }

    boolean is_leaf() {
        return this.high == null && this.low == null && (this.index == -1 || this.index == -2);
    }

    void unmark() {
        this.mark = false;
        if (!this.is_leaf()) {
            this.high.unmark();
            this.low.unmark();
        }
    }

    public int value() {
        return this.index;
    }

    public String toString() {
        String string;
        switch (this.index) {
            case -1: {
                string = new String("1");
                break;
            }
            case -2: {
                string = new String("0");
                break;
            }
            default: {
                string = new String("(x[" + Integer.toString(this.index) + "]," + this.high + "," + this.low + ")");
            }
        }
        return string;
    }

    public String getNodeName() {
        return "x" + Integer.toString(this.index);
    }

    public void countIndex() {
        if (!this.is_leaf()) {
            if (!this.mark) {
                this.mark = true;
                if (varCount[this.index][0] == 0) {
                    ++maxDepth;
                    ++maxNodeAndEdge;
                }
                int[] nArray = varCount[this.index];
                nArray[0] = nArray[0] + 1;
                int[] nArray2 = varCount[this.index];
                nArray2[1] = nArray2[1] + 1;
            }
            ++maxNodeAndEdge;
            this.high.countIndex();
            ++maxNodeAndEdge;
            this.low.countIndex();
        }
    }

    public void countEdges() {
        if (!this.is_leaf()) {
            if (!this.mark) {
                this.mark = true;
                ++maxDepth;
                ++maxNodeAndEdge;
            }
            ++maxNodeAndEdge;
            this.high.countEdges();
            ++maxNodeAndEdge;
            this.low.countEdges();
        } else {
            ++maxNodeAndEdge;
        }
    }

    public void countMaxNodeAndEdge() {
        maxDepth = 0;
        maxNodeAndEdge = 0;
        this.unmark();
        this.countEdges();
        this.unmark();
    }

    public int maxNodeCount() {
        maxDepth = 0;
        this.countIndex();
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        while (n3 < 100) {
            if (n < Math.max(varCount[n3][0], n)) {
                n2 = n3;
                n = Math.max(varCount[n3][0], n);
            }
            ++n3;
        }
        this.unmark();
        return n;
    }

    public void resetNodeCount() {
        int n = 1;
        while (n < 100) {
            Node.varCount[n][0] = 0;
            Node.varCount[n][1] = 0;
            ++n;
        }
    }

    public int trimSpace(int n, Bdd bdd) {
        int n2 = 0;
        int n3 = 1;
        while (n3 < n) {
            if (varCount[bdd.getVarOfPos(n3)][0] == 0) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public int printi() {
        return this.index;
    }

    public boolean checkCollision(Point point, Point point2, double d, double d2, int n, Point point3, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            double d3 = ((double)point3.y - d2) / d;
            double d4 = d * (double)point3.x + d2;
            if ((double)point3.x - d3 > (double)(-n / 2) && (double)point3.x - d3 < (double)(n / 2) && (double)point3.x - d3 > (double)(-n / 2) && (double)point3.x - d3 < (double)(n / 2)) {
                bl4 = true;
            }
            if (point.x < point2.x) {
                if (point3.x >= point.x && point3.x <= point2.x) {
                    bl2 = true;
                }
            } else if (point3.x <= point.x && point3.x >= point2.x) {
                bl2 = true;
            }
            if (point.y < point2.y) {
                if (point3.y >= point.y && point3.y <= point2.y) {
                    bl3 = true;
                }
            } else if (point3.y <= point.y && point3.y >= point2.y) {
                bl3 = true;
            }
            return bl2 && bl3 && bl4;
        }
        if (point.y < point2.y) {
            return point3.x == point.x && point3.y >= point.y && point3.y <= point2.y;
        }
        return point3.x == point.x && point3.y <= point.y && point3.y >= point2.y;
    }

    public void drawLine(Graphics2D graphics2D, Point point, Point point2, int n) {
        Point point3;
        double d = 0.0;
        double d2 = 0.0;
        ListIterator listIterator = collisionTable.listIterator();
        LinkedList<Point> linkedList = new LinkedList<Point>();
        LinkedList<Point> linkedList2 = new LinkedList<Point>();
        Point point4 = new Point();
        boolean bl = false;
        boolean bl2 = false;
        linkedList.addLast(point);
        linkedList2.addFirst(point2);
        while (linkedList2.size() > 0) {
            point = (Point)linkedList.getLast();
            point2 = (Point)linkedList2.getFirst();
            if (point2.x - point.x != 0) {
                d = (double)(point2.y - point.y) / (double)(point2.x - point.x);
                d2 = (double)point.y - d * (double)point.x;
                bl2 = false;
            } else {
                bl2 = true;
            }
            bl = false;
            while (listIterator.hasNext() && !bl) {
                point3 = (Point)listIterator.next();
                if (point.x == point3.x && point.y == point3.y || point2.x == point3.x && point2.y == point3.y || !this.checkCollision(point, point2, d, d2, n, point3, bl2)) continue;
                point4.x = point3.x + n;
                point4.y = point3.y;
                linkedList2.addFirst(new Point(point4.x, point4.y));
                listIterator = collisionTable.listIterator();
                while (listIterator.hasNext()) {
                    point3 = (Point)listIterator.next();
                    if (point4.x != point3.x || point4.y != point3.y) continue;
                    point4.x += 5;
                    listIterator = collisionTable.listIterator();
                }
                listIterator = collisionTable.listIterator();
                bl = true;
            }
            if (bl) continue;
            linkedList.addLast((Point)linkedList2.removeFirst());
        }
        if (linkedList.size() > 2) {
            int n2 = -1;
            int n3 = 999;
            int n4 = -999;
            Spline spline = new Spline(linkedList.size() + 2, 0.0);
            while (linkedList.size() > 0) {
                n3 = Math.min(((Point)linkedList.getFirst()).y, n3);
                n4 = Math.max(((Point)linkedList.getFirst()).y, n4);
                spline.add(((Point)linkedList.getFirst()).y, ((Point)linkedList.getFirst()).x, 1.0);
                n2 = ((Point)linkedList.getFirst()).y;
                collisionTable.addLast(linkedList.removeFirst());
            }
            spline.calcSpline(0.1);
            int n5 = n3;
            int n6 = (int)spline.get(n5);
            int n7 = this.isDashed() ? 5 : 1;
            int n8 = n3 + n7;
            while (n8 <= n4) {
                int n9 = (int)spline.get(n8);
                graphics2D.drawLine(n6, n5, n9, n8);
                n5 = n8;
                n6 = n9;
                n8 += n7;
            }
            graphics2D.drawLine(n6, n5, (int)spline.get(n4), n4);
        } else {
            graphics2D.drawLine(((Point)linkedList.getFirst()).x, ((Point)linkedList.getFirst()).y, ((Point)linkedList.getLast()).x, ((Point)linkedList.getLast()).y);
            while (linkedList.size() > 0) {
                collisionTable.addLast(linkedList.removeFirst());
            }
        }
        listIterator = collisionTable.listIterator();
        while (listIterator.hasNext()) {
            point3 = (Point)listIterator.next();
        }
    }

    public void printCollisionTable() {
        ListIterator listIterator = collisionTable.listIterator();
        while (listIterator.hasNext()) {
            Point point = (Point)listIterator.next();
        }
    }

    public void fillCollisionTable(Bdd bdd, int n, int n2) {
        if (!this.mark) {
            int n3;
            int n4;
            int n5;
            this.mark = true;
            int n6 = this.trimSpace(bdd.getSortPos(this.index), bdd);
            int n7 = varCount[this.index][0] == 1 ? n / 2 : 40 + (varCount[this.index][0] - varCount[this.index][1]) * ((n - 80) / varCount[this.index][0]) + (n - 80) / (2 * varCount[this.index][0]);
            int n8 = 40 + (n2 - 80) / maxDepth * (bdd.getSortPos(this.index) - n6 - 1);
            this.posX = n7;
            this.posY = n8;
            int[] nArray = varCount[this.index];
            nArray[1] = nArray[1] - 1;
            if (!this.high.is_leaf()) {
                n5 = this.trimSpace(bdd.getSortPos(this.high.index), bdd);
                if (!this.high.mark) {
                    n4 = varCount[this.high.index][0] == 1 ? n / 2 : 40 + (varCount[this.high.index][0] - varCount[this.high.index][1]) * ((n - 80) / varCount[this.high.index][0]) + (n - 80) / (2 * varCount[this.high.index][0]);
                    n3 = 40 + (n2 - 80) / maxDepth * (bdd.getSortPos(this.high.index) - n5 - 1);
                    collisionTable.addLast(new Point(n4, n3));
                }
                this.high.fillCollisionTable(bdd, n, n2);
            }
            if (!this.low.is_leaf()) {
                n5 = this.trimSpace(bdd.getSortPos(this.low.index), bdd);
                if (!this.low.mark) {
                    n4 = varCount[this.low.index][0] == 1 ? n / 2 : 40 + (varCount[this.low.index][0] - varCount[this.low.index][1]) * ((n - 80) / varCount[this.low.index][0]) + (n - 80) / (2 * varCount[this.low.index][0]);
                    n3 = 40 + (n2 - 80) / maxDepth * (bdd.getSortPos(this.low.index) - n5 - 1);
                    collisionTable.addLast(new Point(n4, n3));
                }
                this.low.fillCollisionTable(bdd, n, n2);
            }
        }
    }

    public void drawNode(Node node, Graphics2D graphics2D, Bdd bdd, int n, int n2, int n3, int n4, boolean bl, int n5, Color color) {
        Color color2 = Color.white;
        boolean bl2 = false;
        boolean bl3 = false;
        if (++stepNumber <= n4) {
            bl2 = true;
        }
        if (stepNumber == n5) {
            color2 = color;
        }
        if (!this.mark) {
            int n6;
            int n7;
            int n8;
            this.mark = true;
            int n9 = this.trimSpace(bdd.getSortPos(this.index), bdd);
            int n10 = varCount[this.index][0] == 1 ? n / 2 : 40 + (varCount[this.index][0] - varCount[this.index][1]) * ((n - 80) / varCount[this.index][0]) + (n - 80) / (2 * varCount[this.index][0]);
            int n11 = 40 + (n2 - 80) / maxDepth * (bdd.getSortPos(this.index) - n9 - 1);
            this.posX = n10;
            this.posY = n11;
            int[] nArray = varCount[this.index];
            nArray[1] = nArray[1] - 1;
            this.setStroke(graphics2D, false);
            if (!this.high.is_leaf()) {
                ++stepNumber;
                n8 = this.trimSpace(bdd.getSortPos(this.high.index), bdd);
                if (this.high.mark) {
                    if (stepNumber <= n4 || !bl) {
                        this.drawLine(graphics2D, new Point(n10, n11), new Point(this.high.posX, this.high.posY), 40);
                    }
                } else {
                    n7 = varCount[this.high.index][0] == 1 ? n / 2 : 40 + (varCount[this.high.index][0] - varCount[this.high.index][1]) * ((n - 80) / varCount[this.high.index][0]) + (n - 80) / (2 * varCount[this.high.index][0]);
                    n6 = 40 + (n2 - 80) / maxDepth * (bdd.getSortPos(this.high.index) - n8 - 1);
                    if (stepNumber <= n4 || !bl) {
                        this.drawLine(graphics2D, new Point(n10, n11), new Point(n7, n6), 40);
                    }
                }
                this.high.drawNode(this.high, graphics2D, bdd, n, n2, n3, n4, bl, n5, color);
            } else if (this.high.index == -1) {
                if ((stepNumber += 2) <= n4 || !bl) {
                    this.drawLine(graphics2D, new Point(n10, n11), new Point(n / 3, n2 - 20), 40);
                    if (bl) {
                        drawOneLeaf = true;
                    }
                }
            } else if ((stepNumber += 2) <= n4 || !bl) {
                this.drawLine(graphics2D, new Point(n10, n11), new Point(2 * n / 3, n2 - 20), 40);
                if (bl) {
                    drawZeroLeaf = true;
                }
            }
            this.setStroke(graphics2D, true);
            if (stepNumber == n4) {
                bl2 = true;
            }
            if (!this.low.is_leaf()) {
                ++stepNumber;
                n8 = this.trimSpace(bdd.getSortPos(this.low.index), bdd);
                if (this.low.mark) {
                    if (stepNumber <= n4 || !bl) {
                        this.drawLine(graphics2D, new Point(n10, n11), new Point(this.low.posX, this.low.posY), 40);
                    }
                } else {
                    n7 = varCount[this.low.index][0] == 1 ? n / 2 : 40 + (varCount[this.low.index][0] - varCount[this.low.index][1]) * ((n - 80) / varCount[this.low.index][0]) + (n - 80) / (2 * varCount[this.low.index][0]);
                    n6 = 40 + (n2 - 80) / maxDepth * (bdd.getSortPos(this.low.index) - n8 - 1);
                    if (stepNumber <= n4 || !bl) {
                        this.drawLine(graphics2D, new Point(n10, n11), new Point(n7, n6), 40);
                    }
                }
                this.low.drawNode(this.low, graphics2D, bdd, n, n2, n3, n4, bl, n5, color);
            } else if (this.low.index == -1) {
                if ((stepNumber += 2) <= n4 || !bl) {
                    this.drawLine(graphics2D, new Point(n10, n11), new Point(n / 3, n2 - 20), 40);
                    if (bl) {
                        drawOneLeaf = true;
                    }
                }
            } else if ((stepNumber += 2) <= n4 || !bl) {
                this.drawLine(graphics2D, new Point(n10, n11), new Point(2 * n / 3, n2 - 20), 40);
                if (bl) {
                    drawZeroLeaf = true;
                }
            }
        } else {
            if (!this.high.is_leaf()) {
                if (this.high.mark) {
                    ++stepNumber;
                }
                this.high.drawNode(this.high, graphics2D, bdd, n, n2, n3, n4, bl, n5, color);
            } else {
                stepNumber = this.high.index == -1 ? (stepNumber += 2) : (stepNumber += 2);
            }
            if (!this.low.is_leaf()) {
                if (this.high.mark) {
                    ++stepNumber;
                }
                this.low.drawNode(this.low, graphics2D, bdd, n, n2, n3, n4, bl, n5, color);
            } else {
                stepNumber = this.low.index == -1 ? (stepNumber += 2) : (stepNumber += 2);
            }
        }
        if (bl2 || !bl) {
            this.setStroke(graphics2D, false);
            graphics2D.setColor(color2);
            graphics2D.fillOval(this.posX - 15, this.posY - 10, 30, 20);
            graphics2D.setColor(Color.black);
            graphics2D.drawOval(this.posX - 15, this.posY - 10, 30, 20);
            graphics2D.drawString("x" + this.index, this.posX - 8, this.posY + 5);
        }
        bl2 = false;
    }

    public void drawGraph(Graphics2D graphics2D, Bdd bdd, int n, int n2, String string, int n3, boolean bl, int n4, Color color) {
        drawZeroLeaf = false;
        drawOneLeaf = false;
        stepNumber = 0;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        collisionTable.clear();
        if (!this.is_leaf()) {
            this.unmark();
            maxDepth = 0;
            this.resetNodeCount();
            int n5 = this.maxNodeCount();
            this.fillCollisionTable(bdd, n, n2);
        }
        this.unmark();
        Font font = new Font("monospaced", 1, 10);
        graphics2D.setFont(font);
        graphics2D.setColor(Color.black);
        int n6 = 0;
        int n7 = 0;
        int n8 = 10;
        n7 = string.indexOf("\n", n6);
        while (n7 != -1) {
            graphics2D.drawString(string.substring(n6, n7), 15, n8);
            n8 += 10;
            n6 = n7 + 1;
            n7 = string.indexOf("\n", n6);
        }
        graphics2D.drawString(string.substring(n6, string.length()), 15, n8);
        Font font2 = new Font("monospaced", 1, 12);
        graphics2D.setFont(font2);
        if (!this.is_leaf()) {
            maxDepth = 0;
            this.resetNodeCount();
            int n9 = this.maxNodeCount();
            graphics2D.drawLine(n / 2, 11, n / 2, 29);
            graphics2D.drawLine(n / 2 - 4, 22, n / 2, 29);
            graphics2D.drawLine(n / 2 + 4, 22, n / 2, 29);
            this.drawNode(this, graphics2D, bdd, n, n2, n9, n3, bl, n4, color);
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(n / 3 - 15, n2 - 24, 30, 15);
            graphics2D.fillRect(2 * n / 3 - 15, n2 - 24, 30, 15);
            graphics2D.setColor(Color.black);
            if (bl) {
                if (drawZeroLeaf) {
                    graphics2D.drawRect(2 * n / 3 - 15, n2 - 24, 30, 15);
                    graphics2D.drawString("0", 2 * n / 3 - 4, n2 - 10);
                }
                if (drawOneLeaf) {
                    graphics2D.drawRect(n / 3 - 15, n2 - 24, 30, 15);
                    graphics2D.drawString("1", n / 3 - 4, n2 - 10);
                }
            } else {
                graphics2D.drawRect(n / 3 - 15, n2 - 24, 30, 15);
                graphics2D.drawRect(2 * n / 3 - 15, n2 - 24, 30, 15);
                graphics2D.drawString("1", n / 3 - 4, n2 - 10);
                graphics2D.drawString("0", 2 * n / 3 - 4, n2 - 10);
            }
        } else {
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(n / 2 - 15, n2 / 2 - 15, 30, 15);
            graphics2D.drawString(this.toString(), n / 2 - 3, n2 / 2 - 3);
        }
    }

    public void setStroke(Graphics2D graphics2D, boolean bl) {
        if (bl) {
            float[] fArray = new float[]{2.0f};
            bs = new BasicStroke(1.0f, 0, 0, 10.0f, fArray, 0.0f);
            graphics2D.setStroke(bs);
        } else {
            bs = new BasicStroke();
            graphics2D.setStroke(bs);
        }
    }

    public boolean isDashed() {
        return bs.hashCode() == 698351616;
    }
}

