/*
 * Decompiled with CFR 0.152.
 */
package VisBdd;

import VisBdd.Bdd;
import VisBdd.BddFileFilter;
import VisBdd.BddHistory;
import VisBdd.BddPane;
import VisBdd.ExitWindow;
import VisBdd.FormulaInput;
import VisBdd.InfoDialog;
import VisBdd.IteFPane;
import VisBdd.IteGPane;
import VisBdd.IteHPane;
import VisBdd.Node;
import VisBdd.OptionsDialog;
import VisBdd.ResultPane;
import VisBdd.TreePane;
import VisBdd.Yylex;
import VisBdd.formulaTree;
import VisBdd.parser;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.List;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VisBdd
extends JFrame
implements Runnable,
ActionListener,
ChangeListener {
    public static String formel = "x[1]=>x[2]=>(x[3]*x[4]);";
    public static Bdd myBdd = new Bdd();
    public static formulaTree syntaxTree = new formulaTree();
    BddPane outPane;
    static ResultPane outResultPane;
    static IteFPane outIteFPane;
    static IteGPane outIteGPane;
    static IteHPane outIteHPane;
    static TreePane outTreePane;
    static JButton infoHPanelButton;
    static JButton infoGPanelButton;
    static JButton infoFPanelButton;
    static JButton infoResultPanelButton;
    static JButton infoTreePanelButton;
    static JComboBox visType;
    static List codeList;
    static boolean doStepIn;
    static boolean doStepOver;
    static boolean doNext;
    static JButton codeDetails;
    static JButton codeShowFinalNode;
    static JButton codeShowAbleitungsBaum;
    static JButton codeHistoryPrev;
    static JButton codeHistoryNext;
    static JButton codeHistoryStepOver;
    static JButton codeHistoryFirst;
    static JButton codeHistoryLast;
    static JButton codeHistorySpeak;
    static JButton codeHistoryInfo;
    static int stepPosition;
    static JLabel recursionLabel;
    static JSlider codeHistory;
    static boolean userSlide;
    static JButton evalFormulaButton;
    static JTextField formulaInput;
    static JTextField orderingInput;
    static boolean autoRun;
    static Integer autoTime;
    static boolean autoStepOver;
    static boolean autoLoop;
    static boolean audioComment;
    static Integer arraySize;
    static boolean startCalc;
    public boolean calc = false;
    public Thread runner;
    InfoDialog showInfo;
    static LinkedList historyList;
    static /* synthetic */ Class class$VisBdd$VisBdd;

    public VisBdd() {
        super("VisBdd - Visualization of the BDD-ITE algorithm");
        codeDetails = new JButton(new ImageIcon(this.getClass().getResource("details.gif")));
        codeHistoryPrev = new JButton(new ImageIcon(this.getClass().getResource("prev.gif")));
        codeHistoryNext = new JButton(new ImageIcon(this.getClass().getResource("next.gif")));
        codeHistoryStepOver = new JButton(new ImageIcon(this.getClass().getResource("jump.gif")));
        codeHistoryFirst = new JButton(new ImageIcon(this.getClass().getResource("first.gif")));
        codeHistoryLast = new JButton(new ImageIcon(this.getClass().getResource("last.gif")));
        codeHistorySpeak = new JButton(new ImageIcon(this.getClass().getResource("speaker.gif")));
        codeHistoryInfo = new JButton(new ImageIcon(this.getClass().getResource("info.gif")));
        infoHPanelButton = new JButton(new ImageIcon(this.getClass().getResource("details.gif")));
        infoGPanelButton = new JButton(new ImageIcon(this.getClass().getResource("details.gif")));
        infoFPanelButton = new JButton(new ImageIcon(this.getClass().getResource("details.gif")));
        infoResultPanelButton = new JButton(new ImageIcon(this.getClass().getResource("details.gif")));
        infoTreePanelButton = new JButton(new ImageIcon(this.getClass().getResource("details.gif")));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        ((Component)this).setLocation(0, 0);
        ((Component)this).setSize(dimension.width, dimension.height);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ExitWindow exitWindow = new ExitWindow();
        this.addWindowListener(exitWindow);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        JMenu jMenu2 = new JMenu("BDD");
        JMenu jMenu3 = new JMenu("Options");
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        NewAction newAction = new NewAction();
        LoadAction loadAction = new LoadAction();
        SaveAction saveAction = new SaveAction();
        QuitAction quitAction = new QuitAction();
        FormelAction formelAction = new FormelAction();
        OptionenAction optionenAction = new OptionenAction();
        jMenu.add(newAction);
        jMenu.add(loadAction);
        jMenu.add(saveAction);
        jMenu.add(quitAction);
        jMenu2.add(formelAction);
        jMenu3.add(optionenAction);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        BNewAction bNewAction = new BNewAction();
        BLoadAction bLoadAction = new BLoadAction();
        BSaveAction bSaveAction = new BSaveAction();
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(bNewAction);
        jToolBar.add(bLoadAction);
        jToolBar.add(bSaveAction);
        container.add((Component)jToolBar, "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel("Formula:");
        JLabel jLabel2 = new JLabel("Variable ordering:");
        formulaInput.addActionListener(this);
        evalFormulaButton.addActionListener(this);
        jPanel2.setLayout(gridBagLayout);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 10, 40);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 80, 0);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(formulaInput, gridBagConstraints);
        jPanel2.add(formulaInput);
        this.buildConstraints(gridBagConstraints, 2, 0, 1, 2, 10, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(evalFormulaButton, gridBagConstraints);
        jPanel2.add(evalFormulaButton);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 40);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel2.add(jLabel2);
        this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(orderingInput, gridBagConstraints);
        jPanel2.add(orderingInput);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new BevelBorder(1));
        jPanel3.setBackground(Color.white);
        gridBagConstraints.fill = 1;
        jPanel3.setLayout(gridBagLayout);
        JPanel jPanel4 = new JPanel();
        codeHistoryNext.setEnabled(false);
        codeHistoryPrev.setEnabled(false);
        codeHistoryFirst.setEnabled(false);
        codeHistoryLast.setEnabled(false);
        codeHistoryStepOver.setEnabled(false);
        JPanel jPanel5 = new JPanel();
        JLabel jLabel3 = new JLabel("ite Alg.:", 2);
        codeHistory.addChangeListener(this);
        codeHistory.setMajorTickSpacing(1);
        codeHistory.setMinorTickSpacing(1);
        codeHistory.setPaintTicks(false);
        codeHistoryStepOver.addActionListener(this);
        codeHistoryPrev.addActionListener(this);
        codeHistoryNext.addActionListener(this);
        codeHistoryFirst.addActionListener(this);
        codeHistoryLast.addActionListener(this);
        codeHistorySpeak.addActionListener(this);
        codeHistoryInfo.addActionListener(this);
        jPanel4.setLayout(new FlowLayout(0));
        jPanel4.add(jLabel3);
        codeDetails.addActionListener(this);
        jPanel4.add(codeDetails);
        jPanel4.add(codeHistoryFirst);
        jPanel4.add(codeHistoryPrev);
        jPanel4.add(codeHistoryNext);
        jPanel4.add(codeHistoryStepOver);
        jPanel4.add(codeHistoryLast);
        jPanel4.add(codeHistoryInfo);
        jPanel4.add(codeHistorySpeak);
        jPanel4.add(codeHistory);
        JLabel jLabel4 = new JLabel("Depth: ");
        jPanel4.add(jLabel4);
        jPanel4.add(recursionLabel);
        this.buildConstraints(gridBagConstraints, 0, 0, 4, 1, 100, 0);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel3.add(jPanel4);
        JPanel jPanel6 = new JPanel();
        codeList = new List();
        codeList.addActionListener(this);
        codeList.setBackground(Color.white);
        codeList.add("(0)  ITE(F;G;H) {");
        codeList.add("(1)  /* Input:  OBDDs F,G,H reg. ordering pi */");
        codeList.add("(2)  /* Output: a OBDD for ITE(f,g,h)");
        codeList.add("(3)    If (Terminal case) {");
        codeList.add("(4)      R = Find_or_add_unique_table(Result);");
        codeList.add("(5)      Return R;");
        codeList.add("(6)    }");
        codeList.add("(7)    Else If (F,G,H) in ComputedTable {");
        codeList.add("(8)      Return ComputedTable(F,G,H)");
        codeList.add("(9)    }");
        codeList.add("(10    Else {");
        codeList.add("(11)     xi denotes 1. Var. in pi, depend. on  F,G or H");
        codeList.add("(12)     T = ITE(Fxi,Gxi,Hxi);");
        codeList.add("(13)     E = ITE(F!x1,G!xi,H!xi)");
        codeList.add("(14)     R = Find_or_add_unique_table(xi,T,E);");
        codeList.add("(15)     Insert_computed_table({F,G,H},R);");
        codeList.add("(16)     Return R;");
        codeList.add("(17)   }");
        codeList.add("(18) }");
        jPanel6.add(codeList);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 29, 35);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(codeList, gridBagConstraints);
        jPanel3.add(codeList);
        infoFPanelButton.addActionListener(this);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        jPanel8.setBackground(new Color(208, 236, 255));
        JLabel jLabel5 = new JLabel(" F Parameter:", 2);
        jPanel8.add((Component)jLabel5, "West");
        jPanel8.add((Component)infoFPanelButton, "East");
        outIteFPane = new IteFPane();
        jPanel7.add("North", jPanel8);
        jPanel7.add("Center", outIteFPane);
        jPanel7.setBorder(new BevelBorder(1));
        gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
        this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 24, 31);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
        jPanel3.add(jPanel7);
        infoGPanelButton.addActionListener(this);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout());
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout());
        jPanel10.setBackground(new Color(208, 236, 255));
        JLabel jLabel6 = new JLabel(" G Parameter:", 2);
        jPanel10.add((Component)jLabel6, "West");
        jPanel10.add((Component)infoGPanelButton, "East");
        outIteGPane = new IteGPane();
        jPanel9.add("North", jPanel10);
        jPanel9.add("Center", outIteGPane);
        jPanel9.setBorder(new BevelBorder(1));
        gridBagLayout.setConstraints(jPanel9, gridBagConstraints);
        this.buildConstraints(gridBagConstraints, 2, 1, 1, 1, 24, 31);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jPanel9, gridBagConstraints);
        jPanel3.add(jPanel9);
        infoHPanelButton.addActionListener(this);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BorderLayout());
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BorderLayout());
        jPanel12.setBackground(new Color(208, 236, 255));
        JLabel jLabel7 = new JLabel(" H Parameter:", 2);
        jPanel12.add((Component)jLabel7, "West");
        jPanel12.add((Component)infoHPanelButton, "East");
        outIteHPane = new IteHPane();
        jPanel11.add("North", jPanel12);
        jPanel11.add("Center", outIteHPane);
        jPanel11.setBorder(new BevelBorder(1));
        gridBagLayout.setConstraints(jPanel11, gridBagConstraints);
        this.buildConstraints(gridBagConstraints, 3, 1, 1, 1, 24, 31);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jPanel11, gridBagConstraints);
        jPanel3.add(jPanel11);
        infoResultPanelButton.addActionListener(this);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new BorderLayout());
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new BorderLayout());
        jPanel14.setBackground(new Color(253, 255, 227));
        JLabel jLabel8 = new JLabel("Visualization: ", 2);
        visType.addItem("ite Recursion graph");
        visType.addItem("ite Return graph");
        visType.addActionListener(this);
        JPanel jPanel15 = new JPanel();
        jPanel15.setBackground(new Color(253, 255, 227));
        jPanel15.setLayout(new FlowLayout(0));
        jPanel15.add(jLabel8);
        jPanel15.add(visType);
        jPanel14.add((Component)jPanel15, "West");
        jPanel14.add((Component)infoResultPanelButton, "East");
        outResultPane = new ResultPane();
        jPanel13.add("North", jPanel14);
        jPanel13.add("Center", outResultPane);
        this.buildConstraints(gridBagConstraints, 0, 2, 2, 1, 50, 62);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jPanel13, gridBagConstraints);
        jPanel3.add(jPanel13);
        infoTreePanelButton.addActionListener(this);
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout(new BorderLayout());
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout(new BorderLayout());
        jPanel17.setBackground(new Color(253, 255, 227));
        JLabel jLabel9 = new JLabel("Derivation tree: ", 2);
        jPanel17.add((Component)jLabel9, "West");
        jPanel17.add((Component)infoTreePanelButton, "East");
        jPanel16.add("North", jPanel17);
        outTreePane = new TreePane();
        jPanel16.add("Center", outTreePane);
        this.buildConstraints(gridBagConstraints, 2, 2, 2, 1, 50, 62);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jPanel16, gridBagConstraints);
        jPanel3.add(jPanel16);
        jPanel.add((Component)jPanel3, "Center");
        container.add((Component)jPanel, "Center");
    }

    public static void main(String[] stringArray) throws Exception {
        VisBdd visBdd = new VisBdd();
        visBdd.show();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == codeHistory && userSlide && codeHistory.getMaximum() != 1) {
            BddHistory bddHistory = (BddHistory)historyList.get(codeHistory.getValue() - 1);
            outIteFPane.paintGraph(bddHistory.iteF, bddHistory.iteFText, bddHistory.highLight);
            outIteGPane.paintGraph(bddHistory.iteG, bddHistory.iteGText, bddHistory.highLight);
            outIteHPane.paintGraph(bddHistory.iteH, bddHistory.iteHText, bddHistory.highLight);
            outResultPane.paintGraph(bddHistory.iteResult, bddHistory.iteResultText);
            codeList.select(bddHistory.lineNumber);
            recursionLabel.setText(String.valueOf(bddHistory.recursionDepth));
        }
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object != codeList) {
            if (object == codeDetails) {
                if (codeHistory.getMaximum() != 1) {
                    BddHistory bddHistory = (BddHistory)historyList.get(codeHistory.getValue() - 1);
                    this.showInfo = new InfoDialog(this, 100, 100, bddHistory.text, bddHistory.lineNumber, 5);
                } else {
                    JOptionPane.showMessageDialog(null, "No Detail information exists.\nPlease run a computation before.");
                }
            } else if (object == codeHistoryFirst) {
                codeHistory.setValue(0);
                BddHistory bddHistory = (BddHistory)historyList.get(codeHistory.getValue() - 1);
                outIteFPane.paintGraph(bddHistory.iteF, bddHistory.iteFText, bddHistory.highLight);
                outIteGPane.paintGraph(bddHistory.iteG, bddHistory.iteGText, bddHistory.highLight);
                outIteHPane.paintGraph(bddHistory.iteH, bddHistory.iteHText, bddHistory.highLight);
                outResultPane.paintGraph(bddHistory.iteResult, bddHistory.iteResultText);
                codeList.select(bddHistory.lineNumber);
                recursionLabel.setText(String.valueOf(bddHistory.recursionDepth));
                codeHistoryStepOver.setEnabled(false);
            } else if (object == codeHistoryLast) {
                codeHistory.setValue(codeHistory.getMaximum());
                BddHistory bddHistory = (BddHistory)historyList.get(codeHistory.getValue() - 1);
                outIteFPane.paintGraph(bddHistory.iteF, bddHistory.iteFText, bddHistory.highLight);
                outIteGPane.paintGraph(bddHistory.iteG, bddHistory.iteGText, bddHistory.highLight);
                outIteHPane.paintGraph(bddHistory.iteH, bddHistory.iteHText, bddHistory.highLight);
                outResultPane.paintGraph(bddHistory.iteResult, bddHistory.iteResultText);
                codeList.select(bddHistory.lineNumber);
                recursionLabel.setText(String.valueOf(bddHistory.recursionDepth));
                codeHistoryStepOver.setEnabled(false);
            } else if (object == codeHistoryPrev) {
                if (codeHistory.getValue() > 1) {
                    codeHistory.setValue(codeHistory.getValue() - 1);
                    BddHistory bddHistory = (BddHistory)historyList.get(codeHistory.getValue() - 1);
                    outIteFPane.paintGraph(bddHistory.iteF, bddHistory.iteFText, bddHistory.highLight);
                    outIteGPane.paintGraph(bddHistory.iteG, bddHistory.iteGText, bddHistory.highLight);
                    outIteHPane.paintGraph(bddHistory.iteH, bddHistory.iteHText, bddHistory.highLight);
                    outResultPane.paintGraph(bddHistory.iteResult, bddHistory.iteResultText);
                    codeList.select(bddHistory.lineNumber);
                    recursionLabel.setText(String.valueOf(bddHistory.recursionDepth));
                    if (bddHistory.lineNumber == 12 || bddHistory.lineNumber == 13) {
                        codeHistoryStepOver.setEnabled(true);
                    } else {
                        codeHistoryStepOver.setEnabled(false);
                    }
                }
            } else if (object == codeHistoryNext) {
                if (codeHistory.getValue() < codeHistory.getMaximum()) {
                    codeHistory.setValue(codeHistory.getValue() + 1);
                    BddHistory bddHistory = (BddHistory)historyList.get(codeHistory.getValue() - 1);
                    outIteFPane.paintGraph(bddHistory.iteF, bddHistory.iteFText, bddHistory.highLight);
                    outIteGPane.paintGraph(bddHistory.iteG, bddHistory.iteGText, bddHistory.highLight);
                    outIteHPane.paintGraph(bddHistory.iteH, bddHistory.iteHText, bddHistory.highLight);
                    outResultPane.paintGraph(bddHistory.iteResult, bddHistory.iteResultText);
                    codeList.select(bddHistory.lineNumber);
                    recursionLabel.setText(String.valueOf(bddHistory.recursionDepth));
                    if (bddHistory.lineNumber == 12 || bddHistory.lineNumber == 13) {
                        codeHistoryStepOver.setEnabled(true);
                    } else {
                        codeHistoryStepOver.setEnabled(false);
                    }
                }
            } else if (object == codeHistoryStepOver) {
                BddHistory bddHistory = (BddHistory)historyList.get(codeHistory.getValue() - 1);
                int n = bddHistory.recursionDepth;
                codeHistory.setValue(codeHistory.getValue() + 1);
                bddHistory = (BddHistory)historyList.get(codeHistory.getValue() - 1);
                while (n < bddHistory.recursionDepth) {
                    codeHistory.setValue(codeHistory.getValue() + 1);
                    bddHistory = (BddHistory)historyList.get(codeHistory.getValue() - 1);
                }
                outIteFPane.paintGraph(bddHistory.iteF, bddHistory.iteFText, bddHistory.highLight);
                outIteGPane.paintGraph(bddHistory.iteG, bddHistory.iteGText, bddHistory.highLight);
                outIteHPane.paintGraph(bddHistory.iteH, bddHistory.iteHText, bddHistory.highLight);
                outResultPane.paintGraph(bddHistory.iteResult, bddHistory.iteResultText);
                codeList.select(bddHistory.lineNumber);
                recursionLabel.setText(String.valueOf(bddHistory.recursionDepth));
                codeHistoryStepOver.setEnabled(false);
            } else if (object == visType) {
                outResultPane.repaint();
            } else if (object == codeHistorySpeak) {
                this.sayComment();
            } else if (object == evalFormulaButton) {
                if (evalFormulaButton.getLabel() == "start computation") {
                    myBdd = new Bdd();
                    boolean bl = false;
                    syntaxTree = null;
                    syntaxTree = new formulaTree();
                    codeHistory.setMaximum(1);
                    historyList.clear();
                    outResultPane.clear();
                    outIteFPane.clear();
                    outIteGPane.clear();
                    outIteHPane.clear();
                    this.setVariableOrder();
                    formel = formulaInput.getText() + ";";
                    StringReader stringReader = new StringReader(formel);
                    Yylex yylex = new Yylex(stringReader);
                    parser parser2 = new parser(yylex, myBdd, syntaxTree);
                    try {
                        parser2.parse();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(null, "An error occured during computation.\nPlease check your formula!\nVery big OBDDs need a bigger buffer (see Options).");
                    }
                    if (!bl) {
                        if (!autoRun) {
                            codeHistoryNext.setEnabled(true);
                            codeHistoryPrev.setEnabled(true);
                            codeHistoryFirst.setEnabled(true);
                            codeHistoryLast.setEnabled(true);
                            codeHistoryStepOver.setEnabled(false);
                            codeHistory.setValue(0);
                            BddHistory bddHistory = (BddHistory)historyList.get(0);
                            outIteFPane.paintGraph(bddHistory.iteF, bddHistory.iteFText, bddHistory.highLight);
                            outIteGPane.paintGraph(bddHistory.iteG, bddHistory.iteGText, bddHistory.highLight);
                            outIteHPane.paintGraph(bddHistory.iteH, bddHistory.iteHText, bddHistory.highLight);
                            outResultPane.paintGraph(bddHistory.iteResult, bddHistory.iteResultText);
                            codeList.select(bddHistory.lineNumber);
                            recursionLabel.setText(String.valueOf(bddHistory.recursionDepth));
                        } else if (this.runner == null) {
                            this.runner = new Thread(this);
                            this.runner.start();
                        }
                    }
                } else {
                    this.runner.stop();
                    this.runner = null;
                    evalFormulaButton.setLabel("start computation");
                }
            } else if (object == infoFPanelButton) {
                this.showInfo = new InfoDialog(this, 100, 100, IteFPane.info, -1, 1);
            } else if (object == infoGPanelButton) {
                this.showInfo = new InfoDialog(this, 100, 100, IteGPane.info, -1, 2);
            } else if (object == infoHPanelButton) {
                this.showInfo = new InfoDialog(this, 100, 100, IteHPane.info, -1, 3);
            } else if (object == infoResultPanelButton) {
                this.showInfo = new InfoDialog(this, 100, 100, ResultPane.info, -1, 4);
            } else if (object == infoTreePanelButton) {
                this.showInfo = new InfoDialog(this, 100, 100, "The descision tree for the formula\n" + formel + " is computed.\n Nodes, which are in the current computation are marked blue.\n", -1, 5);
            } else if (object == codeHistoryInfo) {
                this.showInfo = new InfoDialog(this, 100, 100, "Statistics for computation: \n\nite-Call savings through cache: " + Bdd.cacheCounter + "\n\nNumber of ite-calls: " + Bdd.recursionCount + "\n\nactual Position: " + String.valueOf(codeHistory.getValue()) + " of " + String.valueOf(codeHistory.getMaximum()), -2, 0);
            }
        }
    }

    void startEval() {
        if (evalFormulaButton.getLabel() == "start computation") {
            myBdd = new Bdd();
            boolean bl = false;
            syntaxTree = null;
            syntaxTree = new formulaTree();
            codeHistory.setMaximum(1);
            historyList.clear();
            outResultPane.clear();
            outIteFPane.clear();
            outIteGPane.clear();
            outIteHPane.clear();
            this.setVariableOrder();
            formel = formulaInput.getText();
            StringReader stringReader = new StringReader(formulaInput.getText() + ";");
            Yylex yylex = new Yylex(stringReader);
            parser parser2 = new parser(yylex, myBdd, syntaxTree);
            try {
                parser2.parse();
            }
            catch (Exception exception) {
                System.out.println("Error in execution: " + exception);
                JOptionPane.showMessageDialog(null, "An error occured during computation.\nPlease check your formula!\nVery big OBDDs need a bigger buffer (see Options).");
                bl = true;
            }
            if (!bl) {
                if (!autoRun) {
                    codeHistoryNext.setEnabled(true);
                    codeHistoryPrev.setEnabled(true);
                    codeHistoryFirst.setEnabled(true);
                    codeHistoryLast.setEnabled(true);
                    codeHistoryStepOver.setEnabled(false);
                    codeHistory.setValue(0);
                    BddHistory bddHistory = (BddHistory)historyList.get(0);
                    outIteFPane.paintGraph(bddHistory.iteF, bddHistory.iteFText, bddHistory.highLight);
                    outIteGPane.paintGraph(bddHistory.iteG, bddHistory.iteGText, bddHistory.highLight);
                    outIteHPane.paintGraph(bddHistory.iteH, bddHistory.iteHText, bddHistory.highLight);
                    outResultPane.paintGraph(bddHistory.iteResult, bddHistory.iteResultText);
                    codeList.select(bddHistory.lineNumber);
                    recursionLabel.setText(String.valueOf(bddHistory.recursionDepth));
                } else if (this.runner == null) {
                    this.runner = new Thread(this);
                    this.runner.start();
                }
            }
        } else {
            this.runner.stop();
            this.runner = null;
            evalFormulaButton.setLabel("start computation");
        }
    }

    static void addHistory(Node node, Node node2, Node node3, Node node4, String string, String string2, String string3, String string4, int n, int n2, String string5, int n3, Node node5, int n4, Color color, int n5, int n6) {
        BddHistory bddHistory = new BddHistory(node, node2, node3, node4, string, string2, string3, string4, n, n2, string5, n3, node5, n4, color, n5, n6);
        historyList.addLast(bddHistory);
        if (historyList.size() > 1) {
            userSlide = false;
            codeHistory.setMaximum(codeHistory.getMaximum() + 1);
            codeHistory.setValue(codeHistory.getMaximum());
            userSlide = true;
        }
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    boolean setVariableOrder() {
        String string = orderingInput.getText();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n2 = string.indexOf("<", n);
        while (n2 != -1) {
            myBdd.SetOrder(++n3, Integer.valueOf(string.substring(n, n2)));
            n = n2 + 1;
            n2 = string.indexOf("<", n);
        }
        return true;
    }

    public synchronized void sayComment() {
        BddHistory bddHistory = (BddHistory)historyList.get(codeHistory.getValue() - 1);
        if (bddHistory.actionCode == 0 && codeHistory.getValue() == 1) {
            this.playAudioFile("sound/itestart.wav", 5500);
            this.sayFormula(formulaInput.getText());
            this.playAudioFile("sound/ableitungsgraph.wav", 5800);
        }
        if (bddHistory.actionCode == 0 && codeHistory.getValue() != 1) {
            this.playAudioFile("sound/iteaufruf.wav", 5420);
        }
        if (bddHistory.actionCode == 6) {
            this.playAudioFile("sound/terminalnein.wav", 2520);
        }
        if (bddHistory.actionCode == 1) {
            this.playAudioFile("sound/terminalja.wav", 2600);
        }
        if (bddHistory.actionCode == 2) {
            this.playAudioFile("sound/terminal1.wav", 7700);
        }
        if (bddHistory.actionCode == 3) {
            this.playAudioFile("sound/terminal2.wav", 6991);
        }
        if (bddHistory.actionCode == 4) {
            this.playAudioFile("sound/terminal3.wav", 9900);
        }
        if (bddHistory.actionCode == 5) {
            this.playAudioFile("sound/terminal4.wav", 8050);
        }
        if (bddHistory.actionCode == 15) {
            this.playAudioFile("sound/return.wav", 4000);
        }
        if (bddHistory.actionCode == 7) {
            this.playAudioFile("sound/ct1.wav", 9300);
        }
        if (bddHistory.actionCode == 8) {
            this.playAudioFile("sound/ct2.wav", 6700);
        }
        if (bddHistory.actionCode > 100 && bddHistory.actionCode < 111) {
            this.playAudioFile("sound/x" + (bddHistory.actionCode - 100) + ".wav", 1400);
            this.playAudioFile("sound/firstxi.wav", 9200);
        }
        if (bddHistory.actionCode > 200 && bddHistory.actionCode < 211) {
            this.playAudioFile("sound/itepos.wav", 6200);
            this.playAudioFile("sound/x" + (bddHistory.actionCode - 200) + ".wav", 1400);
            this.playAudioFile("sound/bzglfgh.wav", 4100);
        }
        if (bddHistory.actionCode > 300 && bddHistory.actionCode < 311) {
            this.playAudioFile("sound/iteneg.wav", 6300);
            this.playAudioFile("sound/x" + (bddHistory.actionCode - 300) + ".wav", 1400);
            this.playAudioFile("sound/bzglfgh.wav", 4100);
        }
        if (bddHistory.actionCode == 17) {
            this.playAudioFile("sound/unique1.wav", 6100);
        }
        if (bddHistory.actionCode == 14) {
            this.playAudioFile("sound/unique2.wav", 7000);
        }
        if (bddHistory.actionCode == 18) {
            this.playAudioFile("sound/ct3.wav", 8800);
        }
    }

    public synchronized void sayFormula(String string) {
        int n = 0;
        while (n <= string.length() - 1) {
            String string2 = string.substring(n, n + 1);
            if (string2.equals("(")) {
                if (!string.substring(n + 1, n + 2).equals("+")) {
                    this.playAudioFile("sound/klammerauf.wav", 2100);
                } else {
                    this.playAudioFile("sound/xoder.wav", 1200);
                    n += 2;
                }
            } else if (string2.equals(")")) {
                this.playAudioFile("sound/klammerzu.wav", 1750);
            } else if (string2.equals("+")) {
                this.playAudioFile("sound/oder.wav", 1150);
            } else if (string2.equals("*")) {
                this.playAudioFile("sound/und.wav", 1050);
            } else if (string2.equals("=")) {
                if (string.substring(n + 1, n + 2).equals("=")) {
                    ++n;
                    this.playAudioFile("sound/aequivalent.wav", 1999);
                } else {
                    this.playAudioFile("sound/impliziert.wav", 1450);
                    ++n;
                }
            } else if (string2.equals("<")) {
                ++n;
                this.playAudioFile("sound/rueckimpliziert.wav", 1900);
            } else if (string2.equals("!")) {
                if (string.substring(n + 1, n + 2).equals("+")) {
                    n += 2;
                    this.playAudioFile("sound/nichtoder.wav", 1550);
                } else if (string.substring(n + 1, n + 2).equals("*")) {
                    n += 2;
                    this.playAudioFile("sound/nichtund.wav", 1550);
                } else if (string.substring(n + 1, n + 2).equals("<")) {
                    n += 3;
                    this.playAudioFile("sound/rueckimpliziertnicht.wav", 1999);
                } else if (string.substring(n + 1, n + 2).equals("=")) {
                    n += 3;
                    this.playAudioFile("sound/impliziertnicht.wav", 1750);
                } else {
                    this.playAudioFile("sound/nicht.wav", 1350);
                }
            } else if (string2.equals("x")) {
                if (string.substring(n + 2, n + 3).equals("1")) {
                    n += 3;
                    this.playAudioFile("sound/x1.wav", 1500);
                } else if (string.substring(n + 2, n + 3).equals("2")) {
                    n += 3;
                    this.playAudioFile("sound/x2.wav", 1500);
                } else if (string.substring(n + 2, n + 3).equals("3")) {
                    n += 3;
                    this.playAudioFile("sound/x3.wav", 1500);
                } else if (string.substring(n + 2, n + 3).equals("4")) {
                    this.playAudioFile("sound/x4.wav", 1500);
                    n += 3;
                } else if (string.substring(n + 2, n + 3).equals("5")) {
                    this.playAudioFile("sound/x5.wav", 1500);
                    n += 3;
                } else if (string.substring(n + 2, n + 3).equals("6")) {
                    this.playAudioFile("sound/x6.wav", 1500);
                    n += 3;
                } else if (string.substring(n + 2, n + 3).equals("7")) {
                    this.playAudioFile("sound/x7.wav", 1500);
                    n += 3;
                } else if (string.substring(n + 2, n + 3).equals("8")) {
                    this.playAudioFile("sound/x8.wav", 1500);
                    n += 3;
                } else if (string.substring(n + 2, n + 3).equals("9")) {
                    this.playAudioFile("sound/x9.wav", 1500);
                    n += 3;
                }
            } else if (string2.equals("1")) {
                this.playAudioFile("sound/eins.wav", 950);
            } else if (string2.equals("0")) {
                this.playAudioFile("sound/null.wav", 990);
            }
            ++n;
        }
    }

    public synchronized void playAudioFile(String string, int n) {
        VisBdd visBdd = this;
        synchronized (visBdd) {
            Class clazz = class$VisBdd$VisBdd == null ? (class$VisBdd$VisBdd = VisBdd.class$("VisBdd.VisBdd")) : class$VisBdd$VisBdd;
            AudioClip audioClip = Applet.newAudioClip(clazz.getResource(string));
            audioClip.play();
            try {
                Thread.sleep(n + 400);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void run() {
        evalFormulaButton.setLabel("stop computation!");
        do {
            codeHistoryNext.setEnabled(false);
            codeHistoryPrev.setEnabled(false);
            codeHistoryFirst.setEnabled(false);
            codeHistoryLast.setEnabled(false);
            codeHistory.setValue(0);
            BddHistory bddHistory = (BddHistory)historyList.get(0);
            outIteFPane.paintGraph(bddHistory.iteF, bddHistory.iteFText, bddHistory.highLight);
            outIteGPane.paintGraph(bddHistory.iteG, bddHistory.iteGText, bddHistory.highLight);
            outIteHPane.paintGraph(bddHistory.iteH, bddHistory.iteHText, bddHistory.highLight);
            outResultPane.paintGraph(bddHistory.iteResult, bddHistory.iteResultText);
            codeList.select(bddHistory.lineNumber);
            recursionLabel.setText(String.valueOf(bddHistory.recursionDepth));
            if (audioComment) {
                this.sayComment();
            }
            try {
                Thread.sleep(autoTime * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int n = 0;
            while (n <= codeHistory.getMaximum()) {
                codeHistory.setValue(codeHistory.getValue() + 1);
                bddHistory = (BddHistory)historyList.get(codeHistory.getValue() - 1);
                outIteFPane.paintGraph(bddHistory.iteF, bddHistory.iteFText, bddHistory.highLight);
                outIteGPane.paintGraph(bddHistory.iteG, bddHistory.iteGText, bddHistory.highLight);
                outIteHPane.paintGraph(bddHistory.iteH, bddHistory.iteHText, bddHistory.highLight);
                outResultPane.paintGraph(bddHistory.iteResult, bddHistory.iteResultText);
                codeList.select(bddHistory.lineNumber);
                recursionLabel.setText(String.valueOf(bddHistory.recursionDepth));
                if (audioComment) {
                    this.sayComment();
                }
                try {
                    Thread.sleep(autoTime * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((bddHistory.lineNumber == 12 || bddHistory.lineNumber == 13) && autoStepOver) {
                    int n2 = bddHistory.recursionDepth;
                    codeHistory.setValue(codeHistory.getValue() + 1);
                    bddHistory = (BddHistory)historyList.get(codeHistory.getValue() - 1);
                    while (n2 < bddHistory.recursionDepth) {
                        codeHistory.setValue(codeHistory.getValue() + 1);
                        bddHistory = (BddHistory)historyList.get(codeHistory.getValue() - 1);
                    }
                    codeHistory.setValue(codeHistory.getValue() - 1);
                    n = codeHistory.getValue();
                }
                ++n;
            }
        } while (autoLoop);
        this.runner = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        visType = new JComboBox();
        doStepIn = false;
        doStepOver = false;
        doNext = false;
        codeShowFinalNode = new JButton("Recursion graph");
        codeShowAbleitungsBaum = new JButton("Derivation tree");
        recursionLabel = new JLabel("1");
        codeHistory = new JSlider(1, 1, 1);
        userSlide = true;
        evalFormulaButton = new JButton("start computation");
        formulaInput = new JTextField("x[1]=>x[2]=>(x[3]*x[4])", 50);
        orderingInput = new JTextField("1<2<3<4<5<6<7<8<9<10<11<12<13<14<15<16<17<18<19<20", 50);
        autoRun = false;
        autoTime = new Integer(5);
        autoStepOver = true;
        autoLoop = true;
        audioComment = false;
        arraySize = new Integer(100);
        startCalc = false;
        historyList = new LinkedList();
    }

    class OptionenAction
    extends AbstractAction {
        public OptionenAction() {
            super("Settings");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OptionsDialog optionsDialog = new OptionsDialog(VisBdd.this, 100, 100);
        }
    }

    class FormelAction
    extends AbstractAction {
        public FormelAction() {
            super("Formula input");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FormulaInput formulaInput = new FormulaInput(VisBdd.this, 100, 100);
            if (startCalc) {
                VisBdd.this.startEval();
            }
            startCalc = false;
        }
    }

    class QuitAction
    extends AbstractAction {
        public QuitAction() {
            super("Quit");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = JOptionPane.showConfirmDialog(VisBdd.this, "Are you sure to quit?");
            if (n == 0) {
                System.exit(0);
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("Save");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.addChoosableFileFilter(new BddFileFilter());
            int n = jFileChooser.showDialog(VisBdd.this, "Save");
            if (n == 0) {
                try {
                    File file = jFileChooser.getSelectedFile();
                    FileWriter fileWriter = new FileWriter(file);
                    fileWriter.write(formulaInput.getText());
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    class LoadAction
    extends AbstractAction {
        public LoadAction() {
            super("Load");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.addChoosableFileFilter(new BddFileFilter());
            int n = jFileChooser.showDialog(VisBdd.this, "Load");
            if (n == 0) {
                try {
                    File file = jFileChooser.getSelectedFile();
                    FileReader fileReader = new FileReader(file);
                    int n2 = (int)file.length();
                    int n3 = 0;
                    char[] cArray = new char[n2];
                    while (n3 < n2) {
                        n3 = (byte)fileReader.read(cArray, n3, n2 - n3);
                    }
                    fileReader.close();
                    formel = new String(cArray);
                    formulaInput.setText(formel);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    class NewAction
    extends AbstractAction {
        public NewAction() {
            super("New");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FormulaInput formulaInput = new FormulaInput(VisBdd.this, 100, 100);
            if (startCalc) {
                VisBdd.this.startEval();
            }
            startCalc = false;
        }
    }

    class BSaveAction
    extends AbstractAction {
        public BSaveAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("save.gif")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.addChoosableFileFilter(new BddFileFilter());
            int n = jFileChooser.showDialog(VisBdd.this, "Save");
            if (n == 0) {
                try {
                    File file = jFileChooser.getSelectedFile();
                    FileWriter fileWriter = new FileWriter(file);
                    fileWriter.write(formulaInput.getText());
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    class BLoadAction
    extends AbstractAction {
        public BLoadAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("open.gif")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.addChoosableFileFilter(new BddFileFilter());
            int n = jFileChooser.showDialog(VisBdd.this, "Load");
            if (n == 0) {
                try {
                    File file = jFileChooser.getSelectedFile();
                    FileReader fileReader = new FileReader(file);
                    int n2 = (int)file.length();
                    int n3 = 0;
                    char[] cArray = new char[n2];
                    while (n3 < n2) {
                        n3 = (byte)fileReader.read(cArray, n3, n2 - n3);
                    }
                    fileReader.close();
                    formel = new String(cArray);
                    formulaInput.setText(formel);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    class BNewAction
    extends AbstractAction {
        public BNewAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("new.gif")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FormulaInput formulaInput = new FormulaInput(VisBdd.this, 100, 100);
            if (startCalc) {
                VisBdd.this.startEval();
            }
            startCalc = false;
        }
    }
}

